/***************************************************************************
 *   Copyright (C) 2005-2008 by Eugene V. Lyubimkin aka jackyf             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License                  *
 *   (version 3 or above) as published by the Free Software Foundation.    *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU GPL                        *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA               *
 ***************************************************************************/
#include <QDialog>

#include "StatsLogic.hpp"

class UserProfile;

class QComboBox;
class QTableWidget;
class QTabWidget;
class QCheckBox;
class QPushButton;

class QwtPlot;
class QwtPlotCurve;
class QwtPlotGrid;

class StatsWidget: public QDialog
{
	Q_OBJECT

 public:
	StatsWidget(const UserProfile& profile, QWidget* parent = NULL);

 private slots:
	void renewStatsViews();
	void renewCategoryView();
	void renewSummarizeByCombo();
	void renewGridsOnPlots();

	void writeGuiSettings();

 private:
	QComboBox* categorizeByCombo;
	QComboBox* summarizeByCombo;
	QComboBox* categoryCombo;

	QTabWidget* tabs;

	QTableWidget* statsTable;

	QTableWidget* mistakesTable;
	QTableWidget* combinationsTable;

	QwtPlot* exerciseCountPlot;
	QwtPlot* symbolCountPlot;
	QwtPlot* timePlot;
	QwtPlot* speedAveragePlot;
	QwtPlot* mistakeAveragePlot;
	QwtPlot* rhythmAveragePlot;
	QwtPlot* indexPlot;
	QwtPlotCurve* exerciseCountCurve;
	QwtPlotCurve* symbolCountCurve;
	QwtPlotCurve* timeCurve;
	QwtPlotCurve* speedAverageCurve;
	QwtPlotCurve* mistakeAverageCurve;
	QwtPlotCurve* rhythmAverageCurve;
	QwtPlotCurve* indexCurve;

	QCheckBox* setMinimumYValueOnPlotsToZeroCheckBox;
	QCheckBox* showGridsOnPlotsCheckBox;
	QList<QwtPlotGrid*> gridList;

	QPushButton* scrollDownStatsTableButton;

	StatsLogic statsLogic;
	StatsLogic::CategorizedStats cachedStats;

	const QString profilePath;

	void initTable();
	void initPlots();
	void initPlotsFormat();
	void initCombos();
	void initCombinationsAndMistakesTables();

	void readGuiSettings();

	static void loadCountedStringsIntoTable(const QStringList& strings, QTableWidget* tableWidget);
};

