## Usage

```js
const write = require('write');
```

## Options

The following options may be used with any method.

### options.newline

**Type**: `boolean`

**Default**: `undefined`

Ensure that contents has a trailing newline before writing it to the file system.

```js
write.sync('foo.txt', 'some data...', { newline: true }); 
```


### options.overwrite

**Type**: `boolean`

**Default**: `undefined`

Set to `false` to prevent existing files from being overwritten. See [increment](#optionsincrement) for a less severe alternative.

```js
write.sync('foo.txt', 'some data...', { overwrite: false });
```

### options.increment

**Type**: `boolean`

**Default**: `undefined`

Set to `true` to automatically rename files by appending an increment, like `foo (2).txt`, to prevent `foo.txt` from being overwritten. This is useful when writing log files, or other information where the file name is less important than the contents being written. 

```js
write.sync('foo.txt', 'some data...', { increment: true });
// if "foo.txt" exists, the file will be renamed to "foo (2).txt"
```

## API
{%= apidocs("index.js") %}

## Release history

See [CHANGELOG.md].


[fs]: https://nodejs.org/api/fs.html

[writestream]: https://nodejs.org/api/fs.html#fs_class_fs_writestream
[wsoptions]: https://nodejs.org/api/fs.html#fs_fs_createwritestream_path_options
[writefile]: https://nodejs.org/api/fs.html#fs_fs_writefile_file_data_options_callback
[writefilesync]: https://nodejs.org/api/fs.html#fs_fs_writefilesync_file_data_options
[writable]: https://nodejs.org/api/stream.html#stream_class_stream_writable
