# {%= name %} {%= badge("fury") %} {%= badge("travis") %}

> {%= description %}

**Changes from v1.0.0 to v{%= version %}** 

- all path-related properties are now on the `path` object
- all boolean properties are now on the `is` object
- adds `base` property

See the [properties](#properties) section for details.

{%= include("install-npm", {save: true}) %}

- parses 1,000+ glob patterns in 29ms (2.3 GHz Intel Core i7)
- Extensive [unit tests](./test.js) (more than 1,000 lines), covering wildcards, globstars, character classes, brace patterns, extglobs, dotfiles and other complex patterns.

See the tests for [hundreds of examples](./test.js).

## Usage

```js
var parseGlob = require('{%= name %}');
```

**Example**

```js
parseGlob('a/b/c/**/*.{yml,json}');
```

**Returns:**

```js
{ orig: 'a/b/c/**/*.{yml,json}',
  is:
   { glob: true,
     negated: false,
     extglob: false,
     braces: true,
     brackets: false,
     globstar: true,
     dotfile: false,
     dotdir: false },
  glob: '**/*.{yml,json}',
  base: 'a/b/c',
  path:
   { dirname: 'a/b/c/**/',
     basename: '*.{yml,json}',
     filename: '*',
     extname: '.{yml,json}',
     ext: '{yml,json}' } }
```

## Properties

The object returned by parseGlob has the following properties:

- `orig`: a copy of the original, unmodified glob pattern
- `is`: an object with boolean information about the glob:
  + `glob`: true if the pattern actually a glob pattern
  + `negated`: true if it's a negation pattern (`!**/foo.js`)
  + `extglob`: true if it has extglobs (`@(foo|bar)`)
  + `braces`: true if it has braces (`{1..2}` or `.{txt,md}`)
  + `brackets`: true if it has POSIX brackets (`[[:alpha:]]`)
  + `globstar`: true if the pattern has a globstar (double star, `**`)
  + `dotfile`: true if the pattern should match dotfiles 
  + `dotdir`: true if the pattern should match dot-directories (like `.git`)
- `glob`: the glob pattern part of the string, if any
- `base`: the non-glob part of the string, if any
- `path`: file path segments
  + `dirname`: directory
  + `basename`: file name with extension
  + `filename`: file name without extension
  + `extname`: file extension with dot
  + `ext`: file extension without dot

## Related
{%= related(['glob-base', 'glob-parent', 'is-glob', 'glob-path-regex', 'micromatch']) %}

## Contributing
{%= include("contributing") %}

## Tests
{%= include("tests") %}

## Author
{%= include("author") %}

## License
{%= copyright({year: 2014}) %}
{%= license() %}

***

{%= include("footer") %}
