<!-- Do not edit this file. It is automatically generated by API Documenter. -->

[Home](./index.md) &gt; [puppeteer](./puppeteer.md)

## puppeteer package

## Classes

|  Class | Description |
|  --- | --- |
|  [Accessibility](./puppeteer.accessibility.md) | The Accessibility class provides methods for inspecting Chromium's accessibility tree. The accessibility tree is used by assistive technology such as [screen readers](https://en.wikipedia.org/wiki/Screen_reader) or [switches](https://en.wikipedia.org/wiki/Switch_access). |
|  [Browser](./puppeteer.browser.md) | A Browser is created when Puppeteer connects to a Chromium instance, either through [PuppeteerNode.launch()](./puppeteer.puppeteernode.launch.md) or [Puppeteer.connect()](./puppeteer.puppeteer.connect.md). |
|  [BrowserContext](./puppeteer.browsercontext.md) | BrowserContexts provide a way to operate multiple independent browser sessions. When a browser is launched, it has a single BrowserContext used by default. The method [Browser.newPage](./puppeteer.browser.newpage.md) creates a page in the default browser context. |
|  [BrowserFetcher](./puppeteer.browserfetcher.md) | BrowserFetcher can download and manage different versions of Chromium and Firefox. |
|  [CDPSession](./puppeteer.cdpsession.md) | The <code>CDPSession</code> instances are used to talk raw Chrome Devtools Protocol. |
|  [Connection](./puppeteer.connection.md) |  |
|  [ConsoleMessage](./puppeteer.consolemessage.md) | ConsoleMessage objects are dispatched by page via the 'console' event. |
|  [Coverage](./puppeteer.coverage.md) | The Coverage class provides methods to gathers information about parts of JavaScript and CSS that were used by the page. |
|  [CSSCoverage](./puppeteer.csscoverage.md) |  |
|  [CustomError](./puppeteer.customerror.md) |  |
|  [Dialog](./puppeteer.dialog.md) | Dialog instances are dispatched by the [Page](./puppeteer.page.md) via the <code>dialog</code> event. |
|  [ElementHandle](./puppeteer.elementhandle.md) | ElementHandle represents an in-page DOM element. |
|  [EventEmitter](./puppeteer.eventemitter.md) | The EventEmitter class that many Puppeteer classes extend. |
|  [ExecutionContext](./puppeteer.executioncontext.md) | This class represents a context for JavaScript execution. A \[Page\] might have many execution contexts: - each [frame](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/iframe) has "default" execution context that is always created after frame is attached to DOM. This context is returned by the [Frame.executionContext()](./puppeteer.frame.executioncontext.md) method. - [Extension](https://developer.chrome.com/extensions)'s content scripts create additional execution contexts.Besides pages, execution contexts can be found in [workers](https://developer.mozilla.org/en-US/docs/Web/API/Web_Workers_API). |
|  [FileChooser](./puppeteer.filechooser.md) | File choosers let you react to the page requesting for a file. |
|  [Frame](./puppeteer.frame.md) | At every point of time, page exposes its current frame tree via the [page.mainFrame](./puppeteer.page.mainframe.md) and [frame.childFrames](./puppeteer.frame.childframes.md) methods. |
|  [HTTPRequest](./puppeteer.httprequest.md) | Represents an HTTP request sent by a page. |
|  [HTTPResponse](./puppeteer.httpresponse.md) | The HTTPResponse class represents responses which are received by the [Page](./puppeteer.page.md) class. |
|  [JSCoverage](./puppeteer.jscoverage.md) |  |
|  [JSHandle](./puppeteer.jshandle.md) | Represents an in-page JavaScript object. JSHandles can be created with the [page.evaluateHandle](./puppeteer.page.evaluatehandle.md) method. |
|  [Keyboard](./puppeteer.keyboard.md) | Keyboard provides an api for managing a virtual keyboard. The high level api is [Keyboard.type()](./puppeteer.keyboard.type.md), which takes raw characters and generates proper keydown, keypress/input, and keyup events on your page. |
|  [Mouse](./puppeteer.mouse.md) | The Mouse class operates in main-frame CSS pixels relative to the top-left corner of the viewport. |
|  [Page](./puppeteer.page.md) | Page provides methods to interact with a single tab or [extension background page](https://developer.chrome.com/extensions/background_pages) in Chromium. |
|  [Puppeteer](./puppeteer.puppeteer.md) | The main Puppeteer class.IMPORTANT: if you are using Puppeteer in a Node environment, you will get an instance of [PuppeteerNode](./puppeteer.puppeteernode.md) when you import or require <code>puppeteer</code>. That class extends <code>Puppeteer</code>, so has all the methods documented below as well as all that are defined on [PuppeteerNode](./puppeteer.puppeteernode.md). |
|  [PuppeteerNode](./puppeteer.puppeteernode.md) | Extends the main [Puppeteer](./puppeteer.puppeteer.md) class with Node specific behaviour for fetching and downloading browsers.If you're using Puppeteer in a Node environment, this is the class you'll get when you run <code>require('puppeteer')</code> (or the equivalent ES <code>import</code>). |
|  [SecurityDetails](./puppeteer.securitydetails.md) | The SecurityDetails class represents the security details of a response that was received over a secure connection. |
|  [Target](./puppeteer.target.md) |  |
|  [TimeoutError](./puppeteer.timeouterror.md) | TimeoutError is emitted whenever certain operations are terminated due to timeout. |
|  [Touchscreen](./puppeteer.touchscreen.md) | The Touchscreen class exposes touchscreen events. |
|  [Tracing](./puppeteer.tracing.md) | The Tracing class exposes the tracing audit interface. |
|  [WebWorker](./puppeteer.webworker.md) | The WebWorker class represents a [WebWorker](https://developer.mozilla.org/en-US/docs/Web/API/Web_Workers_API). |

## Enumerations

|  Enumeration | Description |
|  --- | --- |
|  [BrowserContextEmittedEvents](./puppeteer.browsercontextemittedevents.md) |  |
|  [BrowserEmittedEvents](./puppeteer.browseremittedevents.md) | All the events a [browser instance](./puppeteer.browser.md) may emit. |
|  [PageEmittedEvents](./puppeteer.pageemittedevents.md) | All the events that a page instance may emit. |

## Functions

|  Function | Description |
|  --- | --- |
|  [clearCustomQueryHandlers()](./puppeteer.clearcustomqueryhandlers.md) | Clears all registered handlers. |
|  [connect(options)](./puppeteer.connect.md) | This method attaches Puppeteer to an existing browser instance. |
|  [customQueryHandlerNames()](./puppeteer.customqueryhandlernames.md) |  |
|  [launch(options)](./puppeteer.launch.md) | Launches puppeteer and launches a browser instance with given arguments and options when specified. |
|  [registerCustomQueryHandler(name, queryHandler)](./puppeteer.registercustomqueryhandler.md) | Registers a [custom query handler](./puppeteer.customqueryhandler.md). After registration, the handler can be used everywhere where a selector is expected by prepending the selection string with <code>&lt;name&gt;/</code>. The name is only allowed to consist of lower- and upper case latin letters. |
|  [unregisterCustomQueryHandler(name)](./puppeteer.unregistercustomqueryhandler.md) |  |

## Interfaces

|  Interface | Description |
|  --- | --- |
|  [BoundingBox](./puppeteer.boundingbox.md) |  |
|  [BoxModel](./puppeteer.boxmodel.md) |  |
|  [BrowserConnectOptions](./puppeteer.browserconnectoptions.md) | Generic browser options that can be passed when launching any browser or when connecting to an existing browser instance. |
|  [BrowserFetcherOptions](./puppeteer.browserfetcheroptions.md) |  |
|  [BrowserFetcherRevisionInfo](./puppeteer.browserfetcherrevisioninfo.md) |  |
|  [BrowserLaunchArgumentOptions](./puppeteer.browserlaunchargumentoptions.md) | Launcher options that only apply to Chrome. |
|  [CDPSessionOnMessageObject](./puppeteer.cdpsessiononmessageobject.md) |  |
|  [ClickOptions](./puppeteer.clickoptions.md) |  |
|  [CommonEventEmitter](./puppeteer.commoneventemitter.md) |  |
|  [ConnectionCallback](./puppeteer.connectioncallback.md) |  |
|  [ConnectionTransport](./puppeteer.connectiontransport.md) |  |
|  [ConnectOptions](./puppeteer.connectoptions.md) |  |
|  [ConsoleMessageLocation](./puppeteer.consolemessagelocation.md) |  |
|  [ContinueRequestOverrides](./puppeteer.continuerequestoverrides.md) |  |
|  [CoverageEntry](./puppeteer.coverageentry.md) | The CoverageEntry class represents one entry of the coverage report. |
|  [Credentials](./puppeteer.credentials.md) |  |
|  [CSSCoverageOptions](./puppeteer.csscoverageoptions.md) | Set of configurable options for CSS coverage. |
|  [CustomQueryHandler](./puppeteer.customqueryhandler.md) | Contains two functions <code>queryOne</code> and <code>queryAll</code> that can be [registered](./puppeteer.puppeteer.registercustomqueryhandler.md) as alternative querying strategies. The functions <code>queryOne</code> and <code>queryAll</code> are executed in the page context. <code>queryOne</code> should take an <code>Element</code> and a selector string as argument and return a single <code>Element</code> or <code>null</code> if no element is found. <code>queryAll</code> takes the same arguments but should instead return a <code>NodeListOf&lt;Element&gt;</code> or <code>Array&lt;Element&gt;</code> with all the elements that match the given query selector. |
|  [Device](./puppeteer.device.md) |  |
|  [FrameAddScriptTagOptions](./puppeteer.frameaddscripttagoptions.md) |  |
|  [FrameAddStyleTagOptions](./puppeteer.frameaddstyletagoptions.md) |  |
|  [FrameWaitForFunctionOptions](./puppeteer.framewaitforfunctionoptions.md) |  |
|  [GeolocationOptions](./puppeteer.geolocationoptions.md) |  |
|  [InternalNetworkConditions](./puppeteer.internalnetworkconditions.md) |  |
|  [JSCoverageOptions](./puppeteer.jscoverageoptions.md) | Set of configurable options for JS coverage. |
|  [JSONObject](./puppeteer.jsonobject.md) |  |
|  [LaunchOptions](./puppeteer.launchoptions.md) | Generic launch options that can be passed when launching any browser. |
|  [MediaFeature](./puppeteer.mediafeature.md) |  |
|  [Metrics](./puppeteer.metrics.md) |  |
|  [MouseOptions](./puppeteer.mouseoptions.md) |  |
|  [MouseWheelOptions](./puppeteer.mousewheeloptions.md) |  |
|  [NetworkConditions](./puppeteer.networkconditions.md) |  |
|  [PageEventObject](./puppeteer.pageeventobject.md) | Denotes the objects received by callback functions for page events.See [PageEmittedEvents](./puppeteer.pageemittedevents.md) for more detail on the events and when they are emitted. |
|  [PDFMargin](./puppeteer.pdfmargin.md) |  |
|  [PDFOptions](./puppeteer.pdfoptions.md) | Valid options to configure PDF generation via [Page.pdf()](./puppeteer.page.pdf.md). |
|  [Point](./puppeteer.point.md) |  |
|  [PressOptions](./puppeteer.pressoptions.md) |  |
|  [ProductLauncher](./puppeteer.productlauncher.md) | Describes a launcher - a class that is able to create and launch a browser instance. |
|  [PuppeteerEventListener](./puppeteer.puppeteereventlistener.md) |  |
|  [RemoteAddress](./puppeteer.remoteaddress.md) |  |
|  [ResponseForRequest](./puppeteer.responseforrequest.md) | Required response data to fulfill a request with. |
|  [ScreenshotClip](./puppeteer.screenshotclip.md) |  |
|  [ScreenshotOptions](./puppeteer.screenshotoptions.md) |  |
|  [SerializedAXNode](./puppeteer.serializedaxnode.md) | Represents a Node and the properties of it that are relevant to Accessibility. |
|  [SnapshotOptions](./puppeteer.snapshotoptions.md) |  |
|  [TracingOptions](./puppeteer.tracingoptions.md) |  |
|  [Viewport](./puppeteer.viewport.md) | Sets the viewport of the page. |
|  [WaitForOptions](./puppeteer.waitforoptions.md) |  |
|  [WaitForSelectorOptions](./puppeteer.waitforselectoroptions.md) |  |
|  [WaitForTargetOptions](./puppeteer.waitfortargetoptions.md) |  |
|  [WaitTimeoutOptions](./puppeteer.waittimeoutoptions.md) |  |

## Variables

|  Variable | Description |
|  --- | --- |
|  [devices](./puppeteer.devices.md) |  |
|  [errors](./puppeteer.errors.md) |  |
|  [EVALUATION\_SCRIPT\_URL](./puppeteer.evaluation_script_url.md) |  |
|  [networkConditions](./puppeteer.networkconditions.md) |  |
|  [puppeteerErrors](./puppeteer.puppeteererrors.md) |  |

## Type Aliases

|  Type Alias | Description |
|  --- | --- |
|  [ActionResult](./puppeteer.actionresult.md) |  |
|  [ChromeReleaseChannel](./puppeteer.chromereleasechannel.md) |  |
|  [ConsoleMessageType](./puppeteer.consolemessagetype.md) | The supported types for console messages. |
|  [DevicesMap](./puppeteer.devicesmap.md) |  |
|  [ErrorCode](./puppeteer.errorcode.md) |  |
|  [EvaluateFn](./puppeteer.evaluatefn.md) |  |
|  [EvaluateFnReturnType](./puppeteer.evaluatefnreturntype.md) |  |
|  [EvaluateHandleFn](./puppeteer.evaluatehandlefn.md) |  |
|  [EventType](./puppeteer.eventtype.md) |  |
|  [Handler](./puppeteer.handler.md) |  |
|  [InterceptResolutionStrategy](./puppeteer.interceptresolutionstrategy.md) |  |
|  [JSONArray](./puppeteer.jsonarray.md) |  |
|  [KeyInput](./puppeteer.keyinput.md) | All the valid keys that can be passed to functions that take user input, such as [keyboard.press](./puppeteer.keyboard.press.md) |
|  [MouseButton](./puppeteer.mousebutton.md) |  |
|  [PaperFormat](./puppeteer.paperformat.md) | All the valid paper format types when printing a PDF. |
|  [Permission](./puppeteer.permission.md) |  |
|  [Platform](./puppeteer.platform.md) | Supported platforms. |
|  [PredefinedNetworkConditions](./puppeteer.predefinednetworkconditions.md) |  |
|  [Product](./puppeteer.product.md) | Supported products. |
|  [ProtocolLifeCycleEvent](./puppeteer.protocollifecycleevent.md) |  |
|  [PuppeteerErrors](./puppeteer.puppeteererrors.md) |  |
|  [PuppeteerLifeCycleEvent](./puppeteer.puppeteerlifecycleevent.md) |  |
|  [PuppeteerNodeLaunchOptions](./puppeteer.puppeteernodelaunchoptions.md) | Utility type exposed to enable users to define options that can be passed to <code>puppeteer.launch</code> without having to list the set of all types. |
|  [ResourceType](./puppeteer.resourcetype.md) | Resource types for HTTPRequests as perceived by the rendering engine. |
|  [Serializable](./puppeteer.serializable.md) |  |
|  [SerializableOrJSHandle](./puppeteer.serializableorjshandle.md) |  |
|  [TargetFilterCallback](./puppeteer.targetfiltercallback.md) |  |
|  [UnwrapElementHandle](./puppeteer.unwrapelementhandle.md) | Unwraps a DOM element out of an ElementHandle instance |
|  [UnwrapPromiseLike](./puppeteer.unwrappromiselike.md) |  |
|  [WrapElementHandle](./puppeteer.wrapelementhandle.md) | Wraps a DOM element into an ElementHandle instance |

