<!-- Do not edit this file. It is automatically generated by API Documenter. -->

[Home](./index.md) &gt; [puppeteer](./puppeteer.md) &gt; [Page](./puppeteer.page.md) &gt; [select](./puppeteer.page.select.md)

## Page.select() method

Triggers a `change` and `input` event once all the provided options have been selected. If there's no `<select>` element matching `selector`, the method throws an error.

<b>Signature:</b>

```typescript
select(selector: string, ...values: string[]): Promise<string[]>;
```

## Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  selector | string | A [Selector](https://developer.mozilla.org/en-US/docs/Web/CSS/CSS_Selectors) to query the page for |
|  values | string\[\] | Values of options to select. If the <code>&lt;select&gt;</code> has the <code>multiple</code> attribute, all values are considered, otherwise only the first one is taken into account. |

<b>Returns:</b>

Promise&lt;string\[\]&gt;


## Remarks

Shortcut for [page.mainFrame().select()](./puppeteer.frame.select.md)

## Example


```js
page.select('select#colors', 'blue'); // single selection
page.select('select#colors', 'red', 'green', 'blue'); // multiple selections

```

