#/
# @license Apache-2.0
#
# Copyright (c) 2017 The Stdlib Authors.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#/

# RULES #

#/
# Runs Python benchmarks consecutively.
#
# ## Notes
#
# -   The recipe assumes that benchmark files can be run via Python.
# -   This rule is useful when wanting to glob for Python benchmark files (e.g., run all Python benchmarks for a particular package).
#
#
# @param {string} [BENCHMARKS_FILTER] - file path pattern (e.g., `.*/math/base/special/digamma/.*`)
#
# @example
# make benchmark-python
#
# @example
# make benchmark-python BENCHMARKS_FILTER=".*/math/base/special/digamma/.*"
#/
benchmark-python:
	$(QUIET) $(FIND_PYTHON_BENCHMARKS_CMD) | grep '^[\/]\|^[a-zA-Z]:[/\]' | while read -r file; do \
		echo ""; \
		echo "Running benchmark: $$file"; \
		$(PYTHON) $$file || exit 1; \
	done

.PHONY: benchmark-python

#/
# Runs a specified list of Python benchmarks consecutively.
#
# ## Notes
#
# -   The recipe assumes that benchmark files can be run via Python.
# -   This rule is useful when wanting to run a list of Python benchmark files generated by some other command (e.g., a list of changed Python benchmark files obtained via `git diff`).
#
#
# @param {string} FILES - list of Python benchmark file paths
#
# @example
# make benchmark-python-files FILES='/foo/benchmark.py /bar/benchmark.py'
#/
benchmark-python-files:
	$(QUIET) for file in $(FILES); do \
		echo ""; \
		echo "Running benchmark: $$file"; \
		$(PYTHON) $$file || exit 1; \
	done

.PHONY: benchmark-python-files
