/*
 *  Copyright (C) 2004 Mathias Andre <mathias@openbrookes.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 */

#include <glib.h>
#include <time.h>

#include "nb_util.h"

#define _(text) gettext(text)

gchar *
nb_util_get_date_string (GDate * date)
{
	gchar * cdate = NULL;
	GDate * tmp_date;

	/* if date is null then return current date */
	if ( date == NULL )
		return g_strdup ((gchar *) _("Today"));

	tmp_date = g_date_new ();
	g_date_set_time (tmp_date, time (NULL));

	if ( g_date_compare (date, tmp_date) == 0 )
		cdate = g_strdup ((gchar *) _("Today"));

	g_date_subtract_days (tmp_date, 1); /* set the date to the day before */

	if ( g_date_compare (date, tmp_date) == 0 )
		cdate = g_strdup ((gchar *) _("Yesterday"));

	/* if the date is during the last 7 days then we set it as the name of the day */
	if ( (cdate == NULL) && (g_date_days_between (date, tmp_date) <= 5) )	
	{
		switch (g_date_get_weekday (date))
		{
			case G_DATE_MONDAY:
			{
				cdate = g_strdup ((gchar *) _("Monday"));
				break;
			}
			case G_DATE_TUESDAY:
			{
				cdate = g_strdup ((gchar *) _("Tuesday"));
				break;
			}
			case G_DATE_WEDNESDAY:
			{
				cdate = g_strdup ((gchar *) _("Wednesday"));
				break;
			}
			case G_DATE_THURSDAY:
			{
				cdate = g_strdup ((gchar *) _("Thursday"));
				break;
			}
			case G_DATE_FRIDAY:
			{
				cdate = g_strdup ((gchar *) _("Friday"));
				break;
			}
			case G_DATE_SATURDAY:
			{
				cdate = g_strdup ((gchar *) _("Saturday"));
				break;
			}
			case G_DATE_SUNDAY:
			{
				cdate = g_strdup ((gchar *) _("Sunday"));
				break;
			}
		}
	}

	if ( cdate == NULL)
	{
		/* not very clean, should try to make it dynamic */
		cdate = g_malloc (128 * sizeof (gchar));
		g_date_strftime (cdate, 127, "%A %d %b", date);
	}

	g_date_free (tmp_date);

	return cdate;
}
