/*
 * Decompiled with CFR 0.152.
 */
package com.sourceforge.knecs.dsm.dsi;

import com.sourceforge.knecs.dsm.dsi.DSI;
import com.sourceforge.knecs.dsm.dsi.DSIProperty;
import com.sourceforge.knecs.dsm.util.ISequenceGenerator;
import com.sourceforge.knecs.util.CMCSProperties;
import com.sourceforge.knecs.util.NSProperty;

public class DAVSequenceGenerator
implements ISequenceGenerator {
    private static String mPropertyName = "";
    private static String mPropertyNamespace = "";
    private static String mPath = "";
    private static String mServer = "";
    private static String mUser = "";
    private static String mPassword = "";
    public static String SEQ_NUMBER_PATH;
    public static String SEQ_NUMBER_PROP_NAME;
    public static String SEQ_NUMBER_PROP_NAMESPACE;
    public static String DATA_SERVER;

    public DAVSequenceGenerator() {
        mServer = DATA_SERVER;
        mPath = SEQ_NUMBER_PATH;
        mPropertyName = SEQ_NUMBER_PROP_NAME;
        mPropertyNamespace = SEQ_NUMBER_PROP_NAMESPACE;
    }

    public DAVSequenceGenerator(String path, NSProperty prop, String user, String password) {
        mPath = path;
        if (!mPath.startsWith("/")) {
            mPath = "/" + mPath;
        }
        mPropertyName = prop.getLocalName();
        mPropertyNamespace = prop.getNamespaceURI();
        mUser = user;
        mPassword = password;
        mServer = DATA_SERVER;
    }

    public synchronized int next() throws Exception {
        NSProperty nsProp = new NSProperty(mPropertyNamespace, mPropertyName);
        DSI dsi = new DSI(mServer + mPath, mUser, mPassword);
        int value = DAVSequenceGenerator.getInt(nsProp, dsi);
        return value;
    }

    private static synchronized int getInt(NSProperty prop, DSI dsi) throws Exception {
        DSIProperty dsiprop = dsi.getMetaData(prop);
        String nextAsString = dsiprop.getPropertyAsString();
        Integer nextAsInteger = new Integer(nextAsString);
        int value = nextAsInteger;
        int newValue = value + 1;
        String newNextAsString = Integer.toString(newValue);
        dsi.putMetaData(prop, newNextAsString);
        return value;
    }

    static {
        CMCSProperties props = CMCSProperties.getCMCSProperties();
        SEQ_NUMBER_PATH = (String)props.get("davsequencenumberpath");
        SEQ_NUMBER_PROP_NAME = (String)props.get("davsequencenumberpropertyname");
        SEQ_NUMBER_PROP_NAMESPACE = (String)props.get("cmcsint");
        DATA_SERVER = (String)props.get("samserver");
    }
}

