/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.modules.actions.sessionvalidator;

import org.apache.turbine.modules.actions.sessionvalidator.SessionValidator;
import org.apache.turbine.services.resources.TurbineResources;
import org.apache.turbine.util.RunData;

public class TemplateSecureSessionValidator
extends SessionValidator {
    public void doPerform(RunData data) throws Exception {
        data.populate();
        if (data.getUser() == null || !data.getUser().hasLoggedIn()) {
            if (data.getMessage() == null) {
                data.setMessage(TurbineResources.getString("login.message"));
            }
            data.getTemplateInfo().setScreenTemplate(TurbineResources.getString("template.login"));
            data.setAction(null);
        }
        if (!data.hasScreen() && data.getTemplateInfo().getScreenTemplate() == null) {
            String template = TurbineResources.getString("template.homepage");
            if (template != null) {
                data.getTemplateInfo().setScreenTemplate(template);
            } else {
                data.setScreen(TurbineResources.getString("screen.homepage"));
            }
        } else if (data.getParameters().containsKey("_session_access_counter") && data.getParameters().getInt("_session_access_counter") < (Integer)data.getUser().getTemp("_session_access_counter") - 1) {
            if (data.getTemplateInfo().getScreenTemplate() != null) {
                data.getTemplateInfo().setScreenTemplate(TurbineResources.getString("template.invalidstate"));
                data.getUser().setTemp("prev_template", data.getTemplateInfo().getScreenTemplate());
            } else {
                data.setScreen(TurbineResources.getString("screen.invalidstate"));
                data.getUser().setTemp("prev_screen", data.getScreen());
            }
            data.getUser().setTemp("prev_parameters", data.getParameters());
            data.setAction("");
        }
        if (data.getTemplateInfo().getScreenTemplate() != null) {
            data.setScreen(null);
        }
    }

    public boolean requiresNewSession(RunData data) {
        return true;
    }
}

