/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.xmlrpc;

import helma.xmlrpc.WebServer;
import helma.xmlrpc.XmlRpc;
import helma.xmlrpc.XmlRpcClient;
import helma.xmlrpc.XmlRpcException;
import helma.xmlrpc.XmlRpcServer;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URL;
import java.util.Iterator;
import java.util.Vector;
import javax.servlet.ServletConfig;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.services.resources.ResourceService;
import org.apache.turbine.services.xmlrpc.XmlRpcService;
import org.apache.turbine.services.xmlrpc.util.FileTransfer;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.TurbineException;

public class TurbineXmlRpcService
extends TurbineBaseService
implements XmlRpcService {
    private WebServer webserver = null;
    private XmlRpcServer server = null;
    private XmlRpcClient client = null;
    private int port = 0;

    public void init(ServletConfig config) throws InitializationException {
        try {
            ResourceService resources = ((TurbineServices)TurbineServices.getInstance()).getResources(this.getName());
            this.server = new XmlRpcServer();
            this.port = resources.getInt("port", 0);
            if (this.port != 0) {
                this.webserver = new WebServer(this.port);
            }
            String saxParserClass = resources.getString("parser", "org.apache.xerces.parsers.SAXParser");
            XmlRpc.setDriver((String)saxParserClass);
            Iterator keys = resources.getKeys("handler");
            while (keys.hasNext()) {
                String handler = (String)keys.next();
                String handlerName = handler.substring(handler.indexOf(".") + 1);
                String handlerClass = resources.getString(handler);
                this.registerHandler(handlerName, handlerClass);
            }
            boolean stateOfParanoia = resources.getBoolean("paranoid", false);
            if (stateOfParanoia) {
                this.webserver.setParanoid(stateOfParanoia);
                Log.info("XmlRpcService: Operating in a state of paranoia");
                Vector acceptedClients = resources.getVector("acceptClient");
                int i = 0;
                while (i < acceptedClients.size()) {
                    String acceptClient = (String)acceptedClients.get(i);
                    if (acceptClient != null && !acceptClient.equals("")) {
                        this.webserver.acceptClient(acceptClient);
                        Log.info("XmlRpcService: Accepting client -> " + acceptClient);
                    }
                    ++i;
                }
                Vector deniedClients = resources.getVector("denyClient");
                int i2 = 0;
                while (i2 < deniedClients.size()) {
                    String denyClient = (String)deniedClients.get(i2);
                    if (denyClient != null && !denyClient.equals("")) {
                        this.webserver.denyClient(denyClient);
                        Log.info("XmlRpcService: Denying client -> " + denyClient);
                    }
                    ++i2;
                }
            }
        }
        catch (Exception e) {
            throw new InitializationException("XMLRPCService failed to initialize", e);
        }
        this.setInit(true);
    }

    public void registerHandler(Object handler) throws XmlRpcException, IOException {
        this.registerHandler("$default", handler);
    }

    public void registerHandler(String handlerName, Object handler) throws XmlRpcException, IOException {
        if (this.webserver != null) {
            this.webserver.addHandler(handlerName, handler);
        }
        this.server.addHandler(handlerName, handler);
    }

    public void registerHandler(String handlerName, String handlerClass) throws TurbineException {
        try {
            Object handler = Class.forName(handlerClass).newInstance();
            if (this.webserver != null) {
                this.webserver.addHandler(handlerName, handler);
            }
            this.server.addHandler(handlerName, handler);
        }
        catch (ThreadDeath t) {
            throw t;
        }
        catch (OutOfMemoryError t) {
            throw t;
        }
        catch (Throwable t) {
            throw new TurbineException("Failed to instantiate " + handlerClass, t);
        }
    }

    public void unregisterHandler(String handlerName) {
        if (this.webserver != null) {
            this.webserver.removeHandler(handlerName);
        }
        this.server.removeHandler(handlerName);
    }

    public byte[] handleRequest(InputStream is) {
        return this.server.execute(is);
    }

    public byte[] handleRequest(InputStream is, String user, String password) {
        return this.server.execute(is, user, password);
    }

    public Object executeRpc(URL url, String methodName, Vector params) throws TurbineException {
        try {
            XmlRpcClient client = new XmlRpcClient(url);
            return client.execute(methodName, params);
        }
        catch (Exception e) {
            throw new TurbineException("XML-RPC call failed", e);
        }
    }

    public void send(String serverURL, String sourceLocationProperty, String sourceFileName, String destinationLocationProperty, String destinationFileName) throws Exception {
        FileTransfer.send(serverURL, sourceLocationProperty, sourceFileName, destinationLocationProperty, destinationFileName);
    }

    public void get(String serverURL, String sourceLocationProperty, String sourceFileName, String destinationLocationProperty, String destinationFileName) throws Exception {
        FileTransfer.get(serverURL, sourceLocationProperty, sourceFileName, destinationLocationProperty, destinationFileName);
    }

    public void remove(String serverURL, String sourceLocationProperty, String sourceFileName) throws Exception {
        FileTransfer.remove(serverURL, sourceLocationProperty, sourceFileName);
    }

    public void setParanoid(boolean state) {
        this.webserver.setParanoid(state);
    }

    public void acceptClient(String address) {
        this.webserver.acceptClient(address);
    }

    public void denyClient(String address) {
        this.webserver.denyClient(address);
    }

    public void shutdown() {
        this.webserver.shutdown();
        try {
            Socket interrupt = new Socket(InetAddress.getLocalHost(), this.port);
            interrupt.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setInit(false);
    }
}

