/*
 * Decompiled with CFR 0.152.
 */
package org.chefproject.servlet;

import java.util.Hashtable;

class ChefdavStatus {
    private static Hashtable mapStatusCodes = new Hashtable();
    public static final int SC_OK = 200;
    public static final int SC_CREATED = 201;
    public static final int SC_ACCEPTED = 202;
    public static final int SC_NO_CONTENT = 204;
    public static final int SC_MOVED_PERMANENTLY = 301;
    public static final int SC_MOVED_TEMPORARILY = 302;
    public static final int SC_NOT_MODIFIED = 304;
    public static final int SC_BAD_REQUEST = 400;
    public static final int SC_UNAUTHORIZED = 401;
    public static final int SC_FORBIDDEN = 403;
    public static final int SC_NOT_FOUND = 404;
    public static final int SC_INTERNAL_SERVER_ERROR = 500;
    public static final int SC_NOT_IMPLEMENTED = 501;
    public static final int SC_BAD_GATEWAY = 502;
    public static final int SC_SERVICE_UNAVAILABLE = 503;
    public static final int SC_CONTINUE = 100;
    public static final int SC_METHOD_NOT_ALLOWED = 405;
    public static final int SC_CONFLICT = 409;
    public static final int SC_PRECONDITION_FAILED = 412;
    public static final int SC_REQUEST_TOO_LONG = 413;
    public static final int SC_UNSUPPORTED_MEDIA_TYPE = 415;
    public static final int SC_MULTI_STATUS = 207;
    public static final int SC_UNPROCESSABLE_ENTITY = 418;
    public static final int SC_INSUFFICIENT_SPACE_ON_RESOURCE = 419;
    public static final int SC_METHOD_FAILURE = 420;
    public static final int SC_LOCKED = 423;

    ChefdavStatus() {
    }

    public static String getStatusText(int nHttpStatusCode) {
        Integer intKey = new Integer(nHttpStatusCode);
        if (!mapStatusCodes.containsKey(intKey)) {
            return "";
        }
        return (String)mapStatusCodes.get(intKey);
    }

    private static void addStatusCodeMap(int nKey, String strVal) {
        mapStatusCodes.put(new Integer(nKey), strVal);
    }

    static {
        SC_OK = 200;
        SC_CREATED = 201;
        SC_ACCEPTED = 202;
        SC_NO_CONTENT = 204;
        SC_MOVED_PERMANENTLY = 301;
        SC_MOVED_TEMPORARILY = 302;
        SC_NOT_MODIFIED = 304;
        SC_BAD_REQUEST = 400;
        SC_UNAUTHORIZED = 401;
        SC_FORBIDDEN = 403;
        SC_NOT_FOUND = 404;
        SC_INTERNAL_SERVER_ERROR = 500;
        SC_NOT_IMPLEMENTED = 501;
        SC_BAD_GATEWAY = 502;
        SC_SERVICE_UNAVAILABLE = 503;
        SC_CONTINUE = 100;
        SC_METHOD_NOT_ALLOWED = 405;
        SC_CONFLICT = 409;
        SC_PRECONDITION_FAILED = 412;
        SC_REQUEST_TOO_LONG = 413;
        SC_UNSUPPORTED_MEDIA_TYPE = 415;
        SC_MULTI_STATUS = 207;
        SC_UNPROCESSABLE_ENTITY = 418;
        SC_INSUFFICIENT_SPACE_ON_RESOURCE = 419;
        SC_METHOD_FAILURE = 420;
        SC_LOCKED = 423;
        ChefdavStatus.addStatusCodeMap(200, "OK");
        ChefdavStatus.addStatusCodeMap(201, "Created");
        ChefdavStatus.addStatusCodeMap(202, "Accepted");
        ChefdavStatus.addStatusCodeMap(204, "No Content");
        ChefdavStatus.addStatusCodeMap(301, "Moved Permanently");
        ChefdavStatus.addStatusCodeMap(302, "Moved Temporarily");
        ChefdavStatus.addStatusCodeMap(304, "Not Modified");
        ChefdavStatus.addStatusCodeMap(400, "Bad Request");
        ChefdavStatus.addStatusCodeMap(401, "Unauthorized");
        ChefdavStatus.addStatusCodeMap(403, "Forbidden");
        ChefdavStatus.addStatusCodeMap(404, "Not Found");
        ChefdavStatus.addStatusCodeMap(500, "Internal Server Error");
        ChefdavStatus.addStatusCodeMap(501, "Not Implemented");
        ChefdavStatus.addStatusCodeMap(502, "Bad Gateway");
        ChefdavStatus.addStatusCodeMap(503, "Service Unavailable");
        ChefdavStatus.addStatusCodeMap(100, "Continue");
        ChefdavStatus.addStatusCodeMap(405, "Method Not Allowed");
        ChefdavStatus.addStatusCodeMap(409, "Conflict");
        ChefdavStatus.addStatusCodeMap(412, "Precondition Failed");
        ChefdavStatus.addStatusCodeMap(413, "Request Too Long");
        ChefdavStatus.addStatusCodeMap(415, "Unsupported Media Type");
        ChefdavStatus.addStatusCodeMap(207, "Multi-Status");
        ChefdavStatus.addStatusCodeMap(418, "Unprocessable Entity");
        ChefdavStatus.addStatusCodeMap(419, "Insufficient Space On Resource");
        ChefdavStatus.addStatusCodeMap(420, "Method Failure");
        ChefdavStatus.addStatusCodeMap(423, "Locked");
    }
}

