/*
 * Decompiled with CFR 0.152.
 */
package org.chefproject.util;

public class FlexStringArray {
    protected String[] m_array;
    protected int m_index;
    protected int m_initialSize;
    protected int m_expandBy;

    public FlexStringArray() {
        this.m_initialSize = 10;
        this.m_expandBy = 10;
        this.m_array = new String[10];
        this.m_index = -1;
    }

    public FlexStringArray(int initialSize, int expandBy) {
        this.m_index = -1;
        this.m_initialSize = initialSize < 1 ? 10 : initialSize;
        this.m_expandBy = expandBy < 1 ? 10 : expandBy;
        this.m_array = new String[this.m_initialSize];
    }

    public FlexStringArray(FlexStringArray flexArray) {
        if (flexArray != null) {
            this.m_index = -1;
            this.m_expandBy = flexArray.m_expandBy;
            String[] contents = flexArray.getSizedArray();
            this.m_initialSize = contents.length + this.m_expandBy;
            this.m_array = new String[this.m_initialSize];
            int x = 0;
            while (x < contents.length) {
                this.m_array[x] = new String(contents[x]);
                ++x;
            }
            this.m_index = contents.length - 1;
        } else {
            this.m_initialSize = 10;
            this.m_expandBy = 10;
            this.m_array = new String[10];
            this.m_index = -1;
        }
    }

    public FlexStringArray(String[] stringArray) {
        if (stringArray != null) {
            this.m_index = -1;
            this.m_expandBy = stringArray.length > 20 ? stringArray.length / 2 : 10;
            this.m_initialSize = stringArray.length + this.m_expandBy;
            this.m_array = new String[this.m_initialSize];
            int x = 0;
            while (x < stringArray.length) {
                this.m_array[x] = new String(stringArray[x]);
                ++x;
            }
            this.m_index = stringArray.length - 1;
        } else {
            this.m_initialSize = 10;
            this.m_expandBy = 10;
            this.m_array = new String[10];
            this.m_index = -1;
        }
    }

    public void add(String string) {
        if (string != null) {
            if (this.m_index == this.m_array.length - 1) {
                this.m_array = this.flex();
            }
            this.m_array[++this.m_index] = string;
        }
    }

    public String get(int index) {
        String retVal = null;
        if (index < this.m_index + 1) {
            retVal = this.m_array[index];
        }
        return retVal;
    }

    public void remove(int index) {
        if (index > -1 && index < this.m_index + 1) {
            String[] newArray = new String[this.m_index];
            int x = 0;
            while (x < this.m_index) {
                newArray[x] = x < index ? this.m_array[x] : this.m_array[x + 1];
                ++x;
            }
            this.m_array = newArray;
            --this.m_index;
        }
    }

    public void remove(String item) {
        if (item != null) {
            int x = 0;
            while (x < this.m_index + 1) {
                if (item.equals(this.m_array[x])) {
                    this.remove(x);
                }
                ++x;
            }
        }
    }

    public boolean contains(String tryMe) {
        boolean retVal = false;
        if (tryMe != null) {
            int x = 0;
            while (x < this.m_index + 1) {
                if (tryMe.equals(this.m_array[x])) {
                    retVal = true;
                }
                ++x;
            }
        }
        return retVal;
    }

    public void replace(int index, String newValue) {
        if (index > -1 && index < this.m_index + 1 && newValue != null) {
            this.m_array[index] = newValue;
        }
    }

    public int size() {
        return this.m_index + 1;
    }

    public String[] getSizedArray() {
        String[] retVal = new String[this.m_index + 1];
        int x = 0;
        while (x < this.m_index + 1) {
            retVal[x] = this.m_array[x];
            ++x;
        }
        return retVal;
    }

    public FlexStringArray copy() {
        FlexStringArray retVal = new FlexStringArray(this.size() + this.m_expandBy, this.m_expandBy);
        int x = 0;
        while (x < this.size()) {
            retVal.add(new String(this.get(x)));
            ++x;
        }
        return retVal;
    }

    private String[] flex() {
        int length = this.m_array.length;
        String[] temp = new String[length + this.m_expandBy];
        int i = 0;
        while (i < length) {
            temp[i] = this.m_array[i];
            ++i;
        }
        return temp;
    }
}

