/*
 * Decompiled with CFR 0.152.
 */
package com.sourceforge.knecs.notification.subscriptions;

import com.sourceforge.knecs.dsm.resourceobject.DataRequest;
import com.sourceforge.knecs.dsm.resourceobject.ExpertiseProfile;
import com.sourceforge.knecs.dsm.resourceobject.Interest;
import com.sourceforge.knecs.dsm.search.QueryPredicate;
import com.sourceforge.knecs.notification.subscriptions.Subscription;
import com.sourceforge.knecs.util.CMCSProperties;
import com.sourceforge.knecs.util.LoggerUtils;
import com.sourceforge.knecs.util.NSProperty;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Logger;

public class SubscriptionXlators {
    private Logger mLogger = LoggerUtils.getLogger(this);
    private static final String LIKE = " LIKE ";
    private static final String OR = " OR ";
    private static final String AND = " AND ";

    public Hashtable requestToQueryData(DataRequest req) {
        Hashtable<NSProperty, QueryPredicate> ret = new Hashtable<NSProperty, QueryPredicate>();
        QueryPredicate query = null;
        CMCSProperties sysprops = CMCSProperties.getCMCSProperties();
        NSProperty speciesSearchKey = CMCSProperties.getPropertyAsNSProperty("hasspecies");
        String[] values = req.getSpeciesName();
        if (values != null && values.length > 0) {
            query = new QueryPredicate(speciesSearchKey, this.fixArray(req.getSpeciesName()), "contains", false);
            ret.put(speciesSearchKey, query);
        }
        if ((values = req.getChemProperties()) != null && values.length > 0) {
            query = new QueryPredicate(new NSProperty("http://purl.oclc.org/NET/cmcs/schema/:chemicalproperty"), this.fixArray(req.getChemProperties()), "contains", false);
            ret.put(new NSProperty("http://purl.oclc.org/NET/cmcs/schema/:chemicalproperty"), query);
        }
        return ret;
    }

    public Hashtable profileToQueryData(ExpertiseProfile profile) {
        Hashtable<NSProperty, QueryPredicate> ret = new Hashtable<NSProperty, QueryPredicate>();
        QueryPredicate query = null;
        CMCSProperties sysprops = CMCSProperties.getCMCSProperties();
        NSProperty speciesSearchKey = CMCSProperties.getPropertyAsNSProperty("hasspecies");
        String[] values = profile.getSpeciesName();
        if (values != null && values.length > 0) {
            query = new QueryPredicate(speciesSearchKey, this.fixArray(values), "contains", false);
            ret.put(speciesSearchKey, query);
        }
        if ((values = profile.getChemProperties()) != null && values.length > 0) {
            query = new QueryPredicate(new NSProperty("http://purl.oclc.org/NET/cmcs/schema/:chemicalproperty"), this.fixArray(values), "contains", false);
            ret.put(new NSProperty("http://purl.oclc.org/NET/cmcs/schema/:chemicalproperty"), query);
        }
        return ret;
    }

    public Hashtable interestToQueryData(Interest interest) {
        Hashtable<NSProperty, QueryPredicate> ret = new Hashtable<NSProperty, QueryPredicate>();
        QueryPredicate query = null;
        CMCSProperties sysprops = CMCSProperties.getCMCSProperties();
        NSProperty speciesSearchKey = CMCSProperties.getPropertyAsNSProperty("hasspecies");
        String[] values = interest.getSpeciesName();
        if (values != null && values.length > 0) {
            query = new QueryPredicate(speciesSearchKey, this.fixArray(values), "contains", false);
            ret.put(speciesSearchKey, query);
        }
        if ((values = interest.getChemProperties()) != null && values.length > 0) {
            query = new QueryPredicate(new NSProperty("http://purl.oclc.org/NET/cmcs/schema/:chemicalproperty"), this.fixArray(values), "contains", false);
            ret.put(new NSProperty("http://purl.oclc.org/NET/cmcs/schema/:chemicalproperty"), query);
        }
        if ((values = interest.getKeywords()) != null && values.length > 0) {
            query = new QueryPredicate(new NSProperty("http://purl.org/dc/elements/1.1/:subject"), this.fixArray(values), "contains", false);
            ret.put(new NSProperty("http://purl.org/dc/elements/1.1/:subject"), query);
        }
        if ((values = interest.getCreators()) != null && values.length > 0) {
            query = new QueryPredicate(new NSProperty("http://purl.org/dc/elements/1.1/:creator"), this.fixArray(values), "contains", false);
            ret.put(new NSProperty("http://purl.org/dc/elements/1.1/:creator"), query);
        }
        return ret;
    }

    public Vector requestToSAMSubscriptions(DataRequest req) {
        String[] props;
        Vector<Subscription> ret = new Vector<Subscription>();
        this.mLogger.fine("-------Begin DataRequest--------");
        CMCSProperties sysprops = CMCSProperties.getCMCSProperties();
        String propkey = sysprops.getProperty("sampropadd");
        StringBuffer filter = new StringBuffer();
        String[] species = req.getSpeciesName();
        if (species != null && species.length > 0) {
            this.addStringToFilter(filter, "", propkey, false, "speciesname", true);
        }
        if ((props = req.getChemProperties()) != null && props.length > 0) {
            this.addStringToFilter(filter, AND, propkey, false, "chemicalproperty", true);
        }
        propkey = sysprops.getProperty("samurl");
        String dir = sysprops.getProperty("portalobjects");
        dir = dir + "/" + sysprops.getProperty("datarequest");
        this.addStringToFilter(filter, AND, propkey, true, dir, true);
        propkey = sysprops.getProperty("sammethod");
        this.addStringToFilter(filter, AND, propkey, false, "PROPPATCH", false);
        String topic = sysprops.getProperty("samchangenotify");
        String[] tmpidlist = new String[]{req.getOwnerId()};
        Subscription sub = new Subscription(new Subscription(topic, new String(filter), tmpidlist));
        this.mLogger.fine("-------End DataRequest--------");
        ret.add(sub);
        return ret;
    }

    public Vector profileToSAMSubscriptions(ExpertiseProfile profile) {
        Vector<Subscription> ret = new Vector<Subscription>();
        this.mLogger.fine("-------Begin Profile--------");
        StringBuffer filter = new StringBuffer();
        CMCSProperties sysprops = CMCSProperties.getCMCSProperties();
        String propkey = "";
        propkey = sysprops.getProperty("sammethod");
        this.addStringToFilter(filter, AND, propkey, false, "PROPPATCH", false);
        propkey = sysprops.getProperty("samurl");
        String dir = sysprops.getProperty("portalobjects");
        dir = dir + "/" + sysprops.getProperty("datarequest");
        this.addStringToFilter(filter, AND, propkey, false, dir, true);
        String topic = sysprops.getProperty("samchangenotify");
        String[] tmpidlist = new String[]{profile.getOwnerId()};
        Subscription sub = new Subscription(new Subscription(topic, new String(filter), tmpidlist));
        this.mLogger.fine("-------End Profile--------");
        ret.add(sub);
        return ret;
    }

    public Vector interestToSAMSubscriptions(Interest interest) {
        this.mLogger.fine("-------Begin Interest--------");
        CMCSProperties sysprops = CMCSProperties.getCMCSProperties();
        String propkey = sysprops.getProperty("sampropadd");
        Vector<Subscription> ret = new Vector<Subscription>();
        StringBuffer readFilter = null;
        StringBuffer writeFilter = null;
        StringBuffer rmvcpFilter = null;
        StringBuffer wmvcpFilter = null;
        Vector readOps = new Vector();
        Vector writeOps = new Vector();
        Vector rmvcpOps = new Vector();
        Vector wmvcpOps = new Vector();
        boolean idx = false;
        String[] events = interest.getEventType();
        if (events != null) {
            this.partitionEvents(events, readOps, writeOps, rmvcpOps, wmvcpOps);
            if (readOps.size() > 0) {
                readFilter = new StringBuffer();
            }
            if (writeOps.size() > 0) {
                writeFilter = new StringBuffer();
            }
            if (rmvcpOps.size() > 0) {
                rmvcpFilter = new StringBuffer();
            }
            if (wmvcpOps.size() > 0) {
                wmvcpFilter = new StringBuffer();
            }
        } else if (interest.getSpeciesName() != null || interest.getChemProperties() != null) {
            writeFilter = new StringBuffer();
        } else {
            this.mLogger.severe("No event specified for:\n" + interest.toXML());
        }
        String key = sysprops.getProperty("sammethod");
        this.addToFilterV(readFilter, "", key, readOps, false, OR);
        this.addToFilterV(writeFilter, "", key, writeOps, false, OR);
        this.addToFilterV(rmvcpFilter, "", key, rmvcpOps, false, OR);
        this.addToFilterV(wmvcpFilter, "", key, wmvcpOps, false, OR);
        if (readFilter != null) {
            this.mLogger.fine("readFilter after events " + new String(readFilter));
        }
        if (writeFilter != null) {
            this.mLogger.fine("wrteFilter after events " + new String(writeFilter));
        }
        if (rmvcpFilter != null) {
            this.mLogger.fine("rmvcpFilter after events " + new String(rmvcpFilter));
        }
        if (wmvcpFilter != null) {
            this.mLogger.fine("wmvcpFilter after events " + new String(wmvcpFilter));
        }
        String[] url = interest.getUrlContext();
        boolean includeChildren = interest.getIncludeChildren();
        key = sysprops.getProperty("samurl");
        String newkey = sysprops.getProperty("samnewurl");
        if (url != null) {
            if (url[0].startsWith("http")) {
                if (includeChildren) {
                    this.addToFilter(readFilter, AND, key, url, true, OR, false, true);
                    this.addToFilter(writeFilter, AND, key, url, true, OR, false, true);
                    this.addToFilter(rmvcpFilter, AND, key, url, true, OR, false, true);
                    this.addToFilter(wmvcpFilter, AND, newkey, url, true, OR, false, true);
                } else {
                    this.addToFilter(readFilter, AND, key, url, false, OR);
                    this.addToFilter(writeFilter, AND, key, url, false, OR);
                    this.addToFilter(rmvcpFilter, AND, key, url, false, OR);
                    this.addToFilter(wmvcpFilter, AND, newkey, url, false, OR);
                }
            } else if (includeChildren) {
                this.addToFilter(readFilter, AND, key, url, true, OR);
                this.addToFilter(writeFilter, AND, key, url, true, OR);
                this.addToFilter(rmvcpFilter, AND, key, url, true, OR);
                this.addToFilter(wmvcpFilter, AND, newkey, url, true, OR);
            } else {
                this.specialURLFilter(readFilter, AND, key, url, OR, false);
                this.specialURLFilter(writeFilter, AND, key, url, OR, false);
                this.specialURLFilter(rmvcpFilter, AND, key, url, OR, false);
                this.specialURLFilter(wmvcpFilter, AND, newkey, url, OR, false);
            }
        }
        String[] author = interest.getProducer();
        key = sysprops.getProperty("samuser");
        if (author != null) {
            this.addToFilter(readFilter, AND, key, author, false, OR);
            this.addToFilter(writeFilter, AND, key, author, false, OR);
        }
        String admin = sysprops.getProperty("portalid");
        this.addStringToFilter(readFilter, AND, key, true, admin, false);
        this.addStringToFilter(writeFilter, AND, key, true, admin, false);
        Vector<String> propmatches = new Vector<String>();
        String specieskey = sysprops.getProperty("hasspecies");
        specieskey = specieskey.substring(specieskey.lastIndexOf(":") + 1);
        String[] species = interest.getSpeciesName();
        String keywordkey = sysprops.getProperty("keyword");
        keywordkey = keywordkey.substring(keywordkey.lastIndexOf(":") + 1);
        String[] keywords = interest.getKeywords();
        String creatorkey = sysprops.getProperty("creator");
        creatorkey = creatorkey.substring(creatorkey.lastIndexOf(":") + 1);
        String[] creators = interest.getCreators();
        String chemkey = sysprops.getProperty("chemicalproperty");
        chemkey = chemkey.substring(chemkey.lastIndexOf(":") + 1);
        String[] props = interest.getChemProperties();
        if (species != null) {
            propmatches.add(specieskey);
        }
        if (props != null) {
            propmatches.add(chemkey);
        }
        if (keywords != null) {
            propmatches.add(keywordkey);
        }
        if (creators != null) {
            propmatches.add(creatorkey);
        }
        if (propmatches.size() > 0) {
            this.addToFilterV(readFilter, AND, propkey, propmatches, true, OR);
            this.addToFilterV(writeFilter, AND, propkey, propmatches, true, OR);
        }
        if (readFilter != null) {
            this.mLogger.info("Final readFilter: " + new String(readFilter));
        }
        if (writeFilter != null) {
            this.mLogger.info("Final wrteFilter: " + new String(writeFilter));
        }
        String readtopic = sysprops.getProperty("samaccessnotify");
        String writetopic = sysprops.getProperty("samchangenotify");
        if (readFilter != null) {
            ret.add(new Subscription(readtopic, new String(readFilter), interest.getRecipients()));
        }
        if (writeFilter != null) {
            ret.add(new Subscription(writetopic, new String(writeFilter), interest.getRecipients()));
        }
        if (rmvcpFilter != null) {
            ret.add(new Subscription(writetopic, new String(rmvcpFilter), interest.getRecipients()));
        }
        if (wmvcpFilter != null) {
            ret.add(new Subscription(writetopic, new String(wmvcpFilter), interest.getRecipients()));
        }
        this.mLogger.fine("---------End Interest--------");
        return ret;
    }

    private void partitionEvents(String[] events, Vector reads, Vector writes, Vector rmvcp, Vector wmvcp) {
        CMCSProperties props = CMCSProperties.getCMCSProperties();
        String readevents = props.getProperty("readevents");
        String writeevents = props.getProperty("writeevents");
        String opstr = "";
        for (int idx = 0; idx < events.length; ++idx) {
            Vector ops = CMCSProperties.getPropertyAsVector(events[idx]);
            opstr = opstr + props.getProperty(events[idx]);
            if (ops == null) {
                this.mLogger.severe(events[idx] + " is not defined.");
                continue;
            }
            for (int edx = 0; edx < ops.size(); ++edx) {
                String event = (String)ops.elementAt(edx);
                if (event.equals("MOVE") || event.equals("COPY")) continue;
                if (readevents.indexOf(event) >= 0) {
                    reads.add(event);
                }
                if (writeevents.indexOf(event) < 0) continue;
                writes.add(event);
            }
        }
        if (writes.size() > 0) {
            if (opstr.indexOf("MOVE") >= 0) {
                wmvcp.add("MOVE");
            }
            if (opstr.indexOf("COPY") >= 0) {
                wmvcp.add("COPY");
            }
        }
        if (reads.size() > 0) {
            if (opstr.indexOf("MOVE") >= 0) {
                rmvcp.add("MOVE");
            }
            if (opstr.indexOf("COPY") >= 0) {
                rmvcp.add("COPY");
            }
        }
    }

    private void addToFilter(StringBuffer result, String extop, String prop, String[] values, boolean substr, String intop) {
        this.addToFilter(result, extop, prop, values, substr, intop, substr, substr);
    }

    private void addToFilter(StringBuffer result, String extop, String prop, String[] values, boolean substr, String intop, boolean substrStart, boolean substrEnd) {
        String LIKE = LIKE;
        if (result != null && values != null && values.length > 0) {
            if (result.length() > 0) {
                result.append(extop);
            }
            if (values.length > 1) {
                result.append("(");
            }
            for (int idx = 0; idx < values.length; ++idx) {
                if (idx != 0) {
                    result.append(intop);
                }
                result.append(" ");
                result.append(prop);
                result.append(LIKE);
                result.append("'");
                if (substr) {
                    if (substrStart) {
                        result.append("%");
                    }
                    result.append(values[idx]);
                    if (substrEnd) {
                        result.append("%");
                    }
                } else {
                    result.append(values[idx]);
                }
                result.append("'");
            }
            if (values.length > 1) {
                result.append(")");
            }
        }
    }

    private void specialURLFilter(StringBuffer result, String extop, String prop, String[] values, String intop, boolean children) {
        String LIKE = LIKE;
        if (result != null && values != null && values.length > 0) {
            if (result.length() > 0) {
                result.append(extop);
            }
            if (values.length > 1) {
                result.append("(");
            }
            for (int idx = 0; idx < values.length; ++idx) {
                if (idx != 0) {
                    result.append(intop);
                }
                result.append(" ");
                result.append(prop);
                result.append(LIKE);
                result.append("'");
                result.append("%");
                result.append(values[idx]);
                result.append("%");
                result.append("'");
                if (children) continue;
                result.append(AND);
                result.append(prop);
                result.append(" NOT LIKE ");
                result.append("'");
                result.append("%");
                result.append(values[idx]);
                if (!values[idx].endsWith("/")) {
                    result.append("/");
                }
                result.append("%/_%");
                result.append("'");
            }
            if (values.length > 1) {
                result.append(")");
            }
        }
    }

    private void addToFilterV(StringBuffer result, String extop, String prop, Vector values, boolean substr, String intop) {
        String LIKE = LIKE;
        if (result != null && values != null && values.size() > 0) {
            if (result.length() > 0) {
                result.append(extop);
            }
            if (values.size() > 1) {
                result.append("(");
            }
            for (int idx = 0; idx < values.size(); ++idx) {
                if (idx != 0) {
                    result.append(intop);
                }
                result.append(" ");
                result.append(prop);
                result.append(LIKE);
                result.append("'");
                if (substr) {
                    result.append("%");
                    result.append((String)values.elementAt(idx));
                    result.append("%");
                } else {
                    result.append((String)values.elementAt(idx));
                }
                result.append("'");
            }
            if (values.size() > 1) {
                result.append(")");
            }
        }
    }

    private void addStringToFilter(StringBuffer result, String extop, String prop, boolean not, String value, boolean substr) {
        String LIKE = LIKE;
        if (result != null && value != null && value.length() > 0) {
            if (result.length() > 0) {
                result.append(extop);
            }
            result.append("(");
            result.append(prop);
            if (not) {
                result.append(" NOT");
            }
            result.append(LIKE);
            result.append("'");
            if (substr) {
                result.append("%");
                result.append(value);
                result.append("%");
            } else {
                result.append(value);
            }
            result.append("'");
            result.append(")");
        }
    }

    String[] fixArray(String[] array) {
        int idx;
        String[] ret = null;
        int count = 0;
        for (idx = 0; idx < array.length; ++idx) {
            if (array[idx].length() <= 0) continue;
            ++count;
        }
        ret = new String[count];
        int addidx = 0;
        for (idx = 0; idx < count; ++idx) {
            if (array[idx].length() <= 0) continue;
            ret[addidx] = array[idx];
            ++addidx;
        }
        return ret;
    }
}

