// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _GeomFill_ConstrainedFilling_HeaderFile
#define _GeomFill_ConstrainedFilling_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_DefineAlloc_HeaderFile
#include <Standard_DefineAlloc.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Handle_GeomFill_CoonsAlgPatch_HeaderFile
#include <Handle_GeomFill_CoonsAlgPatch.hxx>
#endif
#ifndef _Handle_GeomFill_TgtField_HeaderFile
#include <Handle_GeomFill_TgtField.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _GeomFill_CornerState_HeaderFile
#include <GeomFill_CornerState.hxx>
#endif
#ifndef _gp_Vec_HeaderFile
#include <gp_Vec.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Handle_TColgp_HArray1OfPnt_HeaderFile
#include <Handle_TColgp_HArray1OfPnt.hxx>
#endif
#ifndef _Handle_TColStd_HArray1OfInteger_HeaderFile
#include <Handle_TColStd_HArray1OfInteger.hxx>
#endif
#ifndef _Handle_TColStd_HArray1OfReal_HeaderFile
#include <Handle_TColStd_HArray1OfReal.hxx>
#endif
#ifndef _Handle_TColgp_HArray2OfPnt_HeaderFile
#include <Handle_TColgp_HArray2OfPnt.hxx>
#endif
#ifndef _Handle_Geom_BSplineSurface_HeaderFile
#include <Handle_Geom_BSplineSurface.hxx>
#endif
#ifndef _Handle_GeomFill_Boundary_HeaderFile
#include <Handle_GeomFill_Boundary.hxx>
#endif
#ifndef _Handle_GeomFill_BoundWithSurf_HeaderFile
#include <Handle_GeomFill_BoundWithSurf.hxx>
#endif
class GeomFill_CoonsAlgPatch;
class GeomFill_TgtField;
class TColgp_HArray1OfPnt;
class TColStd_HArray1OfInteger;
class TColStd_HArray1OfReal;
class TColgp_HArray2OfPnt;
class Geom_BSplineSurface;
class GeomFill_Boundary;
class GeomFill_BoundWithSurf;


//! An algorithm for constructing a BSpline surface filled <br>
//! from a series of boundaries which serve as path <br>
//! constraints and optionally, as tangency constraints. <br>
//! The algorithm accepts three or four curves as the <br>
//! boundaries of the target surface. <br>
//! A ConstrainedFilling object provides a framework for: <br>
//! -   defining the boundaries of the surface <br>
//! -   implementing the construction algorithm <br>
//! -   consulting the result. <br>
//! Warning <br>
//! This surface filling algorithm is specifically designed to <br>
//! be used in connection with fillets. Satisfactory results <br>
//! cannot be guaranteed for other uses. <br>
class GeomFill_ConstrainedFilling  {
public:

  DEFINE_STANDARD_ALLOC

  
//! Constructs an empty framework for filling a surface from boundaries. <br>
//! The boundaries of the surface will be defined, and the <br>
//! surface will be built by using the function Init. <br>
//! The surface will respect the following constraints: <br>
//! -   its degree will not be greater than MaxDeg <br>
//! -   the maximum number of segments MaxSeg which <br>
//!   BSpline surfaces can have. <br>
  Standard_EXPORT   GeomFill_ConstrainedFilling(const Standard_Integer MaxDeg,const Standard_Integer MaxSeg);
  
  Standard_EXPORT     void Init(const Handle(GeomFill_Boundary)& B1,const Handle(GeomFill_Boundary)& B2,const Handle(GeomFill_Boundary)& B3,const Standard_Boolean NoCheck = Standard_False) ;
  //! Constructs a BSpline surface filled from the series of <br>
//! boundaries B1, B2, B3 and, if need be, B4, which serve: <br>
//! -   as path constraints <br>
//! -   and optionally, as tangency constraints if they are <br>
//!   GeomFill_BoundWithSurf curves. <br>
//! The boundaries may be given in any order: they are <br>
//! classified and if necessary, reversed and reparameterized. <br>
//! The surface will also respect the following constraints: <br>
//! -   its degree will not be greater than the maximum <br>
//!   degree defined at the time of construction of this framework, and <br>
//! -   the maximum number of segments MaxSeg which BSpline surfaces can have <br>
  Standard_EXPORT     void Init(const Handle(GeomFill_Boundary)& B1,const Handle(GeomFill_Boundary)& B2,const Handle(GeomFill_Boundary)& B3,const Handle(GeomFill_Boundary)& B4,const Standard_Boolean NoCheck = Standard_False) ;
  //! Allows to modify domain on witch the blending function <br>
//!          associated to  the constrained boundary B  will propag <br>
//!          the  influence   of the  field   of  tangency.  Can be <br>
//!          usefull to  reduce  influence of boundaries  on whitch <br>
//!          the Coons compatibility  conditions are not respected. <br>
//!          l is a  relative value of  the parametric range of  B. <br>
//!          Default value for l is 1 (used in Init). <br>
//!  Warning: Must be called after  Init with a constrained boundary <br>
//!          used in the call to Init. <br>
  Standard_EXPORT     void SetDomain(const Standard_Real l,const Handle(GeomFill_BoundWithSurf)& B) ;
  //! Computes the  new poles  of  the surface using the  new <br>
//!          blending  functions set by several calls to SetDomain. <br>
  Standard_EXPORT     void ReBuild() ;
  //! Returns the bound of index i after sort. <br>
  Standard_EXPORT     Handle_GeomFill_Boundary Boundary(const Standard_Integer I) const;
  //! Returns the BSpline surface after computation of the fill by this framework. <br>
  Standard_EXPORT     Handle_Geom_BSplineSurface Surface() const;
  //! Internal use for Advmath approximation call. <br>
  Standard_EXPORT     Standard_Integer Eval(const Standard_Real W,const Standard_Integer Ord,Standard_Real& Result) const;
  //! Computes the fields of tangents on 30 points along the <br>
//!          bound  I, these  are  not the  constraint tangents but <br>
//!          gives an idea of the coonsAlgPatch regularity. <br>
  Standard_EXPORT     void CheckCoonsAlgPatch(const Standard_Integer I) ;
  //! Computes  the fields  of tangents  and  normals on  30 <br>
//!          points along the bound  I, draw them, and computes the <br>
//!          max dot product that must be near than 0. <br>
  Standard_EXPORT     void CheckTgteField(const Standard_Integer I) ;
  //! Computes  values  and normals  along  the bound  I and <br>
//!          compare  them to the  approx  result curves (bound and <br>
//!          tgte field) , draw  the normals and tangents. <br>
  Standard_EXPORT     void CheckApprox(const Standard_Integer I) ;
  //! Computes values and normals along the  bound I on both <br>
//!          constraint  surface    and result  surface,  draw  the <br>
//!          normals, and  computes the max distance between values <br>
//!          and the max angle  between normals. <br>
  Standard_EXPORT     void CheckResult(const Standard_Integer I) ;





protected:





private:

  //! Performs the approximation an compute  the poles of the <br>
//!          surface. <br>
  Standard_EXPORT     void Build() ;
  //! Performs  the  parallel approximation  on two  oppsite <br>
//!          bounds <br>
  Standard_EXPORT     void PerformApprox() ;
  //! matches  the nodal vectors  of the  blending functions <br>
//!          and the results  of the approx   to allow the  surface <br>
//!          computation. <br>
  Standard_EXPORT     void MatchKnots() ;
  //! performs the poles of the partial construction S0. <br>
  Standard_EXPORT     void PerformS0() ;
  //! performs the poles of the partial construction S1. <br>
  Standard_EXPORT     void PerformS1() ;
  //! performs  the poles of  the  surface using the partial <br>
//!          constructions S0 and S1. <br>
  Standard_EXPORT     void PerformSurface() ;
  //! Checks if the field of tangency doesn t twist along the <br>
//!          boundary. <br>
  Standard_EXPORT     Standard_Boolean CheckTgte(const Standard_Integer I) ;
  //! Evaluates  the min magnitude  of  the field of tangency <br>
//!          along bound  I  to allow a   simple evaluation of  the <br>
//!          tolerance needed for the approximation of the field of <br>
//!          tangency. <br>
  Standard_EXPORT     void MinTgte(const Standard_Integer I) ;


Standard_Integer degmax;
Standard_Integer segmax;
Handle_GeomFill_CoonsAlgPatch ptch;
Handle_GeomFill_TgtField tgalg[4];
Standard_Real mig[4];
GeomFill_CornerState stcor[4];
gp_Vec v[4];
Standard_Boolean appdone;
Standard_Integer degree[2];
Handle_TColgp_HArray1OfPnt curvpol[4];
Handle_TColgp_HArray1OfPnt tgtepol[4];
Handle_TColStd_HArray1OfInteger mults[2];
Handle_TColStd_HArray1OfReal knots[2];
Handle_TColStd_HArray1OfReal ab[4];
Handle_TColStd_HArray1OfReal pq[4];
Standard_Real dom[4];
Handle_TColgp_HArray1OfPnt ncpol[4];
Handle_TColgp_HArray1OfPnt ntpol[4];
Handle_TColStd_HArray1OfInteger nm[2];
Handle_TColStd_HArray1OfReal nk[2];
Standard_Integer ibound[2];
Standard_Integer ctr[2];
Standard_Integer nbd3;
Handle_TColgp_HArray2OfPnt S0;
Handle_TColgp_HArray2OfPnt S1;
Handle_Geom_BSplineSurface surf;


};





// other Inline functions and methods (like "C++: function call" methods)


#endif
