// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _Visual3d_Light_HeaderFile
#define _Visual3d_Light_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_DefineHandle_HeaderFile
#include <Standard_DefineHandle.hxx>
#endif
#ifndef _Handle_Visual3d_Light_HeaderFile
#include <Handle_Visual3d_Light.hxx>
#endif

#ifndef _Graphic3d_CLight_HeaderFile
#include <Graphic3d_CLight.hxx>
#endif
#ifndef _MMgt_TShared_HeaderFile
#include <MMgt_TShared.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Graphic3d_Vertex_HeaderFile
#include <Graphic3d_Vertex.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Visual3d_TypeOfLightSource_HeaderFile
#include <Visual3d_TypeOfLightSource.hxx>
#endif
class Visual3d_LightDefinitionError;
class Visual3d_View;
class Quantity_Color;
class Graphic3d_Vector;


//! This class defines and updates light sources. <br>
//!	    There is no limit to the number of light sources defined. <br>
//!	    Only the number of active sources is limited. <br>
//! <br>
//!	    TypeOfLightSource = TOLS_AMBIENT <br>
//!				TOLS_DIRECTIONAL <br>
//!				TOLS_POSITIONAL <br>
//!				TOLS_SPOT <br>
//! <br>
//!	    Angle is a radian value. <br>
//!	    Concentration, Attenuation are in the [0,1] interval. <br>
//! <br>
class Visual3d_Light : public MMgt_TShared {

public:

  //! Creates a light from default values. <br>
//!	    Light sources are created in a visualiser <br>
//!	    and are activated in one of its views. <br>
//! <br>
//!	    Type	= TOLS_AMBIENT <br>
//!	    Color	= WHITE <br>
  Standard_EXPORT   Visual3d_Light();
  //! Creates an AMBIENT light source. <br>
//!	    Light sources are created in a visualiser <br>
//!	    and are activated in one of its views. <br>
  Standard_EXPORT   Visual3d_Light(const Quantity_Color& Color);
  //! Creates a DIRECTIONAL light source. <br>
//!	    Light sources are created in a visualiser <br>
//!	    and are activated in one of its views. <br>
//!  Warning: Raises LightDefinitionError if <Direction> is null. <br>
  Standard_EXPORT   Visual3d_Light(const Quantity_Color& Color,const Graphic3d_Vector& Direction,const Standard_Boolean Headlight = Standard_False);
  //! Creates a POSITIONAL light source. <br>
//!	    Light sources are created in a visualiser <br>
//!	    and are activated in one of its views. <br>
//!  Warning: Raises LightDefinitionError <br>
//!	    if <Fact1> and <Fact2> are null. <br>
//!	    if <Fact1> is a negative value or greater than 1.0. <br>
//!	    if <Fact2> is a negative value or greater than 1.0. <br>
  Standard_EXPORT   Visual3d_Light(const Quantity_Color& Color,const Graphic3d_Vertex& Position,const Standard_Real Fact1,const Standard_Real Fact2);
  //! Creates a SPOT light source. <br>
//!	    Light sources are created in a visualiser <br>
//!	    and are activated in one of its views. <br>
//!	    <Concentration> specifies the intensity distribution of <br>
//!	    the light. <br>
//!	    <AngleCone> specifies the angle (radians) of the cone <br>
//!	    created by the spot. <br>
//! 	    the global attenuation is equal : <br>
//!	    1 / (Fact1 + Fact2 * (norm(ObjectPosition - LightPosition))) <br>
//!  Warning: Raises LightDefinitionError <br>
//!	    if <Direction> is null. <br>
//!	    if <Concentration> is a negative value or greater than 1.0. <br>
//!	    if <Fact1> and <Fact2> are null. <br>
//!	    if <Fact1> is a negative value or greater than 1.0. <br>
//!	    if <Fact2> is a negative value or greater than 1.0. <br>
//!	    if <AngleCone> is a negative value or greater than PI/2. <br>
  Standard_EXPORT   Visual3d_Light(const Quantity_Color& Color,const Graphic3d_Vertex& Position,const Graphic3d_Vector& Direction,const Standard_Real Concentration,const Standard_Real Fact1,const Standard_Real Fact2,const Standard_Real AngleCone);
  //! Modifies the angle (radians) of the cone created by the spot. <br>
//!	    Works only on TOLS_SPOT lights. <br>
//!  Category: Methods to modify the class definition <br>
//!  Warning: Raises LightDefinitionError <br>
//!	    if the type of the light is not TOLS_SPOT. <br>
//!	    if <AngleCone> is a negative value or greater than PI/2. <br>
  Standard_EXPORT     void SetAngle(const Standard_Real AngleCone) ;
  //! Modifies the attenuation factor of the light. <br>
//!	    Works only on the TOLS_POSITIONAL and TOLS_SPOT lights. <br>
//!  Category: Methods to modify the class definition <br>
//!  Warning: Raises LightDefinitionError <br>
//!	    if the type of the light is not TOLS_SPOT or TOLS_POSITIONAL. <br>
//!	    if <Fact1> is a negative value or greater than 1.0. <br>
  Standard_EXPORT     void SetAttenuation1(const Standard_Real Fact1) ;
  //! Modifies the attenuation factor of the light. <br>
//!	    Works only on the TOLS_POSITIONAL and TOLS_SPOT lights. <br>
//!  Category: Methods to modify the class definition <br>
//!  Warning: Raises LightDefinitionError <br>
//!	    if the type of the light is not TOLS_POSITIONAL or TOLS_SPOT. <br>
//!	    if <Fact2> is a negative value or greater than 1.0.. <br>
  Standard_EXPORT     void SetAttenuation2(const Standard_Real Fact2) ;
  //! Modifies the colour of the light. <br>
  Standard_EXPORT     void SetColor(const Quantity_Color& Color) ;
  //! Modifies the intensity distribution of the light. <br>
//!	    Works only on the TOLS_SPOT lights. <br>
//!  Category: Methods to modify the class definition <br>
//!  Warning: Raises LightDefinitionError <br>
//!	    if the type of the light is not TOLS_SPOT. <br>
//!	    if <Concentration> is a negative value or greater than 1.0. <br>
  Standard_EXPORT     void SetConcentration(const Standard_Real Concentration) ;
  //! Modifies the light direction. <br>
//!	    Works only on the TOLS_DIRECTIONAL and TOLS_SPOT lights. <br>
//!	    Default z <br>
//!  Category: Methods to modify the class definition <br>
//!  Warning: Raises LightDefinitionError <br>
//!	    if the type of the light is not TOLS_DIRECTIONAL <br>
//!	    or TOLS_SPOT. <br>
//!	    if <Direction> is null. <br>
  Standard_EXPORT     void SetDirection(const Graphic3d_Vector& Direction) ;
  //! Modifies the position of the light. <br>
//!	    Works only on the TOLS_POSITIONAL and TOLS_SPOT lights. <br>
//!  Category: Methods to modify the class definition <br>
//!  Warning: Raises LightDefinitionError <br>
//!	    if the type of the light is not TOLS_POSITIONAL or TOLS_SPOT. <br>
  Standard_EXPORT     void SetPosition(const Graphic3d_Vertex& Position) ;
  //!  Returns the headlight  state of the light <me> <br>
  Standard_EXPORT     Standard_Boolean Headlight() const;
  //! Setup headlight flag. <br>
  Standard_EXPORT     void SetHeadlight(const Standard_Boolean theValue) ;
  //! Returns the colour of the light <me>. <br>
  Standard_EXPORT     Quantity_Color Color() const;
  //! Returns the light type of <me>. <br>
//! <br>
//!	    TypeOfLightSource = TOLS_AMBIENT <br>
//!				TOLS_DIRECTIONAL <br>
//!				TOLS_POSITIONAL <br>
//!				TOLS_SPOT <br>
//! <br>
  Standard_EXPORT     Visual3d_TypeOfLightSource LightType() const;
  //! Returns the definition of <me> if <me> is <br>
//!	    a light source of the TOLS_AMBIENT type. <br>
//!  Category: Inquire methods <br>
//!  Warning: Raises LightDefinitionError <br>
//!	    if the type of the light is not TOLS_AMBIENT. <br>
  Standard_EXPORT     void Values(Quantity_Color& Color) const;
  //! Returns the definition of <me> if <me> is <br>
//!	    a light source of the TOLS_DIRECTIONAL type. <br>
//!  Category: Inquire methods <br>
//!  Warning: Raises LightDefinitionError <br>
//!	    if the type of the light is not TOLS_DIRECTIONAL. <br>
  Standard_EXPORT     void Values(Quantity_Color& Color,Graphic3d_Vector& Direction) const;
  //! Returns the definition of <me> if <me> is <br>
//!	    a light source of the TOLS_POSITIONAL type. <br>
//!  Category: Inquire methods <br>
//!  Warning: Raises LightDefinitionError <br>
//!	    if the type of the light is not TOLS_POSITIONAL. <br>
  Standard_EXPORT     void Values(Quantity_Color& Color,Graphic3d_Vertex& Position,Standard_Real& Fact1,Standard_Real& Fact2) const;
  //! Returns the definition of <me> if <me> is <br>
//!	    a light source of the TOLS_SPOT type. <br>
//!  Category: Inquire methods <br>
//!  Warning: Raises LightDefinitionError <br>
//!	    if the type of the light is not TOLS_SPOT. <br>
  Standard_EXPORT     void Values(Quantity_Color& Color,Graphic3d_Vertex& Position,Graphic3d_Vector& Direction,Standard_Real& Concentration,Standard_Real& Fact1,Standard_Real& Fact2,Standard_Real& AngleCone) const;
  //! Returns the light defintion. <br>
  Standard_EXPORT    const Graphic3d_CLight& CLight() const;


friend class Visual3d_View;


  DEFINE_STANDARD_RTTI(Visual3d_Light)

protected:




private: 

  //! Returns True if <AAngle> is a valid <br>
//!	    spot light spread angle. <br>
  Standard_EXPORT   static  Standard_Boolean IsValid(const Standard_Real AAngle) ;

Graphic3d_CLight myCLight;


};





// other Inline functions and methods (like "C++: function call" methods)


#endif
