// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _GCPnts_QuasiUniformAbscissa_HeaderFile
#define _GCPnts_QuasiUniformAbscissa_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineAlloc.hxx>
#include <Standard_Macro.hxx>

#include <Standard_Boolean.hxx>
#include <Standard_Integer.hxx>
#include <Handle_TColStd_HArray1OfReal.hxx>
#include <Standard_Real.hxx>
class TColStd_HArray1OfReal;
class Standard_DomainError;
class Standard_ConstructionError;
class Standard_OutOfRange;
class StdFail_NotDone;
class Adaptor3d_Curve;
class Adaptor2d_Curve2d;


//! This class provides an algorithm to compute a uniform abscissa
//! distribution of points on a curve, i.e. a sequence of
//! equidistant points. The distance between two
//! consecutive points is measured along the curve.
//! The distribution is defined:
//! -   either by the curvilinear distance between two consecutive points
//! -   or by a number of points.
class GCPnts_QuasiUniformAbscissa 
{
public:

  DEFINE_STANDARD_ALLOC

  
  //! Constructs an empty algorithm. To define the problem
  //! to be solved, use the function Initialize.
  Standard_EXPORT GCPnts_QuasiUniformAbscissa();
  
  //! Computes a uniform abscissa distribution of points
  //! -   on the curve C where Abscissa is the curvilinear distance between
  //! two consecutive points of the distribution.
  Standard_EXPORT GCPnts_QuasiUniformAbscissa(Adaptor3d_Curve& C, const Standard_Integer NbPoints);
  
  //! Computes a uniform abscissa distribution of points
  //! on the part of curve C limited by the two parameter values U1 and U2,
  //! where Abscissa is the curvilinear distance between
  //! two consecutive points of the distribution.
  //! The first point of the distribution is either the origin of
  //! curve C or the point of parameter U1. The following
  //! points are computed such that the curvilinear
  //! distance between two consecutive points is equal to Abscissa.
  //! The last point of the distribution is either the end
  //! point of curve C or the point of parameter U2.
  //! However the curvilinear distance between this last
  //! point and the point just preceding it in the distribution
  //! is, of course, generally not equal to Abscissa.
  //! Use the function IsDone to verify that the
  //! computation was successful, the function NbPoints
  //! to obtain the number of points of the computed
  //! distribution, and the function Parameter to read the
  //! parameter of each point.
  //! Warning
  //! The roles of U1 and U2 are inverted if U1 > U2 .
  //! Warning
  //! C is an adapted curve, that is, an object which is an
  //! interface between:
  //! -   the services provided by either a 2D curve from
  //! the package Geom2d (in the case of an
  //! Adaptor2d_Curve2d curve) or a 3D curve from
  //! the package Geom (in the case of an Adaptor3d_Curve curve),
  //! -   and those required on the curve by the computation algorithm.
  Standard_EXPORT GCPnts_QuasiUniformAbscissa(Adaptor3d_Curve& C, const Standard_Integer NbPoints, const Standard_Real U1, const Standard_Real U2);
  
  //! Initialize the algoritms with <C>, <NbPoints> and
  Standard_EXPORT   void Initialize (Adaptor3d_Curve& C, const Standard_Integer NbPoints) ;
  
  //! Initialize the algoritms with <C>, <Abscissa>, <U1>,
  //! <U2>.
  Standard_EXPORT   void Initialize (Adaptor3d_Curve& C, const Standard_Integer NbPoints, const Standard_Real U1, const Standard_Real U2) ;
  
  //! Computes a uniform abscissa distribution of points on
  //! the Curve2d <C>.
  //! <NbPoints> defines the nomber of desired points.
  Standard_EXPORT GCPnts_QuasiUniformAbscissa(Adaptor2d_Curve2d& C, const Standard_Integer NbPoints);
  
  //! Computes a Uniform abscissa distribution of points
  //! on a part of the Curve2d <C>.
  Standard_EXPORT GCPnts_QuasiUniformAbscissa(Adaptor2d_Curve2d& C, const Standard_Integer NbPoints, const Standard_Real U1, const Standard_Real U2);
  
  //! Initialize the algoritms with <C>, <NbPoints> and
  Standard_EXPORT   void Initialize (Adaptor2d_Curve2d& C, const Standard_Integer NbPoints) ;
  
  //! Initialize the algoritms with <C>, <Abscissa>, <U1>,
  //! <U2>.
  Standard_EXPORT   void Initialize (Adaptor2d_Curve2d& C, const Standard_Integer NbPoints, const Standard_Real U1, const Standard_Real U2) ;
  
  //! Returns true if the computation was successful.
  //! IsDone is a protection against:
  //! -   non-convergence of the algorithm
  //! -   querying the results before computation.
      Standard_Boolean IsDone()  const;
  

  //! Returns the number of points of the distribution
  //! computed by this algorithm.
  //! This value is either:
  //! -   the one imposed on the algorithm at the time of
  //! construction (or initialization), or
  //! -   the one computed by the algorithm when the
  //! curvilinear distance between two consecutive
  //! points of the distribution is imposed on the
  //! algorithm at the time of construction (or initialization).
  //! Exceptions
  //! StdFail_NotDone if this algorithm has not been
  //! initialized, or if the computation was not successful.
      Standard_Integer NbPoints()  const;
  
  //! Returns the parameter of the point of index Index in
  //! the distribution computed by this algorithm.
  //! Warning
  //! Index must be greater than or equal to 1, and less
  //! than or equal to the number of points of the
  //! distribution. However, pay particular attention as this
  //! condition is not checked by this function.
  //! Exceptions
  //! StdFail_NotDone if this algorithm has not been
  //! initialized, or if the computation was not successful.
      Standard_Real Parameter (const Standard_Integer Index)  const;




protected:





private:



  Standard_Boolean myDone;
  Standard_Integer myNbPoints;
  Handle(TColStd_HArray1OfReal) myParams;


};


#include <GCPnts_QuasiUniformAbscissa.lxx>





#endif // _GCPnts_QuasiUniformAbscissa_HeaderFile
