-- Create software_name table
CREATE TABLE IF NOT EXISTS `software_name` (
    `ID` INTEGER NOT NULL AUTO_INCREMENT,
    `NAME` VARCHAR(255) NOT NULL UNIQUE,
    `CATEGORY` INTEGER DEFAULT NULL,
    PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=UTF8;

-- Create software_publisher table
CREATE TABLE IF NOT EXISTS `software_publisher` (
    `ID` INTEGER NOT NULL AUTO_INCREMENT,
    `PUBLISHER` VARCHAR(255) NOT NULL UNIQUE,
    PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=UTF8;

-- Create software_version table
CREATE TABLE IF NOT EXISTS `software_version` (
    `ID` INTEGER NOT NULL AUTO_INCREMENT,
    `VERSION` VARCHAR(255) NOT NULL UNIQUE,
    PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=UTF8;

-- Create software table
CREATE TABLE IF NOT EXISTS `software` (
    `ID` INTEGER NOT NULL AUTO_INCREMENT,
    `HARDWARE_ID` INTEGER NOT NULL,
    `NAME_ID` INTEGER NOT NULL,
    `PUBLISHER_ID` INTEGER NOT NULL,
    `VERSION_ID` INTEGER NOT NULL,
    `FOLDER` TEXT DEFAULT NULL,
    `COMMENTS` TEXT DEFAULT NULL,
    `FILENAME` VARCHAR(255) DEFAULT NULL,
    `FILESIZE` INTEGER DEFAULT 0,
    `SOURCE` INTEGER DEFAULT NULL,
    `GUID` VARCHAR(255) DEFAULT NULL,
    `LANGUAGE` VARCHAR(255) DEFAULT NULL,
    `INSTALLDATE` DATETIME DEFAULT NULL,
    `BITSWIDTH` INTEGER DEFAULT NULL,
    PRIMARY KEY (`ID`),

    FOREIGN KEY (`NAME_ID`)
        REFERENCES `software_name`(`ID`),
    
    FOREIGN KEY (`PUBLISHER_ID`)
        REFERENCES `software_publisher`(`ID`),

    FOREIGN KEY (`VERSION_ID`)
        REFERENCES `software_version`(`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=UTF8;

-- Insert default value
INSERT INTO software_publisher (`ID`,`PUBLISHER`) VALUES (1,"Unavailable");
INSERT INTO software_version (`ID`,`VERSION`) VALUES (1,"Unavailable");