/*
-----------------------------------------------------------------------------
This source file is part of OGRE
    (Object-oriented Graphics Rendering Engine)
For the latest info, see http://www.ogre3d.org/

Copyright (c) 2000-2016 Torus Knot Software Ltd

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
-----------------------------------------------------------------------------
*/

#import "OgreMetalView.h"

#import <SpriteKit/SpriteKit.h>
#import <QuartzCore/QuartzCore.h>

@implementation OgreMetalView
{
}

+ (Class)layerClass
{
    return [CAMetalLayer class];
}

- (void)initCommon
{
    self.layer = [CAMetalLayer layer];
    self.wantsLayer = YES;

    self.presentationTime = -1.0;

    _layerSizeDidUpdate = YES;
}

- (void)viewDidMoveToWindow
{
    //if(self.scaleToNative)
    //    [setContentScaleFactor:self.window.screen.backingScaleFactor * self.nativeScaleFactor];
    _layerSizeDidUpdate = YES;
}

#if OGRE_PLATFORM == OGRE_PLATFORM_APPLE_IOS
- (id)initWithFrame:(CGRect)frame
#else
- (id)initWithFrame:(NSRect)frame
#endif
{
    self = [super initWithFrame:frame];
    
    if( self )
    {
        [self initCommon];
    }
    
    return self;
}

- (instancetype)initWithCoder:(NSCoder *)coder
{
    self = [super initWithCoder:coder];
    
    if( self )
    {
        [self initCommon];
    }
    return self;
}

- (BOOL)acceptsFirstMouse:(NSEvent *)theEvent
{
    if(self.superview == nil) {
        return NO;
    } else {
        return [self.superview acceptsFirstMouse:theEvent];
    }
}

- (void)setContentScaleFactor:(CGFloat)contentScaleFactor
{
    self.scaleToNative = false;
    //[super setContentScaleFactor:contentScaleFactor];
    _layerSizeDidUpdate = YES;
}

- (void)setFrameSize:(NSSize)newSize
{
    [super setFrameSize:newSize];
    _layerSizeDidUpdate = YES;
}

- (void)setBoundsSize:(NSSize)newSize
{
    [super setBoundsSize:newSize];
    _layerSizeDidUpdate = YES;
}

- (void)viewDidChangeBackingProperties
{
    [super viewDidChangeBackingProperties];
    _layerSizeDidUpdate = YES;
}

@end
