/*
 * Copyright 2018 Andrew Rucker Jones.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.opencsv.bean.mocks.join;

import com.opencsv.bean.CsvBindAndJoinByName;
import com.opencsv.bean.CsvBindByName;
import com.opencsv.bean.customconverter.ErrorCodeConverter;
import org.apache.commons.collections4.MultiValuedMap;

public class IdAndErrorJoinByName {

    @CsvBindByName
    private int id;

    @CsvBindAndJoinByName(elementType = ErrorCode.class, converter = ErrorCodeConverter.class, locale = "de-DE")
    private MultiValuedMap<String, ErrorCode> ec;

    public int getId() {
        return id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public MultiValuedMap<String, ErrorCode> getEc() {
        return ec;
    }

    public void setEc(MultiValuedMap<String, ErrorCode> ec) {
        this.ec = ec;
    }
}
