/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.osgi.util;

import org.apache.ivy.osgi.util.Version;
import org.apache.ivy.osgi.util.VersionRange$VersionRangeParser;

public final class VersionRange {
    private boolean startExclusive;
    private Version startVersion;
    private boolean endExclusive;
    private Version endVersion;

    public VersionRange(String string) {
        if (string == null || string.length() == 0) {
            this.startExclusive = false;
            this.startVersion = new Version(0, 0, 0, null);
            this.endExclusive = true;
            this.endVersion = null;
            return;
        }
        new VersionRange$VersionRangeParser(this, string).parse();
    }

    public final String toString() {
        return (this.startExclusive ? "(" : "[") + this.startVersion + "," + (this.endVersion == null ? "" : this.endVersion.toString()) + (this.endExclusive ? ")" : "]");
    }

    public final String toIvyRevision() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.startExclusive ? "(" : "[");
        stringBuffer.append(this.startVersion);
        if (this.endVersion == null) {
            stringBuffer.append(",)");
        } else if (!this.endExclusive || this.startVersion.equals(this.endVersion)) {
            stringBuffer.append(",");
            stringBuffer.append(this.endVersion.withNudgedPatch());
            stringBuffer.append(")");
        } else {
            stringBuffer.append(",");
            stringBuffer.append(this.endVersion);
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }

    public final int hashCode() {
        int n = 31 + (this.endExclusive ? 1231 : 1237);
        n = n * 31 + (this.endVersion == null ? 0 : this.endVersion.hashCode());
        n = n * 31 + (this.startExclusive ? 1231 : 1237);
        return n * 31 + (this.startVersion == null ? 0 : this.startVersion.hashCode());
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof VersionRange)) {
            return false;
        }
        VersionRange versionRange = (VersionRange)object;
        if (this.endExclusive != versionRange.endExclusive) {
            return false;
        }
        if (this.endVersion == null ? versionRange.endVersion != null : !this.endVersion.equals(versionRange.endVersion)) {
            return false;
        }
        if (this.startExclusive != versionRange.startExclusive) {
            return false;
        }
        return !(this.startVersion == null ? versionRange.startVersion != null : !this.startVersion.equals(versionRange.startVersion));
    }

    static Version access$002(VersionRange versionRange, Version version) {
        versionRange.startVersion = version;
        return versionRange.startVersion;
    }

    static Version access$000(VersionRange versionRange) {
        return versionRange.startVersion;
    }

    static Version access$102(VersionRange versionRange, Version version) {
        versionRange.endVersion = version;
        return versionRange.endVersion;
    }

    static boolean access$202(VersionRange versionRange, boolean bl) {
        versionRange.startExclusive = bl;
        return versionRange.startExclusive;
    }

    static boolean access$302(VersionRange versionRange, boolean bl) {
        versionRange.endExclusive = bl;
        return versionRange.endExclusive;
    }
}

