/*###############################################################################
# Linux Management Providers (LMP), Boot provider package
# Copyright (C) 2009 Nodir Nazarov <nazarov.nodir@gmail.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#include "cmpiOpenDRIM_BootConfigSetting.h"

CMPIObjectPath* Boot_OpenDRIM_BootConfigSetting_toCMPIObjectPath(const CMPIBroker* broker, const OpenDRIM_BootConfigSetting& instance) {
	_E_;
	Objectpath op(broker, OpenDRIM_BootConfigSetting_classnames[0], OpenDRIM_BootConfigSetting_NAMESPACE);

	if (!instance.InstanceID_isNULL)
		op.addKey("InstanceID", instance.InstanceID);

	_L_;
	return op.getHdl();
}

CMPIInstance* Boot_OpenDRIM_BootConfigSetting_toCMPIInstance(const CMPIBroker* broker, const OpenDRIM_BootConfigSetting& instance) {
	_E_;
	Objectpath op(broker, Boot_OpenDRIM_BootConfigSetting_toCMPIObjectPath(broker, instance));
	Instance ci(broker, op);

	if (!instance.Caption_isNULL)
		ci.setProperty("Caption", instance.Caption);

	if (!instance.Description_isNULL)
		ci.setProperty("Description", instance.Description);

	if (!instance.ElementName_isNULL)
		ci.setProperty("ElementName", instance.ElementName);

	_L_;
	return ci.getHdl();
}

void Boot_OpenDRIM_BootConfigSetting_toCPP(const CMPIBroker* broker, const CMPIObjectPath* ref, OpenDRIM_BootConfigSetting& instance) {
	_E_;
	Objectpath op(broker, (CMPIObjectPath*) ref);

	if (op.getKey("InstanceID", instance.InstanceID) == OK)
		instance.InstanceID_isNULL = false;

	_L_;
}

void Boot_OpenDRIM_BootConfigSetting_toCPP(const CMPIBroker* broker, const CMPIInstance* ci, OpenDRIM_BootConfigSetting& instance) {
	_E_;
	Instance inst(broker, (CMPIInstance*) ci);

	if (inst.getProperty("Caption", instance.Caption) == OK)
		instance.Caption_isNULL = false;

	if (inst.getProperty("Description", instance.Description) == OK)
		instance.Description_isNULL = false;

	if (inst.getProperty("InstanceID", instance.InstanceID) == OK)
		instance.InstanceID_isNULL = false;

	if (inst.getProperty("ElementName", instance.ElementName) == OK)
		instance.ElementName_isNULL = false;

	_L_;
}

void Boot_OpenDRIM_BootConfigSetting_toCPP(const CMPIBroker* broker, const CMPIArgs* in, OpenDRIM_BootConfigSetting_ChangeBootOrder_In& args) {
	_E_;
	CMPIStatus rc;
	CMPIData data;

	vector<Objectpath> Source;
	data = in->ft->getArg(in, "Source", &rc);
	if (rc.rc == OK) {
		CT_ToC(broker, data, Source);	
		args.setSource(Source);
	}			

	Objectpath Job;
	data = in->ft->getArg(in, "Job", &rc);
	if (rc.rc == OK) {
		CT_ToC(broker, data, Job);	
		args.setJob(Job);
	}			

	_L_;
}

void Boot_OpenDRIM_BootConfigSetting_toCMPIArg(const CMPIBroker* broker, CMPIArgs* out, const OpenDRIM_BootConfigSetting_ChangeBootOrder_Out& args) {
	_E_;
	CMPIValue value;
	int errorMessage;

	Objectpath Job;
	errorMessage = args.getJob(Job);
	if (errorMessage == OK) {
		value = CT_toCMPI(Job);
		out->ft->addArg(out, "Job", &value, CMPI_ref);
	}

	_L_;
}
