/*###############################################################################
# Linux Management Providers (LMP), Software Inventory provider package
# Copyright (C) 2009 Nazarov Nodir, TUIT <nazarov.nodir@gmail.com, nodir2000@yahoo.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#ifndef OPENDRIM_SAPAVAILABLEFORSOFTWAREINVENTORY_H_
#define OPENDRIM_SAPAVAILABLEFORSOFTWAREINVENTORY_H_

#include <Association.h>

// Direct Invocation includes, may have to be adjusted
/*
#include "cmpiCIM_ServiceAccessPoint.h"
#include "CIM_ServiceAccessPointAccess.h"
#include "cmpiCIM_ManagedElement.h"
#include "CIM_ManagedElementAccess.h"
*/

const static char* OpenDRIM_SAPAvailableForSoftwareInventory_classnames[] = {"OpenDRIM_SAPAvailableForSoftwareInventory"};
static string OpenDRIM_SAPAvailableForSoftwareInventory_NAMESPACE = _NAMESPACE;
const static string AvailableSAP_role = "AvailableSAP";
const static char* AvailableSAP_classnames[] = {"OpenDRIM_SoftwareIdentityResource"};
const static string AvailableSAP_NAMESPACE = _NAMESPACE;

const static string ManagedElement_role = "ManagedElement";
const static char* ManagedElement_classnames[] = {"OpenDRIM_SoftwareIdentity"};
const static string ManagedElement_NAMESPACE = _NAMESPACE;

class OpenDRIM_SAPAvailableForSoftwareInventory {

public:
	
	Objectpath AvailableSAP;
	bool AvailableSAP_isNULL;
	
	Objectpath ManagedElement;
	bool ManagedElement_isNULL;
	
	OpenDRIM_SAPAvailableForSoftwareInventory() {
		AvailableSAP_isNULL = true;
		ManagedElement_isNULL = true;
	}
	
	~OpenDRIM_SAPAvailableForSoftwareInventory() {}
	
	string getKeys() const {
		return CF_toLowCase(".AvailableSAP=\"" + CF_quoteString(AvailableSAP.toString()) + "\""".ManagedElement=\"" + CF_quoteString(ManagedElement.toString()) + "\"");
	}

	int getAvailableSAP(Objectpath& value) const {
		if (AvailableSAP_isNULL==true)
			return NOT_FOUND;
		value = AvailableSAP;
		return OK;
	}
	
	int setAvailableSAP(const Objectpath& newValue) {
		AvailableSAP = newValue;
		AvailableSAP.setNamespace(AvailableSAP_NAMESPACE);
		AvailableSAP_isNULL = false;
		return OK;
	}

	int getManagedElement(Objectpath& value) const {
		if (ManagedElement_isNULL==true)
			return NOT_FOUND;
		value = ManagedElement;
		return OK;
	}
	
	int setManagedElement(const Objectpath& newValue) {
		ManagedElement = newValue;
		ManagedElement.setNamespace(ManagedElement_NAMESPACE);
		ManagedElement_isNULL = false;
		return OK;
	}

};

#endif /*OPENDRIM_SAPAVAILABLEFORSOFTWAREINVENTORY_H_*/
