/*
 *  Copyright (c) 2009 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "GTLTest/Thread.h"

#include <unistd.h>

#ifdef GTLTEST_HAVE_THREAD

class MyThreadTCTLCT : public GTLTest::Thread
{
  public:
    MyThreadTCTLCT(const GTLCore::String& _code) : m_stop(false), m_code(_code)
    {
    }
    void stop()
    {
      m_stop = true;
    }
  protected:
    virtual void run()
    {
      std::vector< GTLCore::Value> arguments;
      while(not m_stop)
      {
        OpenCTL::Module p;
        p.setSource( "test", m_code );
        p.compile();
      }
    }
  private:
    bool m_stop;
    GTLCore::String m_code;
};

class TestCompileThreading : public GTLTest::Case {
  public:
    TestCompileThreading() : GTLTest::Case("CompileThreading")
    {
    }
    virtual void runTest()
    {
      GTLCore::String source = " \
void testCall() \
{ \
  int a[5]; \
  a[0] = 1; \
  a[1] = -1; \
  a[2] = -2; \
  a[3] = 2; \
  a[4] = 3; \
}";
      MyThreadTCTLCT thread1(source);
      thread1.start();
      MyThreadTCTLCT thread2(source);
      thread2.start();
      MyThreadTCTLCT thread3(source);
      thread3.start();
      MyThreadTCTLCT thread4(source);
      thread4.start();
      MyThreadTCTLCT thread5(source);
      thread5.start();
      MyThreadTCTLCT thread6(source);
      thread6.start();
      sleep(3);
      thread1.stop();
      thread2.stop();
      thread3.stop();
      thread4.stop();
      thread5.stop();
      thread6.stop();
      thread1.wait();
      thread2.wait();
      thread3.wait();
      thread4.wait();
      thread5.wait();
      thread6.wait();
    }
};
#endif
