/*
 *  Copyright (c) 2006 Cyrille Berger <cberger@cberger.bet
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#include "ChannelMaths.h"

#include <cfloat>

using namespace GTLCore;

#ifdef _HAS_HALF_SUPPORT_

const half ChannelMathsTraits<half>::zeroValue = 0.0;
const half ChannelMathsTraits<half>::unitValue = 1.0;
const half ChannelMathsTraits<half>::max = HALF_MAX;
const half ChannelMathsTraits<half>::min = -HALF_MAX;
const half ChannelMathsTraits<half>::epsilon = HALF_EPSILON;

#endif

const float ChannelMathsTraits<float>::zeroValue = 0.0;
const float ChannelMathsTraits<float>::unitValue = 1.0;
const float ChannelMathsTraits<float>::max = FLT_MAX;
const float ChannelMathsTraits<float>::min = -FLT_MAX;
const float ChannelMathsTraits<float>::epsilon = FLT_EPSILON;

const double ChannelMathsTraits<double>::zeroValue = 0.0;
const double ChannelMathsTraits<double>::unitValue = 1.0;
const double ChannelMathsTraits<double>::max = DBL_MAX;
const double ChannelMathsTraits<double>::min = -DBL_MAX;
const double ChannelMathsTraits<double>::epsilon = DBL_EPSILON;

const GTLCore::FullLut< IntegerToFloat<gtl_uint16>, float, gtl_uint16> GTLCore::Luts::Uint16ToFloat;
const GTLCore::FullLut< IntegerToFloat<gtl_uint8>, float, gtl_uint8> GTLCore::Luts::Uint8ToFloat;
