/*
 *  Copyright (c) 2009 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "Debug_p.h"

#include "../Debug.h"
#include "../Macros_p.h"

#include "Group.h"
#include "ParameterEntry.h"
#include "TextEntry.h"
#include "ValueEntry.h"

#include <iostream>

using namespace GTLCore::Metadata;

void GTLCore::Metadata::dumpAll( const Entry* _entry, const GTLCore::String& _indent )
{
  if( const Group* group = _entry->asGroup() )
  {
    if( _entry->asParameterEntry() )
    {
      std::cout << _indent << "Parameter: ";
    } else {
      std::cout << _indent << "Group: ";
    }
    std::cout << _entry->name() << std::endl;
    foreach( const Entry* entry, group->entries())
    {
      dumpAll( entry, _indent + "" );
    }
  } else if( const TextEntry* text = _entry->asTextEntry())
  {
    std::cout << _indent << "Text: " << text->name() << ", " << text->text() << std::endl;
  } else if( const ValueEntry* value = _entry->asValueEntry())
  {
    std::cout << _indent << "Value: " << value->name() << ", " << value->value() << std::endl;
  } else {
    std::cout << _indent << "Unknown: " << _entry->name() << std::endl;
  }
}
