/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

class TestPixelDescriptionConstructor1 : public GTLTest::Case {
  public:
    TestPixelDescriptionConstructor1() : GTLTest::Case("Mono-type")
    {
    }
    virtual void runTest()
    {
      GTLCore::PixelDescription pd1( Type::Integer32, 3);
      GTLTEST_CHECK_EQUAL( pd1.channels(), 3 );
      GTLTEST_CHECK_EQUAL( pd1.bitsSize(), 96 );
      GTLTEST_CHECK_EQUAL( pd1.channelTypes()[0], Type::Integer32);
      GTLTEST_CHECK_EQUAL( pd1.channelTypes()[1], Type::Integer32);
      GTLTEST_CHECK_EQUAL( pd1.channelTypes()[2], Type::Integer32);
    }
};

class TestPixelDescriptionConstructor2 : public GTLTest::Case {
  public:
    TestPixelDescriptionConstructor2() : GTLTest::Case("Multi-type")
    {
    }
    virtual void runTest()
    {
      std::vector<const Type*> types;
      types.push_back( Type::Integer8 );
      types.push_back( Type::Integer16 );
      types.push_back( Type::Integer32 );
      types.push_back( Type::Float32 );
      GTLCore::PixelDescription pd1( types);
      GTLTEST_CHECK_EQUAL( pd1.channels(), 4 );
      GTLTEST_CHECK_EQUAL( pd1.bitsSize(), 88 );
      GTLTEST_CHECK_EQUAL( pd1.channelTypes()[0], Type::Integer8);
      GTLTEST_CHECK_EQUAL( pd1.channelTypes()[1], Type::Integer16);
      GTLTEST_CHECK_EQUAL( pd1.channelTypes()[2], Type::Integer32);
      GTLTEST_CHECK_EQUAL( pd1.channelTypes()[3], Type::Float32);
    }
};

class TestPixelDescription : public GTLTest::Suite {
  public:
    TestPixelDescription() : GTLTest::Suite("PixelDescription")
    {
      addCase( new TestPixelDescriptionConstructor1);
      addCase( new TestPixelDescriptionConstructor2);
    }
};
