/*
 * Copyright (C) 2009 Apple Inc. All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL APPLE INC. OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef SuddenTermination_h
#define SuddenTermination_h

#include <wtf/Noncopyable.h>

namespace WebCore {

    // Once disabled via one or more more calls to disableSuddenTermination(), fast shutdown
    // is not valid until enableSuddenTermination() has been called an equal number of times.
    // On Mac, these are thin wrappers around Mac OS X functions of the same name.
#if PLATFORM(MAC)
    WEBCORE_EXPORT void disableSuddenTermination();
    WEBCORE_EXPORT void enableSuddenTermination();
#else
    inline void disableSuddenTermination() { }
    inline void enableSuddenTermination() { }
#endif

    class SuddenTerminationDisabler {
        WTF_MAKE_NONCOPYABLE(SuddenTerminationDisabler);
    public:
        SuddenTerminationDisabler()
        {
            disableSuddenTermination();
        }

        ~SuddenTerminationDisabler()
        {
            enableSuddenTermination();
        }
    };

} // namespace WebCore

#endif // SuddenTermination_h
