// --------------------------------------------------------------------------
//                   OpenMS -- Open-Source Mass Spectrometry               
// --------------------------------------------------------------------------
// Copyright The OpenMS Team -- Eberhard Karls University Tuebingen,
// ETH Zurich, and Freie Universitaet Berlin 2002-2013.
// 
// This software is released under a three-clause BSD license:
//  * Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
//  * Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//  * Neither the name of any author or any participating institution 
//    may be used to endorse or promote products derived from this software 
//    without specific prior written permission.
// For a full list of authors, refer to the file AUTHORS. 
// --------------------------------------------------------------------------
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
// AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED. IN NO EVENT SHALL ANY OF THE AUTHORS OR THE CONTRIBUTING 
// INSTITUTIONS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
// EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
// PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
// OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
// WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
// OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
// ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
// 
// --------------------------------------------------------------------------
// $Maintainer: Clemens Groepl $
// $Authors: $
// --------------------------------------------------------------------------

#include <OpenMS/CONCEPT/ClassTest.h>

///////////////////////////
#include <OpenMS/CONCEPT/UniqueIdGenerator.h>
///////////////////////////

using namespace OpenMS;
using namespace std;

START_TEST(UniqueIdGenerator, "$Id: UniqueIdGenerator_test.C 10915 2013-04-04 20:14:57Z aiche $")

/////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////

START_SECTION((UniqueIdGenerator()))
{
  // singleton has private ctor
  NOT_TESTABLE;
}
END_SECTION

START_SECTION((~UniqueIdGenerator()))
{
  // singleton has private dtor
  NOT_TESTABLE;
}
END_SECTION

START_SECTION((static UInt64 getUniqueId()))
{
  STATUS("OpenMS::UniqueIdGenerator::getUniqueId(): " << OpenMS::UniqueIdGenerator::getUniqueId());
  // the actual values are unpredictable, but see setSeed() below
  NOT_TESTABLE;
}
END_SECTION

START_SECTION((static void setSeed(const DateTime &)))
{
  OpenMS::DateTime one_moment_in_time;
  one_moment_in_time.set(5,4,6666,3,2,1);
  OpenMS::UniqueIdGenerator::setSeed(one_moment_in_time);

  // hoping that your compiler already supports the ull suffix for unsigned long long (aka Int64Type) integer literals
  OpenMS::UInt64 unique_ids[] =
                  {
                    17506003619360897276ull,
                    10043082726796495519ull,
                    7830402478541866667ull,
                    8002416538250417709ull,
                    10620916023778653771ull
                  };

  const int num_num = sizeof(unique_ids)/sizeof(*unique_ids);

  for ( int i = 0; i < num_num; ++i )
  {
    OpenMS::UInt64 uid = OpenMS::UniqueIdGenerator::getUniqueId();
    TEST_EQUAL(uid,unique_ids[i]);
  }

  OpenMS::UniqueIdGenerator::setSeed(one_moment_in_time);

  for ( int i = 0; i < num_num; ++i )
  {
    OpenMS::UInt64 uid = OpenMS::UniqueIdGenerator::getUniqueId();
    TEST_EQUAL(uid,unique_ids[i]);
  }

}
END_SECTION

START_SECTION((static Param const& getInfo()))
{
  STATUS(std::endl << OpenMS::UniqueIdGenerator::getInfo());
  Param const & param(OpenMS::UniqueIdGenerator::getInfo());
  TEST_STRING_EQUAL(param.getValue("generator_type"),"mt19937");
  TEST_STRING_EQUAL(param.getValue("generator_min"),"0");
  TEST_STRING_EQUAL(param.getValue("generator_max"),"4294967295");
  TEST_STRING_EQUAL(param.getValue("initialization_date_time_as_string"),"6666-05-04 03:02:01");
  TEST_STRING_EQUAL(param.getValue("initialization_date_time_as_longlong"),"66660504030201000");
  TEST_STRING_EQUAL(param.getValue("actually_used_seed"),"262674376");
  STATUS(OpenMS::UniqueIdGenerator::getInfo());
}
END_SECTION


/////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////
END_TEST
