##############################################################################
# Local Security Check Automation Framework
#
# Authors:
# Veerendra GG <veerendragg@secpod.com>
#
# Revision 1.0
# Date: 2009/01/30
#
# Copyright:
# Copyright (c) 2009 SecPod , http://www.secpod.org
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

import unittest
from common import utils


class UtilsTestCase(unittest.TestCase):

    import os
    cwd = os.getcwd() + '/test/unit_test'

    def test_removeDups(self):
        print "\nTesting Utils Test Suite ..."
        req_out_put = ['123', '234', '345', 'CVE-7788', 'CVE-1234']

        input_list = ['123', '234', '345', '123', '345', 'CVE-7788', 'CVE-1234', 'CVE-7788']
        out_put = utils.removeDups(input_list)
        self.assertEquals(out_put, req_out_put)


    def test_getHTMLCon(self):
        req_out_put = '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">\n<html><head><title>Security Announcement</title></head><body><pre>\nDate: Fri, 11 Jul 2008 13:26:28 +0200\nFrom: Marcus Meissner &lt;meissner@suse.de&gt;\nTo: opensuse-security-announce@opensuse.org\nSubject: [security-announce] SUSE Security Announcement: Mozilla Firefox (SUSE-SA:2008:034)\n\n\n-----BEGIN PGP SIGNED MESSAGE-----\nHash: SHA1\n\n______________________________________________________________________________\n\n                        SUSE Security Announcement\n\n        Package:                MozillaFirefox\n        Announcement ID:        SUSE-SA:2008:034\n        Date:                   Fri, 11 Jul 2008 10:00:00 +0000\n        Affected Products:      openSUSE 10.2\n                                openSUSE 10.3\n        Vulnerability Type:     remote code execution\n        Severity (1-10):        8\n        SUSE Default Package:   yes\n\n    Content of This Advisory:\n        1) Security Vulnerability Resolved:\n             Mozilla Firefox 2.0.0.15 security update\n           Problem Description\n        2) Solution or Work-Around\n        3) Special Instructions and Notes\n        4) Package Location and Checksums\n        5) Pending Vulnerabilities, Solutions, and Work-Arounds:\n            See SUSE Security Summary Report.\n        6) Authenticity Verification and Additional Information\n\n</pre></body></html>\n'

        url = self.cwd + '/work/input/firefox.html'
        out_put = utils.getHTMLCon(url)
        self.assertEquals(out_put, req_out_put)


    def test_fetchFiles(self):
        req_out_put = self.cwd + '/work/output/2008_34_firefox.html'

        save_path = self.cwd + '/work/output/2008_34_firefox.html'
        get_path = self.cwd + '/work/input/advisories/2008_34_firefox.html'

        out_put = utils.fetchFiles(get_path, save_path)
        self.assertEquals(out_put, req_out_put)


    def test_readFile_str(self):
        req_out_put = 'This is sample text message.\nThis text message is used for unitest.\n\nIt is new paragraph.\nEnd of sample message\n\n\n'

        file_path = self.cwd + '/work/input/test.txt'
        out_put = utils.readFile(file_path)
        self.assertEquals(out_put, req_out_put)


    def test_readFile_list(self):
        req_out_put = ['This is sample text message.\n', 'This text message is used for unitest.\n', '\n', 'It is new paragraph.\n', 'End of sample message\n', '\n', '\n']

        file_path = self.cwd + '/work/input/test.txt'
        out_put = utils.readFile(file_path, lines=1)
        self.assertEquals(out_put, req_out_put)


    def test_writeFile(self):
        req_out_put = None

        data = 'Unit Testing for WriteFile'
        file_path = self.cwd + '/work/input/temp.txt'
        out_put = utils.writeFile(file_path, data)
        self.assertEquals(out_put, req_out_put)


    def test_stringFormat(self):
        req_out_put = 'This is sample text message.\nThis text message is used for unitest.\n\nIt is new paragraph.\nEnd of sample message\n\n\n'

        file_path = self.cwd + '/work/input/test.txt'
        out_put = utils.stringFormat(file_path)
        self.assertEquals(out_put, req_out_put)


    def test_stripIt_list(self):
        req_out_put = ['mozilla', 'real_player', 'firefox.calender', 'firefox']

        list_ = ['mozilla.x86.rpm', 'real_player.x64.rpm', 'firefox.calender.x86.ppc', 'firefox']
        strip_val = ['.x86.rpm', '.x64.rpm', '.x86.ppc', 'abc.rpm']
        out_put = utils.stripIt(list_, strip_val)
        self.assertEquals(out_put, req_out_put)


    def test_stripIt_str(self):
        req_out_put = ['mozilla', 'real_player.x64.rpm', 'firefox.calender', 'firefox']

        list_ = ['mozilla.x86.rpm', 'real_player.x64.rpm', 'firefox.calender.x86.rpm', 'firefox']
        strip_val = '.x86.rpm'
        out_put = utils.stripIt(list_, strip_val)
        self.assertEquals(out_put, req_out_put)


    def test_loadPickle(self):
        req_out_put = {'firefox_34':1000, 'kernel_49':1001}

        dict_ = {'firefox_34':1000, 'kernel_49':1001}
        file_path = self.cwd + '/work/input/id_file.pickle'
        out_put = utils.loadPickle(file_path)
        self.assertEquals(out_put, req_out_put)


    def test_dumpPickle(self):
        req_out_put = True

        dict_ = {'firefox_34':1000, 'kernel_49':1001}
        file_path = self.cwd + '/work/input/id_file1.pickle'
        out_put = utils.dumpPickle(dict_, file_path)
        self.assertEquals(out_put, req_out_put)


if __name__ == '__main__':
    unittest.main()
