#
#VID ce29ce1d-971a-11dd-ab7e-001c2514716c
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from VID ce29ce1d-971a-11dd-ab7e-001c2514716c
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(61805);
 script_cve_id("CVE-2008-3639", "CVE-2008-3640", "CVE-2008-3641");
 script_version ("$");
 script_tag(name:"cvss_base", value:"10.0");
 script_tag(name:"risk_factor", value:"Critical");
 name = "FreeBSD Ports: cups-base";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: cups-base

CVE-2008-3639
Heap-based buffer overflow in the read_rle16 function in imagetops in
CUPS before 1.3.9 allows remote attackers to execute arbitrary code
via an SGI image with malformed Run Length Encoded (RLE) data
containing a small image and a large row count.

CVE-2008-3640
Integer overflow in the WriteProlog function in texttops in CUPS
before 1.3.9 allows remote attackers to execute arbitrary code via a
crafted PostScript file that triggers a heap-based buffer overflow.

CVE-2008-3641
The Hewlett-Packard Graphics Language (HPGL) filter in CUPS before
1.3.9 allows remote attackers to execute arbitrary code via crafted
pen width and pen color opcodes that overwrite arbitrary memory.

Solution:
Update your system with the appropriate patches or
software upgrades.


Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: cups-base";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"cups-base");
if(!isnull(bver) && revcomp(a:bver, b:"1.3.9")<0) {
    security_note(0, data:"Package cups-base version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
