###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_f-prot_av_dos_vuln_lin.nasl 794 2009-01-02 12:58:24Z jan $
#
# F-PROT AV 'ELF' Header Denial of Service Vulnerability
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800325);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"5.0");
  script_tag(name:"risk_factor", value:"Medium");
  script_cve_id("CVE-2008-5747");
  script_bugtraq_id(32753);
  script_name("F-PROT AV 'ELF' Header Denial of Service Vulnerability");
  desc = "

  Overview: This host has F-PROT Antivirus installed and is prone to Denial of
  Service vulnerability.

  Vulnerability Insight:
  The flaw is caused due to error in ELF program with a corrupted header. The
  scanner can be exploited while scanning the header.

  Impact:
  Successful exploitation will allow attackers to bypass anti-virus protection
  and cause a Denial of Service condition.

  Impact Level: Application

  Affected Software/OS:
  Frisk Software, F-Prot Antivirus version 4.6.8 and prior on Linux.

  Fix: No solution or patch is available as on 13th January, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.f-prot.com/index.html

  References:
  http://securityreason.com/securityalert/4822
  http://www.ivizsecurity.com/security-advisory-iviz-sr-08016.html

  CVSS Score:
    CVSS Base Score     : 5.0 (AV:N/AC:L/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score : 4.2
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the Version of F-PROT Antivirus");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Denial of Service");
  script_dependencies("gb_f-prot_av_detect_lin.nasl");
  exit(0);
}


include("version_func.inc");

fpscanVer = get_kb_item("F-Prot/AV/Linux/Ver");
if(!fpscanVer){
  exit(0);
}

# Check for version <= 4.6.8
if(version_is_less_equal(version:fpscanVer, test_version:"4.6.8")){
  security_warning(0);
}
