###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for imlib FEDORA-2007-4594
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(861223);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"5.0");
  script_tag(name:"risk_factor", value:"Medium");
  script_xref(name: "FEDORA", value: "2007-4594");
  script_cve_id("CVE-2007-3568");
  script_name( "Fedora Update for imlib FEDORA-2007-4594");
  desc = "

  Vulnerability Insight:
  Imlib is a display depth independent image loading and rendering library.
  Imlib is designed to simplify and speed up the process of loading images and
  obtaining X Window System drawables. Imlib provides many simple manipulation
  routines which can be used for common operations.
  
  The imlib package also contains the imlib_config program, which you can use to
  configure the Imlib image loading and rendering library. Imlib_config can be
  used to control how Imlib uses color and handles gamma corrections, etc.
  
  Install imlib if you need an image loading and rendering library for X11R6, or
  if you are installing GNOME.


  Affected Software/OS:
  imlib on Fedora 8

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2007-December/msg00811.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of imlib");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC8")
{

  if(isrpmvuln(pkg:"imlib", rpm:"imlib~1.9.15~6.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"imlib-debuginfo", rpm:"imlib-debuginfo~1.9.15~6.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"imlib-devel", rpm:"imlib-devel~1.9.15~6.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"imlib", rpm:"imlib~1.9.15~6.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"imlib-debuginfo", rpm:"imlib-debuginfo~1.9.15~6.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"imlib-devel", rpm:"imlib-devel~1.9.15~6.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"imlib", rpm:"imlib~1.9.15~6.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}