###############################################################################
# OpenVAS Vulnerability Test
#
# HP-UX Update for xntpd(1M) HPSBUX00148
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(835070);
  script_version("$Revision: 1.0 $");
  script_tag(name:"risk_factor", value:"High");
  script_xref(name: "HPSBUX", value: "00148");
  script_name( "HP-UX Update for xntpd(1M) HPSBUX00148");
  desc = "

  Vulnerability Insight:
  A potential security vulnerability has been identified with HP-UX running 
  xntpd(1M). The vulnerability could be exploitedremotely execute arbitrary 
  commands, with increased privilege. 

  Impact:
  Remote execution of arbitrary commands
  increased privilege.

  Affected Software/OS:
  xntpd(1M) on
  HP-UX release B.11.11, B.11.04, B.11.00, B.10.24, B.10.20, B.10.10, B.10.01. 

  Fix: Please Install the Updated Packages.

  References:
  http://www11.itrc.hp.com/service/cki/docDisplay.do?docId=emr_na-c00994050-2

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of xntpd(1M)");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("HP-UX Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-hpux.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "HPUX10.01")
{

  if(ishpuxpkgvuln(pkg:"InternetSrvcs.INETSVCS-BOOT", patch_list:['PHNE_23717'], rls:"HPUX10.01"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX10.10")
{

  if(ishpuxpkgvuln(pkg:"InternetSrvcs.INETSVCS-BOOT", patch_list:['PHNE_23717'], rls:"HPUX10.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.00")
{

  if(ishpuxpkgvuln(pkg:"InternetSrvcs.INETSVCS-BOOT", patch_list:['PHNE_23697'], rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX10.24")
{

  if(ishpuxpkgvuln(pkg:"InternetSrvcs.INETSVCS-BOOT", patch_list:['PHNE_24076'], rls:"HPUX10.24"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.04")
{

  if(ishpuxpkgvuln(pkg:"InternetSrvcs.INETSVCS-BOOT", patch_list:['PHNE_24077'], rls:"HPUX11.04"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX10.20")
{

  if(ishpuxpkgvuln(pkg:"InternetSrvcs.INETSVCS-BOOT", patch_list:['PHNE_23717'], rls:"HPUX10.20"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.11")
{

  if(ishpuxpkgvuln(pkg:"InternetSrvcs.INETSVCS-BOOT", patch_list:['PHNE_22722'], rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}