###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_ms08-033.nasl  0291 30 11:22:07Z sep $
#
# Vulnerabilities in DirectX Could Allow Remote Code Execution (951698)
#
# Authors:
# Veerendra GG <veerendragg@secpod.com>
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800104);
  script_version("$Revision: 1.1 $");
  script_tag(name:"cvss_base", value:"9.3");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2008-0011","CVE-2008-1444");
  script_bugtraq_id(29581, 29578);
  script_xref(name:"CB-A", value:"08-0097");
  script_name("Vulnerabilities in DirectX Could Allow Remote Code Execution (951698)");
  desc = "

  Overview : This host has DirectX installed, which is prone to Remote Code
  Execution Vulnerabilities.

  Vulnerability Insight:
  The flaws are caused due to,
  - error in the Windows MJPEG Codec when performing error checking on MJPEG
    video streams embedded in ASF or AVI media files can be exploited with a
    specially crafted MJPEG file.
  - error in the parsing of Class Name variables in Synchronized Accessible
    Media Interchange (SAMI) files can be exploited with a specially crafted
    SAMI file.

  Impact:
  Successful exploitation allows remote attackers to execute arbitrary code when
  a user opens a specially crafted media file. An attacker could take complete
  control of an affected system.

  Impact Level: System

  Affected Software/OS:
  DirectX 7.0, 8.1, 9.0, 9.0a, 9.0b and 9.0c on Microsoft Windows 2000
  DirectX 9.0, 9.0a, 9.0b and 9.0c on Microsoft Windows XP and 2003

  Fix:
  Run Windows Update and update the listed hotfixes or download and update
  mentioned hotfixes in the advisory from the below link.
  http://www.microsoft.com/technet/security/bulletin/ms08-033.mspx

  References:
  http://secunia.com/advisories/30579
  http://www.frsirt.com/english/advisories/2008/1780
  http://www.us-cert.gov/cas/techalerts/TA08-162B.html
  http://www.zerodayinitiative.com/advisories/ZDI-08-040/
  http://www.microsoft.com/technet/security/bulletin/ms08-033.mspx

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 6.9
  Risk factor : High";

  script_description(desc);
  script_summary("Check for the version of Internet Explorer");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2008 Intevation GmbH");
  script_family("Windows : Microsoft Bulletins");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_reg.inc");
include("secpod_smb_func.inc");

# Check the hotfix applicability to each OS
if(hotfix_check_sp(win2k:5, xp:4, win2003:3) <= 0){
  exit(0);
}

function Get_FileVersion()
{
  dllFile = registry_get_sz(key:"SOFTWARE\Microsoft\COM3\Setup",
                            item:"Install Path");
  if(!dllFile){
    exit(0);
  }

  dllFile += "\quartz.dll";
  share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:dllFile);
  file =  ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:dllFile);

  soc = open_sock_tcp(port);
  if(!soc){
    exit(0);
  }

  r = smb_session_request(soc:soc, remote:name);
  if(!r)
  {
    close(soc);
    exit(0);
  }

  prot = smb_neg_prot(soc:soc);
  if(!prot)
  {
    close(soc);
    exit(0);
  }

  r = smb_session_setup(soc:soc, login:login, password:pass,
                        domain:domain, prot:prot);
  if(!r)
  {
    close(soc);
    exit(0);
  }

  uid = session_extract_uid(reply:r);
  r = smb_tconx(soc:soc, name:name, uid:uid, share:share);

  tid = tconx_extract_tid(reply:r);
  if(!tid)
  {
    close(soc);
    exit(0);
  }

  fid = OpenAndX(socket:soc, uid:uid, tid:tid, file:file);
  if(!fid)
  {
    close(soc);
    exit(0);
  }

  v = GetVersion(socket:soc, uid:uid, tid:tid, fid:fid, verstr:"prod",
                 offset:600000);
  close(soc);
  return v;
}

# Check DirectX is installed
directXver = registry_get_sz(key:"SOFTWARE\Microsoft\DirectX", item:"Version");
if(!egrep(pattern:"^4\.0[7-9]\..*", string:directXver)){
  exit(0);
}

# MS08-033 Hotfix check
if(hotfix_missing(name:"951698") == 0){
  exit(0);
}

fileVer = Get_FileVersion();
if(fileVer == NULL){
  exit(0);
}

if(hotfix_check_sp(win2k:5) > 0)
{
  if(egrep(pattern:"^4\.07", string:directXver))
  {
    # Grep Quartz.dll version < 6.1.9.734
    if(egrep(pattern:"^6\.01\.09\.0?([0-6]?[0-9]?[0-9]|7([0-2][0-9]|3[0-3]))$",
             string:fileVer)){
      security_hole(0);
    }
  }
  else if(egrep(pattern:"^4\.08", string:directXver))
  {
    # Grep Quartz.dll version < 6.3.1.891
    if(egrep(pattern:"^6\.03\.01\.0?([0-7]?[0-9]?[0-9]|8([0-8][0-9]|90))$",
             string:fileVer)){
      security_hole(0);
    }
  }
  else if(egrep(pattern:"^4\.09", string:directXver))
  {
    # Grep Quartz.dll version < 6.5.1.909
    if(egrep(pattern:"^6\.05\.0?1\.0?([0-8]?[0-9]?[0-9]|90[0-8])$",
             string:fileVer)){
      security_hole(0);
    }
    # Grep Quartz.dll version < 6.5.2600.1316
    else if(egrep(pattern:"^6\.05\.2600\.(0?[0-9]?[0-9]?[0-9]|1([0-2][0-9]" +
                       "[0-9]|3(0[0-9]|1[0-5])))$", string:fileVer)){
      security_hole(0);
    }
  }
  exit(0);
}

if(hotfix_check_sp(xp:4) > 0)
{
  if(egrep(pattern:"^4\.09", string:directXver))
  {
    SP = get_kb_item("SMB/WinXP/ServicePack");
    if("Service Pack 2" >< SP)
    {
      # Grep Quartz.dll version < 6.5.2600.3367
      if(egrep(pattern:"^6\.05\.2600\.([0-2]?[0-9]?[0-9]?[0-9]|3([0-2][0-9]" +
                       "[0-9]|3([0-5][0-9]|6[0-6])))$", string:fileVer)){
        security_hole(0);
      }
    }
    else if("Service Pack 3" >< SP)
    {
      # Grep Quartz.dll version < 6.5.2600.5596
      if(egrep(pattern:"^6\.05\.2600\.([0-4]?[0-9]?[0-9]?[0-9]|5([0-4][0-9]" +
                       "[0-9]|5([0-8][0-9]|9[0-5])))$", string:fileVer)){
        security_hole(0);
      }
    }
  }
  exit(0);
}

if(hotfix_check_sp(win2003:3) > 0)
{
  if(egrep(pattern:"^4\.09", string:directXver))
  {
    SP = get_kb_item("SMB/Win2003/ServicePack");
    if("Service Pack 1" >< SP)
    {
      # Grep Quartz.dll version < 6.5.3790.3130
      if(egrep(pattern:"^6\.05\.3790\.([0-2]?[0-9]?[0-9]?[0-9]|3(0[0-9]" +
                       "[0-9]|1[0-2][0-9]))$", string:fileVer)){
        security_hole(0);
      }
    }
    else if("Service Pack 2" >< SP)
    {
      # Grep Quartz.dll version < 6.5.3790.4283
      if(egrep(pattern:"^6\.05\.3790\.([0-3]?[0-9]?[0-9]?[0-9]|4([01][0-9]" +
                       "[0-9]|2([0-7][0-9]|8[0-2])))$", string:fileVer)){
        security_hole(0);
      }
    }
  }
}
