###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_activex.inc 865 2009-01-09 15:15:24Z jan $
#
# ActiveX Control functions
#
# Authors:
# Chandrashekhar B <bchandra@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

# Check if killbit is set for the given ActiveX control.
# clsid - CLSID for the given ActiveX control

function is_killbit_set(clsid)
{
  if(clsid)
  {
    if(registry_key_exists(key:"SOFTWARE\Classes\CLSID\" + clsid))
    {
      activeKey = "SOFTWARE\Microsoft\Internet Explorer\" +
                  "ActiveX Compatibility\" + clsid;
      killBit = registry_get_dword(key:activeKey, item:"Compatibility Flags");
      if(killBit && (int(killBit) == 1024)){
        return 1;
      }
      return 0;
    }
  }
  return -1;
}
