###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_cmailserver_detect.nasl 3898 2009-08-19 09:14:24Z aug $
#
# CMailServer Version Detection
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
##############################################################################

if(description)
{
  script_id(900917);
  script_version("$ Revision: 1.0 $");
  script_tag(name:"risk_factor", value:"None");
  script_name("CMailServer Version Detection");
  desc = "

  Overview: The script detects the installed version of CMailServer and sets
  the result in KB.

  Risk factor: None";

  script_description(desc);
  script_summary("Sets the version of CMailServer in KB");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Service detection");
  script_dependencie("find_service.nes");
  script_require_ports("Services/smtp", 25);
  exit(0);
}


include("smtp_func.inc");

smtpPort = get_kb_item("Services/smtp");
if(!smtpPort){
  smtpPort = 25;
}

imapPort = get_kb_item("Services/imap");
if(!imapPort){
  imapPort = 143;
}

popPort = get_kb_item("Services/pop3");
if(!popPort){
  popPort = 110;
}

foreach port (make_list(smtpPort, imapPort, popPort))
{
  banner = get_kb_item(string("Banner/", port));
  if((banner != NULL) && ("CMailServer" >< banner))
  {
    cmailVer = eregmatch(pattern:"CMailServer ([0-9.]+)", string:banner);
    if(cmailVer[1] != NULL)
    {
      set_kb_item(name:"CMailServer/Ver", value:cmailVer[1]);
      security_note(data:"CMailServer version " + cmailVer[1] +
                                               " was detected on the host");
      exit(0);
    }
  }
}
