# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory USN-781-2 (gaim)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(64176);
 script_cve_id("CVE-2009-1373", "CVE-2009-1376");
 script_version ("$");
 script_tag(name:"cvss_base", value:"9.3");
 script_tag(name:"risk_factor", value:"Critical");
 name = "Ubuntu USN-781-2 (gaim)";
 script_name(name);

 desc = "The remote host is missing an update to gaim
announced via advisory USN-781-2.

Details follow:

It was discovered that Gaim did not properly handle certain malformed
messages when sending a file using the XMPP protocol handler. If a user
were tricked into sending a file, a remote attacker could send a specially
crafted response and cause Gaim to crash, or possibly execute arbitrary
code with user privileges. (CVE-2009-1373)

It was discovered that Gaim did not properly handle certain malformed
messages in the MSN protocol handler. A remote attacker could send a
specially crafted message and possibly execute arbitrary code with user
privileges. (CVE-2009-1376)

Solution:
The problem can be corrected by upgrading your system to the
following package versions:

Ubuntu 6.06 LTS:
  gaim                            1:1.5.0+1.5.1cvs20051015-1ubuntu10.2

After a standard system upgrade you need to restart Gaim to effect
the necessary changes.

https://secure1.securityspace.com/smysecure/catid.html?in=USN-781-2

Risk factor : High";

 script_description(desc);

 summary = "Ubuntu USN-781-2 (gaim)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Ubuntu Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"gaim-data", ver:"1.5.0+1.5.1cvs20051015-1ubuntu10.2", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gaim-dev", ver:"1.5.0+1.5.1cvs20051015-1ubuntu10.2", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gaim", ver:"1.5.0+1.5.1cvs20051015-1ubuntu10.2", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
