Minutes from 86th OpenVDB TSC meeting, April 13th, 2021, (EDT)

Attendees: *Nick* A., *Jeff* L., *Ken* M., *Dan* B, *Andre* P.

Additional Attendees: JT Nelson (Blender), Bruce Chernaik (Intel),
Laura Lediaev (ImageWorks), Johannes Meng (Intel)

Regrets: none

Agenda:

1) Confirm Quorum
2) Secretary
3) Forum
4) Unfinished Business
5) VDB 8.1 Release
6) TBB 2021
7) Updating Houdini Examples
8) Multithreaded Count: PR: 1010
9) Next meeting

1) Confirm Quorum

Quorum is present.

2) Secretary

Secretary is Jeff Lait

3) Forum

Issues is quiet, but issue on the forum.

User is using custom grid type, with custom topology.  Some tools have been templated to default, not to custom tree topology.  But we were thinking of locking down tree configuration anyways?  Locking down hierarchy means we remove a feature and can't go back.  Not sure who uses it, but this person does.  Dan will reply.  We should test under our current state of the things.

There are two aspects to lock down.  One is the four-level topology.  But the other is changing the fan-out.  This is more common.  But if you allow leaf to configure, you don't change anything.  Though it does allow triple-nested loops be hardcoded.

The problem is the ValueOnIterator is very slow compared to any other approach, especially if you could do nested loops.  So you lose a lot of inlining opportunities with it.  This would be better if there were ways to vectorize final loop - process entire leaves at once and do a masked write back; or return blocks of active voxels.

Another option is to just harden standard layouts so we can have pre-compiled tools.

But we should add testing for something other than 5443.  Probably add a 544 to make sure common variants work.

NanoVDB shows a measurable, several times faster, for locking down in the value on case.

Should we remove valueoniterator?  We would need something as economical in code, not just performance, as people return to these because they are easy to use.

Files are troublesome with custom types.  AX likewise has a set of registered types, so only works with specific types.  You need to re-build AX to support different tree configurations.

Dan will fix the issue and enquire further about this.

4) Unfinished Business

We will attempt to survey what fell off the agenda in previous meetings before going onto the new agenda to avoid starvation.

* VDB 8.1 Release Schedule
* PR 1010
* Embedding pointers/blind data

5) VDB 8.1 Release

Ready to go.  Is there anything still pending?  Can we lock it down?  Extrapolate PR is in, so will be added to Houdini Unreleased for testing.

VDB Merge should get in.  A SOP has been released, doing Sum.  Working on Max.  Does levelset/volume merging.  Been matching the Composite methods for how inactive voxels are handled.

VDB 9 needs to be around September to meet new requirements.  PR is pushed in to support ABI 9.  Doing a 9 a few weeks after 8.2 isn't unreasonable.

Nano could either be 8.2 or 9.0.

VDB Merge is ready, just being delayed to ensure API is stable.  This will need multiple-input-in-place compile support in Houdini when it is in.

Plan: Lock down end of April for mid-May release.

6) TBB 2021

Nick has a currently-failing PR to get it to work in 2021.  Not looked at enqueue.  So just IO that needs updating and unit tests.  We've heard from TBB and task_arena::enqueue can replace enqueue.   The use of split in the proposed PR is a bit heavy-handed.  Any compile time defines in core.h have to go to downstream projects.  Hard to support the dummy class in both versions as they are in different locations.

Hopefully we can port our enqueue stuff with the suggestions from TBB.

Another option is just to deprecate the enqueue() stuff.  But this might have been useful when doing 1000s of VDBs.

7) Updating Houdini Examples

Jeff Budsberg will update and ping Nick about AX examples.

8) Multithreaded Count: PR: 1010

Why should this replace the existing method?   This will keep breaking API if we keep writing new tools everytime we find a faster way of doing things.  So do we need to deprecate the old method?

Initial motivation was that voxel count was serial and slow, so makes sense it is a tool rather than modifying the tree.  The active count doesn't belong in FindActiveValues header, so it ends up in the Count header.  There is no issues with this.

We should either have both, or unify the implementation behind separate interfaces.  If we were to start from scratch, count active voxel and count active voxel within bounding box in the same header.  The existing bounding box counting methods were made specifically to not replace the un-bounded ones.

How aggressive should we about cleaning the API?  Vs support them using the library?  Very important that the API is stable.  Need a very good reason to break the API.  People will not upgrade.  Our rule should be to keep the API stable.  Finding the balance is hard.  Replacement should be gradual.  Note method on header is deprecated, it is the method in the class is removed.  Latter could be made deprecated.  

"VDB just works" is the hope.  Ideally people can compile blindly without worrying.

Find Active Values class will stay the same, but the function would point to something else.

vdb_print prints out counts using possible the old method?  Since there are no alternative to the internal node count it won't be deprecated.


9) Next meeting

Next meeting is April 20th, 2021. 12pm-1pm EST (GMT-5).
