///////////////////////////////////////////////////////////////////////////////
//
//  Copyright (2008) Alexander Stukowski
//
//  This file is part of OVITO (Open Visualization Tool).
//
//  OVITO is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  OVITO is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
///////////////////////////////////////////////////////////////////////////////

#include <core/Core.h>
#include "FreezeSelectionModifier.h"

namespace AtomViz {

IMPLEMENT_SERIALIZABLE_PLUGIN_CLASS(FreezeSelectionModifier, AtomsObjectModifierBase)
DEFINE_FLAGS_REFERENCE_FIELD(FreezeSelectionModifier, DataChannel, "Selection", PROPERTY_FIELD_NO_UNDO|PROPERTY_FIELD_NO_CHANGE_MESSAGE, _selectionChannel)

/******************************************************************************
* This modifies the input object.
******************************************************************************/
EvaluationStatus FreezeSelectionModifier::modifyAtomsObject(TimeTicks time, TimeInterval& validityInterval)
{
	// If the internal cache is empty then create it by adopting the selection of the input object.
	if(!_selectionChannel) {
		// Make a deep copy of the input selection channel.
		CloneHelper cloneHelper;
		_selectionChannel = cloneHelper.cloneObject(inputStandardChannel(DataChannel::SelectionChannel), true);
	}
	else {
		if(input()->atomsCount() == _selectionChannel->size()) {
			// Create a copy of the selection channel.
			CloneHelper cloneHelper;
			DataChannel::SmartPtr channel = cloneHelper.cloneObject(_selectionChannel, true);
			// Put the new channel into the output object.
			output()->insertDataChannel(channel);
		}
		else {
			throw Exception(tr("Number of atoms of input object has changed over time. Cannot preserve selection."));
		}
	}

	return EvaluationStatus();
}

IMPLEMENT_PLUGIN_CLASS(FreezeSelectionModifierEditor, AtomsObjectModifierEditorBase)

/******************************************************************************
* Sets up the UI widgets of the editor.
******************************************************************************/
void FreezeSelectionModifierEditor::createUI(const RolloutInsertionParameters& rolloutParams)
{
	// Create a rollout.
	QWidget* rollout = createRollout(tr("Freeze Selection"), rolloutParams, "atomviz.modifiers.freeze_selection");

    // Create the rollout contents.
	QVBoxLayout* layout = new QVBoxLayout(rollout);
	layout->setContentsMargins(4,4,4,4);
	layout->setSpacing(0);

	/*
	QPushButton* acquireButton = new QPushButton(tr("Acquire selection"), rollout);
	layout1->addWidget(acquireButton);
	connect(acquireButton, SIGNAL(clicked(bool)), this, SLOT(onAcquireSelection()));
	*/

	// Status label.
	layout->addWidget(new QLabel(tr("Status:")));
	layout->addWidget(statusLabel());
}

/******************************************************************************
* Is called when the user presses the Acquire Selection button.
******************************************************************************/
void FreezeSelectionModifierEditor::onAcquireSelection()
{
	/*
	if(!editObject()) return;
	FreezeSelectionModifier* modifier = static_object_cast<FreezeSelectionModifier>(editObject());
	try {
		modifier->acquireNewSelection(ANIM_MANAGER.time());
	}
	catch(Exception& ex) {
		ex.prependGeneralMessage(tr("Failed to acquire new selection."));
		ex.showError();
	}
	*/
}

};	// End of namespace AtomViz
