///////////////////////////////////////////////////////////////////////////////
// 
//  Copyright (2008) Alexander Stukowski
//
//  This file is part of OVITO (Open Visualization Tool).
//
//  OVITO is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  OVITO is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
///////////////////////////////////////////////////////////////////////////////

#ifndef __OVITO_ACTION_H
#define __OVITO_ACTION_H

#include <core/Core.h>

namespace Core {

class ActionProxy;		// defined in ActionProxy.h

/******************************************************************************
* Base class for application actions.
******************************************************************************/
class CORE_DLLEXPORT Action : public PluginClass
{	
	Q_OBJECT

public:

	/// \brief Initializes the action object.
	/// \param id The unique identifier string of this action object.
	Action(const QString& id = QString()) : _proxy(NULL) { setObjectName(id); }

	/// \brief Returns a pointer to the proxy that owns this action object.
	/// \return The ActionProxy to which this action object belongs to.
	ActionProxy* proxy() const {
		OVITO_ASSERT_MSG(_proxy != NULL, "Action::proxy()", "The action object has not been initialized yet.");
		return _proxy;
	}

protected:
	
	/// This is called by the system after the action object has been bound to its ActionProxy. 
	virtual void initializeAction(ActionProxy* proxy) { OVITO_ASSERT(_proxy == NULL); _proxy = proxy; }

	/// This function is called whenever the action is added to a container widget that supports custom widgets.
	virtual QWidget* createWidget(QWidget* parent);

private:
	
	/// The action's proxy.
	ActionProxy* _proxy;
	
	DECLARE_PLUGIN_CLASS(Action)
	
	friend class ActionProxy;
};

};

#endif // __OVITO_ACTION_H
