///////////////////////////////////////////////////////////////////////////////
// 
//  Copyright (2008) Alexander Stukowski
//
//  This file is part of OVITO (Open Visualization Tool).
//
//  OVITO is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  OVITO is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
///////////////////////////////////////////////////////////////////////////////

#ifndef __OVITO_VARIANT_COMBO_BOX_PROPERTY_UI_H
#define __OVITO_VARIANT_COMBO_BOX_PROPERTY_UI_H

#include <core/Core.h>
#include "ParameterUI.h"

namespace Core {

/******************************************************************************
* This UI letsw the user to change a property of the object being edited
* using a combo box widget.
******************************************************************************/
class CORE_DLLEXPORT VariantComboBoxPropertyUI : public PropertyParameterUI
{
public:
	/// Constructor.
	VariantComboBoxPropertyUI(PropertiesEditor* parentEditor, const char* propertyName);
	
	/// Destructor, that releases all GUI controls.
	virtual ~VariantComboBoxPropertyUI();
	
	/// This returns the combo box managed by this ParameterUI.
	QComboBox* comboBox() const { return _comboBox; }
	
	/// This method is called when a new editable object has been assigned to the properties owner this
	/// parameter UI belongs to.  
	virtual void resetUI();

	/// This method updates the displayed value of the property UI.
	virtual void updateUI();
	
	/// Sets the enabled state of the UI.
	virtual void setEnabled(bool enabled);
	
	/// Sets the tooltip text for the combo box widget.
	void setToolTip(const QString& text) const { 
		if(comboBox()) comboBox()->setToolTip(text); 
	}
	
	/// Sets the What's This helper text for the combo box.
	void setWhatsThis(const QString& text) const { 
		if(comboBox()) comboBox()->setWhatsThis(text); 
	}
	
public:
	
	Q_PROPERTY(QComboBox comboBox READ comboBox)		
	
public Q_SLOTS:
	
	/// Takes the value entered by the user and stores it in the property field 
	/// this property UI is bound to. 
	void updatePropertyValue();
	
protected:

	/// The combo box of the UI component.
	QPointer<QComboBox> _comboBox;

private:

	Q_OBJECT
	DECLARE_ABSTRACT_PLUGIN_CLASS(VariantComboBoxPropertyUI)
};

};

#endif // __OVITO_VARIANT_COMBO_BOX_PROPERTY_UI_H
