/*
 * Copyright (c) 2008 Google, Inc
 * Contributed by Stephane Eranian <eranian@gmail.com>
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
 * INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
 * CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE
 * OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * This file is part of libpfm, a performance monitoring support library for
 * applications on Linux.
 */
static pme_nhm_entry_t corei7_unc_pe[]={
	/*
	 * BEGIN uncore events
	 */
	{ .pme_name   = "UNC_CLK_UNHALTED",
		.pme_desc   = "Uncore clockticks.",
		.pme_code   = 0x0000,
		.pme_flags  = PFMLIB_NHM_UNC_FIXED,
	},
	{ .pme_name   = "UNC_DRAM_OPEN",
		.pme_desc   = "DRAM open comamnds issued for read or write",
		.pme_code   = 0x60,
		.pme_flags  = PFMLIB_NHM_UNC,
		.pme_umasks = { 
			{ .pme_uname  = "CH0",
				.pme_udesc  = "DRAM Channel 0 open comamnds issued for read or write",
				.pme_ucode  = 0x01,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "CH1",
				.pme_udesc  = "DRAM Channel 1 open comamnds issued for read or write",
				.pme_ucode  = 0x02,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "CH2",
				.pme_udesc  = "DRAM Channel 2 open comamnds issued for read or write",
				.pme_ucode  = 0x04,
				.pme_uflags = 0,
			}, 
		},
		.pme_numasks = 3
	}, 
	{ .pme_name   = "UNC_DRAM_PAGE_CLOSE",
		.pme_desc   = "DRAM page close due to idle timer expiration",
		.pme_code   = 0x61,
		.pme_flags  = PFMLIB_NHM_UNC,
		.pme_umasks = { 
			{ .pme_uname  = "CH0",
				.pme_udesc  = "DRAM Channel 0 page close",
				.pme_ucode  = 0x01,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "CH1",
				.pme_udesc  = "DRAM Channel 1 page close",
				.pme_ucode  = 0x02,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "CH2",
				.pme_udesc  = "DRAM Channel 2 page close",
				.pme_ucode  = 0x04,
				.pme_uflags = 0,
			}, 
		},
		.pme_numasks = 3
	}, 
	{ .pme_name   = "UNC_DRAM_PAGE_MISS",
		.pme_desc   = "DRAM Channel 0 page miss",
		.pme_code   = 0x62,
		.pme_flags  = PFMLIB_NHM_UNC,
		.pme_umasks = { 
			{ .pme_uname  = "CH0",
				.pme_udesc  = "DRAM Channel 0 page miss",
				.pme_ucode  = 0x01,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "CH1",
				.pme_udesc  = "DRAM Channel 1 page miss",
				.pme_ucode  = 0x02,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "CH2",
				.pme_udesc  = "DRAM Channel 2 page miss",
				.pme_ucode  = 0x04,
				.pme_uflags = 0,
			}, 
		},
		.pme_numasks = 3
	}, 
	{ .pme_name   = "UNC_DRAM_PRE_ALL",
		.pme_desc   = "DRAM Channel 0 precharge all commands",
		.pme_code   = 0x66,
		.pme_flags  = PFMLIB_NHM_UNC,
		.pme_umasks = { 
			{ .pme_uname  = "CH0",
				.pme_udesc  = "DRAM Channel 0 precharge all commands",
				.pme_ucode  = 0x01,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "CH1",
				.pme_udesc  = "DRAM Channel 1 precharge all commands",
				.pme_ucode  = 0x02,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "CH2",
				.pme_udesc  = "DRAM Channel 2 precharge all commands",
				.pme_ucode  = 0x04,
				.pme_uflags = 0,
			}, 
		},
		.pme_numasks = 3
	}, 
	{ .pme_name   = "UNC_DRAM_READ_CAS",
		.pme_desc   = "DRAM Channel 0 read CAS commands",
		.pme_code   = 0x63,
		.pme_flags  = PFMLIB_NHM_UNC,
		.pme_umasks = { 
			{ .pme_uname  = "CH0",
				.pme_udesc  = "DRAM Channel 0 read CAS commands",
				.pme_ucode  = 0x01,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "AUTOPRE_CH0",
				.pme_udesc  = "DRAM Channel 0 read CAS auto page close commands",
				.pme_ucode  = 0x02,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "CH1",
				.pme_udesc  = "DRAM Channel 1 read CAS commands",
				.pme_ucode  = 0x04,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "AUTOPRE_CH1",
				.pme_udesc  = "DRAM Channel 1 read CAS auto page close commands",
				.pme_ucode  = 0x08,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "CH2",
				.pme_udesc  = "DRAM Channel 2 read CAS commands",
				.pme_ucode  = 0x10,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "AUTOPRE_CH2",
				.pme_udesc  = "DRAM Channel 2 read CAS auto page close commands",
				.pme_ucode  = 0x20,
				.pme_uflags = 0,
			}, 
		},
		.pme_numasks = 6
	}, 
	{ .pme_name   = "UNC_DRAM_REFRESH",
		.pme_desc   = "DRAM Channel 0 refresh commands",
		.pme_code   = 0x65,
		.pme_flags  = PFMLIB_NHM_UNC,
		.pme_umasks = { 
			{ .pme_uname  = "CH0",
				.pme_udesc  = "DRAM Channel 0 refresh commands",
				.pme_ucode  = 0x01,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "CH1",
				.pme_udesc  = "DRAM Channel 1 refresh commands",
				.pme_ucode  = 0x02,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "CH2",
				.pme_udesc  = "DRAM Channel 2 refresh commands",
				.pme_ucode  = 0x04,
				.pme_uflags = 0,
			}, 
		},
		.pme_numasks = 3
	}, 
	{ .pme_name   = "UNC_DRAM_WRITE_CAS",
		.pme_desc   = "DRAM Channel 0 write CAS commands",
		.pme_code   = 0x64,
		.pme_flags  = PFMLIB_NHM_UNC,
		.pme_umasks = { 
			{ .pme_uname  = "CH0",
				.pme_udesc  = "DRAM Channel 0 write CAS commands",
				.pme_ucode  = 0x01,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "AUTOPRE_CH0",
				.pme_udesc  = "DRAM Channel 0 write CAS auto page close commands",
				.pme_ucode  = 0x02,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "CH1",
				.pme_udesc  = "DRAM Channel 1 write CAS commands",
				.pme_ucode  = 0x04,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "AUTOPRE_CH1",
				.pme_udesc  = "DRAM Channel 1 write CAS auto page close commands",
				.pme_ucode  = 0x08,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "CH2",
				.pme_udesc  = "DRAM Channel 2 write CAS commands",
				.pme_ucode  = 0x10,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "AUTOPRE_CH2",
				.pme_udesc  = "DRAM Channel 2 write CAS auto page close commands",
				.pme_ucode  = 0x20,
				.pme_uflags = 0,
			}, 
		},
		.pme_numasks = 6
	}, 
	{ .pme_name   = "UNC_GQ_ALLOC",
		.pme_desc   = "GQ read tracker requests",
		.pme_code   = 0x03,
		.pme_flags  = PFMLIB_NHM_UNC,
		.pme_umasks = { 
			{ .pme_uname  = "READ_TRACKER",
				.pme_udesc  = "GQ read tracker requests",
				.pme_ucode  = 0x01,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "RT_LLC_MISS",
				.pme_udesc  = "GQ read tracker LLC misses",
				.pme_ucode  = 0x02,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "RT_TO_LLC_RESP",
				.pme_udesc  = "GQ read tracker LLC requests",
				.pme_ucode  = 0x04,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "RT_TO_RTID_ACQUIRED",
				.pme_udesc  = "GQ read tracker LLC miss to RTID acquired",
				.pme_ucode  = 0x08,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "WT_TO_RTID_ACQUIRED",
				.pme_udesc  = "GQ write tracker LLC miss to RTID acquired",
				.pme_ucode  = 0x10,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "WRITE_TRACKER",
				.pme_udesc  = "GQ write tracker LLC misses",
				.pme_ucode  = 0x20,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "PEER_PROBE_TRACKER",
				.pme_udesc  = "GQ peer probe tracker requests",
				.pme_ucode  = 0x40,
				.pme_uflags = 0,
			}, 
		},
		.pme_numasks = 7
	}, 
	{ .pme_name   = "UNC_GQ_CYCLES_FULL",
		.pme_desc   = "Cycles GQ read tracker is full.",
		.pme_code   = 0x00,
		.pme_flags  = PFMLIB_NHM_UNC,
		.pme_umasks = { 
			{ .pme_uname  = "READ_TRACKER",
				.pme_udesc  = "Cycles GQ read tracker is full.",
				.pme_ucode  = 0x01,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "WRITE_TRACKER",
				.pme_udesc  = "Cycles GQ write tracker is full.",
				.pme_ucode  = 0x02,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "PEER_PROBE_TRACKER",
				.pme_udesc  = "Cycles GQ peer probe tracker is full.",
				.pme_ucode  = 0x04,
				.pme_uflags = 0,
			}, 
		},
		.pme_numasks = 3
	}, 
	{ .pme_name   = "UNC_GQ_CYCLES_NOT_EMPTY",
		.pme_desc   = "Cycles GQ read tracker is busy",
		.pme_code   = 0x01,
		.pme_flags  = PFMLIB_NHM_UNC,
		.pme_umasks = { 
			{ .pme_uname  = "READ_TRACKER",
				.pme_udesc  = "Cycles GQ read tracker is busy",
				.pme_ucode  = 0x01,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "WRITE_TRACKER",
				.pme_udesc  = "Cycles GQ write tracker is busy",
				.pme_ucode  = 0x02,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "PEER_PROBE_TRACKER",
				.pme_udesc  = "Cycles GQ peer probe tracker is busy",
				.pme_ucode  = 0x04,
				.pme_uflags = 0,
			}, 
		},
		.pme_numasks = 3
	}, 
	{ .pme_name   = "UNC_GQ_DATA",
		.pme_desc   = "Cycles GQ data is imported from Quickpath interface",
		.pme_code   = 0x04,
		.pme_flags  = PFMLIB_NHM_UNC,
		.pme_umasks = { 
			{ .pme_uname  = "FROM_QPI",
				.pme_udesc  = "Cycles GQ data is imported from Quickpath interface",
				.pme_ucode  = 0x01,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "FROM_QMC",
				.pme_udesc  = "Cycles GQ data is imported from Quickpath memory interface",
				.pme_ucode  = 0x02,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "FROM_LLC",
				.pme_udesc  = "Cycles GQ data is imported from LLC",
				.pme_ucode  = 0x04,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "FROM_CORES_02",
				.pme_udesc  = "Cycles GQ data is imported from Cores 0 and 2",
				.pme_ucode  = 0x08,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "FROM_CORES_13",
				.pme_udesc  = "Cycles GQ data is imported from Cores 1 and 3",
				.pme_ucode  = 0x10,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "TO_QPI_QMC",
				.pme_udesc  = "Cycles GQ data sent to the QPI or QMC",
				.pme_ucode  = 0x01,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "TO_LLC",
				.pme_udesc  = "Cycles GQ data sent to LLC",
				.pme_ucode  = 0x02,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "TO_CORES",
				.pme_udesc  = "Cycles GQ data sent to cores",
				.pme_ucode  = 0x04,
				.pme_uflags = 0,
			}, 
		},
		.pme_numasks = 8
	}, 
	{ .pme_name   = "UNC_LLC_HITS",
		.pme_desc   = "Number of LLC read hits",
		.pme_code   = 0x08,
		.pme_flags  = PFMLIB_NHM_UNC,
		.pme_umasks = { 
			{ .pme_uname  = "READ",
				.pme_udesc  = "Number of LLC read hits",
				.pme_ucode  = 0x01,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "WRITE",
				.pme_udesc  = "Number of LLC write hits",
				.pme_ucode  = 0x02,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "PROBE",
				.pme_udesc  = "Number of LLC peer probe hits",
				.pme_ucode  = 0x04,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "ANY",
				.pme_udesc  = "Number of LLC hits",
				.pme_ucode  = 0x03,
				.pme_uflags = 0,
			}, 
		},
		.pme_numasks = 4
	}, 
	{ .pme_name   = "UNC_LLC_LINES_IN",
		.pme_desc   = "LLC lines allocated in M state",
		.pme_code   = 0x0A,
		.pme_flags  = PFMLIB_NHM_UNC,
		.pme_umasks = { 
			{ .pme_uname  = "M_STATE",
				.pme_udesc  = "LLC lines allocated in M state",
				.pme_ucode  = 0x01,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "E_STATE",
				.pme_udesc  = "LLC lines allocated in E state",
				.pme_ucode  = 0x02,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "S_STATE",
				.pme_udesc  = "LLC lines allocated in S state",
				.pme_ucode  = 0x04,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "F_STATE",
				.pme_udesc  = "LLC lines allocated in F state",
				.pme_ucode  = 0x08,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "ANY",
				.pme_udesc  = "LLC lines allocated",
				.pme_ucode  = 0x0F,
				.pme_uflags = 0,
			}, 
		},
		.pme_numasks = 5
	}, 
	{ .pme_name   = "UNC_LLC_LINES_OUT",
		.pme_desc   = "LLC lines victimized in M state",
		.pme_code   = 0x0B,
		.pme_flags  = PFMLIB_NHM_UNC,
		.pme_umasks = { 
			{ .pme_uname  = "M_STATE",
				.pme_udesc  = "LLC lines victimized in M state",
				.pme_ucode  = 0x01,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "E_STATE",
				.pme_udesc  = "LLC lines victimized in E state",
				.pme_ucode  = 0x02,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "S_STATE",
				.pme_udesc  = "LLC lines victimized in S state",
				.pme_ucode  = 0x04,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "I_STATE",
				.pme_udesc  = "LLC lines victimized in I state",
				.pme_ucode  = 0x08,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "F_STATE",
				.pme_udesc  = "LLC lines victimized in F state",
				.pme_ucode  = 0x10,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "ANY",
				.pme_udesc  = "LLC lines victimized",
				.pme_ucode  = 0x1F,
				.pme_uflags = 0,
			}, 
		},
		.pme_numasks = 6
	}, 
	{ .pme_name   = "UNC_LLC_MISS",
		.pme_desc   = "Number of LLC read misses",
		.pme_code   = 0x09,
		.pme_flags  = PFMLIB_NHM_UNC,
		.pme_umasks = { 
			{ .pme_uname  = "READ",
				.pme_udesc  = "Number of LLC read misses",
				.pme_ucode  = 0x01,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "WRITE",
				.pme_udesc  = "Number of LLC write misses",
				.pme_ucode  = 0x02,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "PROBE",
				.pme_udesc  = "Number of LLC peer probe misses",
				.pme_ucode  = 0x04,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "ANY",
				.pme_udesc  = "Number of LLC misses",
				.pme_ucode  = 0x03,
				.pme_uflags = 0,
			}, 
		},
		.pme_numasks = 4
	}, 
	{ .pme_name   = "UNC_QHL_ADDRESS_CONFLICTS",
		.pme_desc   = "QHL 2 way address conflicts",
		.pme_code   = 0x24,
		.pme_flags  = PFMLIB_NHM_UNC,
		.pme_umasks = { 
			{ .pme_uname  = "2WAY",
				.pme_udesc  = "QHL 2 way address conflicts",
				.pme_ucode  = 0x02,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "3WAY",
				.pme_udesc  = "QHL 3 way address conflicts",
				.pme_ucode  = 0x04,
				.pme_uflags = 0,
			}, 
		},
		.pme_numasks = 2
	}, 
	{ .pme_name   = "UNC_QHL_CONFLICT_CYCLES",
		.pme_desc   = "QHL IOH Tracker conflict cycles",
		.pme_code   = 0x25,
		.pme_flags  = PFMLIB_NHM_UNC,
		.pme_umasks = { 
			{ .pme_uname  = "IOH",
				.pme_udesc  = "QHL IOH Tracker conflict cycles",
				.pme_ucode  = 0x01,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "REMOTE",
				.pme_udesc  = "QHL Remote Tracker conflict cycles",
				.pme_ucode  = 0x02,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "LOCAL",
				.pme_udesc  = "QHL Local Tracker conflict cycles",
				.pme_ucode  = 0x04,
				.pme_uflags = 0,
			}, 
		},
		.pme_numasks = 3
	}, 
	{ .pme_name   = "UNC_QHL_CYCLES_FULL",
		.pme_desc   = "Cycles QHL  Remote Tracker is full",
		.pme_code   = 0x21,
		.pme_flags  = PFMLIB_NHM_UNC,
		.pme_umasks = { 
			{ .pme_uname  = "REMOTE",
				.pme_udesc  = "Cycles QHL  Remote Tracker is full",
				.pme_ucode  = 0x02,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "LOCAL",
				.pme_udesc  = "Cycles QHL Local Tracker is full",
				.pme_ucode  = 0x04,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "IOH",
				.pme_udesc  = "Cycles QHL IOH Tracker is full",
				.pme_ucode  = 0x01,
				.pme_uflags = 0,
			}, 
		},
		.pme_numasks = 3
	}, 
	{ .pme_name   = "UNC_QHL_CYCLES_NOT_EMPTY",
		.pme_desc   = "Cycles QHL Tracker is not empty",
		.pme_code   = 0x22,
		.pme_flags  = PFMLIB_NHM_UNC,
		.pme_umasks = { 
			{ .pme_uname  = "IOH",
				.pme_udesc  = "Cycles QHL IOH is busy",
				.pme_ucode  = 0x01,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "REMOTE",
				.pme_udesc  = "Cycles QHL Remote Tracker is busy",
				.pme_ucode  = 0x02,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "LOCAL",
				.pme_udesc  = "Cycles QHL Local Tracker is busy",
				.pme_ucode  = 0x04,
				.pme_uflags = 0,
			}, 
		},
		.pme_numasks = 3
	}, 
	{ .pme_name   = "UNC_QHL_FRC_ACK_CNFLTS",
		.pme_desc   = "QHL FrcAckCnflts sent to local home",
		.pme_code   = 0x33,
		.pme_flags  = PFMLIB_NHM_UNC,
		.pme_umasks = { 
			{ .pme_uname  = "LOCAL",
				.pme_udesc  = "QHL FrcAckCnflts sent to local home",
				.pme_ucode  = 0x04,
				.pme_uflags = 0,
			}, 
		},
		.pme_numasks = 1
	}, 
	{ .pme_name   = "UNC_QHL_OCCUPANCY",
		.pme_desc   = "Cycles QHL Tracker Allocate to Deallocate Read Occupancy",
		.pme_code   = 0x23,
		.pme_flags  = PFMLIB_NHM_UNC,
		.pme_umasks = { 
			{ .pme_uname  = "IOH",
				.pme_udesc  = "Cycles QHL IOH Tracker Allocate to Deallocate Read Occupancy",
				.pme_ucode  = 0x01,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "REMOTE",
				.pme_udesc  = "Cycles QHL Remote Tracker Allocate to Deallocate Read Occupancy",
				.pme_ucode  = 0x02,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "LOCAL",
				.pme_udesc  = "Cycles QHL Local Tracker Allocate to Deallocate Read Occupancy",
				.pme_ucode  = 0x04,
				.pme_uflags = 0,
			}, 
		},
		.pme_numasks = 3
	}, 
	{ .pme_name   = "UNC_QHL_REQUESTS",
		.pme_desc   = "Quickpath Home Logic local read requests",
		.pme_code   = 0x20,
		.pme_flags  = PFMLIB_NHM_UNC,
		.pme_umasks = { 
			{ .pme_uname  = "LOCAL_READS",
				.pme_udesc  = "Quickpath Home Logic local read requests",
				.pme_ucode  = 0x10,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "LOCAL_WRITES",
				.pme_udesc  = "Quickpath Home Logic local write requests",
				.pme_ucode  = 0x20,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "REMOTE_READS",
				.pme_udesc  = "Quickpath Home Logic remote read requests",
				.pme_ucode  = 0x04,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "IOH_READS",
				.pme_udesc  = "Quickpath Home Logic IOH read requests",
				.pme_ucode  = 0x01,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "IOH_WRITES",
                       		.pme_udesc  = "Quickpath Home Logic IOH write requests",
                       		.pme_ucode  = 0x02,
                       		.pme_uflags = 0,
                 	},
			{ .pme_uname  = "REMOTE_WRITES",
				.pme_udesc  = "Quickpath Home Logic remote write requests",
				.pme_ucode  = 0x08,
				.pme_uflags = 0,
			},
		},
		.pme_numasks = 6
	}, 
	{ .pme_name   = "UNC_QHL_TO_QMC_BYPASS",
		.pme_desc   = "Number of requests to QMC that bypass QHL",
		.pme_code   = 0x0126,
		.pme_flags  = PFMLIB_NHM_UNC,
	}, 
	{ .pme_name   = "UNC_QMC_BUSY",
		.pme_desc   = "Cycles QMC busy with a read request",
		.pme_code   = 0x29,
		.pme_flags  = PFMLIB_NHM_UNC,
		.pme_umasks = { 
			{ .pme_uname  = "READ_CH0",
				.pme_udesc  = "Cycles QMC channel 0 busy with a read request",
				.pme_ucode  = 0x01,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "READ_CH1",
				.pme_udesc  = "Cycles QMC channel 1 busy with a read request",
				.pme_ucode  = 0x02,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "READ_CH2",
				.pme_udesc  = "Cycles QMC channel 2 busy with a read request",
				.pme_ucode  = 0x04,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "WRITE_CH0",
				.pme_udesc  = "Cycles QMC channel 0 busy with a write request",
				.pme_ucode  = 0x08,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "WRITE_CH1",
				.pme_udesc  = "Cycles QMC channel 1 busy with a write request",
				.pme_ucode  = 0x10,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "WRITE_CH2",
				.pme_udesc  = "Cycles QMC channel 2 busy with a write request",
				.pme_ucode  = 0x20,
				.pme_uflags = 0,
			}, 
		},
		.pme_numasks = 6
	}, 
	{ .pme_name   = "UNC_QMC_CANCEL",
		.pme_desc   = "QMC cancels",
		.pme_code   = 0x30,
		.pme_flags  = PFMLIB_NHM_UNC,
		.pme_umasks = { 
			{ .pme_uname  = "CH0",
				.pme_udesc  = "QMC channel 0 cancels",
				.pme_ucode  = 0x01,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "CH1",
				.pme_udesc  = "QMC channel 1 cancels",
				.pme_ucode  = 0x02,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "CH2",
				.pme_udesc  = "QMC channel 2 cancels",
				.pme_ucode  = 0x04,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "ANY",
				.pme_udesc  = "QMC cancels",
				.pme_ucode  = 0x07,
				.pme_uflags = 0,
			}, 
		},
		.pme_numasks = 4
	}, 
	{ .pme_name   = "UNC_QMC_CRITICAL_PRIORITY_READS",
		.pme_desc   = "QMC critical priority read requests",
		.pme_code   = 0x2E,
		.pme_flags  = PFMLIB_NHM_UNC,
		.pme_umasks = { 
			{ .pme_uname  = "CH0",
				.pme_udesc  = "QMC channel 0 critical priority read requests",
				.pme_ucode  = 0x01,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "CH1",
				.pme_udesc  = "QMC channel 1 critical priority read requests",
				.pme_ucode  = 0x02,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "CH2",
				.pme_udesc  = "QMC channel 2 critical priority read requests",
				.pme_ucode  = 0x04,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "ANY",
				.pme_udesc  = "QMC critical priority read requests",
				.pme_ucode  = 0x07,
				.pme_uflags = 0,
			}, 
		},
		.pme_numasks = 4
	}, 
	{ .pme_name   = "UNC_QMC_HIGH_PRIORITY_READS",
		.pme_desc   = "QMC high priority read requests",
		.pme_code   = 0x2D,
		.pme_flags  = PFMLIB_NHM_UNC,
		.pme_umasks = { 
			{ .pme_uname  = "CH0",
				.pme_udesc  = "QMC channel 0 high priority read requests",
				.pme_ucode  = 0x01,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "CH1",
				.pme_udesc  = "QMC channel 1 high priority read requests",
				.pme_ucode  = 0x02,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "CH2",
				.pme_udesc  = "QMC channel 2 high priority read requests",
				.pme_ucode  = 0x04,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "ANY",
				.pme_udesc  = "QMC high priority read requests",
				.pme_ucode  = 0x07,
				.pme_uflags = 0,
			}, 
		},
		.pme_numasks = 4
	}, 
	{ .pme_name   = "UNC_QMC_ISOC_FULL",
		.pme_desc   = "Cycles DRAM full with isochronous read requests",
		.pme_code   = 0x28,
		.pme_flags  = PFMLIB_NHM_UNC,
		.pme_umasks = { 
			{ .pme_uname  = "READ_CH0",
				.pme_udesc  = "Cycles DRAM channel 0 full with isochronous read requests",
				.pme_ucode  = 0x01,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "READ_CH1",
				.pme_udesc  = "Cycles DRAM channel 1 full with isochronous read requests",
				.pme_ucode  = 0x02,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "READ_CH2",
				.pme_udesc  = "Cycles DRAM channel 2 full with ISOC read requests",
				.pme_ucode  = 0x04,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "WRITE_CH0",
				.pme_udesc  = "Cycles DRAM channel 0 full with ISOC write requests",
				.pme_ucode  = 0x08,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "WRITE_CH1",
				.pme_udesc  = "Cycles DRAM channel 1 full with ISOC write requests",
				.pme_ucode  = 0x10,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "WRITE_CH2",
				.pme_udesc  = "Cycles DRAM channel 2 full with ISOC write requests",
				.pme_ucode  = 0x20,
				.pme_uflags = 0,
			}, 
		},
		.pme_numasks = 6
	}, 
	{ .pme_name   = "UNC_IMC_ISOC_OCCUPANCY",
		.pme_desc   = "IMC isochronous (ISOC) Read Occupancy",
		.pme_code   = 0x2B,
		.pme_flags  = PFMLIB_NHM_UNC,
		.pme_umasks = { 
			{ .pme_uname  = "CH0",
				.pme_udesc  = "IMC channel 0 isochronous read request occupancy",
				.pme_ucode  = 0x01,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "CH1",
				.pme_udesc  = "IMC channel 1 isochronous read request occupancy",
				.pme_ucode  = 0x02,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "CH2",
				.pme_udesc  = "IMC channel 2 isochronous read request occupancy",
				.pme_ucode  = 0x04,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "ANY",
				.pme_udesc  = "IMC any channel isochronous read request occupancy",
				.pme_ucode  = 0x07,
				.pme_uflags = 0,
			}, 
		},
		.pme_numasks = 4
	}, 
	{ .pme_name   = "UNC_QMC_NORMAL_FULL",
		.pme_desc   = "Cycles DRAM full with normal read requests",
		.pme_code   = 0x27,
		.pme_flags  = PFMLIB_NHM_UNC,
		.pme_umasks = { 
			{ .pme_uname  = "READ_CH0",
				.pme_udesc  = "Cycles DRAM channel 0 full with normal read requests",
				.pme_ucode  = 0x01,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "READ_CH1",
				.pme_udesc  = "Cycles DRAM channel 1 full with normal read requests",
				.pme_ucode  = 0x02,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "READ_CH2",
				.pme_udesc  = "Cycles DRAM channel 2 full with normal read requests",
				.pme_ucode  = 0x04,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "WRITE_CH0",
				.pme_udesc  = "Cycles DRAM channel 0 full with normal write requests",
				.pme_ucode  = 0x08,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "WRITE_CH1",
				.pme_udesc  = "Cycles DRAM channel 1 full with normal write requests",
				.pme_ucode  = 0x10,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "WRITE_CH2",
				.pme_udesc  = "Cycles DRAM channel 2 full with normal write requests",
				.pme_ucode  = 0x20,
				.pme_uflags = 0,
			}, 
		},
		.pme_numasks = 6
	}, 
	{ .pme_name   = "UNC_QMC_NORMAL_READS",
		.pme_desc   = "QMC normal read requests",
		.pme_code   = 0x2C,
		.pme_flags  = PFMLIB_NHM_UNC,
		.pme_umasks = { 
			{ .pme_uname  = "CH0",
				.pme_udesc  = "QMC channel 0 normal read requests",
				.pme_ucode  = 0x01,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "CH1",
				.pme_udesc  = "QMC channel 1 normal read requests",
				.pme_ucode  = 0x02,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "CH2",
				.pme_udesc  = "QMC channel 2 normal read requests",
				.pme_ucode  = 0x04,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "ANY",
				.pme_udesc  = "QMC normal read requests",
				.pme_ucode  = 0x07,
				.pme_uflags = 0,
			}, 
		},
		.pme_numasks = 4
	}, 
	{ .pme_name   = "UNC_QMC_OCCUPANCY",
		.pme_desc   = "QMC Occupancy",
		.pme_code   = 0x2A,
		.pme_flags  = PFMLIB_NHM_UNC,
		.pme_umasks = { 
			{ .pme_uname  = "CH0",
				.pme_udesc  = "IMC channel 0 normal read request occupancy",
				.pme_ucode  = 0x01,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "CH1",
				.pme_udesc  = "IMC channel 1 normal read request occupancy",
				.pme_ucode  = 0x02,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "CH2",
				.pme_udesc  = "IMC channel 2 normal read request occupancy",
				.pme_ucode  = 0x04,
				.pme_uflags = 0,
			}, 
		},
		.pme_numasks = 3
	}, 
	{ .pme_name   = "UNC_QMC_PRIORITY_UPDATES",
		.pme_desc   = "QMC priority updates",
		.pme_code   = 0x31,
		.pme_flags  = PFMLIB_NHM_UNC,
		.pme_umasks = { 
			{ .pme_uname  = "CH0",
				.pme_udesc  = "QMC channel 0 priority updates",
				.pme_ucode  = 0x01,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "CH1",
				.pme_udesc  = "QMC channel 1 priority updates",
				.pme_ucode  = 0x02,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "CH2",
				.pme_udesc  = "QMC channel 2 priority updates",
				.pme_ucode  = 0x04,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "ANY",
				.pme_udesc  = "QMC priority updates",
				.pme_ucode  = 0x07,
				.pme_uflags = 0,
			}, 
		},
		.pme_numasks = 4
	}, 
	{ .pme_name   = "UNC_QMC_WRITES",
		.pme_desc   = "QMC full cache line writes",
		.pme_code   = 0x2F,
		.pme_flags  = PFMLIB_NHM_UNC,
		.pme_umasks = { 
			{ .pme_uname  = "FULL_CH0",
				.pme_udesc  = "QMC channel 0 full cache line writes",
				.pme_ucode  = 0x01,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "FULL_CH1",
				.pme_udesc  = "QMC channel 1 full cache line writes",
				.pme_ucode  = 0x02,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "FULL_CH2",
				.pme_udesc  = "QMC channel 2 full cache line writes",
				.pme_ucode  = 0x04,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "FULL_ANY",
				.pme_udesc  = "QMC full cache line writes",
				.pme_ucode  = 0x07,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "PARTIAL_CH0",
				.pme_udesc  = "QMC channel 0 partial cache line writes",
				.pme_ucode  = 0x08,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "PARTIAL_CH1",
				.pme_udesc  = "QMC channel 1 partial cache line writes",
				.pme_ucode  = 0x10,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "PARTIAL_CH2",
				.pme_udesc  = "QMC channel 2 partial cache line writes",
				.pme_ucode  = 0x20,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "PARTIAL_ANY",
				.pme_udesc  = "QMC partial cache line writes",
				.pme_ucode  = 0x38,
				.pme_uflags = 0,
			}, 
		},
		.pme_numasks = 8
	}, 
	{ .pme_name   = "UNC_QPI_RX_NO_PPT_CREDIT",
		.pme_desc   = "Link 0 snoop stalls due to no PPT entry",
		.pme_code   = 0x43,
		.pme_flags  = PFMLIB_NHM_UNC,
		.pme_umasks = { 
			{ .pme_uname  = "STALLS_LINK_0",
				.pme_udesc  = "Link 0 snoop stalls due to no PPT entry",
				.pme_ucode  = 0x01,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "STALLS_LINK_1",
				.pme_udesc  = "Link 1 snoop stalls due to no PPT entry",
				.pme_ucode  = 0x02,
				.pme_uflags = 0,
			}, 
		},
		.pme_numasks = 2
	}, 
	{ .pme_name   = "UNC_QPI_TX_HEADER",
		.pme_desc   = "Cycles link 0 outbound header busy",
		.pme_code   = 0x42,
		.pme_flags  = PFMLIB_NHM_UNC,
		.pme_umasks = { 
			{ .pme_uname  = "BUSY_LINK_0",
				.pme_udesc  = "Cycles link 0 outbound header busy",
				.pme_ucode  = 0x02,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "BUSY_LINK_1",
				.pme_udesc  = "Cycles link 1 outbound header busy",
				.pme_ucode  = 0x08,
				.pme_uflags = 0,
			}, 
		},
		.pme_numasks = 2
	}, 
	{ .pme_name   = "UNC_QPI_TX_STALLED_MULTI_FLIT",
		.pme_desc   = "Cycles QPI outbound link 0 DRS stalled",
		.pme_code   = 0x41,
		.pme_flags  = PFMLIB_NHM_UNC,
		.pme_umasks = { 
			{ .pme_uname  = "DRS_LINK_0",
				.pme_udesc  = "Cycles QPI outbound link 0 DRS stalled",
				.pme_ucode  = 0x01,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "NCB_LINK_0",
				.pme_udesc  = "Cycles QPI outbound link 0 NCB stalled",
				.pme_ucode  = 0x02,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "NCS_LINK_0",
				.pme_udesc  = "Cycles QPI outbound link 0 NCS stalled",
				.pme_ucode  = 0x04,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "DRS_LINK_1",
				.pme_udesc  = "Cycles QPI outbound link 1 DRS stalled",
				.pme_ucode  = 0x08,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "NCB_LINK_1",
				.pme_udesc  = "Cycles QPI outbound link 1 NCB stalled",
				.pme_ucode  = 0x10,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "NCS_LINK_1",
				.pme_udesc  = "Cycles QPI outbound link 1 NCS stalled",
				.pme_ucode  = 0x20,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "LINK_0",
				.pme_udesc  = "Cycles QPI outbound link 0 multi flit stalled",
				.pme_ucode  = 0x07,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "LINK_1",
				.pme_udesc  = "Cycles QPI outbound link 1 multi flit stalled",
				.pme_ucode  = 0x38,
				.pme_uflags = 0,
			}, 
		},
		.pme_numasks = 8
	}, 
	{ .pme_name   = "UNC_QPI_TX_STALLED_SINGLE_FLIT",
		.pme_desc   = "Cycles QPI outbound link 0 HOME stalled",
		.pme_code   = 0x40,
		.pme_flags  = PFMLIB_NHM_UNC,
		.pme_umasks = { 
			{ .pme_uname  = "HOME_LINK_0",
				.pme_udesc  = "Cycles QPI outbound link 0 HOME stalled",
				.pme_ucode  = 0x01,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "SNOOP_LINK_0",
				.pme_udesc  = "Cycles QPI outbound link 0 SNOOP stalled",
				.pme_ucode  = 0x02,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "NDR_LINK_0",
				.pme_udesc  = "Cycles QPI outbound link 0 NDR stalled",
				.pme_ucode  = 0x04,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "HOME_LINK_1",
				.pme_udesc  = "Cycles QPI outbound link 1 HOME stalled",
				.pme_ucode  = 0x08,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "SNOOP_LINK_1",
				.pme_udesc  = "Cycles QPI outbound link 1 SNOOP stalled",
				.pme_ucode  = 0x10,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "NDR_LINK_1",
				.pme_udesc  = "Cycles QPI outbound link 1 NDR stalled",
				.pme_ucode  = 0x20,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "LINK_0",
				.pme_udesc  = "Cycles QPI outbound link 0 single flit stalled",
				.pme_ucode  = 0x07,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "LINK_1",
				.pme_udesc  = "Cycles QPI outbound link 1 single flit stalled",
				.pme_ucode  = 0x38,
				.pme_uflags = 0,
			}, 
		},
		.pme_numasks = 8
	}, 
	{ .pme_name   = "UNC_SNP_RESP_TO_LOCAL_HOME",
		.pme_desc   = "Local home snoop response - LLC does not have cache line",
		.pme_code   = 0x06,
		.pme_flags  = PFMLIB_NHM_UNC,
		.pme_umasks = { 
			{ .pme_uname  = "I_STATE",
				.pme_udesc  = "Local home snoop response - LLC does not have cache line",
				.pme_ucode  = 0x01,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "S_STATE",
				.pme_udesc  = "Local home snoop response - LLC has  cache line in S state",
				.pme_ucode  = 0x02,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "FWD_S_STATE",
				.pme_udesc  = "Local home snoop response - LLC forwarding cache line in S state.",
				.pme_ucode  = 0x04,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "FWD_I_STATE",
				.pme_udesc  = "Local home snoop response - LLC has forwarded a modified cache line",
				.pme_ucode  = 0x08,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "CONFLICT",
				.pme_udesc  = "Local home conflict snoop response",
				.pme_ucode  = 0x10,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "WB",
				.pme_udesc  = "Local home snoop response - LLC has cache line in the M state",
				.pme_ucode  = 0x20,
				.pme_uflags = 0,
			}, 
		},
		.pme_numasks = 6
	}, 
	{ .pme_name   = "UNC_SNP_RESP_TO_REMOTE_HOME",
		.pme_desc   = "Remote home snoop response - LLC does not have cache line",
		.pme_code   = 0x07,
		.pme_flags  = PFMLIB_NHM_UNC,
		.pme_umasks = { 
			{ .pme_uname  = "I_STATE",
				.pme_udesc  = "Remote home snoop response - LLC does not have cache line",
				.pme_ucode  = 0x01,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "S_STATE",
				.pme_udesc  = "Remote home snoop response - LLC has  cache line in S state",
				.pme_ucode  = 0x02,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "FWD_S_STATE",
				.pme_udesc  = "Remote home snoop response - LLC forwarding cache line in S state.",
				.pme_ucode  = 0x04,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "FWD_I_STATE",
				.pme_udesc  = "Remote home snoop response - LLC has forwarded a modified cache line",
				.pme_ucode  = 0x08,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "CONFLICT",
				.pme_udesc  = "Remote home conflict snoop response",
				.pme_ucode  = 0x10,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "WB",
				.pme_udesc  = "Remote home snoop response - LLC has cache line in the M state",
				.pme_ucode  = 0x20,
				.pme_uflags = 0,
			}, 
			{ .pme_uname  = "HITM",
				.pme_udesc  = "Remote home snoop response - LLC HITM",
				.pme_ucode  = 0x24,
				.pme_uflags = 0,
			}, 
		},
		.pme_numasks = 7
	},
};
#define PME_COREI7_UNC_EVENT_COUNT	  (sizeof(corei7_unc_pe)/sizeof(pme_nhm_entry_t))
