/* scaler.c generated by valac 0.16.0, the Vala compiler
 * generated from scaler.vala, do not modify */


#include <glib.h>
#include <glib-object.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>
#include <string.h>


#define PDFPC_TYPE_SCALER (pdfpc_scaler_get_type ())
#define PDFPC_SCALER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PDFPC_TYPE_SCALER, pdfpcScaler))
#define PDFPC_SCALER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PDFPC_TYPE_SCALER, pdfpcScalerClass))
#define PDFPC_IS_SCALER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PDFPC_TYPE_SCALER))
#define PDFPC_IS_SCALER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PDFPC_TYPE_SCALER))
#define PDFPC_SCALER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PDFPC_TYPE_SCALER, pdfpcScalerClass))

typedef struct _pdfpcScaler pdfpcScaler;
typedef struct _pdfpcScalerClass pdfpcScalerClass;
typedef struct _pdfpcScalerPrivate pdfpcScalerPrivate;

struct _pdfpcScaler {
	GObject parent_instance;
	pdfpcScalerPrivate * priv;
	gdouble initial_width;
	gdouble initial_height;
};

struct _pdfpcScalerClass {
	GObjectClass parent_class;
};


static gpointer pdfpc_scaler_parent_class = NULL;

GType pdfpc_scaler_get_type (void) G_GNUC_CONST;
enum  {
	PDFPC_SCALER_DUMMY_PROPERTY
};
pdfpcScaler* pdfpc_scaler_new (gdouble width, gdouble height);
pdfpcScaler* pdfpc_scaler_construct (GType object_type, gdouble width, gdouble height);
void pdfpc_scaler_scale_to (pdfpcScaler* self, gint width, gint height, gboolean centered, gboolean allow_cutoff, GdkRectangle* result);
static void pdfpc_scaler_finalize (GObject* obj);


/**
         * Create a new Scaler taking initial width and height as input
         */
pdfpcScaler* pdfpc_scaler_construct (GType object_type, gdouble width, gdouble height) {
	pdfpcScaler * self = NULL;
	gdouble _tmp0_;
	gdouble _tmp1_;
	self = (pdfpcScaler*) g_object_new (object_type, NULL);
	_tmp0_ = width;
	self->initial_width = _tmp0_;
	_tmp1_ = height;
	self->initial_height = _tmp1_;
	return self;
}


pdfpcScaler* pdfpc_scaler_new (gdouble width, gdouble height) {
	return pdfpc_scaler_construct (PDFPC_TYPE_SCALER, width, height);
}


/**
         * Scale the initial dimensions to a specific measurement.
         *
         * The result is a Gdk.Rectangle, as by default the aspect_ration is
         * maintained and the result is centered in the given space.
         *
         * By default the given scaling will not cut off any information of the
         * source size. The allow_cutoff parameter allows to maximize usage of
         * the given space by allowing to cut off certain parts of the initial
         * input.
         */
void pdfpc_scaler_scale_to (pdfpcScaler* self, gint width, gint height, gboolean centered, gboolean allow_cutoff, GdkRectangle* result) {
	GdkRectangle target = {0};
	gdouble factor;
	gint _tmp0_;
	gdouble _tmp17_;
	gdouble _tmp18_;
	gdouble _tmp19_ = 0.0;
	gdouble _tmp20_;
	gdouble _tmp21_;
	gdouble _tmp22_ = 0.0;
	gboolean _tmp23_;
	g_return_if_fail (self != NULL);
	memset (&target, 0, sizeof (GdkRectangle));
	factor = (gdouble) 1.0f;
	_tmp0_ = width;
	if (_tmp0_ == 0) {
		gint _tmp1_;
		gdouble _tmp2_;
		_tmp1_ = height;
		_tmp2_ = self->initial_height;
		factor = _tmp1_ / _tmp2_;
	} else {
		gint _tmp3_;
		_tmp3_ = height;
		if (_tmp3_ == 0) {
			gint _tmp4_;
			gdouble _tmp5_;
			_tmp4_ = width;
			_tmp5_ = self->initial_width;
			factor = _tmp4_ / _tmp5_;
		} else {
			gboolean _tmp6_;
			_tmp6_ = allow_cutoff;
			if (_tmp6_ == TRUE) {
				gint _tmp7_;
				gdouble _tmp8_;
				gint _tmp9_;
				gdouble _tmp10_;
				gdouble _tmp11_ = 0.0;
				_tmp7_ = width;
				_tmp8_ = self->initial_width;
				_tmp9_ = height;
				_tmp10_ = self->initial_height;
				_tmp11_ = fmax (_tmp7_ / _tmp8_, _tmp9_ / _tmp10_);
				factor = _tmp11_;
			} else {
				gint _tmp12_;
				gdouble _tmp13_;
				gint _tmp14_;
				gdouble _tmp15_;
				gdouble _tmp16_ = 0.0;
				_tmp12_ = width;
				_tmp13_ = self->initial_width;
				_tmp14_ = height;
				_tmp15_ = self->initial_height;
				_tmp16_ = fmin (_tmp12_ / _tmp13_, _tmp14_ / _tmp15_);
				factor = _tmp16_;
			}
		}
	}
	_tmp17_ = self->initial_width;
	_tmp18_ = factor;
	_tmp19_ = floor (_tmp17_ * _tmp18_);
	target.width = (gint) _tmp19_;
	_tmp20_ = self->initial_height;
	_tmp21_ = factor;
	_tmp22_ = floor (_tmp20_ * _tmp21_);
	target.height = (gint) _tmp22_;
	_tmp23_ = centered;
	if (_tmp23_ == TRUE) {
		gint _tmp24_;
		GdkRectangle _tmp25_;
		gint _tmp26_;
		gdouble _tmp27_ = 0.0;
		gint _tmp28_;
		GdkRectangle _tmp29_;
		gint _tmp30_;
		gdouble _tmp31_ = 0.0;
		_tmp24_ = width;
		_tmp25_ = target;
		_tmp26_ = _tmp25_.width;
		_tmp27_ = floor ((gdouble) ((_tmp24_ - _tmp26_) / 2.0f));
		target.x = (gint) _tmp27_;
		_tmp28_ = height;
		_tmp29_ = target;
		_tmp30_ = _tmp29_.height;
		_tmp31_ = floor ((gdouble) ((_tmp28_ - _tmp30_) / 2.0f));
		target.y = (gint) _tmp31_;
	}
	*result = target;
	return;
}


static void pdfpc_scaler_class_init (pdfpcScalerClass * klass) {
	pdfpc_scaler_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = pdfpc_scaler_finalize;
}


static void pdfpc_scaler_instance_init (pdfpcScaler * self) {
}


static void pdfpc_scaler_finalize (GObject* obj) {
	pdfpcScaler * self;
	self = PDFPC_SCALER (obj);
	G_OBJECT_CLASS (pdfpc_scaler_parent_class)->finalize (obj);
}


/**
     * Scaling calculator which is able to calculate different scaling
     * scenarios while maintaining the correct aspect ratio.
     */
GType pdfpc_scaler_get_type (void) {
	static volatile gsize pdfpc_scaler_type_id__volatile = 0;
	if (g_once_init_enter (&pdfpc_scaler_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (pdfpcScalerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pdfpc_scaler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (pdfpcScaler), 0, (GInstanceInitFunc) pdfpc_scaler_instance_init, NULL };
		GType pdfpc_scaler_type_id;
		pdfpc_scaler_type_id = g_type_register_static (G_TYPE_OBJECT, "pdfpcScaler", &g_define_type_info, 0);
		g_once_init_leave (&pdfpc_scaler_type_id__volatile, pdfpc_scaler_type_id);
	}
	return pdfpc_scaler_type_id__volatile;
}



