/* This file is autogenerated, edit the original template instead! */

/* Copyright (c) 2007-2013 Antony Dovgal <tony@daylessday.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; version 2 of the License.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

void pinba_update_report_info_add(size_t request_id, pinba_report *report, const pinba_stats_record *record) /*pinba_update_report1_add(pinba_report *report, const pinba_stats_record *record)*/ /* {{{ */
{
	struct pinba_report_info_data *data;
	/*struct pinba_report1_data *data;*/
	;
	PPvoid_t ppvalue;

	timeradd(&report->time_total, &record->data.req_time, &report->time_total);
	timeradd(&report->ru_utime_total, &record->data.ru_utime, &report->ru_utime_total);
	timeradd(&report->ru_stime_total, &record->data.ru_stime, &report->ru_stime_total);
	report->kbytes_total += record->data.doc_size;
	report->memory_footprint += record->data.memory_footprint;

#if 1
	report->std.results_cnt++;
	PINBA_UPDATE_HISTOGRAM_ADD(report, report->std.histogram_data, record->data.req_time);
#else 
	{
		size_t index_len, dummy;
		/*int index_len, dummy;*/

		;

		ppvalue = JudySLGet(report->results, index, NULL);

		if (UNLIKELY(!ppvalue || ppvalue == PPJERR)) {
			/* no such value, insert */
			ppvalue = JudySLIns(&report->results, index, NULL);
			if (UNLIKELY(!ppvalue || ppvalue == PPJERR)) {
				return;
			}
			data = (struct pinba_report_info_data *)calloc(1, sizeof(struct pinba_report_info_data));

			;

			*ppvalue = data;
			report->std.results_cnt++;
		} else {
			data = (struct pinba_report_info_data *)*ppvalue;
		}

		data->req_count++;
		timeradd(&data->req_time_total, &record->data.req_time, &data->req_time_total);
		timeradd(&data->ru_utime_total, &record->data.ru_utime, &data->ru_utime_total);
		timeradd(&data->ru_stime_total, &record->data.ru_stime, &data->ru_stime_total);
		data->kbytes_total += record->data.doc_size;
		data->memory_footprint += record->data.memory_footprint;
		PINBA_UPDATE_HISTOGRAM_ADD(report, data->histogram_data, record->data.req_time);
	}
#endif
}
/* }}} */

void pinba_update_report_info_delete(size_t request_id, pinba_report *report, const pinba_stats_record *record) /* pinba_update_report1_delete(pinba_report *report, const pinba_stats_record *record)*/ /* {{{ */
{
	struct pinba_report_info_data *data;
	;
	PPvoid_t ppvalue;

	if (report->std.results_cnt == 0) {
		return;
	}

	PINBA_REPORT_DELETE_CHECK(report, record);

	timersub(&report->time_total, &record->data.req_time, &report->time_total);
	timersub(&report->ru_utime_total, &record->data.ru_utime, &report->ru_utime_total);
	timersub(&report->ru_stime_total, &record->data.ru_stime, &report->ru_stime_total);
	report->kbytes_total -= record->data.doc_size;
	report->memory_footprint -= record->data.memory_footprint;

#if 1
	report->std.results_cnt--;
	PINBA_UPDATE_HISTOGRAM_DEL(report, report->std.histogram_data, record->data.req_time);
#else 
	{
		size_t index_len, dummy;
		/*int index_len, dummy;*/

		;

		ppvalue = JudySLGet(report->results, index, NULL);

		if (UNLIKELY(!ppvalue || ppvalue == PPJERR)) {
			/* no such value, mmm?? */
			return;
		} else {

			data = (struct pinba_report_info_data *)*ppvalue;
			if (UNLIKELY(data->req_count == 1)) {
				free(data);
				JudySLDel(&report->results, index, NULL);
				report->std.results_cnt--;
			} else {
				data->req_count--;
				timersub(&data->req_time_total, &record->data.req_time, &data->req_time_total);
				timersub(&data->ru_utime_total, &record->data.ru_utime, &data->ru_utime_total);
				timersub(&data->ru_stime_total, &record->data.ru_stime, &data->ru_stime_total);
				data->kbytes_total -= record->data.doc_size;
				data->memory_footprint -= record->data.memory_footprint;
				PINBA_UPDATE_HISTOGRAM_DEL(report, data->histogram_data, record->data.req_time);
			}
		}
	}
#endif
}
/* }}} */

void pinba_update_report1_add(size_t request_id, pinba_report *report, const pinba_stats_record *record) /*pinba_update_report1_add(pinba_report *report, const pinba_stats_record *record)*/ /* {{{ */
{
	struct pinba_report1_data *data;
	/*struct pinba_report1_data *data;*/
	const uint8_t *index;
	PPvoid_t ppvalue;

	timeradd(&report->time_total, &record->data.req_time, &report->time_total);
	timeradd(&report->ru_utime_total, &record->data.ru_utime, &report->ru_utime_total);
	timeradd(&report->ru_stime_total, &record->data.ru_stime, &report->ru_stime_total);
	report->kbytes_total += record->data.doc_size;
	report->memory_footprint += record->data.memory_footprint;

#if 0
	report->std.results_cnt++;
	PINBA_UPDATE_HISTOGRAM_ADD(report, report->std.histogram_data, record->data.req_time);
#else 
	{
		size_t index_len, dummy;
		/*int index_len, dummy;*/

		index = (const uint8_t *)record->data.script_name;

		ppvalue = JudySLGet(report->results, index, NULL);

		if (UNLIKELY(!ppvalue || ppvalue == PPJERR)) {
			/* no such value, insert */
			ppvalue = JudySLIns(&report->results, index, NULL);
			if (UNLIKELY(!ppvalue || ppvalue == PPJERR)) {
				return;
			}
			data = (struct pinba_report1_data *)calloc(1, sizeof(struct pinba_report1_data));

			;

			*ppvalue = data;
			report->std.results_cnt++;
		} else {
			data = (struct pinba_report1_data *)*ppvalue;
		}

		data->req_count++;
		timeradd(&data->req_time_total, &record->data.req_time, &data->req_time_total);
		timeradd(&data->ru_utime_total, &record->data.ru_utime, &data->ru_utime_total);
		timeradd(&data->ru_stime_total, &record->data.ru_stime, &data->ru_stime_total);
		data->kbytes_total += record->data.doc_size;
		data->memory_footprint += record->data.memory_footprint;
		PINBA_UPDATE_HISTOGRAM_ADD(report, data->histogram_data, record->data.req_time);
	}
#endif
}
/* }}} */

void pinba_update_report1_delete(size_t request_id, pinba_report *report, const pinba_stats_record *record) /* pinba_update_report1_delete(pinba_report *report, const pinba_stats_record *record)*/ /* {{{ */
{
	struct pinba_report1_data *data;
	const uint8_t *index;
	PPvoid_t ppvalue;

	if (report->std.results_cnt == 0) {
		return;
	}

	PINBA_REPORT_DELETE_CHECK(report, record);

	timersub(&report->time_total, &record->data.req_time, &report->time_total);
	timersub(&report->ru_utime_total, &record->data.ru_utime, &report->ru_utime_total);
	timersub(&report->ru_stime_total, &record->data.ru_stime, &report->ru_stime_total);
	report->kbytes_total -= record->data.doc_size;
	report->memory_footprint -= record->data.memory_footprint;

#if 0
	report->std.results_cnt--;
	PINBA_UPDATE_HISTOGRAM_DEL(report, report->std.histogram_data, record->data.req_time);
#else 
	{
		size_t index_len, dummy;
		/*int index_len, dummy;*/

		index = (const uint8_t *)record->data.script_name;

		ppvalue = JudySLGet(report->results, index, NULL);

		if (UNLIKELY(!ppvalue || ppvalue == PPJERR)) {
			/* no such value, mmm?? */
			return;
		} else {

			data = (struct pinba_report1_data *)*ppvalue;
			if (UNLIKELY(data->req_count == 1)) {
				free(data);
				JudySLDel(&report->results, index, NULL);
				report->std.results_cnt--;
			} else {
				data->req_count--;
				timersub(&data->req_time_total, &record->data.req_time, &data->req_time_total);
				timersub(&data->ru_utime_total, &record->data.ru_utime, &data->ru_utime_total);
				timersub(&data->ru_stime_total, &record->data.ru_stime, &data->ru_stime_total);
				data->kbytes_total -= record->data.doc_size;
				data->memory_footprint -= record->data.memory_footprint;
				PINBA_UPDATE_HISTOGRAM_DEL(report, data->histogram_data, record->data.req_time);
			}
		}
	}
#endif
}
/* }}} */

void pinba_update_report2_add(size_t request_id, pinba_report *report, const pinba_stats_record *record) /*pinba_update_report1_add(pinba_report *report, const pinba_stats_record *record)*/ /* {{{ */
{
	struct pinba_report2_data *data;
	/*struct pinba_report1_data *data;*/
	const uint8_t *index;
	PPvoid_t ppvalue;

	timeradd(&report->time_total, &record->data.req_time, &report->time_total);
	timeradd(&report->ru_utime_total, &record->data.ru_utime, &report->ru_utime_total);
	timeradd(&report->ru_stime_total, &record->data.ru_stime, &report->ru_stime_total);
	report->kbytes_total += record->data.doc_size;
	report->memory_footprint += record->data.memory_footprint;

#if 0
	report->std.results_cnt++;
	PINBA_UPDATE_HISTOGRAM_ADD(report, report->std.histogram_data, record->data.req_time);
#else 
	{
		size_t index_len, dummy;
		/*int index_len, dummy;*/

		index = (const uint8_t *)record->data.server_name;

		ppvalue = JudySLGet(report->results, index, NULL);

		if (UNLIKELY(!ppvalue || ppvalue == PPJERR)) {
			/* no such value, insert */
			ppvalue = JudySLIns(&report->results, index, NULL);
			if (UNLIKELY(!ppvalue || ppvalue == PPJERR)) {
				return;
			}
			data = (struct pinba_report2_data *)calloc(1, sizeof(struct pinba_report2_data));

			;

			*ppvalue = data;
			report->std.results_cnt++;
		} else {
			data = (struct pinba_report2_data *)*ppvalue;
		}

		data->req_count++;
		timeradd(&data->req_time_total, &record->data.req_time, &data->req_time_total);
		timeradd(&data->ru_utime_total, &record->data.ru_utime, &data->ru_utime_total);
		timeradd(&data->ru_stime_total, &record->data.ru_stime, &data->ru_stime_total);
		data->kbytes_total += record->data.doc_size;
		data->memory_footprint += record->data.memory_footprint;
		PINBA_UPDATE_HISTOGRAM_ADD(report, data->histogram_data, record->data.req_time);
	}
#endif
}
/* }}} */

void pinba_update_report2_delete(size_t request_id, pinba_report *report, const pinba_stats_record *record) /* pinba_update_report1_delete(pinba_report *report, const pinba_stats_record *record)*/ /* {{{ */
{
	struct pinba_report2_data *data;
	const uint8_t *index;
	PPvoid_t ppvalue;

	if (report->std.results_cnt == 0) {
		return;
	}

	PINBA_REPORT_DELETE_CHECK(report, record);

	timersub(&report->time_total, &record->data.req_time, &report->time_total);
	timersub(&report->ru_utime_total, &record->data.ru_utime, &report->ru_utime_total);
	timersub(&report->ru_stime_total, &record->data.ru_stime, &report->ru_stime_total);
	report->kbytes_total -= record->data.doc_size;
	report->memory_footprint -= record->data.memory_footprint;

#if 0
	report->std.results_cnt--;
	PINBA_UPDATE_HISTOGRAM_DEL(report, report->std.histogram_data, record->data.req_time);
#else 
	{
		size_t index_len, dummy;
		/*int index_len, dummy;*/

		index = (const uint8_t *)record->data.server_name;

		ppvalue = JudySLGet(report->results, index, NULL);

		if (UNLIKELY(!ppvalue || ppvalue == PPJERR)) {
			/* no such value, mmm?? */
			return;
		} else {

			data = (struct pinba_report2_data *)*ppvalue;
			if (UNLIKELY(data->req_count == 1)) {
				free(data);
				JudySLDel(&report->results, index, NULL);
				report->std.results_cnt--;
			} else {
				data->req_count--;
				timersub(&data->req_time_total, &record->data.req_time, &data->req_time_total);
				timersub(&data->ru_utime_total, &record->data.ru_utime, &data->ru_utime_total);
				timersub(&data->ru_stime_total, &record->data.ru_stime, &data->ru_stime_total);
				data->kbytes_total -= record->data.doc_size;
				data->memory_footprint -= record->data.memory_footprint;
				PINBA_UPDATE_HISTOGRAM_DEL(report, data->histogram_data, record->data.req_time);
			}
		}
	}
#endif
}
/* }}} */

void pinba_update_report3_add(size_t request_id, pinba_report *report, const pinba_stats_record *record) /*pinba_update_report1_add(pinba_report *report, const pinba_stats_record *record)*/ /* {{{ */
{
	struct pinba_report3_data *data;
	/*struct pinba_report1_data *data;*/
	const uint8_t *index;
	PPvoid_t ppvalue;

	timeradd(&report->time_total, &record->data.req_time, &report->time_total);
	timeradd(&report->ru_utime_total, &record->data.ru_utime, &report->ru_utime_total);
	timeradd(&report->ru_stime_total, &record->data.ru_stime, &report->ru_stime_total);
	report->kbytes_total += record->data.doc_size;
	report->memory_footprint += record->data.memory_footprint;

#if 0
	report->std.results_cnt++;
	PINBA_UPDATE_HISTOGRAM_ADD(report, report->std.histogram_data, record->data.req_time);
#else 
	{
		size_t index_len, dummy;
		/*int index_len, dummy;*/

		index = (const uint8_t *)record->data.hostname;

		ppvalue = JudySLGet(report->results, index, NULL);

		if (UNLIKELY(!ppvalue || ppvalue == PPJERR)) {
			/* no such value, insert */
			ppvalue = JudySLIns(&report->results, index, NULL);
			if (UNLIKELY(!ppvalue || ppvalue == PPJERR)) {
				return;
			}
			data = (struct pinba_report3_data *)calloc(1, sizeof(struct pinba_report3_data));

			;

			*ppvalue = data;
			report->std.results_cnt++;
		} else {
			data = (struct pinba_report3_data *)*ppvalue;
		}

		data->req_count++;
		timeradd(&data->req_time_total, &record->data.req_time, &data->req_time_total);
		timeradd(&data->ru_utime_total, &record->data.ru_utime, &data->ru_utime_total);
		timeradd(&data->ru_stime_total, &record->data.ru_stime, &data->ru_stime_total);
		data->kbytes_total += record->data.doc_size;
		data->memory_footprint += record->data.memory_footprint;
		PINBA_UPDATE_HISTOGRAM_ADD(report, data->histogram_data, record->data.req_time);
	}
#endif
}
/* }}} */

void pinba_update_report3_delete(size_t request_id, pinba_report *report, const pinba_stats_record *record) /* pinba_update_report1_delete(pinba_report *report, const pinba_stats_record *record)*/ /* {{{ */
{
	struct pinba_report3_data *data;
	const uint8_t *index;
	PPvoid_t ppvalue;

	if (report->std.results_cnt == 0) {
		return;
	}

	PINBA_REPORT_DELETE_CHECK(report, record);

	timersub(&report->time_total, &record->data.req_time, &report->time_total);
	timersub(&report->ru_utime_total, &record->data.ru_utime, &report->ru_utime_total);
	timersub(&report->ru_stime_total, &record->data.ru_stime, &report->ru_stime_total);
	report->kbytes_total -= record->data.doc_size;
	report->memory_footprint -= record->data.memory_footprint;

#if 0
	report->std.results_cnt--;
	PINBA_UPDATE_HISTOGRAM_DEL(report, report->std.histogram_data, record->data.req_time);
#else 
	{
		size_t index_len, dummy;
		/*int index_len, dummy;*/

		index = (const uint8_t *)record->data.hostname;

		ppvalue = JudySLGet(report->results, index, NULL);

		if (UNLIKELY(!ppvalue || ppvalue == PPJERR)) {
			/* no such value, mmm?? */
			return;
		} else {

			data = (struct pinba_report3_data *)*ppvalue;
			if (UNLIKELY(data->req_count == 1)) {
				free(data);
				JudySLDel(&report->results, index, NULL);
				report->std.results_cnt--;
			} else {
				data->req_count--;
				timersub(&data->req_time_total, &record->data.req_time, &data->req_time_total);
				timersub(&data->ru_utime_total, &record->data.ru_utime, &data->ru_utime_total);
				timersub(&data->ru_stime_total, &record->data.ru_stime, &data->ru_stime_total);
				data->kbytes_total -= record->data.doc_size;
				data->memory_footprint -= record->data.memory_footprint;
				PINBA_UPDATE_HISTOGRAM_DEL(report, data->histogram_data, record->data.req_time);
			}
		}
	}
#endif
}
/* }}} */

void pinba_update_report4_add(size_t request_id, pinba_report *report, const pinba_stats_record *record) /*pinba_update_report1_add(pinba_report *report, const pinba_stats_record *record)*/ /* {{{ */
{
	struct pinba_report4_data *data;
	/*struct pinba_report1_data *data;*/
	uint8_t index[PINBA_SERVER_NAME_SIZE + PINBA_SCRIPT_NAME_SIZE + 1] = {0};
	PPvoid_t ppvalue;

	timeradd(&report->time_total, &record->data.req_time, &report->time_total);
	timeradd(&report->ru_utime_total, &record->data.ru_utime, &report->ru_utime_total);
	timeradd(&report->ru_stime_total, &record->data.ru_stime, &report->ru_stime_total);
	report->kbytes_total += record->data.doc_size;
	report->memory_footprint += record->data.memory_footprint;

#if 0
	report->std.results_cnt++;
	PINBA_UPDATE_HISTOGRAM_ADD(report, report->std.histogram_data, record->data.req_time);
#else 
	{
		size_t index_len, dummy;
		/*int index_len, dummy;*/

		
		memcpy_static(index, record->data.server_name, record->data.server_name_len, index_len);
		(index_len < sizeof(index)-1) ? index[index_len++] = '/' : 0;
		memcat_static(index, index_len, record->data.script_name, record->data.script_name_len, index_len);
		;

		ppvalue = JudySLGet(report->results, index, NULL);

		if (UNLIKELY(!ppvalue || ppvalue == PPJERR)) {
			/* no such value, insert */
			ppvalue = JudySLIns(&report->results, index, NULL);
			if (UNLIKELY(!ppvalue || ppvalue == PPJERR)) {
				return;
			}
			data = (struct pinba_report4_data *)calloc(1, sizeof(struct pinba_report4_data));

			
		memcpy_static(data->server_name, record->data.server_name, record->data.server_name_len, dummy);
		memcpy_static(data->script_name, record->data.script_name, record->data.script_name_len, dummy);
		;

			*ppvalue = data;
			report->std.results_cnt++;
		} else {
			data = (struct pinba_report4_data *)*ppvalue;
		}

		data->req_count++;
		timeradd(&data->req_time_total, &record->data.req_time, &data->req_time_total);
		timeradd(&data->ru_utime_total, &record->data.ru_utime, &data->ru_utime_total);
		timeradd(&data->ru_stime_total, &record->data.ru_stime, &data->ru_stime_total);
		data->kbytes_total += record->data.doc_size;
		data->memory_footprint += record->data.memory_footprint;
		PINBA_UPDATE_HISTOGRAM_ADD(report, data->histogram_data, record->data.req_time);
	}
#endif
}
/* }}} */

void pinba_update_report4_delete(size_t request_id, pinba_report *report, const pinba_stats_record *record) /* pinba_update_report1_delete(pinba_report *report, const pinba_stats_record *record)*/ /* {{{ */
{
	struct pinba_report4_data *data;
	uint8_t index[PINBA_SERVER_NAME_SIZE + PINBA_SCRIPT_NAME_SIZE + 1] = {0};
	PPvoid_t ppvalue;

	if (report->std.results_cnt == 0) {
		return;
	}

	PINBA_REPORT_DELETE_CHECK(report, record);

	timersub(&report->time_total, &record->data.req_time, &report->time_total);
	timersub(&report->ru_utime_total, &record->data.ru_utime, &report->ru_utime_total);
	timersub(&report->ru_stime_total, &record->data.ru_stime, &report->ru_stime_total);
	report->kbytes_total -= record->data.doc_size;
	report->memory_footprint -= record->data.memory_footprint;

#if 0
	report->std.results_cnt--;
	PINBA_UPDATE_HISTOGRAM_DEL(report, report->std.histogram_data, record->data.req_time);
#else 
	{
		size_t index_len, dummy;
		/*int index_len, dummy;*/

		
		memcpy_static(index, record->data.server_name, record->data.server_name_len, index_len);
		(index_len < sizeof(index)-1) ? index[index_len++] = '/' : 0;
		memcat_static(index, index_len, record->data.script_name, record->data.script_name_len, index_len);
		;

		ppvalue = JudySLGet(report->results, index, NULL);

		if (UNLIKELY(!ppvalue || ppvalue == PPJERR)) {
			/* no such value, mmm?? */
			return;
		} else {

			data = (struct pinba_report4_data *)*ppvalue;
			if (UNLIKELY(data->req_count == 1)) {
				free(data);
				JudySLDel(&report->results, index, NULL);
				report->std.results_cnt--;
			} else {
				data->req_count--;
				timersub(&data->req_time_total, &record->data.req_time, &data->req_time_total);
				timersub(&data->ru_utime_total, &record->data.ru_utime, &data->ru_utime_total);
				timersub(&data->ru_stime_total, &record->data.ru_stime, &data->ru_stime_total);
				data->kbytes_total -= record->data.doc_size;
				data->memory_footprint -= record->data.memory_footprint;
				PINBA_UPDATE_HISTOGRAM_DEL(report, data->histogram_data, record->data.req_time);
			}
		}
	}
#endif
}
/* }}} */

void pinba_update_report5_add(size_t request_id, pinba_report *report, const pinba_stats_record *record) /*pinba_update_report1_add(pinba_report *report, const pinba_stats_record *record)*/ /* {{{ */
{
	struct pinba_report5_data *data;
	/*struct pinba_report1_data *data;*/
	uint8_t index[PINBA_HOSTNAME_SIZE + PINBA_SCRIPT_NAME_SIZE + 1] = {0};
	PPvoid_t ppvalue;

	timeradd(&report->time_total, &record->data.req_time, &report->time_total);
	timeradd(&report->ru_utime_total, &record->data.ru_utime, &report->ru_utime_total);
	timeradd(&report->ru_stime_total, &record->data.ru_stime, &report->ru_stime_total);
	report->kbytes_total += record->data.doc_size;
	report->memory_footprint += record->data.memory_footprint;

#if 0
	report->std.results_cnt++;
	PINBA_UPDATE_HISTOGRAM_ADD(report, report->std.histogram_data, record->data.req_time);
#else 
	{
		size_t index_len, dummy;
		/*int index_len, dummy;*/

		
		memcpy_static(index, record->data.hostname, record->data.hostname_len, index_len);
		(index_len < sizeof(index)-1) ? index[index_len++] = '/' : 0;
		memcat_static(index, index_len, record->data.script_name, record->data.script_name_len, index_len);
		;

		ppvalue = JudySLGet(report->results, index, NULL);

		if (UNLIKELY(!ppvalue || ppvalue == PPJERR)) {
			/* no such value, insert */
			ppvalue = JudySLIns(&report->results, index, NULL);
			if (UNLIKELY(!ppvalue || ppvalue == PPJERR)) {
				return;
			}
			data = (struct pinba_report5_data *)calloc(1, sizeof(struct pinba_report5_data));

			
		memcpy_static(data->hostname, record->data.hostname, record->data.hostname_len, dummy);
		memcpy_static(data->script_name, record->data.script_name, record->data.script_name_len, dummy);
		;

			*ppvalue = data;
			report->std.results_cnt++;
		} else {
			data = (struct pinba_report5_data *)*ppvalue;
		}

		data->req_count++;
		timeradd(&data->req_time_total, &record->data.req_time, &data->req_time_total);
		timeradd(&data->ru_utime_total, &record->data.ru_utime, &data->ru_utime_total);
		timeradd(&data->ru_stime_total, &record->data.ru_stime, &data->ru_stime_total);
		data->kbytes_total += record->data.doc_size;
		data->memory_footprint += record->data.memory_footprint;
		PINBA_UPDATE_HISTOGRAM_ADD(report, data->histogram_data, record->data.req_time);
	}
#endif
}
/* }}} */

void pinba_update_report5_delete(size_t request_id, pinba_report *report, const pinba_stats_record *record) /* pinba_update_report1_delete(pinba_report *report, const pinba_stats_record *record)*/ /* {{{ */
{
	struct pinba_report5_data *data;
	uint8_t index[PINBA_HOSTNAME_SIZE + PINBA_SCRIPT_NAME_SIZE + 1] = {0};
	PPvoid_t ppvalue;

	if (report->std.results_cnt == 0) {
		return;
	}

	PINBA_REPORT_DELETE_CHECK(report, record);

	timersub(&report->time_total, &record->data.req_time, &report->time_total);
	timersub(&report->ru_utime_total, &record->data.ru_utime, &report->ru_utime_total);
	timersub(&report->ru_stime_total, &record->data.ru_stime, &report->ru_stime_total);
	report->kbytes_total -= record->data.doc_size;
	report->memory_footprint -= record->data.memory_footprint;

#if 0
	report->std.results_cnt--;
	PINBA_UPDATE_HISTOGRAM_DEL(report, report->std.histogram_data, record->data.req_time);
#else 
	{
		size_t index_len, dummy;
		/*int index_len, dummy;*/

		
		memcpy_static(index, record->data.hostname, record->data.hostname_len, index_len);
		(index_len < sizeof(index)-1) ? index[index_len++] = '/' : 0;
		memcat_static(index, index_len, record->data.script_name, record->data.script_name_len, index_len);
		;

		ppvalue = JudySLGet(report->results, index, NULL);

		if (UNLIKELY(!ppvalue || ppvalue == PPJERR)) {
			/* no such value, mmm?? */
			return;
		} else {

			data = (struct pinba_report5_data *)*ppvalue;
			if (UNLIKELY(data->req_count == 1)) {
				free(data);
				JudySLDel(&report->results, index, NULL);
				report->std.results_cnt--;
			} else {
				data->req_count--;
				timersub(&data->req_time_total, &record->data.req_time, &data->req_time_total);
				timersub(&data->ru_utime_total, &record->data.ru_utime, &data->ru_utime_total);
				timersub(&data->ru_stime_total, &record->data.ru_stime, &data->ru_stime_total);
				data->kbytes_total -= record->data.doc_size;
				data->memory_footprint -= record->data.memory_footprint;
				PINBA_UPDATE_HISTOGRAM_DEL(report, data->histogram_data, record->data.req_time);
			}
		}
	}
#endif
}
/* }}} */

void pinba_update_report6_add(size_t request_id, pinba_report *report, const pinba_stats_record *record) /*pinba_update_report1_add(pinba_report *report, const pinba_stats_record *record)*/ /* {{{ */
{
	struct pinba_report6_data *data;
	/*struct pinba_report1_data *data;*/
	uint8_t index[PINBA_HOSTNAME_SIZE + PINBA_SERVER_NAME_SIZE + 1] = {0};
	PPvoid_t ppvalue;

	timeradd(&report->time_total, &record->data.req_time, &report->time_total);
	timeradd(&report->ru_utime_total, &record->data.ru_utime, &report->ru_utime_total);
	timeradd(&report->ru_stime_total, &record->data.ru_stime, &report->ru_stime_total);
	report->kbytes_total += record->data.doc_size;
	report->memory_footprint += record->data.memory_footprint;

#if 0
	report->std.results_cnt++;
	PINBA_UPDATE_HISTOGRAM_ADD(report, report->std.histogram_data, record->data.req_time);
#else 
	{
		size_t index_len, dummy;
		/*int index_len, dummy;*/

		
		memcpy_static(index, record->data.hostname, record->data.hostname_len, index_len);
		(index_len < sizeof(index)-1) ? index[index_len++] = '/' : 0;
		memcat_static(index, index_len, record->data.server_name, record->data.server_name_len, index_len);
		;

		ppvalue = JudySLGet(report->results, index, NULL);

		if (UNLIKELY(!ppvalue || ppvalue == PPJERR)) {
			/* no such value, insert */
			ppvalue = JudySLIns(&report->results, index, NULL);
			if (UNLIKELY(!ppvalue || ppvalue == PPJERR)) {
				return;
			}
			data = (struct pinba_report6_data *)calloc(1, sizeof(struct pinba_report6_data));

			
		memcpy_static(data->hostname, record->data.hostname, record->data.hostname_len, dummy);
		memcpy_static(data->server_name, record->data.server_name, record->data.server_name_len, dummy);
		;

			*ppvalue = data;
			report->std.results_cnt++;
		} else {
			data = (struct pinba_report6_data *)*ppvalue;
		}

		data->req_count++;
		timeradd(&data->req_time_total, &record->data.req_time, &data->req_time_total);
		timeradd(&data->ru_utime_total, &record->data.ru_utime, &data->ru_utime_total);
		timeradd(&data->ru_stime_total, &record->data.ru_stime, &data->ru_stime_total);
		data->kbytes_total += record->data.doc_size;
		data->memory_footprint += record->data.memory_footprint;
		PINBA_UPDATE_HISTOGRAM_ADD(report, data->histogram_data, record->data.req_time);
	}
#endif
}
/* }}} */

void pinba_update_report6_delete(size_t request_id, pinba_report *report, const pinba_stats_record *record) /* pinba_update_report1_delete(pinba_report *report, const pinba_stats_record *record)*/ /* {{{ */
{
	struct pinba_report6_data *data;
	uint8_t index[PINBA_HOSTNAME_SIZE + PINBA_SERVER_NAME_SIZE + 1] = {0};
	PPvoid_t ppvalue;

	if (report->std.results_cnt == 0) {
		return;
	}

	PINBA_REPORT_DELETE_CHECK(report, record);

	timersub(&report->time_total, &record->data.req_time, &report->time_total);
	timersub(&report->ru_utime_total, &record->data.ru_utime, &report->ru_utime_total);
	timersub(&report->ru_stime_total, &record->data.ru_stime, &report->ru_stime_total);
	report->kbytes_total -= record->data.doc_size;
	report->memory_footprint -= record->data.memory_footprint;

#if 0
	report->std.results_cnt--;
	PINBA_UPDATE_HISTOGRAM_DEL(report, report->std.histogram_data, record->data.req_time);
#else 
	{
		size_t index_len, dummy;
		/*int index_len, dummy;*/

		
		memcpy_static(index, record->data.hostname, record->data.hostname_len, index_len);
		(index_len < sizeof(index)-1) ? index[index_len++] = '/' : 0;
		memcat_static(index, index_len, record->data.server_name, record->data.server_name_len, index_len);
		;

		ppvalue = JudySLGet(report->results, index, NULL);

		if (UNLIKELY(!ppvalue || ppvalue == PPJERR)) {
			/* no such value, mmm?? */
			return;
		} else {

			data = (struct pinba_report6_data *)*ppvalue;
			if (UNLIKELY(data->req_count == 1)) {
				free(data);
				JudySLDel(&report->results, index, NULL);
				report->std.results_cnt--;
			} else {
				data->req_count--;
				timersub(&data->req_time_total, &record->data.req_time, &data->req_time_total);
				timersub(&data->ru_utime_total, &record->data.ru_utime, &data->ru_utime_total);
				timersub(&data->ru_stime_total, &record->data.ru_stime, &data->ru_stime_total);
				data->kbytes_total -= record->data.doc_size;
				data->memory_footprint -= record->data.memory_footprint;
				PINBA_UPDATE_HISTOGRAM_DEL(report, data->histogram_data, record->data.req_time);
			}
		}
	}
#endif
}
/* }}} */

void pinba_update_report7_add(size_t request_id, pinba_report *report, const pinba_stats_record *record) /*pinba_update_report1_add(pinba_report *report, const pinba_stats_record *record)*/ /* {{{ */
{
	struct pinba_report7_data *data;
	/*struct pinba_report1_data *data;*/
	uint8_t index[PINBA_HOSTNAME_SIZE + 1 + PINBA_SERVER_NAME_SIZE + 1 + PINBA_SCRIPT_NAME_SIZE] = {0};
	PPvoid_t ppvalue;

	timeradd(&report->time_total, &record->data.req_time, &report->time_total);
	timeradd(&report->ru_utime_total, &record->data.ru_utime, &report->ru_utime_total);
	timeradd(&report->ru_stime_total, &record->data.ru_stime, &report->ru_stime_total);
	report->kbytes_total += record->data.doc_size;
	report->memory_footprint += record->data.memory_footprint;

#if 0
	report->std.results_cnt++;
	PINBA_UPDATE_HISTOGRAM_ADD(report, report->std.histogram_data, record->data.req_time);
#else 
	{
		size_t index_len, dummy;
		/*int index_len, dummy;*/

		
		memcpy_static(index, record->data.hostname, record->data.hostname_len, index_len);
		(index_len < sizeof(index)-1) ? index[index_len++] = ':' : 0;
		memcat_static(index, index_len, record->data.server_name, record->data.server_name_len, index_len);
		(index_len < sizeof(index)-1) ? index[index_len++] = '/' : 0;
		memcat_static(index, index_len, record->data.script_name, record->data.script_name_len, index_len);
		;

		ppvalue = JudySLGet(report->results, index, NULL);

		if (UNLIKELY(!ppvalue || ppvalue == PPJERR)) {
			/* no such value, insert */
			ppvalue = JudySLIns(&report->results, index, NULL);
			if (UNLIKELY(!ppvalue || ppvalue == PPJERR)) {
				return;
			}
			data = (struct pinba_report7_data *)calloc(1, sizeof(struct pinba_report7_data));

			
		memcpy_static(data->hostname, record->data.hostname, record->data.hostname_len, dummy);
		memcpy_static(data->server_name, record->data.server_name, record->data.server_name_len, dummy);
		memcpy_static(data->script_name, record->data.script_name, record->data.script_name_len, dummy);
		;

			*ppvalue = data;
			report->std.results_cnt++;
		} else {
			data = (struct pinba_report7_data *)*ppvalue;
		}

		data->req_count++;
		timeradd(&data->req_time_total, &record->data.req_time, &data->req_time_total);
		timeradd(&data->ru_utime_total, &record->data.ru_utime, &data->ru_utime_total);
		timeradd(&data->ru_stime_total, &record->data.ru_stime, &data->ru_stime_total);
		data->kbytes_total += record->data.doc_size;
		data->memory_footprint += record->data.memory_footprint;
		PINBA_UPDATE_HISTOGRAM_ADD(report, data->histogram_data, record->data.req_time);
	}
#endif
}
/* }}} */

void pinba_update_report7_delete(size_t request_id, pinba_report *report, const pinba_stats_record *record) /* pinba_update_report1_delete(pinba_report *report, const pinba_stats_record *record)*/ /* {{{ */
{
	struct pinba_report7_data *data;
	uint8_t index[PINBA_HOSTNAME_SIZE + 1 + PINBA_SERVER_NAME_SIZE + 1 + PINBA_SCRIPT_NAME_SIZE] = {0};
	PPvoid_t ppvalue;

	if (report->std.results_cnt == 0) {
		return;
	}

	PINBA_REPORT_DELETE_CHECK(report, record);

	timersub(&report->time_total, &record->data.req_time, &report->time_total);
	timersub(&report->ru_utime_total, &record->data.ru_utime, &report->ru_utime_total);
	timersub(&report->ru_stime_total, &record->data.ru_stime, &report->ru_stime_total);
	report->kbytes_total -= record->data.doc_size;
	report->memory_footprint -= record->data.memory_footprint;

#if 0
	report->std.results_cnt--;
	PINBA_UPDATE_HISTOGRAM_DEL(report, report->std.histogram_data, record->data.req_time);
#else 
	{
		size_t index_len, dummy;
		/*int index_len, dummy;*/

		
		memcpy_static(index, record->data.hostname, record->data.hostname_len, index_len);
		(index_len < sizeof(index)-1) ? index[index_len++] = ':' : 0;
		memcat_static(index, index_len, record->data.server_name, record->data.server_name_len, index_len);
		(index_len < sizeof(index)-1) ? index[index_len++] = '/' : 0;
		memcat_static(index, index_len, record->data.script_name, record->data.script_name_len, index_len);
		;

		ppvalue = JudySLGet(report->results, index, NULL);

		if (UNLIKELY(!ppvalue || ppvalue == PPJERR)) {
			/* no such value, mmm?? */
			return;
		} else {

			data = (struct pinba_report7_data *)*ppvalue;
			if (UNLIKELY(data->req_count == 1)) {
				free(data);
				JudySLDel(&report->results, index, NULL);
				report->std.results_cnt--;
			} else {
				data->req_count--;
				timersub(&data->req_time_total, &record->data.req_time, &data->req_time_total);
				timersub(&data->ru_utime_total, &record->data.ru_utime, &data->ru_utime_total);
				timersub(&data->ru_stime_total, &record->data.ru_stime, &data->ru_stime_total);
				data->kbytes_total -= record->data.doc_size;
				data->memory_footprint -= record->data.memory_footprint;
				PINBA_UPDATE_HISTOGRAM_DEL(report, data->histogram_data, record->data.req_time);
			}
		}
	}
#endif
}
/* }}} */

void pinba_update_report8_add(size_t request_id, pinba_report *report, const pinba_stats_record *record) /*pinba_update_report1_add(pinba_report *report, const pinba_stats_record *record)*/ /* {{{ */
{
	struct pinba_report8_data *data;
	/*struct pinba_report1_data *data;*/
	uint8_t index[PINBA_STATUS_SIZE] = {0};
	PPvoid_t ppvalue;

	timeradd(&report->time_total, &record->data.req_time, &report->time_total);
	timeradd(&report->ru_utime_total, &record->data.ru_utime, &report->ru_utime_total);
	timeradd(&report->ru_stime_total, &record->data.ru_stime, &report->ru_stime_total);
	report->kbytes_total += record->data.doc_size;
	report->memory_footprint += record->data.memory_footprint;

#if 0
	report->std.results_cnt++;
	PINBA_UPDATE_HISTOGRAM_ADD(report, report->std.histogram_data, record->data.req_time);
#else 
	{
		size_t index_len, dummy;
		/*int index_len, dummy;*/

		
		sprintf((char *)index, "%u", record->data.status);
		;

		ppvalue = JudySLGet(report->results, index, NULL);

		if (UNLIKELY(!ppvalue || ppvalue == PPJERR)) {
			/* no such value, insert */
			ppvalue = JudySLIns(&report->results, index, NULL);
			if (UNLIKELY(!ppvalue || ppvalue == PPJERR)) {
				return;
			}
			data = (struct pinba_report8_data *)calloc(1, sizeof(struct pinba_report8_data));

			
		data->status = record->data.status;
		;

			*ppvalue = data;
			report->std.results_cnt++;
		} else {
			data = (struct pinba_report8_data *)*ppvalue;
		}

		data->req_count++;
		timeradd(&data->req_time_total, &record->data.req_time, &data->req_time_total);
		timeradd(&data->ru_utime_total, &record->data.ru_utime, &data->ru_utime_total);
		timeradd(&data->ru_stime_total, &record->data.ru_stime, &data->ru_stime_total);
		data->kbytes_total += record->data.doc_size;
		data->memory_footprint += record->data.memory_footprint;
		PINBA_UPDATE_HISTOGRAM_ADD(report, data->histogram_data, record->data.req_time);
	}
#endif
}
/* }}} */

void pinba_update_report8_delete(size_t request_id, pinba_report *report, const pinba_stats_record *record) /* pinba_update_report1_delete(pinba_report *report, const pinba_stats_record *record)*/ /* {{{ */
{
	struct pinba_report8_data *data;
	uint8_t index[PINBA_STATUS_SIZE] = {0};
	PPvoid_t ppvalue;

	if (report->std.results_cnt == 0) {
		return;
	}

	PINBA_REPORT_DELETE_CHECK(report, record);

	timersub(&report->time_total, &record->data.req_time, &report->time_total);
	timersub(&report->ru_utime_total, &record->data.ru_utime, &report->ru_utime_total);
	timersub(&report->ru_stime_total, &record->data.ru_stime, &report->ru_stime_total);
	report->kbytes_total -= record->data.doc_size;
	report->memory_footprint -= record->data.memory_footprint;

#if 0
	report->std.results_cnt--;
	PINBA_UPDATE_HISTOGRAM_DEL(report, report->std.histogram_data, record->data.req_time);
#else 
	{
		size_t index_len, dummy;
		/*int index_len, dummy;*/

		
		sprintf((char *)index, "%u", record->data.status);
		;

		ppvalue = JudySLGet(report->results, index, NULL);

		if (UNLIKELY(!ppvalue || ppvalue == PPJERR)) {
			/* no such value, mmm?? */
			return;
		} else {

			data = (struct pinba_report8_data *)*ppvalue;
			if (UNLIKELY(data->req_count == 1)) {
				free(data);
				JudySLDel(&report->results, index, NULL);
				report->std.results_cnt--;
			} else {
				data->req_count--;
				timersub(&data->req_time_total, &record->data.req_time, &data->req_time_total);
				timersub(&data->ru_utime_total, &record->data.ru_utime, &data->ru_utime_total);
				timersub(&data->ru_stime_total, &record->data.ru_stime, &data->ru_stime_total);
				data->kbytes_total -= record->data.doc_size;
				data->memory_footprint -= record->data.memory_footprint;
				PINBA_UPDATE_HISTOGRAM_DEL(report, data->histogram_data, record->data.req_time);
			}
		}
	}
#endif
}
/* }}} */

void pinba_update_report9_add(size_t request_id, pinba_report *report, const pinba_stats_record *record) /*pinba_update_report1_add(pinba_report *report, const pinba_stats_record *record)*/ /* {{{ */
{
	struct pinba_report9_data *data;
	/*struct pinba_report1_data *data;*/
	uint8_t index[PINBA_STATUS_SIZE + 1 + PINBA_SCRIPT_NAME_SIZE] = {0};
	PPvoid_t ppvalue;

	timeradd(&report->time_total, &record->data.req_time, &report->time_total);
	timeradd(&report->ru_utime_total, &record->data.ru_utime, &report->ru_utime_total);
	timeradd(&report->ru_stime_total, &record->data.ru_stime, &report->ru_stime_total);
	report->kbytes_total += record->data.doc_size;
	report->memory_footprint += record->data.memory_footprint;

#if 0
	report->std.results_cnt++;
	PINBA_UPDATE_HISTOGRAM_ADD(report, report->std.histogram_data, record->data.req_time);
#else 
	{
		size_t index_len, dummy;
		/*int index_len, dummy;*/

		
        index_len = sprintf((char *)index, "%u:", record->data.status);
        memcat_static(index, index_len, record->data.script_name, record->data.script_name_len, index_len);
		;

		ppvalue = JudySLGet(report->results, index, NULL);

		if (UNLIKELY(!ppvalue || ppvalue == PPJERR)) {
			/* no such value, insert */
			ppvalue = JudySLIns(&report->results, index, NULL);
			if (UNLIKELY(!ppvalue || ppvalue == PPJERR)) {
				return;
			}
			data = (struct pinba_report9_data *)calloc(1, sizeof(struct pinba_report9_data));

			
		data->status = record->data.status;
		memcpy_static(data->script_name, record->data.script_name, record->data.script_name_len, dummy);
		;

			*ppvalue = data;
			report->std.results_cnt++;
		} else {
			data = (struct pinba_report9_data *)*ppvalue;
		}

		data->req_count++;
		timeradd(&data->req_time_total, &record->data.req_time, &data->req_time_total);
		timeradd(&data->ru_utime_total, &record->data.ru_utime, &data->ru_utime_total);
		timeradd(&data->ru_stime_total, &record->data.ru_stime, &data->ru_stime_total);
		data->kbytes_total += record->data.doc_size;
		data->memory_footprint += record->data.memory_footprint;
		PINBA_UPDATE_HISTOGRAM_ADD(report, data->histogram_data, record->data.req_time);
	}
#endif
}
/* }}} */

void pinba_update_report9_delete(size_t request_id, pinba_report *report, const pinba_stats_record *record) /* pinba_update_report1_delete(pinba_report *report, const pinba_stats_record *record)*/ /* {{{ */
{
	struct pinba_report9_data *data;
	uint8_t index[PINBA_STATUS_SIZE + 1 + PINBA_SCRIPT_NAME_SIZE] = {0};
	PPvoid_t ppvalue;

	if (report->std.results_cnt == 0) {
		return;
	}

	PINBA_REPORT_DELETE_CHECK(report, record);

	timersub(&report->time_total, &record->data.req_time, &report->time_total);
	timersub(&report->ru_utime_total, &record->data.ru_utime, &report->ru_utime_total);
	timersub(&report->ru_stime_total, &record->data.ru_stime, &report->ru_stime_total);
	report->kbytes_total -= record->data.doc_size;
	report->memory_footprint -= record->data.memory_footprint;

#if 0
	report->std.results_cnt--;
	PINBA_UPDATE_HISTOGRAM_DEL(report, report->std.histogram_data, record->data.req_time);
#else 
	{
		size_t index_len, dummy;
		/*int index_len, dummy;*/

		
        index_len = sprintf((char *)index, "%u:", record->data.status);
        memcat_static(index, index_len, record->data.script_name, record->data.script_name_len, index_len);
		;

		ppvalue = JudySLGet(report->results, index, NULL);

		if (UNLIKELY(!ppvalue || ppvalue == PPJERR)) {
			/* no such value, mmm?? */
			return;
		} else {

			data = (struct pinba_report9_data *)*ppvalue;
			if (UNLIKELY(data->req_count == 1)) {
				free(data);
				JudySLDel(&report->results, index, NULL);
				report->std.results_cnt--;
			} else {
				data->req_count--;
				timersub(&data->req_time_total, &record->data.req_time, &data->req_time_total);
				timersub(&data->ru_utime_total, &record->data.ru_utime, &data->ru_utime_total);
				timersub(&data->ru_stime_total, &record->data.ru_stime, &data->ru_stime_total);
				data->kbytes_total -= record->data.doc_size;
				data->memory_footprint -= record->data.memory_footprint;
				PINBA_UPDATE_HISTOGRAM_DEL(report, data->histogram_data, record->data.req_time);
			}
		}
	}
#endif
}
/* }}} */

void pinba_update_report10_add(size_t request_id, pinba_report *report, const pinba_stats_record *record) /*pinba_update_report1_add(pinba_report *report, const pinba_stats_record *record)*/ /* {{{ */
{
	struct pinba_report10_data *data;
	/*struct pinba_report1_data *data;*/
	uint8_t index[PINBA_STATUS_SIZE + 1 + PINBA_SERVER_NAME_SIZE] = {0};
	PPvoid_t ppvalue;

	timeradd(&report->time_total, &record->data.req_time, &report->time_total);
	timeradd(&report->ru_utime_total, &record->data.ru_utime, &report->ru_utime_total);
	timeradd(&report->ru_stime_total, &record->data.ru_stime, &report->ru_stime_total);
	report->kbytes_total += record->data.doc_size;
	report->memory_footprint += record->data.memory_footprint;

#if 0
	report->std.results_cnt++;
	PINBA_UPDATE_HISTOGRAM_ADD(report, report->std.histogram_data, record->data.req_time);
#else 
	{
		size_t index_len, dummy;
		/*int index_len, dummy;*/

		
		index_len = sprintf((char *)index, "%u", record->data.status);
		memcat_static(index, index_len, record->data.server_name, record->data.server_name_len, index_len);
		;

		ppvalue = JudySLGet(report->results, index, NULL);

		if (UNLIKELY(!ppvalue || ppvalue == PPJERR)) {
			/* no such value, insert */
			ppvalue = JudySLIns(&report->results, index, NULL);
			if (UNLIKELY(!ppvalue || ppvalue == PPJERR)) {
				return;
			}
			data = (struct pinba_report10_data *)calloc(1, sizeof(struct pinba_report10_data));

			
		data->status = record->data.status;
		memcpy_static(data->server_name, record->data.server_name, record->data.server_name_len, dummy);
		;

			*ppvalue = data;
			report->std.results_cnt++;
		} else {
			data = (struct pinba_report10_data *)*ppvalue;
		}

		data->req_count++;
		timeradd(&data->req_time_total, &record->data.req_time, &data->req_time_total);
		timeradd(&data->ru_utime_total, &record->data.ru_utime, &data->ru_utime_total);
		timeradd(&data->ru_stime_total, &record->data.ru_stime, &data->ru_stime_total);
		data->kbytes_total += record->data.doc_size;
		data->memory_footprint += record->data.memory_footprint;
		PINBA_UPDATE_HISTOGRAM_ADD(report, data->histogram_data, record->data.req_time);
	}
#endif
}
/* }}} */

void pinba_update_report10_delete(size_t request_id, pinba_report *report, const pinba_stats_record *record) /* pinba_update_report1_delete(pinba_report *report, const pinba_stats_record *record)*/ /* {{{ */
{
	struct pinba_report10_data *data;
	uint8_t index[PINBA_STATUS_SIZE + 1 + PINBA_SERVER_NAME_SIZE] = {0};
	PPvoid_t ppvalue;

	if (report->std.results_cnt == 0) {
		return;
	}

	PINBA_REPORT_DELETE_CHECK(report, record);

	timersub(&report->time_total, &record->data.req_time, &report->time_total);
	timersub(&report->ru_utime_total, &record->data.ru_utime, &report->ru_utime_total);
	timersub(&report->ru_stime_total, &record->data.ru_stime, &report->ru_stime_total);
	report->kbytes_total -= record->data.doc_size;
	report->memory_footprint -= record->data.memory_footprint;

#if 0
	report->std.results_cnt--;
	PINBA_UPDATE_HISTOGRAM_DEL(report, report->std.histogram_data, record->data.req_time);
#else 
	{
		size_t index_len, dummy;
		/*int index_len, dummy;*/

		
		index_len = sprintf((char *)index, "%u", record->data.status);
		memcat_static(index, index_len, record->data.server_name, record->data.server_name_len, index_len);
		;

		ppvalue = JudySLGet(report->results, index, NULL);

		if (UNLIKELY(!ppvalue || ppvalue == PPJERR)) {
			/* no such value, mmm?? */
			return;
		} else {

			data = (struct pinba_report10_data *)*ppvalue;
			if (UNLIKELY(data->req_count == 1)) {
				free(data);
				JudySLDel(&report->results, index, NULL);
				report->std.results_cnt--;
			} else {
				data->req_count--;
				timersub(&data->req_time_total, &record->data.req_time, &data->req_time_total);
				timersub(&data->ru_utime_total, &record->data.ru_utime, &data->ru_utime_total);
				timersub(&data->ru_stime_total, &record->data.ru_stime, &data->ru_stime_total);
				data->kbytes_total -= record->data.doc_size;
				data->memory_footprint -= record->data.memory_footprint;
				PINBA_UPDATE_HISTOGRAM_DEL(report, data->histogram_data, record->data.req_time);
			}
		}
	}
#endif
}
/* }}} */

void pinba_update_report11_add(size_t request_id, pinba_report *report, const pinba_stats_record *record) /*pinba_update_report1_add(pinba_report *report, const pinba_stats_record *record)*/ /* {{{ */
{
	struct pinba_report11_data *data;
	/*struct pinba_report1_data *data;*/
	uint8_t index[PINBA_HOSTNAME_SIZE + 1 + PINBA_STATUS_SIZE] = {0};
	PPvoid_t ppvalue;

	timeradd(&report->time_total, &record->data.req_time, &report->time_total);
	timeradd(&report->ru_utime_total, &record->data.ru_utime, &report->ru_utime_total);
	timeradd(&report->ru_stime_total, &record->data.ru_stime, &report->ru_stime_total);
	report->kbytes_total += record->data.doc_size;
	report->memory_footprint += record->data.memory_footprint;

#if 0
	report->std.results_cnt++;
	PINBA_UPDATE_HISTOGRAM_ADD(report, report->std.histogram_data, record->data.req_time);
#else 
	{
		size_t index_len, dummy;
		/*int index_len, dummy;*/

		
		index_len = sprintf((char *)index, "%u", record->data.status);
		memcat_static(index, index_len, record->data.hostname, record->data.hostname_len, index_len);
		;

		ppvalue = JudySLGet(report->results, index, NULL);

		if (UNLIKELY(!ppvalue || ppvalue == PPJERR)) {
			/* no such value, insert */
			ppvalue = JudySLIns(&report->results, index, NULL);
			if (UNLIKELY(!ppvalue || ppvalue == PPJERR)) {
				return;
			}
			data = (struct pinba_report11_data *)calloc(1, sizeof(struct pinba_report11_data));

			
		data->status = record->data.status;
		memcpy_static(data->hostname, record->data.hostname, record->data.hostname_len, dummy);
		;

			*ppvalue = data;
			report->std.results_cnt++;
		} else {
			data = (struct pinba_report11_data *)*ppvalue;
		}

		data->req_count++;
		timeradd(&data->req_time_total, &record->data.req_time, &data->req_time_total);
		timeradd(&data->ru_utime_total, &record->data.ru_utime, &data->ru_utime_total);
		timeradd(&data->ru_stime_total, &record->data.ru_stime, &data->ru_stime_total);
		data->kbytes_total += record->data.doc_size;
		data->memory_footprint += record->data.memory_footprint;
		PINBA_UPDATE_HISTOGRAM_ADD(report, data->histogram_data, record->data.req_time);
	}
#endif
}
/* }}} */

void pinba_update_report11_delete(size_t request_id, pinba_report *report, const pinba_stats_record *record) /* pinba_update_report1_delete(pinba_report *report, const pinba_stats_record *record)*/ /* {{{ */
{
	struct pinba_report11_data *data;
	uint8_t index[PINBA_HOSTNAME_SIZE + 1 + PINBA_STATUS_SIZE] = {0};
	PPvoid_t ppvalue;

	if (report->std.results_cnt == 0) {
		return;
	}

	PINBA_REPORT_DELETE_CHECK(report, record);

	timersub(&report->time_total, &record->data.req_time, &report->time_total);
	timersub(&report->ru_utime_total, &record->data.ru_utime, &report->ru_utime_total);
	timersub(&report->ru_stime_total, &record->data.ru_stime, &report->ru_stime_total);
	report->kbytes_total -= record->data.doc_size;
	report->memory_footprint -= record->data.memory_footprint;

#if 0
	report->std.results_cnt--;
	PINBA_UPDATE_HISTOGRAM_DEL(report, report->std.histogram_data, record->data.req_time);
#else 
	{
		size_t index_len, dummy;
		/*int index_len, dummy;*/

		
		index_len = sprintf((char *)index, "%u", record->data.status);
		memcat_static(index, index_len, record->data.hostname, record->data.hostname_len, index_len);
		;

		ppvalue = JudySLGet(report->results, index, NULL);

		if (UNLIKELY(!ppvalue || ppvalue == PPJERR)) {
			/* no such value, mmm?? */
			return;
		} else {

			data = (struct pinba_report11_data *)*ppvalue;
			if (UNLIKELY(data->req_count == 1)) {
				free(data);
				JudySLDel(&report->results, index, NULL);
				report->std.results_cnt--;
			} else {
				data->req_count--;
				timersub(&data->req_time_total, &record->data.req_time, &data->req_time_total);
				timersub(&data->ru_utime_total, &record->data.ru_utime, &data->ru_utime_total);
				timersub(&data->ru_stime_total, &record->data.ru_stime, &data->ru_stime_total);
				data->kbytes_total -= record->data.doc_size;
				data->memory_footprint -= record->data.memory_footprint;
				PINBA_UPDATE_HISTOGRAM_DEL(report, data->histogram_data, record->data.req_time);
			}
		}
	}
#endif
}
/* }}} */

void pinba_update_report12_add(size_t request_id, pinba_report *report, const pinba_stats_record *record) /*pinba_update_report1_add(pinba_report *report, const pinba_stats_record *record)*/ /* {{{ */
{
	struct pinba_report12_data *data;
	/*struct pinba_report1_data *data;*/
	uint8_t index[PINBA_STATUS_SIZE + 1 + PINBA_HOSTNAME_SIZE + 1 + PINBA_SCRIPT_NAME_SIZE] = {0};
	PPvoid_t ppvalue;

	timeradd(&report->time_total, &record->data.req_time, &report->time_total);
	timeradd(&report->ru_utime_total, &record->data.ru_utime, &report->ru_utime_total);
	timeradd(&report->ru_stime_total, &record->data.ru_stime, &report->ru_stime_total);
	report->kbytes_total += record->data.doc_size;
	report->memory_footprint += record->data.memory_footprint;

#if 0
	report->std.results_cnt++;
	PINBA_UPDATE_HISTOGRAM_ADD(report, report->std.histogram_data, record->data.req_time);
#else 
	{
		size_t index_len, dummy;
		/*int index_len, dummy;*/

				index_len = sprintf((char *)index, "%u", record->data.status);
		memcat_static(index, index_len, record->data.hostname, record->data.hostname_len, index_len);
		(index_len < sizeof(index)-1) ? index[index_len++] = '/' : 0;
		memcat_static(index, index_len, record->data.script_name, record->data.script_name_len, index_len);;

		ppvalue = JudySLGet(report->results, index, NULL);

		if (UNLIKELY(!ppvalue || ppvalue == PPJERR)) {
			/* no such value, insert */
			ppvalue = JudySLIns(&report->results, index, NULL);
			if (UNLIKELY(!ppvalue || ppvalue == PPJERR)) {
				return;
			}
			data = (struct pinba_report12_data *)calloc(1, sizeof(struct pinba_report12_data));

			
		data->status = record->data.status;
		memcpy_static(data->hostname, record->data.hostname, record->data.hostname_len, dummy);
		memcpy_static(data->script_name, record->data.script_name, record->data.script_name_len, dummy);
		;

			*ppvalue = data;
			report->std.results_cnt++;
		} else {
			data = (struct pinba_report12_data *)*ppvalue;
		}

		data->req_count++;
		timeradd(&data->req_time_total, &record->data.req_time, &data->req_time_total);
		timeradd(&data->ru_utime_total, &record->data.ru_utime, &data->ru_utime_total);
		timeradd(&data->ru_stime_total, &record->data.ru_stime, &data->ru_stime_total);
		data->kbytes_total += record->data.doc_size;
		data->memory_footprint += record->data.memory_footprint;
		PINBA_UPDATE_HISTOGRAM_ADD(report, data->histogram_data, record->data.req_time);
	}
#endif
}
/* }}} */

void pinba_update_report12_delete(size_t request_id, pinba_report *report, const pinba_stats_record *record) /* pinba_update_report1_delete(pinba_report *report, const pinba_stats_record *record)*/ /* {{{ */
{
	struct pinba_report12_data *data;
	uint8_t index[PINBA_STATUS_SIZE + 1 + PINBA_HOSTNAME_SIZE + 1 + PINBA_SCRIPT_NAME_SIZE] = {0};
	PPvoid_t ppvalue;

	if (report->std.results_cnt == 0) {
		return;
	}

	PINBA_REPORT_DELETE_CHECK(report, record);

	timersub(&report->time_total, &record->data.req_time, &report->time_total);
	timersub(&report->ru_utime_total, &record->data.ru_utime, &report->ru_utime_total);
	timersub(&report->ru_stime_total, &record->data.ru_stime, &report->ru_stime_total);
	report->kbytes_total -= record->data.doc_size;
	report->memory_footprint -= record->data.memory_footprint;

#if 0
	report->std.results_cnt--;
	PINBA_UPDATE_HISTOGRAM_DEL(report, report->std.histogram_data, record->data.req_time);
#else 
	{
		size_t index_len, dummy;
		/*int index_len, dummy;*/

				index_len = sprintf((char *)index, "%u", record->data.status);
		memcat_static(index, index_len, record->data.hostname, record->data.hostname_len, index_len);
		(index_len < sizeof(index)-1) ? index[index_len++] = '/' : 0;
		memcat_static(index, index_len, record->data.script_name, record->data.script_name_len, index_len);;

		ppvalue = JudySLGet(report->results, index, NULL);

		if (UNLIKELY(!ppvalue || ppvalue == PPJERR)) {
			/* no such value, mmm?? */
			return;
		} else {

			data = (struct pinba_report12_data *)*ppvalue;
			if (UNLIKELY(data->req_count == 1)) {
				free(data);
				JudySLDel(&report->results, index, NULL);
				report->std.results_cnt--;
			} else {
				data->req_count--;
				timersub(&data->req_time_total, &record->data.req_time, &data->req_time_total);
				timersub(&data->ru_utime_total, &record->data.ru_utime, &data->ru_utime_total);
				timersub(&data->ru_stime_total, &record->data.ru_stime, &data->ru_stime_total);
				data->kbytes_total -= record->data.doc_size;
				data->memory_footprint -= record->data.memory_footprint;
				PINBA_UPDATE_HISTOGRAM_DEL(report, data->histogram_data, record->data.req_time);
			}
		}
	}
#endif
}
/* }}} */

void pinba_update_report13_add(size_t request_id, pinba_report *report, const pinba_stats_record *record) /*pinba_update_report1_add(pinba_report *report, const pinba_stats_record *record)*/ /* {{{ */
{
	struct pinba_report13_data *data;
	/*struct pinba_report1_data *data;*/
	const uint8_t *index;
	PPvoid_t ppvalue;

	timeradd(&report->time_total, &record->data.req_time, &report->time_total);
	timeradd(&report->ru_utime_total, &record->data.ru_utime, &report->ru_utime_total);
	timeradd(&report->ru_stime_total, &record->data.ru_stime, &report->ru_stime_total);
	report->kbytes_total += record->data.doc_size;
	report->memory_footprint += record->data.memory_footprint;

#if 0
	report->std.results_cnt++;
	PINBA_UPDATE_HISTOGRAM_ADD(report, report->std.histogram_data, record->data.req_time);
#else 
	{
		size_t index_len, dummy;
		/*int index_len, dummy;*/

		index = (const uint8_t *)record->data.schema;

		ppvalue = JudySLGet(report->results, index, NULL);

		if (UNLIKELY(!ppvalue || ppvalue == PPJERR)) {
			/* no such value, insert */
			ppvalue = JudySLIns(&report->results, index, NULL);
			if (UNLIKELY(!ppvalue || ppvalue == PPJERR)) {
				return;
			}
			data = (struct pinba_report13_data *)calloc(1, sizeof(struct pinba_report13_data));

			;

			*ppvalue = data;
			report->std.results_cnt++;
		} else {
			data = (struct pinba_report13_data *)*ppvalue;
		}

		data->req_count++;
		timeradd(&data->req_time_total, &record->data.req_time, &data->req_time_total);
		timeradd(&data->ru_utime_total, &record->data.ru_utime, &data->ru_utime_total);
		timeradd(&data->ru_stime_total, &record->data.ru_stime, &data->ru_stime_total);
		data->kbytes_total += record->data.doc_size;
		data->memory_footprint += record->data.memory_footprint;
		PINBA_UPDATE_HISTOGRAM_ADD(report, data->histogram_data, record->data.req_time);
	}
#endif
}
/* }}} */

void pinba_update_report13_delete(size_t request_id, pinba_report *report, const pinba_stats_record *record) /* pinba_update_report1_delete(pinba_report *report, const pinba_stats_record *record)*/ /* {{{ */
{
	struct pinba_report13_data *data;
	const uint8_t *index;
	PPvoid_t ppvalue;

	if (report->std.results_cnt == 0) {
		return;
	}

	PINBA_REPORT_DELETE_CHECK(report, record);

	timersub(&report->time_total, &record->data.req_time, &report->time_total);
	timersub(&report->ru_utime_total, &record->data.ru_utime, &report->ru_utime_total);
	timersub(&report->ru_stime_total, &record->data.ru_stime, &report->ru_stime_total);
	report->kbytes_total -= record->data.doc_size;
	report->memory_footprint -= record->data.memory_footprint;

#if 0
	report->std.results_cnt--;
	PINBA_UPDATE_HISTOGRAM_DEL(report, report->std.histogram_data, record->data.req_time);
#else 
	{
		size_t index_len, dummy;
		/*int index_len, dummy;*/

		index = (const uint8_t *)record->data.schema;

		ppvalue = JudySLGet(report->results, index, NULL);

		if (UNLIKELY(!ppvalue || ppvalue == PPJERR)) {
			/* no such value, mmm?? */
			return;
		} else {

			data = (struct pinba_report13_data *)*ppvalue;
			if (UNLIKELY(data->req_count == 1)) {
				free(data);
				JudySLDel(&report->results, index, NULL);
				report->std.results_cnt--;
			} else {
				data->req_count--;
				timersub(&data->req_time_total, &record->data.req_time, &data->req_time_total);
				timersub(&data->ru_utime_total, &record->data.ru_utime, &data->ru_utime_total);
				timersub(&data->ru_stime_total, &record->data.ru_stime, &data->ru_stime_total);
				data->kbytes_total -= record->data.doc_size;
				data->memory_footprint -= record->data.memory_footprint;
				PINBA_UPDATE_HISTOGRAM_DEL(report, data->histogram_data, record->data.req_time);
			}
		}
	}
#endif
}
/* }}} */

void pinba_update_report14_add(size_t request_id, pinba_report *report, const pinba_stats_record *record) /*pinba_update_report1_add(pinba_report *report, const pinba_stats_record *record)*/ /* {{{ */
{
	struct pinba_report14_data *data;
	/*struct pinba_report1_data *data;*/
	uint8_t index[PINBA_SCHEMA_SIZE + PINBA_SCRIPT_NAME_SIZE + 1] = {0};
	PPvoid_t ppvalue;

	timeradd(&report->time_total, &record->data.req_time, &report->time_total);
	timeradd(&report->ru_utime_total, &record->data.ru_utime, &report->ru_utime_total);
	timeradd(&report->ru_stime_total, &record->data.ru_stime, &report->ru_stime_total);
	report->kbytes_total += record->data.doc_size;
	report->memory_footprint += record->data.memory_footprint;

#if 0
	report->std.results_cnt++;
	PINBA_UPDATE_HISTOGRAM_ADD(report, report->std.histogram_data, record->data.req_time);
#else 
	{
		size_t index_len, dummy;
		/*int index_len, dummy;*/

		
		memcpy_static(index, record->data.schema, record->data.schema_len, index_len);
		(index_len < sizeof(index)-1) ? index[index_len++] = ':' : 0;
		memcat_static(index, index_len, record->data.script_name, record->data.script_name_len, index_len);
		;

		ppvalue = JudySLGet(report->results, index, NULL);

		if (UNLIKELY(!ppvalue || ppvalue == PPJERR)) {
			/* no such value, insert */
			ppvalue = JudySLIns(&report->results, index, NULL);
			if (UNLIKELY(!ppvalue || ppvalue == PPJERR)) {
				return;
			}
			data = (struct pinba_report14_data *)calloc(1, sizeof(struct pinba_report14_data));

			
		memcpy_static(data->schema, record->data.schema, record->data.schema_len, dummy);
		memcpy_static(data->script_name, record->data.script_name, record->data.script_name_len, dummy);
		;

			*ppvalue = data;
			report->std.results_cnt++;
		} else {
			data = (struct pinba_report14_data *)*ppvalue;
		}

		data->req_count++;
		timeradd(&data->req_time_total, &record->data.req_time, &data->req_time_total);
		timeradd(&data->ru_utime_total, &record->data.ru_utime, &data->ru_utime_total);
		timeradd(&data->ru_stime_total, &record->data.ru_stime, &data->ru_stime_total);
		data->kbytes_total += record->data.doc_size;
		data->memory_footprint += record->data.memory_footprint;
		PINBA_UPDATE_HISTOGRAM_ADD(report, data->histogram_data, record->data.req_time);
	}
#endif
}
/* }}} */

void pinba_update_report14_delete(size_t request_id, pinba_report *report, const pinba_stats_record *record) /* pinba_update_report1_delete(pinba_report *report, const pinba_stats_record *record)*/ /* {{{ */
{
	struct pinba_report14_data *data;
	uint8_t index[PINBA_SCHEMA_SIZE + PINBA_SCRIPT_NAME_SIZE + 1] = {0};
	PPvoid_t ppvalue;

	if (report->std.results_cnt == 0) {
		return;
	}

	PINBA_REPORT_DELETE_CHECK(report, record);

	timersub(&report->time_total, &record->data.req_time, &report->time_total);
	timersub(&report->ru_utime_total, &record->data.ru_utime, &report->ru_utime_total);
	timersub(&report->ru_stime_total, &record->data.ru_stime, &report->ru_stime_total);
	report->kbytes_total -= record->data.doc_size;
	report->memory_footprint -= record->data.memory_footprint;

#if 0
	report->std.results_cnt--;
	PINBA_UPDATE_HISTOGRAM_DEL(report, report->std.histogram_data, record->data.req_time);
#else 
	{
		size_t index_len, dummy;
		/*int index_len, dummy;*/

		
		memcpy_static(index, record->data.schema, record->data.schema_len, index_len);
		(index_len < sizeof(index)-1) ? index[index_len++] = ':' : 0;
		memcat_static(index, index_len, record->data.script_name, record->data.script_name_len, index_len);
		;

		ppvalue = JudySLGet(report->results, index, NULL);

		if (UNLIKELY(!ppvalue || ppvalue == PPJERR)) {
			/* no such value, mmm?? */
			return;
		} else {

			data = (struct pinba_report14_data *)*ppvalue;
			if (UNLIKELY(data->req_count == 1)) {
				free(data);
				JudySLDel(&report->results, index, NULL);
				report->std.results_cnt--;
			} else {
				data->req_count--;
				timersub(&data->req_time_total, &record->data.req_time, &data->req_time_total);
				timersub(&data->ru_utime_total, &record->data.ru_utime, &data->ru_utime_total);
				timersub(&data->ru_stime_total, &record->data.ru_stime, &data->ru_stime_total);
				data->kbytes_total -= record->data.doc_size;
				data->memory_footprint -= record->data.memory_footprint;
				PINBA_UPDATE_HISTOGRAM_DEL(report, data->histogram_data, record->data.req_time);
			}
		}
	}
#endif
}
/* }}} */

void pinba_update_report15_add(size_t request_id, pinba_report *report, const pinba_stats_record *record) /*pinba_update_report1_add(pinba_report *report, const pinba_stats_record *record)*/ /* {{{ */
{
	struct pinba_report15_data *data;
	/*struct pinba_report1_data *data;*/
	uint8_t index[PINBA_SCHEMA_SIZE + PINBA_SERVER_NAME_SIZE + 1] = {0};
	PPvoid_t ppvalue;

	timeradd(&report->time_total, &record->data.req_time, &report->time_total);
	timeradd(&report->ru_utime_total, &record->data.ru_utime, &report->ru_utime_total);
	timeradd(&report->ru_stime_total, &record->data.ru_stime, &report->ru_stime_total);
	report->kbytes_total += record->data.doc_size;
	report->memory_footprint += record->data.memory_footprint;

#if 0
	report->std.results_cnt++;
	PINBA_UPDATE_HISTOGRAM_ADD(report, report->std.histogram_data, record->data.req_time);
#else 
	{
		size_t index_len, dummy;
		/*int index_len, dummy;*/

		
		memcpy_static(index, record->data.schema, record->data.schema_len, index_len);
		(index_len < sizeof(index)-1) ? index[index_len++] = ':' : 0;
		memcat_static(index, index_len, record->data.server_name, record->data.server_name_len, index_len);
		;

		ppvalue = JudySLGet(report->results, index, NULL);

		if (UNLIKELY(!ppvalue || ppvalue == PPJERR)) {
			/* no such value, insert */
			ppvalue = JudySLIns(&report->results, index, NULL);
			if (UNLIKELY(!ppvalue || ppvalue == PPJERR)) {
				return;
			}
			data = (struct pinba_report15_data *)calloc(1, sizeof(struct pinba_report15_data));

			
		memcpy_static(data->schema, record->data.schema, record->data.schema_len, dummy);
		memcpy_static(data->server_name, record->data.server_name, record->data.server_name_len, dummy);
		;

			*ppvalue = data;
			report->std.results_cnt++;
		} else {
			data = (struct pinba_report15_data *)*ppvalue;
		}

		data->req_count++;
		timeradd(&data->req_time_total, &record->data.req_time, &data->req_time_total);
		timeradd(&data->ru_utime_total, &record->data.ru_utime, &data->ru_utime_total);
		timeradd(&data->ru_stime_total, &record->data.ru_stime, &data->ru_stime_total);
		data->kbytes_total += record->data.doc_size;
		data->memory_footprint += record->data.memory_footprint;
		PINBA_UPDATE_HISTOGRAM_ADD(report, data->histogram_data, record->data.req_time);
	}
#endif
}
/* }}} */

void pinba_update_report15_delete(size_t request_id, pinba_report *report, const pinba_stats_record *record) /* pinba_update_report1_delete(pinba_report *report, const pinba_stats_record *record)*/ /* {{{ */
{
	struct pinba_report15_data *data;
	uint8_t index[PINBA_SCHEMA_SIZE + PINBA_SERVER_NAME_SIZE + 1] = {0};
	PPvoid_t ppvalue;

	if (report->std.results_cnt == 0) {
		return;
	}

	PINBA_REPORT_DELETE_CHECK(report, record);

	timersub(&report->time_total, &record->data.req_time, &report->time_total);
	timersub(&report->ru_utime_total, &record->data.ru_utime, &report->ru_utime_total);
	timersub(&report->ru_stime_total, &record->data.ru_stime, &report->ru_stime_total);
	report->kbytes_total -= record->data.doc_size;
	report->memory_footprint -= record->data.memory_footprint;

#if 0
	report->std.results_cnt--;
	PINBA_UPDATE_HISTOGRAM_DEL(report, report->std.histogram_data, record->data.req_time);
#else 
	{
		size_t index_len, dummy;
		/*int index_len, dummy;*/

		
		memcpy_static(index, record->data.schema, record->data.schema_len, index_len);
		(index_len < sizeof(index)-1) ? index[index_len++] = ':' : 0;
		memcat_static(index, index_len, record->data.server_name, record->data.server_name_len, index_len);
		;

		ppvalue = JudySLGet(report->results, index, NULL);

		if (UNLIKELY(!ppvalue || ppvalue == PPJERR)) {
			/* no such value, mmm?? */
			return;
		} else {

			data = (struct pinba_report15_data *)*ppvalue;
			if (UNLIKELY(data->req_count == 1)) {
				free(data);
				JudySLDel(&report->results, index, NULL);
				report->std.results_cnt--;
			} else {
				data->req_count--;
				timersub(&data->req_time_total, &record->data.req_time, &data->req_time_total);
				timersub(&data->ru_utime_total, &record->data.ru_utime, &data->ru_utime_total);
				timersub(&data->ru_stime_total, &record->data.ru_stime, &data->ru_stime_total);
				data->kbytes_total -= record->data.doc_size;
				data->memory_footprint -= record->data.memory_footprint;
				PINBA_UPDATE_HISTOGRAM_DEL(report, data->histogram_data, record->data.req_time);
			}
		}
	}
#endif
}
/* }}} */

void pinba_update_report16_add(size_t request_id, pinba_report *report, const pinba_stats_record *record) /*pinba_update_report1_add(pinba_report *report, const pinba_stats_record *record)*/ /* {{{ */
{
	struct pinba_report16_data *data;
	/*struct pinba_report1_data *data;*/
	uint8_t index[PINBA_SCHEMA_SIZE + PINBA_HOSTNAME_SIZE + 1] = {0};
	PPvoid_t ppvalue;

	timeradd(&report->time_total, &record->data.req_time, &report->time_total);
	timeradd(&report->ru_utime_total, &record->data.ru_utime, &report->ru_utime_total);
	timeradd(&report->ru_stime_total, &record->data.ru_stime, &report->ru_stime_total);
	report->kbytes_total += record->data.doc_size;
	report->memory_footprint += record->data.memory_footprint;

#if 0
	report->std.results_cnt++;
	PINBA_UPDATE_HISTOGRAM_ADD(report, report->std.histogram_data, record->data.req_time);
#else 
	{
		size_t index_len, dummy;
		/*int index_len, dummy;*/

		
		memcpy_static(index, record->data.schema, record->data.schema_len, index_len);
		(index_len < sizeof(index)-1) ? index[index_len++] = ':' : 0;
		memcat_static(index, index_len, record->data.hostname, record->data.hostname_len, index_len);
		;

		ppvalue = JudySLGet(report->results, index, NULL);

		if (UNLIKELY(!ppvalue || ppvalue == PPJERR)) {
			/* no such value, insert */
			ppvalue = JudySLIns(&report->results, index, NULL);
			if (UNLIKELY(!ppvalue || ppvalue == PPJERR)) {
				return;
			}
			data = (struct pinba_report16_data *)calloc(1, sizeof(struct pinba_report16_data));

			
		memcpy_static(data->schema, record->data.schema, record->data.schema_len, dummy);
		memcpy_static(data->hostname, record->data.hostname, record->data.hostname_len, dummy);
		;

			*ppvalue = data;
			report->std.results_cnt++;
		} else {
			data = (struct pinba_report16_data *)*ppvalue;
		}

		data->req_count++;
		timeradd(&data->req_time_total, &record->data.req_time, &data->req_time_total);
		timeradd(&data->ru_utime_total, &record->data.ru_utime, &data->ru_utime_total);
		timeradd(&data->ru_stime_total, &record->data.ru_stime, &data->ru_stime_total);
		data->kbytes_total += record->data.doc_size;
		data->memory_footprint += record->data.memory_footprint;
		PINBA_UPDATE_HISTOGRAM_ADD(report, data->histogram_data, record->data.req_time);
	}
#endif
}
/* }}} */

void pinba_update_report16_delete(size_t request_id, pinba_report *report, const pinba_stats_record *record) /* pinba_update_report1_delete(pinba_report *report, const pinba_stats_record *record)*/ /* {{{ */
{
	struct pinba_report16_data *data;
	uint8_t index[PINBA_SCHEMA_SIZE + PINBA_HOSTNAME_SIZE + 1] = {0};
	PPvoid_t ppvalue;

	if (report->std.results_cnt == 0) {
		return;
	}

	PINBA_REPORT_DELETE_CHECK(report, record);

	timersub(&report->time_total, &record->data.req_time, &report->time_total);
	timersub(&report->ru_utime_total, &record->data.ru_utime, &report->ru_utime_total);
	timersub(&report->ru_stime_total, &record->data.ru_stime, &report->ru_stime_total);
	report->kbytes_total -= record->data.doc_size;
	report->memory_footprint -= record->data.memory_footprint;

#if 0
	report->std.results_cnt--;
	PINBA_UPDATE_HISTOGRAM_DEL(report, report->std.histogram_data, record->data.req_time);
#else 
	{
		size_t index_len, dummy;
		/*int index_len, dummy;*/

		
		memcpy_static(index, record->data.schema, record->data.schema_len, index_len);
		(index_len < sizeof(index)-1) ? index[index_len++] = ':' : 0;
		memcat_static(index, index_len, record->data.hostname, record->data.hostname_len, index_len);
		;

		ppvalue = JudySLGet(report->results, index, NULL);

		if (UNLIKELY(!ppvalue || ppvalue == PPJERR)) {
			/* no such value, mmm?? */
			return;
		} else {

			data = (struct pinba_report16_data *)*ppvalue;
			if (UNLIKELY(data->req_count == 1)) {
				free(data);
				JudySLDel(&report->results, index, NULL);
				report->std.results_cnt--;
			} else {
				data->req_count--;
				timersub(&data->req_time_total, &record->data.req_time, &data->req_time_total);
				timersub(&data->ru_utime_total, &record->data.ru_utime, &data->ru_utime_total);
				timersub(&data->ru_stime_total, &record->data.ru_stime, &data->ru_stime_total);
				data->kbytes_total -= record->data.doc_size;
				data->memory_footprint -= record->data.memory_footprint;
				PINBA_UPDATE_HISTOGRAM_DEL(report, data->histogram_data, record->data.req_time);
			}
		}
	}
#endif
}
/* }}} */

void pinba_update_report17_add(size_t request_id, pinba_report *report, const pinba_stats_record *record) /*pinba_update_report1_add(pinba_report *report, const pinba_stats_record *record)*/ /* {{{ */
{
	struct pinba_report17_data *data;
	/*struct pinba_report1_data *data;*/
	uint8_t index[PINBA_SCHEMA_SIZE + 1 + PINBA_HOSTNAME_SIZE + 1 + PINBA_SCRIPT_NAME_SIZE] = {0};
	PPvoid_t ppvalue;

	timeradd(&report->time_total, &record->data.req_time, &report->time_total);
	timeradd(&report->ru_utime_total, &record->data.ru_utime, &report->ru_utime_total);
	timeradd(&report->ru_stime_total, &record->data.ru_stime, &report->ru_stime_total);
	report->kbytes_total += record->data.doc_size;
	report->memory_footprint += record->data.memory_footprint;

#if 0
	report->std.results_cnt++;
	PINBA_UPDATE_HISTOGRAM_ADD(report, report->std.histogram_data, record->data.req_time);
#else 
	{
		size_t index_len, dummy;
		/*int index_len, dummy;*/

		
		memcpy_static(index, record->data.schema, record->data.schema_len, index_len);
		(index_len < sizeof(index)-1) ? index[index_len++] = '/' : 0;
		memcat_static(index, index_len, record->data.hostname, record->data.hostname_len, index_len);
		(index_len < sizeof(index)-1) ? index[index_len++] = '/' : 0;
		memcat_static(index, index_len, record->data.script_name, record->data.script_name_len, index_len);
		;

		ppvalue = JudySLGet(report->results, index, NULL);

		if (UNLIKELY(!ppvalue || ppvalue == PPJERR)) {
			/* no such value, insert */
			ppvalue = JudySLIns(&report->results, index, NULL);
			if (UNLIKELY(!ppvalue || ppvalue == PPJERR)) {
				return;
			}
			data = (struct pinba_report17_data *)calloc(1, sizeof(struct pinba_report17_data));

			
		memcpy_static(data->schema, record->data.schema, record->data.schema_len, dummy);
		memcpy_static(data->hostname, record->data.hostname, record->data.hostname_len, dummy);
		memcpy_static(data->script_name, record->data.script_name, record->data.script_name_len, dummy);
		;

			*ppvalue = data;
			report->std.results_cnt++;
		} else {
			data = (struct pinba_report17_data *)*ppvalue;
		}

		data->req_count++;
		timeradd(&data->req_time_total, &record->data.req_time, &data->req_time_total);
		timeradd(&data->ru_utime_total, &record->data.ru_utime, &data->ru_utime_total);
		timeradd(&data->ru_stime_total, &record->data.ru_stime, &data->ru_stime_total);
		data->kbytes_total += record->data.doc_size;
		data->memory_footprint += record->data.memory_footprint;
		PINBA_UPDATE_HISTOGRAM_ADD(report, data->histogram_data, record->data.req_time);
	}
#endif
}
/* }}} */

void pinba_update_report17_delete(size_t request_id, pinba_report *report, const pinba_stats_record *record) /* pinba_update_report1_delete(pinba_report *report, const pinba_stats_record *record)*/ /* {{{ */
{
	struct pinba_report17_data *data;
	uint8_t index[PINBA_SCHEMA_SIZE + 1 + PINBA_HOSTNAME_SIZE + 1 + PINBA_SCRIPT_NAME_SIZE] = {0};
	PPvoid_t ppvalue;

	if (report->std.results_cnt == 0) {
		return;
	}

	PINBA_REPORT_DELETE_CHECK(report, record);

	timersub(&report->time_total, &record->data.req_time, &report->time_total);
	timersub(&report->ru_utime_total, &record->data.ru_utime, &report->ru_utime_total);
	timersub(&report->ru_stime_total, &record->data.ru_stime, &report->ru_stime_total);
	report->kbytes_total -= record->data.doc_size;
	report->memory_footprint -= record->data.memory_footprint;

#if 0
	report->std.results_cnt--;
	PINBA_UPDATE_HISTOGRAM_DEL(report, report->std.histogram_data, record->data.req_time);
#else 
	{
		size_t index_len, dummy;
		/*int index_len, dummy;*/

		
		memcpy_static(index, record->data.schema, record->data.schema_len, index_len);
		(index_len < sizeof(index)-1) ? index[index_len++] = '/' : 0;
		memcat_static(index, index_len, record->data.hostname, record->data.hostname_len, index_len);
		(index_len < sizeof(index)-1) ? index[index_len++] = '/' : 0;
		memcat_static(index, index_len, record->data.script_name, record->data.script_name_len, index_len);
		;

		ppvalue = JudySLGet(report->results, index, NULL);

		if (UNLIKELY(!ppvalue || ppvalue == PPJERR)) {
			/* no such value, mmm?? */
			return;
		} else {

			data = (struct pinba_report17_data *)*ppvalue;
			if (UNLIKELY(data->req_count == 1)) {
				free(data);
				JudySLDel(&report->results, index, NULL);
				report->std.results_cnt--;
			} else {
				data->req_count--;
				timersub(&data->req_time_total, &record->data.req_time, &data->req_time_total);
				timersub(&data->ru_utime_total, &record->data.ru_utime, &data->ru_utime_total);
				timersub(&data->ru_stime_total, &record->data.ru_stime, &data->ru_stime_total);
				data->kbytes_total -= record->data.doc_size;
				data->memory_footprint -= record->data.memory_footprint;
				PINBA_UPDATE_HISTOGRAM_DEL(report, data->histogram_data, record->data.req_time);
			}
		}
	}
#endif
}
/* }}} */

void pinba_update_report18_add(size_t request_id, pinba_report *report, const pinba_stats_record *record) /*pinba_update_report1_add(pinba_report *report, const pinba_stats_record *record)*/ /* {{{ */
{
	struct pinba_report18_data *data;
	/*struct pinba_report1_data *data;*/
	uint8_t index[PINBA_SCHEMA_SIZE + 1 + PINBA_HOSTNAME_SIZE + 1 + PINBA_STATUS_SIZE] = {0};
	PPvoid_t ppvalue;

	timeradd(&report->time_total, &record->data.req_time, &report->time_total);
	timeradd(&report->ru_utime_total, &record->data.ru_utime, &report->ru_utime_total);
	timeradd(&report->ru_stime_total, &record->data.ru_stime, &report->ru_stime_total);
	report->kbytes_total += record->data.doc_size;
	report->memory_footprint += record->data.memory_footprint;

#if 0
	report->std.results_cnt++;
	PINBA_UPDATE_HISTOGRAM_ADD(report, report->std.histogram_data, record->data.req_time);
#else 
	{
		size_t index_len, dummy;
		/*int index_len, dummy;*/

				index_len = sprintf((char *)index, "%u:", record->data.status);
		memcat_static(index, index_len, record->data.schema, record->data.schema_len, index_len);
		(index_len < sizeof(index)-1) ? index[index_len++] = '/' : 0;
		memcat_static(index, index_len, record->data.hostname, record->data.hostname_len, index_len);;

		ppvalue = JudySLGet(report->results, index, NULL);

		if (UNLIKELY(!ppvalue || ppvalue == PPJERR)) {
			/* no such value, insert */
			ppvalue = JudySLIns(&report->results, index, NULL);
			if (UNLIKELY(!ppvalue || ppvalue == PPJERR)) {
				return;
			}
			data = (struct pinba_report18_data *)calloc(1, sizeof(struct pinba_report18_data));

			
		data->status = record->data.status;
		memcpy_static(data->schema, record->data.schema, record->data.schema_len, dummy);
		memcpy_static(data->hostname, record->data.hostname, record->data.hostname_len, dummy);
		;

			*ppvalue = data;
			report->std.results_cnt++;
		} else {
			data = (struct pinba_report18_data *)*ppvalue;
		}

		data->req_count++;
		timeradd(&data->req_time_total, &record->data.req_time, &data->req_time_total);
		timeradd(&data->ru_utime_total, &record->data.ru_utime, &data->ru_utime_total);
		timeradd(&data->ru_stime_total, &record->data.ru_stime, &data->ru_stime_total);
		data->kbytes_total += record->data.doc_size;
		data->memory_footprint += record->data.memory_footprint;
		PINBA_UPDATE_HISTOGRAM_ADD(report, data->histogram_data, record->data.req_time);
	}
#endif
}
/* }}} */

void pinba_update_report18_delete(size_t request_id, pinba_report *report, const pinba_stats_record *record) /* pinba_update_report1_delete(pinba_report *report, const pinba_stats_record *record)*/ /* {{{ */
{
	struct pinba_report18_data *data;
	uint8_t index[PINBA_SCHEMA_SIZE + 1 + PINBA_HOSTNAME_SIZE + 1 + PINBA_STATUS_SIZE] = {0};
	PPvoid_t ppvalue;

	if (report->std.results_cnt == 0) {
		return;
	}

	PINBA_REPORT_DELETE_CHECK(report, record);

	timersub(&report->time_total, &record->data.req_time, &report->time_total);
	timersub(&report->ru_utime_total, &record->data.ru_utime, &report->ru_utime_total);
	timersub(&report->ru_stime_total, &record->data.ru_stime, &report->ru_stime_total);
	report->kbytes_total -= record->data.doc_size;
	report->memory_footprint -= record->data.memory_footprint;

#if 0
	report->std.results_cnt--;
	PINBA_UPDATE_HISTOGRAM_DEL(report, report->std.histogram_data, record->data.req_time);
#else 
	{
		size_t index_len, dummy;
		/*int index_len, dummy;*/

				index_len = sprintf((char *)index, "%u:", record->data.status);
		memcat_static(index, index_len, record->data.schema, record->data.schema_len, index_len);
		(index_len < sizeof(index)-1) ? index[index_len++] = '/' : 0;
		memcat_static(index, index_len, record->data.hostname, record->data.hostname_len, index_len);;

		ppvalue = JudySLGet(report->results, index, NULL);

		if (UNLIKELY(!ppvalue || ppvalue == PPJERR)) {
			/* no such value, mmm?? */
			return;
		} else {

			data = (struct pinba_report18_data *)*ppvalue;
			if (UNLIKELY(data->req_count == 1)) {
				free(data);
				JudySLDel(&report->results, index, NULL);
				report->std.results_cnt--;
			} else {
				data->req_count--;
				timersub(&data->req_time_total, &record->data.req_time, &data->req_time_total);
				timersub(&data->ru_utime_total, &record->data.ru_utime, &data->ru_utime_total);
				timersub(&data->ru_stime_total, &record->data.ru_stime, &data->ru_stime_total);
				data->kbytes_total -= record->data.doc_size;
				data->memory_footprint -= record->data.memory_footprint;
				PINBA_UPDATE_HISTOGRAM_DEL(report, data->histogram_data, record->data.req_time);
			}
		}
	}
#endif
}
/* }}} */
