import QtQuick 2.1
import QtQuick.Layouts 1.1
import org.kde.plasma.core 2.0 as PlasmaCore
import QtGraphicalEffects 1.0
import org.kde.plasma.extras 2.0 as PlasmaExtras
import org.kde.plasma.components 2.0 as PlasmaComponents
import org.kde.plasma.plasmoid 2.0

Item {
    id: root

    property string icon:       Qt.resolvedUrl("nvidia-off.svg")
    property string stat:       String("undefined")
    property string gpu:        String("undefined")
    property bool nvidia:       false
    property bool intel:        false
    property bool ondemand:     false

    Component.onCompleted: {
        checkTimer.start()
        sniffgpu()
    }

    function switchCardNvidia(){
        if (root.nvidia == false) {
            executable.exec("/usr/share/plasma/plasmoids/org.kde.plasma.plasma-optimus/contents/ui/./switch.sh nvidia")
        }
    }

    function switchCardIntel(){
        if (root.intel == false) {
            executable.exec("/usr/share/plasma/plasmoids/org.kde.plasma.plasma-optimus/contents/ui/./switch.sh intel")
        }
    }

    function switchCardHybrid(){
        if (root.ondemand == false) {
            executable.exec("/usr/share/plasma/plasmoids/org.kde.plasma.plasma-optimus/contents/ui/./switch.sh on-demand")
        }
    }

    function getCurrentProcess() {
        executable.exec("/usr/share/plasma/plasmoids/org.kde.plasma.plasma-optimus/contents/ui/./process.sh")
    }

    PlasmaCore.DataSource {
        id: executable
        engine: "executable"
        connectedSources: []
        onNewData: {
            var exitCode = data["exit code"]
            var exitStatus = data["exit status"]
            var stdout = data["stdout"]
            var stderr = data["stderr"]
            exited(sourceName, exitCode, exitStatus, stdout, stderr)
            disconnectSource(sourceName)
        }
        function exec(cmd) {
            if (cmd) {
                connectSource(cmd)
            }
        }
        signal exited(string cmd, int exitCode, int exitStatus, string stdout, string stderr)
    }

    function check() {
        executable.exec("prime-select query")
    }

    Connections {
        target: executable
        onExited: {
            var graphics = stdout
            var errorText = stderr
            if (graphics.includes("nvidia")) {
                root.icon = Qt.resolvedUrl("nvidia-on.svg")
                root.stat = "Nvidia GPU is in use"
                root.nvidia = true
                root.ondemand = false
                root.intel = false
            } else if (graphics.includes("intel")) {
                root.icon = Qt.resolvedUrl("intel.svg")
                root.stat = "Nvidia GPU is not in use"
                root.intel = true
                root.nvidia = false
                root.ondemand = false
            } else if (graphics.includes("on-demand")) {
                root.icon = Qt.resolvedUrl("hybrid.svg")
                root.stat = "Nvidia GPU is in On-Demand Mode"
                root.ondemand = true
                root.nvidia = false
                root.intel = false
            }
        }
    }

    PlasmaCore.DataSource {
        id: gpusniff
        engine: "executable"
        connectedSources: []
        onNewData: {
            var exitCode = data["exit code"]
            var exitStatus = data["exit status"]
            var stdout = data["stdout"]
            var stderr = data["stderr"]
            exited(sourceName, exitCode, exitStatus, stdout, stderr)
            disconnectSource(sourceName)
        }
        function exec(cmd) {
            if (cmd) {
                connectSource(cmd)
            }
        }
        signal exited(string cmd, int exitCode, int exitStatus, string stdout, string stderr)
    }

    function sniffgpu() {
        gpusniff.exec("/usr/share/plasma/plasmoids/org.kde.plasma.plasma-optimus/contents/ui/sniff-gpu.sh")
    }

    Connections {
        target: gpusniff
        onExited: {
            root.gpu = stdout
        }
    }

    Connections {
        target: plasmoid.configuration
    }

    Item {
        id: tool

        property int preferredTextWidth: units.gridUnit * 20
        Layout.minimumWidth: childrenRect.width + units.gridUnit
        Layout.minimumHeight: childrenRect.height + units.gridUnit
        Layout.maximumWidth: childrenRect.width + units.gridUnit
        Layout.maximumHeight: childrenRect.height + units.gridUnit

        RowLayout {
            anchors {
                left: parent.left
                top: parent.top
            }

            spacing: units.largeSpacing
            Image {
                id: toolImage
                source: root.icon
                Layout.alignment: Qt.AlignTop
                Layout.preferredWidth: 56
                Layout.preferredHeight: 56
                ColorOverlay {
                    anchors.fill: mainImage
                    source: root.icon
                    color: PlasmaCore.ColorScope.textColor
                    visible: false //root.stat ? false : true
                    antialiasing: true
                }
            }

            ColumnLayout {
                PlasmaExtras.Heading {
                    id: toolText
                    level: 2
                    Layout.fillWidth: true
                    elide: Text.ElideRight
                    wrapMode: Text.Wrap
                    text: root.stat
                    visible: text != ""
                }
                PlasmaComponents.Label {
                    id: toolTextGpu
                    Layout.fillWidth: true
                    height: undefined
                    wrapMode: Text.WordWrap
                    text: root.gpu
                    //opacity: root.stat ? 1 : 0.8
                    visible: text != ""
                    maximumLineCount: 8
                }

            }
        }
    }

    Plasmoid.preferredRepresentation: Plasmoid.compactRepresentation
    Plasmoid.compactRepresentation: Item {
        PlasmaCore.IconItem {
            id: ima
            anchors.fill: parent
            //            anchors.topMargin: 3
            //            anchors.bottomMargin: 3
            source: root.icon
            active: mouseArea.containsMouse
            //opacity: root.stat ? 1 : 0.7
            ColorOverlay {
                anchors.fill: ima
                source: root.icon
                visible: false //root.stat ? false : true
                color: PlasmaCore.ColorScope.textColor
                antialiasing: true
                //opacity: root.stat ? 1 : 0.7
            }
        }

        MouseArea {
            id: mouseArea
            anchors.fill: parent
            hoverEnabled: true
            onClicked: {
                    plasmoid.expanded = !plasmoid.expanded
                }
        }
        PlasmaCore.ToolTipArea {
            id: toolTip
            width: parent.width
            height: parent.height
            anchors.fill: parent
            mainItem: tool
            interactive: true
        }
    }

    Plasmoid.fullRepresentation: Item {
        Layout.preferredWidth: 400 * PlasmaCore.Units.devicePixelRatio
        Layout.preferredHeight: 400 * PlasmaCore.Units.devicePixelRatio

        property int preferredTextWidth: units.gridUnit * 20
        Layout.minimumWidth: childrenRect.width + units.gridUnit
        Layout.minimumHeight: childrenRect.height + units.gridUnit
        Layout.maximumWidth: childrenRect.width + units.gridUnit
        Layout.maximumHeight: childrenRect.height + units.gridUnit

        RowLayout {

            anchors {
                left: parent.left
                top: parent.top
                margins: units.gridUnit / 2
            }

            spacing: units.largeSpacing
            Image {
                id: mainImage
                source: root.icon
                Layout.alignment: Qt.AlignTop
                Layout.preferredWidth: 56
                Layout.preferredHeight: 56
                ColorOverlay {
                    anchors.fill: mainImage
                    source: root.icon
                    color: PlasmaCore.ColorScope.textColor
                    visible: false //root.stat ? false : true
                    antialiasing: true
                }
            }

            ColumnLayout {
                PlasmaExtras.Heading {
                    id: mainText
                    level: 2
                    Layout.fillWidth: true
                    elide: Text.ElideRight
                    wrapMode: Text.Wrap
                    text: root.stat
                    visible: text != ""
                }
                PlasmaComponents.Label {
                    id: subTextGpu
                    Layout.fillWidth: true
                    height: undefined
                    wrapMode: Text.WordWrap
                    text: root.gpu
                    //opacity: root.stat ? 1 : 0.8
                    visible: text != ""
                    maximumLineCount: 8
                }

                PlasmaComponents.ToolButton {
                    iconSource: "view-refresh-symbolic"
                    text: i18n("Switch to Nvidia GPU (Performance Mode)")
                    onClicked: switchCardNvidia()
                    opacity: root.nvidia ? 0.4 : 1
                }
                PlasmaComponents.ToolButton {
                    iconSource: "view-refresh-symbolic"
                    text: i18n("Switch to Intel GPU (Power Save Mode)")
                    opacity: root.intel ? 0.4 : 1
                    onClicked: switchCardIntel()
                }
                PlasmaComponents.ToolButton {
                    iconSource: "view-refresh-symbolic"
                    text: i18n("Switch to Hybrid GPU (On-Demand Mode)")
                    opacity: root.ondemand ? 0.4 : 1
                    onClicked: switchCardHybrid()
                }
                PlasmaComponents.ToolButton {
                    iconSource: Qt.resolvedUrl("nvidia-on.svg")
                    text: i18n("Open Nvidia Settings")
                    onClicked: executable.exec("nvidia-settings")
                }
                PlasmaComponents.ToolButton {
                    iconSource: "view-process-system"
                    text: i18n("Processes using Nvidia GPU")
                    onClicked: getCurrentProcess()
                }
            }
        }
    }

    Timer {
        id: checkTimer
        interval: plasmoid.configuration.delay * 10000
        running: false
        repeat: true
        triggeredOnStart: true
        onTriggered: {
            check()
            if ( root.gpu === 'undefined' ) { sniffgpu() }
        }
    }
}
