#
#@BEGIN LICENSE
#
# PSI4: an ab initio quantum chemistry software package
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
#
#@END LICENSE
#

# load   jul-cc-pVDZ basis set
# load   jun-cc-pVDZ basis set
# load   jul-cc-pVTZ basis set
# load   jun-cc-pVTZ basis set
# load   may-cc-pVTZ basis set
# load   jul-cc-pVQZ basis set
# load   jun-cc-pVQZ basis set
# load   may-cc-pVQZ basis set
# load   apr-cc-pVQZ basis set

altbasis = {

'jul-cc-pvdz': [
    "! #####################",
    "! ##                 ##",
    "! ##   jul-cc-pVDZ   ##",
    "! ##                 ##",
    "! #####################",
    "!",
    "! HYDROGEN       (5s,2p) -> [3s,2p]",
    "! HYDROGEN       (4s,1p) -> [2s,1p]",
    "! HYDROGEN       (1s,1p)",
    "s, H , 13.0100000, 1.9620000, 0.4446000, 0.1220000",
    "c, 1.3, 0.0196850, 0.1379770, 0.4781480",
    "c, 4.4, 1",
    "p, H , 0.7270000",
    "c, 1.1, 1",
    "! HELIUM       (5s,2p) -> [3s,2p]",
    "! HELIUM       (4s,1p) -> [2s,1p]",
    "! HELIUM       (1s,1p)",
    "s, HE , 38.3600000, 5.7700000, 1.2400000, 0.2976000",
    "c, 1.3, 0.0238090, 0.1548910, 0.4699870",
    "c, 4.4, 1",
    "p, HE , 1.2750000",
    "c, 1.1, 1",
    "! LITHIUM       (10s,5p,2d) -> [4s,3p,2d]",
    "! LITHIUM       (9s,4p,1d) -> [3s,2p,1d]",
    "! LITHIUM       (1s,1p,1d)",
    "s, LI , 1469.0000000, 220.5000000, 50.2600000, 14.2400000, 4.5810000, 1.5800000, 0.5640000, 0.0734500, 0.0280500, 0.0086400",
    "c, 1.8, 0.0007660, 0.0058920, 0.0296710, 0.1091800, 0.2827890, 0.4531230, 0.2747740, 0.0097510",
    "c, 1.8, -0.0001200, -0.0009230, -0.0046890, -0.0176820, -0.0489020, -0.0960090, -0.1363800, 0.5751020",
    "c, 9.9, 1",
    "c, 10.10, 1",
    "p, LI , 1.5340000, 0.2749000, 0.0736200, 0.0240300, 0.0057900",
    "c, 1.3, 0.0227840, 0.1391070, 0.5003750",
    "c, 4.4, 1",
    "c, 5.5, 1",
    "d, LI , 0.1239000, 0.0725000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "! BERYLLIUM       (10s,5p,2d) -> [4s,3p,2d]",
    "! BERYLLIUM       (9s,4p,1d) -> [3s,2p,1d]",
    "! BERYLLIUM       (1s,1p,1d)",
    "s, BE , 2940.0000000, 441.2000000, 100.5000000, 28.4300000, 9.1690000, 3.1960000, 1.1590000, 0.1811000, 0.0589000, 0.0187700",
    "c, 1.8, 0.0006800, 0.0052360, 0.0266060, 0.0999930, 0.2697020, 0.4514690, 0.2950740, 0.0125870",
    "c, 1.8, -0.0001230, -0.0009660, -0.0048310, -0.0193140, -0.0532800, -0.1207230, -0.1334350, 0.5307670",
    "c, 9.9, 1",
    "c, 10.10, 1",
    "p, BE , 3.6190000, 0.7110000, 0.1951000, 0.0601800, 0.0085000",
    "c, 1.3, 0.0291110, 0.1693650, 0.5134580",
    "c, 4.4, 1",
    "c, 5.5, 1",
    "d, BE , 0.2380000, 0.0740000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "! BORON       (10s,5p,2d) -> [4s,3p,2d]",
    "! BORON       (9s,4p,1d) -> [3s,2p,1d]",
    "! BORON       (1s,1p,1d)",
    "s, B , 4570.0000000, 685.9000000, 156.5000000, 44.4700000, 14.4800000, 5.1310000, 1.8980000, 0.3329000, 0.1043000, 0.0310500",
    "c, 1.8, 0.0006960, 0.0053530, 0.0271340, 0.1013800, 0.2720550, 0.4484030, 0.2901230, 0.0143220",
    "c, 1.8, -0.0001390, -0.0010970, -0.0054440, -0.0219160, -0.0597510, -0.1387320, -0.1314820, 0.5395260",
    "c, 9.9, 1",
    "c, 10.10, 1",
    "p, B , 6.0010000, 1.2410000, 0.3364000, 0.0953800, 0.0237800",
    "c, 1.3, 0.0354810, 0.1980720, 0.5052300",
    "c, 4.4, 1",
    "c, 5.5, 1",
    "d, B , 0.3430000, 0.0904000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "! CARBON       (10s,5p,2d) -> [4s,3p,2d]",
    "! CARBON       (9s,4p,1d) -> [3s,2p,1d]",
    "! CARBON       (1s,1p,1d)",
    "s, C , 6665.0000000, 1000.0000000, 228.0000000, 64.7100000, 21.0600000, 7.4950000, 2.7970000, 0.5215000, 0.1596000, 0.0469000",
    "c, 1.8, 0.0006920, 0.0053290, 0.0270770, 0.1017180, 0.2747400, 0.4485640, 0.2850740, 0.0152040",
    "c, 1.8, -0.0001460, -0.0011540, -0.0057250, -0.0233120, -0.0639550, -0.1499810, -0.1272620, 0.5445290",
    "c, 9.9, 1",
    "c, 10.10, 1",
    "p, C , 9.4390000, 2.0020000, 0.5456000, 0.1517000, 0.0404100",
    "c, 1.3, 0.0381090, 0.2094800, 0.5085570",
    "c, 4.4, 1",
    "c, 5.5, 1",
    "d, C , 0.5500000, 0.1510000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "! NITROGEN       (10s,5p,2d) -> [4s,3p,2d]",
    "! NITROGEN       (9s,4p,1d) -> [3s,2p,1d]",
    "! NITROGEN       (1s,1p,1d)",
    "s, N , 9046.0000000, 1357.0000000, 309.3000000, 87.7300000, 28.5600000, 10.2100000, 3.8380000, 0.7466000, 0.2248000, 0.0612400",
    "c, 1.8, 0.0007000, 0.0053890, 0.0274060, 0.1032070, 0.2787230, 0.4485400, 0.2782380, 0.0154400",
    "c, 1.8, -0.0001530, -0.0012080, -0.0059920, -0.0245440, -0.0674590, -0.1580780, -0.1218310, 0.5490030",
    "c, 9.9, 1",
    "c, 10.10, 1",
    "p, N , 13.5500000, 2.9170000, 0.7973000, 0.2185000, 0.0561100",
    "c, 1.3, 0.0399190, 0.2171690, 0.5103190",
    "c, 4.4, 1",
    "c, 5.5, 1",
    "d, N , 0.8170000, 0.2300000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "! OXYGEN       (10s,5p,2d) -> [4s,3p,2d]",
    "! OXYGEN       (9s,4p,1d) -> [3s,2p,1d]",
    "! OXYGEN       (1s,1p,1d)",
    "s, O , 11720.0000000, 1759.0000000, 400.8000000, 113.7000000, 37.0300000, 13.2700000, 5.0250000, 1.0130000, 0.3023000, 0.0789600",
    "c, 1.8, 0.0007100, 0.0054700, 0.0278370, 0.1048000, 0.2830620, 0.4487190, 0.2709520, 0.0154580",
    "c, 1.8, -0.0001600, -0.0012630, -0.0062670, -0.0257160, -0.0709240, -0.1654110, -0.1169550, 0.5573680",
    "c, 9.9, 1",
    "c, 10.10, 1",
    "p, O , 17.7000000, 3.8540000, 1.0460000, 0.2753000, 0.0685600",
    "c, 1.3, 0.0430180, 0.2289130, 0.5087280",
    "c, 4.4, 1",
    "c, 5.5, 1",
    "d, O , 1.1850000, 0.3320000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "! FLUORINE       (10s,5p,2d) -> [4s,3p,2d]",
    "! FLUORINE       (9s,4p,1d) -> [3s,2p,1d]",
    "! FLUORINE       (1s,1p,1d)",
    "s, F , 14710.0000000, 2207.0000000, 502.8000000, 142.6000000, 46.4700000, 16.7000000, 6.3560000, 1.3160000, 0.3897000, 0.0986300",
    "c, 1.8, 0.0007210, 0.0055530, 0.0282670, 0.1064440, 0.2868140, 0.4486410, 0.2647610, 0.0153330",
    "c, 1.8, -0.0001650, -0.0013080, -0.0064950, -0.0266910, -0.0736900, -0.1707760, -0.1123270, 0.5628140",
    "c, 9.9, 1",
    "c, 10.10, 1",
    "p, F , 22.6700000, 4.9770000, 1.3470000, 0.3471000, 0.0850200",
    "c, 1.3, 0.0448780, 0.2357180, 0.5085210",
    "c, 4.4, 1",
    "c, 5.5, 1",
    "d, F , 1.6400000, 0.4640000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "! NEON       (10s,5p,2d) -> [4s,3p,2d]",
    "! NEON       (9s,4p,1d) -> [3s,2p,1d]",
    "! NEON       (1s,1p,1d)",
    "s, NE , 17880.0000000, 2683.0000000, 611.5000000, 173.5000000, 56.6400000, 20.4200000, 7.8100000, 1.6530000, 0.4869000, 0.1230000",
    "c, 1.8, 0.0007380, 0.0056770, 0.0288830, 0.1085400, 0.2909070, 0.4483240, 0.2580260, 0.0150630",
    "c, 1.8, -0.0001720, -0.0013570, -0.0067370, -0.0276630, -0.0762080, -0.1752270, -0.1070380, 0.5670500",
    "c, 9.9, 1",
    "c, 10.10, 1",
    "p, NE , 28.3900000, 6.2700000, 1.6950000, 0.4317000, 0.1064000",
    "c, 1.3, 0.0460870, 0.2401810, 0.5087440",
    "c, 4.4, 1",
    "c, 5.5, 1",
    "d, NE , 2.2020000, 0.6310000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "! SODIUM       (13s,9p,2d) -> [5s,4p,2d]",
    "! SODIUM       (12s,8p,1d) -> [4s,3p,1d]",
    "! SODIUM       (1s,1p,1d)",
    "s, NA , 31700.0000000, 4755.0000000, 1082.0000000, 306.4000000, 99.5300000, 35.4200000, 13.3000000, 4.3920000, 1.6760000, 0.5889000, 0.0564000, 0.0230700, 0.0072500",
    "c, 1.11, 0.458878D-03, 0.355070D-02, 0.182618D-01, 0.716650D-01, 0.212346D+00, 0.416203D+00, 0.373020D+00, 0.625054D-01, -0.624532D-02, 0.243374D-02, -0.442381D-03",
    "c, 1.11, -0.112162D-03, -0.868512D-03, -0.451330D-02, -0.181436D-01, -0.580799D-01, -0.137653D+00, -0.193908D+00, 0.858009D-01, 0.604419D+00, 0.441719D+00, 0.130547D-01",
    "c, 1.11, 0.170160D-04, 0.130693D-03, 0.687784D-03, 0.272359D-02, 0.895529D-02, 0.207832D-01, 0.319380D-01, -0.191368D-01, -0.102595D+00, -0.198945D+00, 0.655952D+00",
    "c, 12.12, 1",
    "c, 13.13, 1",
    "p, NA , 138.1000000, 32.2400000, 9.9850000, 3.4840000, 1.2310000, 0.4177000, 0.0651300, 0.0205300, 0.0063300",
    "c, 1.7, 0.579641D-02, 0.415756D-01, 0.162873D+00, 0.359401D+00, 0.449988D+00, 0.227507D+00, 0.808247D-02",
    "c, 1.7, -0.581531D-03, -0.407306D-02, -0.167937D-01, -0.353268D-01, -0.521971D-01, -0.168359D-01, 0.434613D+00",
    "c, 8.8, 1",
    "c, 9.9, 1",
    "d, NA , 0.0973000, 0.0468000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "! MAGNESIUM       (13s,9p,2d) -> [5s,4p,2d]",
    "! MAGNESIUM       (12s,8p,1d) -> [4s,3p,1d]",
    "! MAGNESIUM       (1s,1p,1d)",
    "s, MG , 47390.0000000, 7108.0000000, 1618.0000000, 458.4000000, 149.3000000, 53.5900000, 20.7000000, 8.3840000, 2.5420000, 0.8787000, 0.1077000, 0.0399900, 0.0148800",
    "c, 1.11, 0.346023D-03, 0.268077D-02, 0.138367D-01, 0.551767D-01, 0.169660D+00, 0.364703D+00, 0.406856D+00, 0.135089D+00, 0.490884D-02, 0.286460D-03, 0.264590D-04",
    "c, 1.11, -0.877839D-04, -0.674725D-03, -0.355603D-02, -0.142154D-01, -0.476748D-01, -0.114892D+00, -0.200676D+00, -0.341224D-01, 0.570454D+00, 0.542309D+00, 0.218128D-01",
    "c, 1.11, 0.169628D-04, 0.129865D-03, 0.688831D-03, 0.273533D-02, 0.931224D-02, 0.223265D-01, 0.411195D-01, 0.545642D-02, -0.134012D+00, -0.256176D+00, 0.605856D+00",
    "c, 12.12, 1",
    "c, 13.13, 1",
    "p, MG , 179.9000000, 42.1400000, 13.1300000, 4.6280000, 1.6700000, 0.5857000, 0.1311000, 0.0411200, 0.0093500",
    "c, 1.7, 0.538161D-02, 0.392418D-01, 0.157445D+00, 0.358535D+00, 0.457226D+00, 0.215918D+00, 0.664948D-02",
    "c, 1.7, -0.865948D-03, -0.615978D-02, -0.261519D-01, -0.570647D-01, -0.873906D-01, -0.122990D-01, 0.502085D+00",
    "c, 8.8, 1",
    "c, 9.9, 1",
    "d, MG , 0.1870000, 0.0595000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "! ALUMINUM       (13s,9p,2d) -> [5s,4p,2d]",
    "! ALUMINUM       (12s,8p,1d) -> [4s,3p,1d]",
    "! ALUMINUM       (1s,1p,1d)",
    "s, AL , 64150.0000000, 9617.0000000, 2189.0000000, 620.5000000, 202.7000000, 73.1500000, 28.5500000, 11.7700000, 3.3000000, 1.1730000, 0.1752000, 0.0647300, 0.0231000",
    "c, 1.11, 0.290250D-03, 0.225064D-02, 0.116459D-01, 0.467377D-01, 0.146299D+00, 0.330283D+00, 0.415861D+00, 0.189253D+00, 0.115889D-01, -0.128385D-02, 0.425883D-03",
    "c, 1.11, -0.758048D-04, -0.581791D-03, -0.308113D-02, -0.123112D-01, -0.419781D-01, -0.103371D+00, -0.196308D+00, -0.830002D-01, 0.541040D+00, 0.578796D+00, 0.288147D-01",
    "c, 1.11, 0.175078D-04, 0.134208D-03, 0.712442D-03, 0.284330D-02, 0.976842D-02, 0.241850D-01, 0.474993D-01, 0.203621D-01, -0.158788D+00, -0.311694D+00, 0.620147D+00",
    "c, 12.12, 1",
    "c, 13.13, 1",
    "p, AL , 258.8000000, 60.8900000, 19.1400000, 6.8810000, 2.5740000, 0.9572000, 0.2099000, 0.0598600, 0.0153000",
    "c, 1.7, 0.406847D-02, 0.306815D-01, 0.129149D+00, 0.320831D+00, 0.453815D+00, 0.275066D+00, 0.190807D-01",
    "c, 1.7, -0.748053D-03, -0.545796D-02, -0.245371D-01, -0.582138D-01, -0.983756D-01, -0.260064D-01, 0.464020D+00",
    "c, 8.8, 1",
    "c, 9.9, 1",
    "d, AL , 0.1890000, 0.0535000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "! SILICON       (13s,9p,2d) -> [5s,4p,2d]",
    "! SILICON       (12s,8p,1d) -> [4s,3p,1d]",
    "! SILICON       (1s,1p,1d)",
    "s, SI , 78860.0000000, 11820.0000000, 2692.0000000, 763.4000000, 249.6000000, 90.2800000, 35.2900000, 14.5100000, 4.0530000, 1.4820000, 0.2517000, 0.0924300, 0.0332000",
    "c, 1.11, 0.270443D-03, 0.209717D-02, 0.108506D-01, 0.436754D-01, 0.137653D+00, 0.316644D+00, 0.418581D+00, 0.210212D+00, 0.144952D-01, -0.203590D-02, 0.624186D-03",
    "c, 1.11, -0.723177D-04, -0.555116D-03, -0.293805D-02, -0.117687D-01, -0.402907D-01, -0.100609D+00, -0.196528D+00, -0.102382D+00, 0.527190D+00, 0.593251D+00, 0.332652D-01",
    "c, 1.11, 0.185113D-04, 0.142236D-03, 0.752185D-03, 0.302279D-02, 0.103677D-01, 0.262563D-01, 0.523989D-01, 0.290959D-01, -0.178003D+00, -0.346874D+00, 0.623020D+00",
    "c, 12.12, 1",
    "c, 13.13, 1",
    "p, SI , 315.9000000, 74.4200000, 23.4800000, 8.4880000, 3.2170000, 1.2290000, 0.2964000, 0.0876800, 0.0250000",
    "c, 1.7, 0.392656D-02, 0.298811D-01, 0.127212D+00, 0.320943D+00, 0.455429D+00, 0.268563D+00, 0.188336D-01",
    "c, 1.7, -0.858302D-03, -0.630328D-02, -0.288255D-01, -0.694560D-01, -0.119493D+00, -0.199581D-01, 0.510268D+00",
    "c, 8.8, 1",
    "c, 9.9, 1",
    "d, SI , 0.2750000, 0.0823000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "! PHOSPHOROUS       (13s,9p,2d) -> [5s,4p,2d]",
    "! PHOSPHOROUS       (12s,8p,1d) -> [4s,3p,1d]",
    "! PHOSPHOROUS       (1s,1p,1d)",
    "s, P , 94840.0000000, 14220.0000000, 3236.0000000, 917.1000000, 299.5000000, 108.1000000, 42.1800000, 17.2800000, 4.8580000, 1.8180000, 0.3372000, 0.1232000, 0.0417000",
    "c, 1.11, 0.255509D-03, 0.198193D-02, 0.102760D-01, 0.414823D-01, 0.131984D+00, 0.308662D+00, 0.420647D+00, 0.222878D+00, 0.164035D-01, -0.254255D-02, 0.748050D-03",
    "c, 1.11, -0.696939D-04, -0.535266D-03, -0.283709D-02, -0.113983D-01, -0.392929D-01, -0.996364D-01, -0.197983D+00, -0.114860D+00, 0.518595D+00, 0.601847D+00, 0.368612D-01",
    "c, 1.11, 0.191199D-04, 0.147223D-03, 0.777912D-03, 0.314546D-02, 0.108200D-01, 0.279957D-01, 0.563978D-01, 0.358190D-01, -0.193387D+00, -0.372097D+00, 0.624246D+00",
    "c, 12.12, 1",
    "c, 13.13, 1",
    "p, P , 370.5000000, 87.3300000, 27.5900000, 10.0000000, 3.8250000, 1.4940000, 0.3921000, 0.1186000, 0.0343000",
    "c, 1.7, 0.395005D-02, 0.302492D-01, 0.129554D+00, 0.327594D+00, 0.456992D+00, 0.253086D+00, 0.168798D-01",
    "c, 1.7, -0.959832D-03, -0.711177D-02, -0.327122D-01, -0.795784D-01, -0.135016D+00, -0.910585D-02, 0.537802D+00",
    "c, 8.8, 1",
    "c, 9.9, 1",
    "d, P , 0.3730000, 0.1130000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "! SULFUR       (13s,9p,2d) -> [5s,4p,2d]",
    "! SULFUR       (12s,8p,1d) -> [4s,3p,1d]",
    "! SULFUR       (1s,1p,1d)",
    "s, S , 110800.0000000, 16610.0000000, 3781.0000000, 1071.0000000, 349.8000000, 126.3000000, 49.2600000, 20.1600000, 5.7200000, 2.1820000, 0.4327000, 0.1570000, 0.0507000",
    "c, 1.11, 0.247635D-03, 0.192026D-02, 0.996192D-02, 0.402975D-01, 0.128604D+00, 0.303480D+00, 0.421432D+00, 0.230781D+00, 0.178971D-01, -0.297516D-02, 0.849522D-03",
    "c, 1.11, -0.687039D-04, -0.527681D-03, -0.279671D-02, -0.112651D-01, -0.388834D-01, -0.995025D-01, -0.199740D+00, -0.123360D+00, 0.513194D+00, 0.607120D+00, 0.396753D-01",
    "c, 1.11, 0.199077D-04, 0.153483D-03, 0.809503D-03, 0.328974D-02, 0.112967D-01, 0.296385D-01, 0.599851D-01, 0.413248D-01, -0.207474D+00, -0.392889D+00, 0.632840D+00",
    "c, 12.12, 1",
    "c, 13.13, 1",
    "p, S , 399.7000000, 94.1900000, 29.7500000, 10.7700000, 4.1190000, 1.6250000, 0.4726000, 0.1407000, 0.0399000",
    "c, 1.7, 0.447541D-02, 0.341708D-01, 0.144250D+00, 0.353928D+00, 0.459085D+00, 0.206383D+00, 0.102141D-01",
    "c, 1.7, -0.116251D-02, -0.865664D-02, -0.390886D-01, -0.934625D-01, -0.147994D+00, 0.301904D-01, 0.561573D+00",
    "c, 8.8, 1",
    "c, 9.9, 1",
    "d, S , 0.4790000, 0.1520000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "! CHLORINE       (13s,9p,2d) -> [5s,4p,2d]",
    "! CHLORINE       (12s,8p,1d) -> [4s,3p,1d]",
    "! CHLORINE       (1s,1p,1d)",
    "s, CL , 127900.0000000, 19170.0000000, 4363.0000000, 1236.0000000, 403.6000000, 145.7000000, 56.8100000, 23.2300000, 6.6440000, 2.5750000, 0.5371000, 0.1938000, 0.0608000",
    "c, 1.11, 0.241153D-03, 0.187095D-02, 0.970827D-02, 0.393153D-01, 0.125932D+00, 0.299341D+00, 0.421886D+00, 0.237201D+00, 0.191531D-01, -0.334792D-02, 0.929883D-03",
    "c, 1.11, -0.678922D-04, -0.521836D-03, -0.276513D-02, -0.111537D-01, -0.385919D-01, -0.994848D-01, -0.201392D+00, -0.130313D+00, 0.509443D+00, 0.610725D+00, 0.421549D-01",
    "c, 1.11, 0.204986D-04, 0.158298D-03, 0.833639D-03, 0.339880D-02, 0.116738D-01, 0.309622D-01, 0.629533D-01, 0.460257D-01, -0.219312D+00, -0.408773D+00, 0.638465D+00",
    "c, 12.12, 1",
    "c, 13.13, 1",
    "p, CL , 417.6000000, 98.3300000, 31.0400000, 11.1900000, 4.2490000, 1.6240000, 0.5322000, 0.1620000, 0.0466000",
    "c, 1.7, 0.525982D-02, 0.398332D-01, 0.164655D+00, 0.387322D+00, 0.457072D+00, 0.151636D+00, 0.181615D-02",
    "c, 1.7, -0.143570D-02, -0.107796D-01, -0.470075D-01, -0.111030D+00, -0.153275D+00, 0.894609D-01, 0.579444D+00",
    "c, 8.8, 1",
    "c, 9.9, 1",
    "d, CL , 0.6000000, 0.1960000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "! ARGON       (13s,9p,2d) -> [5s,4p,2d]",
    "! ARGON       (12s,8p,1d) -> [4s,3p,1d]",
    "! ARGON       (1s,1p,1d)",
    "s, AR , 145700.0000000, 21840.0000000, 4972.0000000, 1408.0000000, 459.7000000, 165.9000000, 64.6900000, 26.4400000, 7.6280000, 2.9960000, 0.6504000, 0.2337000, 0.0709000",
    "c, 1.11, 0.236700D-03, 0.183523D-02, 0.952860D-02, 0.386283D-01, 0.124081D+00, 0.296471D+00, 0.422068D+00, 0.241711D+00, 0.200509D-01, -0.361000D-02, 0.975607D-03",
    "c, 1.11, -0.674910D-04, -0.518522D-03, -0.274825D-02, -0.111007D-01, -0.384820D-01, -0.997599D-01, -0.203088D+00, -0.135608D+00, 0.507195D+00, 0.612898D+00, 0.442968D-01",
    "c, 1.11, 0.210457D-04, 0.162565D-03, 0.855463D-03, 0.349745D-02, 0.120156D-01, 0.321368D-01, 0.655279D-01, 0.499370D-01, -0.229769D+00, -0.421006D+00, 0.642331D+00",
    "c, 12.12, 1",
    "c, 13.13, 1",
    "p, AR , 453.7000000, 106.8000000, 33.7300000, 12.1300000, 4.5940000, 1.6780000, 0.5909000, 0.1852000, 0.0533000",
    "c, 1.7, 0.570555D-02, 0.430460D-01, 0.176591D+00, 0.406863D+00, 0.452549D+00, 0.122801D+00, -0.445996D-02",
    "c, 1.7, -0.160655D-02, -0.121714D-01, -0.520789D-01, -0.123737D+00, -0.151619D+00, 0.142425D+00, 0.584501D+00",
    "c, 8.8, 1",
    "c, 9.9, 1",
    "d, AR , 0.7380000, 0.2400000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    ],

'jun-cc-pvdz': [
    "! #####################",
    "! ##                 ##",
    "! ##   jun-cc-pVDZ   ##",
    "! ##                 ##",
    "! #####################",
    "!",
    "! HYDROGEN       (5s,2p) -> [3s,2p]",
    "! HYDROGEN       (4s,1p) -> [2s,1p]",
    "! HYDROGEN       (1s,1p)",
    "s, H , 13.0100000, 1.9620000, 0.4446000, 0.1220000",
    "c, 1.3, 0.0196850, 0.1379770, 0.4781480",
    "c, 4.4, 1",
    "p, H , 0.7270000",
    "c, 1.1, 1",
    "! HELIUM       (5s,2p) -> [3s,2p]",
    "! HELIUM       (4s,1p) -> [2s,1p]",
    "! HELIUM       (1s,1p)",
    "s, HE , 38.3600000, 5.7700000, 1.2400000, 0.2976000",
    "c, 1.3, 0.0238090, 0.1548910, 0.4699870",
    "c, 4.4, 1",
    "p, HE , 1.2750000",
    "c, 1.1, 1",
    "! LITHIUM       (10s,5p,2d) -> [4s,3p,2d]",
    "! LITHIUM       (9s,4p,1d) -> [3s,2p,1d]",
    "! LITHIUM       (1s,1p,1d)",
    "s, LI , 1469.0000000, 220.5000000, 50.2600000, 14.2400000, 4.5810000, 1.5800000, 0.5640000, 0.0734500, 0.0280500, 0.0086400",
    "c, 1.8, 0.0007660, 0.0058920, 0.0296710, 0.1091800, 0.2827890, 0.4531230, 0.2747740, 0.0097510",
    "c, 1.8, -0.0001200, -0.0009230, -0.0046890, -0.0176820, -0.0489020, -0.0960090, -0.1363800, 0.5751020",
    "c, 9.9, 1",
    "c, 10.10, 1",
    "p, LI , 1.5340000, 0.2749000, 0.0736200, 0.0240300, 0.0057900",
    "c, 1.3, 0.0227840, 0.1391070, 0.5003750",
    "c, 4.4, 1",
    "c, 5.5, 1",
    "d, LI , 0.1239000",
    "c, 1.1, 1",
    "! BERYLLIUM       (10s,5p,2d) -> [4s,3p,2d]",
    "! BERYLLIUM       (9s,4p,1d) -> [3s,2p,1d]",
    "! BERYLLIUM       (1s,1p,1d)",
    "s, BE , 2940.0000000, 441.2000000, 100.5000000, 28.4300000, 9.1690000, 3.1960000, 1.1590000, 0.1811000, 0.0589000, 0.0187700",
    "c, 1.8, 0.0006800, 0.0052360, 0.0266060, 0.0999930, 0.2697020, 0.4514690, 0.2950740, 0.0125870",
    "c, 1.8, -0.0001230, -0.0009660, -0.0048310, -0.0193140, -0.0532800, -0.1207230, -0.1334350, 0.5307670",
    "c, 9.9, 1",
    "c, 10.10, 1",
    "p, BE , 3.6190000, 0.7110000, 0.1951000, 0.0601800, 0.0085000",
    "c, 1.3, 0.0291110, 0.1693650, 0.5134580",
    "c, 4.4, 1",
    "c, 5.5, 1",
    "d, BE , 0.2380000",
    "c, 1.1, 1",
    "! BORON       (10s,5p,2d) -> [4s,3p,2d]",
    "! BORON       (9s,4p,1d) -> [3s,2p,1d]",
    "! BORON       (1s,1p,1d)",
    "s, B , 4570.0000000, 685.9000000, 156.5000000, 44.4700000, 14.4800000, 5.1310000, 1.8980000, 0.3329000, 0.1043000, 0.0310500",
    "c, 1.8, 0.0006960, 0.0053530, 0.0271340, 0.1013800, 0.2720550, 0.4484030, 0.2901230, 0.0143220",
    "c, 1.8, -0.0001390, -0.0010970, -0.0054440, -0.0219160, -0.0597510, -0.1387320, -0.1314820, 0.5395260",
    "c, 9.9, 1",
    "c, 10.10, 1",
    "p, B , 6.0010000, 1.2410000, 0.3364000, 0.0953800, 0.0237800",
    "c, 1.3, 0.0354810, 0.1980720, 0.5052300",
    "c, 4.4, 1",
    "c, 5.5, 1",
    "d, B , 0.3430000",
    "c, 1.1, 1",
    "! CARBON       (10s,5p,2d) -> [4s,3p,2d]",
    "! CARBON       (9s,4p,1d) -> [3s,2p,1d]",
    "! CARBON       (1s,1p,1d)",
    "s, C , 6665.0000000, 1000.0000000, 228.0000000, 64.7100000, 21.0600000, 7.4950000, 2.7970000, 0.5215000, 0.1596000, 0.0469000",
    "c, 1.8, 0.0006920, 0.0053290, 0.0270770, 0.1017180, 0.2747400, 0.4485640, 0.2850740, 0.0152040",
    "c, 1.8, -0.0001460, -0.0011540, -0.0057250, -0.0233120, -0.0639550, -0.1499810, -0.1272620, 0.5445290",
    "c, 9.9, 1",
    "c, 10.10, 1",
    "p, C , 9.4390000, 2.0020000, 0.5456000, 0.1517000, 0.0404100",
    "c, 1.3, 0.0381090, 0.2094800, 0.5085570",
    "c, 4.4, 1",
    "c, 5.5, 1",
    "d, C , 0.5500000",
    "c, 1.1, 1",
    "! NITROGEN       (10s,5p,2d) -> [4s,3p,2d]",
    "! NITROGEN       (9s,4p,1d) -> [3s,2p,1d]",
    "! NITROGEN       (1s,1p,1d)",
    "s, N , 9046.0000000, 1357.0000000, 309.3000000, 87.7300000, 28.5600000, 10.2100000, 3.8380000, 0.7466000, 0.2248000, 0.0612400",
    "c, 1.8, 0.0007000, 0.0053890, 0.0274060, 0.1032070, 0.2787230, 0.4485400, 0.2782380, 0.0154400",
    "c, 1.8, -0.0001530, -0.0012080, -0.0059920, -0.0245440, -0.0674590, -0.1580780, -0.1218310, 0.5490030",
    "c, 9.9, 1",
    "c, 10.10, 1",
    "p, N , 13.5500000, 2.9170000, 0.7973000, 0.2185000, 0.0561100",
    "c, 1.3, 0.0399190, 0.2171690, 0.5103190",
    "c, 4.4, 1",
    "c, 5.5, 1",
    "d, N , 0.8170000",
    "c, 1.1, 1",
    "! OXYGEN       (10s,5p,2d) -> [4s,3p,2d]",
    "! OXYGEN       (9s,4p,1d) -> [3s,2p,1d]",
    "! OXYGEN       (1s,1p,1d)",
    "s, O , 11720.0000000, 1759.0000000, 400.8000000, 113.7000000, 37.0300000, 13.2700000, 5.0250000, 1.0130000, 0.3023000, 0.0789600",
    "c, 1.8, 0.0007100, 0.0054700, 0.0278370, 0.1048000, 0.2830620, 0.4487190, 0.2709520, 0.0154580",
    "c, 1.8, -0.0001600, -0.0012630, -0.0062670, -0.0257160, -0.0709240, -0.1654110, -0.1169550, 0.5573680",
    "c, 9.9, 1",
    "c, 10.10, 1",
    "p, O , 17.7000000, 3.8540000, 1.0460000, 0.2753000, 0.0685600",
    "c, 1.3, 0.0430180, 0.2289130, 0.5087280",
    "c, 4.4, 1",
    "c, 5.5, 1",
    "d, O , 1.1850000",
    "c, 1.1, 1",
    "! FLUORINE       (10s,5p,2d) -> [4s,3p,2d]",
    "! FLUORINE       (9s,4p,1d) -> [3s,2p,1d]",
    "! FLUORINE       (1s,1p,1d)",
    "s, F , 14710.0000000, 2207.0000000, 502.8000000, 142.6000000, 46.4700000, 16.7000000, 6.3560000, 1.3160000, 0.3897000, 0.0986300",
    "c, 1.8, 0.0007210, 0.0055530, 0.0282670, 0.1064440, 0.2868140, 0.4486410, 0.2647610, 0.0153330",
    "c, 1.8, -0.0001650, -0.0013080, -0.0064950, -0.0266910, -0.0736900, -0.1707760, -0.1123270, 0.5628140",
    "c, 9.9, 1",
    "c, 10.10, 1",
    "p, F , 22.6700000, 4.9770000, 1.3470000, 0.3471000, 0.0850200",
    "c, 1.3, 0.0448780, 0.2357180, 0.5085210",
    "c, 4.4, 1",
    "c, 5.5, 1",
    "d, F , 1.6400000",
    "c, 1.1, 1",
    "! NEON       (10s,5p,2d) -> [4s,3p,2d]",
    "! NEON       (9s,4p,1d) -> [3s,2p,1d]",
    "! NEON       (1s,1p,1d)",
    "s, NE , 17880.0000000, 2683.0000000, 611.5000000, 173.5000000, 56.6400000, 20.4200000, 7.8100000, 1.6530000, 0.4869000, 0.1230000",
    "c, 1.8, 0.0007380, 0.0056770, 0.0288830, 0.1085400, 0.2909070, 0.4483240, 0.2580260, 0.0150630",
    "c, 1.8, -0.0001720, -0.0013570, -0.0067370, -0.0276630, -0.0762080, -0.1752270, -0.1070380, 0.5670500",
    "c, 9.9, 1",
    "c, 10.10, 1",
    "p, NE , 28.3900000, 6.2700000, 1.6950000, 0.4317000, 0.1064000",
    "c, 1.3, 0.0460870, 0.2401810, 0.5087440",
    "c, 4.4, 1",
    "c, 5.5, 1",
    "d, NE , 2.2020000",
    "c, 1.1, 1",
    "! SODIUM       (13s,9p,2d) -> [5s,4p,2d]",
    "! SODIUM       (12s,8p,1d) -> [4s,3p,1d]",
    "! SODIUM       (1s,1p,1d)",
    "s, NA , 31700.0000000, 4755.0000000, 1082.0000000, 306.4000000, 99.5300000, 35.4200000, 13.3000000, 4.3920000, 1.6760000, 0.5889000, 0.0564000, 0.0230700, 0.0072500",
    "c, 1.11, 0.458878D-03, 0.355070D-02, 0.182618D-01, 0.716650D-01, 0.212346D+00, 0.416203D+00, 0.373020D+00, 0.625054D-01, -0.624532D-02, 0.243374D-02, -0.442381D-03",
    "c, 1.11, -0.112162D-03, -0.868512D-03, -0.451330D-02, -0.181436D-01, -0.580799D-01, -0.137653D+00, -0.193908D+00, 0.858009D-01, 0.604419D+00, 0.441719D+00, 0.130547D-01",
    "c, 1.11, 0.170160D-04, 0.130693D-03, 0.687784D-03, 0.272359D-02, 0.895529D-02, 0.207832D-01, 0.319380D-01, -0.191368D-01, -0.102595D+00, -0.198945D+00, 0.655952D+00",
    "c, 12.12, 1",
    "c, 13.13, 1",
    "p, NA , 138.1000000, 32.2400000, 9.9850000, 3.4840000, 1.2310000, 0.4177000, 0.0651300, 0.0205300, 0.0063300",
    "c, 1.7, 0.579641D-02, 0.415756D-01, 0.162873D+00, 0.359401D+00, 0.449988D+00, 0.227507D+00, 0.808247D-02",
    "c, 1.7, -0.581531D-03, -0.407306D-02, -0.167937D-01, -0.353268D-01, -0.521971D-01, -0.168359D-01, 0.434613D+00",
    "c, 8.8, 1",
    "c, 9.9, 1",
    "d, NA , 0.0973000",
    "c, 1.1, 1",
    "! MAGNESIUM       (13s,9p,2d) -> [5s,4p,2d]",
    "! MAGNESIUM       (12s,8p,1d) -> [4s,3p,1d]",
    "! MAGNESIUM       (1s,1p,1d)",
    "s, MG , 47390.0000000, 7108.0000000, 1618.0000000, 458.4000000, 149.3000000, 53.5900000, 20.7000000, 8.3840000, 2.5420000, 0.8787000, 0.1077000, 0.0399900, 0.0148800",
    "c, 1.11, 0.346023D-03, 0.268077D-02, 0.138367D-01, 0.551767D-01, 0.169660D+00, 0.364703D+00, 0.406856D+00, 0.135089D+00, 0.490884D-02, 0.286460D-03, 0.264590D-04",
    "c, 1.11, -0.877839D-04, -0.674725D-03, -0.355603D-02, -0.142154D-01, -0.476748D-01, -0.114892D+00, -0.200676D+00, -0.341224D-01, 0.570454D+00, 0.542309D+00, 0.218128D-01",
    "c, 1.11, 0.169628D-04, 0.129865D-03, 0.688831D-03, 0.273533D-02, 0.931224D-02, 0.223265D-01, 0.411195D-01, 0.545642D-02, -0.134012D+00, -0.256176D+00, 0.605856D+00",
    "c, 12.12, 1",
    "c, 13.13, 1",
    "p, MG , 179.9000000, 42.1400000, 13.1300000, 4.6280000, 1.6700000, 0.5857000, 0.1311000, 0.0411200, 0.0093500",
    "c, 1.7, 0.538161D-02, 0.392418D-01, 0.157445D+00, 0.358535D+00, 0.457226D+00, 0.215918D+00, 0.664948D-02",
    "c, 1.7, -0.865948D-03, -0.615978D-02, -0.261519D-01, -0.570647D-01, -0.873906D-01, -0.122990D-01, 0.502085D+00",
    "c, 8.8, 1",
    "c, 9.9, 1",
    "d, MG , 0.1870000",
    "c, 1.1, 1",
    "! ALUMINUM       (13s,9p,2d) -> [5s,4p,2d]",
    "! ALUMINUM       (12s,8p,1d) -> [4s,3p,1d]",
    "! ALUMINUM       (1s,1p,1d)",
    "s, AL , 64150.0000000, 9617.0000000, 2189.0000000, 620.5000000, 202.7000000, 73.1500000, 28.5500000, 11.7700000, 3.3000000, 1.1730000, 0.1752000, 0.0647300, 0.0231000",
    "c, 1.11, 0.290250D-03, 0.225064D-02, 0.116459D-01, 0.467377D-01, 0.146299D+00, 0.330283D+00, 0.415861D+00, 0.189253D+00, 0.115889D-01, -0.128385D-02, 0.425883D-03",
    "c, 1.11, -0.758048D-04, -0.581791D-03, -0.308113D-02, -0.123112D-01, -0.419781D-01, -0.103371D+00, -0.196308D+00, -0.830002D-01, 0.541040D+00, 0.578796D+00, 0.288147D-01",
    "c, 1.11, 0.175078D-04, 0.134208D-03, 0.712442D-03, 0.284330D-02, 0.976842D-02, 0.241850D-01, 0.474993D-01, 0.203621D-01, -0.158788D+00, -0.311694D+00, 0.620147D+00",
    "c, 12.12, 1",
    "c, 13.13, 1",
    "p, AL , 258.8000000, 60.8900000, 19.1400000, 6.8810000, 2.5740000, 0.9572000, 0.2099000, 0.0598600, 0.0153000",
    "c, 1.7, 0.406847D-02, 0.306815D-01, 0.129149D+00, 0.320831D+00, 0.453815D+00, 0.275066D+00, 0.190807D-01",
    "c, 1.7, -0.748053D-03, -0.545796D-02, -0.245371D-01, -0.582138D-01, -0.983756D-01, -0.260064D-01, 0.464020D+00",
    "c, 8.8, 1",
    "c, 9.9, 1",
    "d, AL , 0.1890000",
    "c, 1.1, 1",
    "! SILICON       (13s,9p,2d) -> [5s,4p,2d]",
    "! SILICON       (12s,8p,1d) -> [4s,3p,1d]",
    "! SILICON       (1s,1p,1d)",
    "s, SI , 78860.0000000, 11820.0000000, 2692.0000000, 763.4000000, 249.6000000, 90.2800000, 35.2900000, 14.5100000, 4.0530000, 1.4820000, 0.2517000, 0.0924300, 0.0332000",
    "c, 1.11, 0.270443D-03, 0.209717D-02, 0.108506D-01, 0.436754D-01, 0.137653D+00, 0.316644D+00, 0.418581D+00, 0.210212D+00, 0.144952D-01, -0.203590D-02, 0.624186D-03",
    "c, 1.11, -0.723177D-04, -0.555116D-03, -0.293805D-02, -0.117687D-01, -0.402907D-01, -0.100609D+00, -0.196528D+00, -0.102382D+00, 0.527190D+00, 0.593251D+00, 0.332652D-01",
    "c, 1.11, 0.185113D-04, 0.142236D-03, 0.752185D-03, 0.302279D-02, 0.103677D-01, 0.262563D-01, 0.523989D-01, 0.290959D-01, -0.178003D+00, -0.346874D+00, 0.623020D+00",
    "c, 12.12, 1",
    "c, 13.13, 1",
    "p, SI , 315.9000000, 74.4200000, 23.4800000, 8.4880000, 3.2170000, 1.2290000, 0.2964000, 0.0876800, 0.0250000",
    "c, 1.7, 0.392656D-02, 0.298811D-01, 0.127212D+00, 0.320943D+00, 0.455429D+00, 0.268563D+00, 0.188336D-01",
    "c, 1.7, -0.858302D-03, -0.630328D-02, -0.288255D-01, -0.694560D-01, -0.119493D+00, -0.199581D-01, 0.510268D+00",
    "c, 8.8, 1",
    "c, 9.9, 1",
    "d, SI , 0.2750000",
    "c, 1.1, 1",
    "! PHOSPHOROUS       (13s,9p,2d) -> [5s,4p,2d]",
    "! PHOSPHOROUS       (12s,8p,1d) -> [4s,3p,1d]",
    "! PHOSPHOROUS       (1s,1p,1d)",
    "s, P , 94840.0000000, 14220.0000000, 3236.0000000, 917.1000000, 299.5000000, 108.1000000, 42.1800000, 17.2800000, 4.8580000, 1.8180000, 0.3372000, 0.1232000, 0.0417000",
    "c, 1.11, 0.255509D-03, 0.198193D-02, 0.102760D-01, 0.414823D-01, 0.131984D+00, 0.308662D+00, 0.420647D+00, 0.222878D+00, 0.164035D-01, -0.254255D-02, 0.748050D-03",
    "c, 1.11, -0.696939D-04, -0.535266D-03, -0.283709D-02, -0.113983D-01, -0.392929D-01, -0.996364D-01, -0.197983D+00, -0.114860D+00, 0.518595D+00, 0.601847D+00, 0.368612D-01",
    "c, 1.11, 0.191199D-04, 0.147223D-03, 0.777912D-03, 0.314546D-02, 0.108200D-01, 0.279957D-01, 0.563978D-01, 0.358190D-01, -0.193387D+00, -0.372097D+00, 0.624246D+00",
    "c, 12.12, 1",
    "c, 13.13, 1",
    "p, P , 370.5000000, 87.3300000, 27.5900000, 10.0000000, 3.8250000, 1.4940000, 0.3921000, 0.1186000, 0.0343000",
    "c, 1.7, 0.395005D-02, 0.302492D-01, 0.129554D+00, 0.327594D+00, 0.456992D+00, 0.253086D+00, 0.168798D-01",
    "c, 1.7, -0.959832D-03, -0.711177D-02, -0.327122D-01, -0.795784D-01, -0.135016D+00, -0.910585D-02, 0.537802D+00",
    "c, 8.8, 1",
    "c, 9.9, 1",
    "d, P , 0.3730000",
    "c, 1.1, 1",
    "! SULFUR       (13s,9p,2d) -> [5s,4p,2d]",
    "! SULFUR       (12s,8p,1d) -> [4s,3p,1d]",
    "! SULFUR       (1s,1p,1d)",
    "s, S , 110800.0000000, 16610.0000000, 3781.0000000, 1071.0000000, 349.8000000, 126.3000000, 49.2600000, 20.1600000, 5.7200000, 2.1820000, 0.4327000, 0.1570000, 0.0507000",
    "c, 1.11, 0.247635D-03, 0.192026D-02, 0.996192D-02, 0.402975D-01, 0.128604D+00, 0.303480D+00, 0.421432D+00, 0.230781D+00, 0.178971D-01, -0.297516D-02, 0.849522D-03",
    "c, 1.11, -0.687039D-04, -0.527681D-03, -0.279671D-02, -0.112651D-01, -0.388834D-01, -0.995025D-01, -0.199740D+00, -0.123360D+00, 0.513194D+00, 0.607120D+00, 0.396753D-01",
    "c, 1.11, 0.199077D-04, 0.153483D-03, 0.809503D-03, 0.328974D-02, 0.112967D-01, 0.296385D-01, 0.599851D-01, 0.413248D-01, -0.207474D+00, -0.392889D+00, 0.632840D+00",
    "c, 12.12, 1",
    "c, 13.13, 1",
    "p, S , 399.7000000, 94.1900000, 29.7500000, 10.7700000, 4.1190000, 1.6250000, 0.4726000, 0.1407000, 0.0399000",
    "c, 1.7, 0.447541D-02, 0.341708D-01, 0.144250D+00, 0.353928D+00, 0.459085D+00, 0.206383D+00, 0.102141D-01",
    "c, 1.7, -0.116251D-02, -0.865664D-02, -0.390886D-01, -0.934625D-01, -0.147994D+00, 0.301904D-01, 0.561573D+00",
    "c, 8.8, 1",
    "c, 9.9, 1",
    "d, S , 0.4790000",
    "c, 1.1, 1",
    "! CHLORINE       (13s,9p,2d) -> [5s,4p,2d]",
    "! CHLORINE       (12s,8p,1d) -> [4s,3p,1d]",
    "! CHLORINE       (1s,1p,1d)",
    "s, CL , 127900.0000000, 19170.0000000, 4363.0000000, 1236.0000000, 403.6000000, 145.7000000, 56.8100000, 23.2300000, 6.6440000, 2.5750000, 0.5371000, 0.1938000, 0.0608000",
    "c, 1.11, 0.241153D-03, 0.187095D-02, 0.970827D-02, 0.393153D-01, 0.125932D+00, 0.299341D+00, 0.421886D+00, 0.237201D+00, 0.191531D-01, -0.334792D-02, 0.929883D-03",
    "c, 1.11, -0.678922D-04, -0.521836D-03, -0.276513D-02, -0.111537D-01, -0.385919D-01, -0.994848D-01, -0.201392D+00, -0.130313D+00, 0.509443D+00, 0.610725D+00, 0.421549D-01",
    "c, 1.11, 0.204986D-04, 0.158298D-03, 0.833639D-03, 0.339880D-02, 0.116738D-01, 0.309622D-01, 0.629533D-01, 0.460257D-01, -0.219312D+00, -0.408773D+00, 0.638465D+00",
    "c, 12.12, 1",
    "c, 13.13, 1",
    "p, CL , 417.6000000, 98.3300000, 31.0400000, 11.1900000, 4.2490000, 1.6240000, 0.5322000, 0.1620000, 0.0466000",
    "c, 1.7, 0.525982D-02, 0.398332D-01, 0.164655D+00, 0.387322D+00, 0.457072D+00, 0.151636D+00, 0.181615D-02",
    "c, 1.7, -0.143570D-02, -0.107796D-01, -0.470075D-01, -0.111030D+00, -0.153275D+00, 0.894609D-01, 0.579444D+00",
    "c, 8.8, 1",
    "c, 9.9, 1",
    "d, CL , 0.6000000",
    "c, 1.1, 1",
    "! ARGON       (13s,9p,2d) -> [5s,4p,2d]",
    "! ARGON       (12s,8p,1d) -> [4s,3p,1d]",
    "! ARGON       (1s,1p,1d)",
    "s, AR , 145700.0000000, 21840.0000000, 4972.0000000, 1408.0000000, 459.7000000, 165.9000000, 64.6900000, 26.4400000, 7.6280000, 2.9960000, 0.6504000, 0.2337000, 0.0709000",
    "c, 1.11, 0.236700D-03, 0.183523D-02, 0.952860D-02, 0.386283D-01, 0.124081D+00, 0.296471D+00, 0.422068D+00, 0.241711D+00, 0.200509D-01, -0.361000D-02, 0.975607D-03",
    "c, 1.11, -0.674910D-04, -0.518522D-03, -0.274825D-02, -0.111007D-01, -0.384820D-01, -0.997599D-01, -0.203088D+00, -0.135608D+00, 0.507195D+00, 0.612898D+00, 0.442968D-01",
    "c, 1.11, 0.210457D-04, 0.162565D-03, 0.855463D-03, 0.349745D-02, 0.120156D-01, 0.321368D-01, 0.655279D-01, 0.499370D-01, -0.229769D+00, -0.421006D+00, 0.642331D+00",
    "c, 12.12, 1",
    "c, 13.13, 1",
    "p, AR , 453.7000000, 106.8000000, 33.7300000, 12.1300000, 4.5940000, 1.6780000, 0.5909000, 0.1852000, 0.0533000",
    "c, 1.7, 0.570555D-02, 0.430460D-01, 0.176591D+00, 0.406863D+00, 0.452549D+00, 0.122801D+00, -0.445996D-02",
    "c, 1.7, -0.160655D-02, -0.121714D-01, -0.520789D-01, -0.123737D+00, -0.151619D+00, 0.142425D+00, 0.584501D+00",
    "c, 8.8, 1",
    "c, 9.9, 1",
    "d, AR , 0.7380000",
    "c, 1.1, 1",
    ],

'jul-cc-pvtz': [
    "! #####################",
    "! ##                 ##",
    "! ##   jul-cc-pVTZ   ##",
    "! ##                 ##",
    "! #####################",
    "!",
    "! HYDROGEN       (6s,3p,2d) -> [4s,3p,2d]",
    "! HYDROGEN       (5s,2p,1d) -> [3s,2p,1d]",
    "! HYDROGEN       (1s,1p,1d)",
    "s, H , 33.8700000, 5.0950000, 1.1590000, 0.3258000, 0.1027000",
    "c, 1.3, 0.0060680, 0.0453080, 0.2028220",
    "c, 4.4, 1",
    "c, 5.5, 1",
    "p, H , 1.4070000, 0.3880000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "d, H , 1.0570000",
    "c, 1.1, 1",
    "! HELIUM       (7s,3p,2d) -> [4s,3p,2d]",
    "! HELIUM       (6s,2p,1d) -> [3s,2p,1d]",
    "! HELIUM       (1s,1p,1d)",
    "s, HE , 234.0000000, 35.1600000, 7.9890000, 2.2120000, 0.6669000, 0.2089000",
    "c, 1.4, 0.0025870, 0.0195330, 0.0909980, 0.2720500",
    "c, 5.5, 1",
    "c, 6.6, 1",
    "p, HE , 3.0440000, 0.7580000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "d, HE , 1.9650000",
    "c, 1.1, 1",
    "! LITHIUM       (12s,6p,3d,2f) -> [5s,4p,3d,2f]",
    "! LITHIUM       (11s,5p,2d,1f) -> [4s,3p,2d,1f]",
    "! LITHIUM       (1s,1p,1d,1f)",
    "s, LI , 5988.0000000, 898.9000000, 205.9000000, 59.2400000, 19.8700000, 7.4060000, 2.9300000, 1.1890000, 0.4798000, 0.0750900, 0.0283200, 0.0076000",
    "c, 1.9, 0.0001330, 0.0010250, 0.0052720, 0.0209290, 0.0663400, 0.1657750, 0.3150380, 0.3935230, 0.1908700",
    "c, 1.9, -0.0000210, -0.0001610, -0.0008200, -0.0033260, -0.0105190, -0.0280970, -0.0559360, -0.0992370, -0.1121890",
    "c, 10.10, 1",
    "c, 11.11, 1",
    "c, 12.12, 1",
    "p, LI , 3.2660000, 0.6511000, 0.1696000, 0.0557800, 0.0205000, 0.0091000",
    "c, 1.3, 0.0086300, 0.0475380, 0.2097720",
    "c, 4.4, 1",
    "c, 5.5, 1",
    "c, 6.6, 1",
    "d, LI , 0.1874000, 0.0801000, 0.0371000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "f, LI , 0.1829000, 0.0816000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "! BERYLLIUM       (12s,6p,3d,2f) -> [5s,4p,3d,2f]",
    "! BERYLLIUM       (11s,5p,2d,1f) -> [4s,3p,2d,1f]",
    "! BERYLLIUM       (1s,1p,1d,1f)",
    "s, BE , 6863.0000000, 1030.0000000, 234.7000000, 66.5600000, 21.6900000, 7.7340000, 2.9160000, 1.1300000, 0.1101000, 0.2577000, 0.0440900, 0.0150300",
    "c, 1.9, 0.0002360, 0.0018260, 0.0094520, 0.0379570, 0.1199650, 0.2821620, 0.4274040, 0.2662780, -0.0072750",
    "c, 1.9, -0.0000430, -0.0003330, -0.0017360, -0.0070120, -0.0231260, -0.0581380, -0.1145560, -0.1359080, 0.5774410",
    "c, 10.10, 1",
    "c, 11.11, 1",
    "c, 12.12, 1",
    "p, BE , 7.4360000, 1.5770000, 0.4352000, 0.1438000, 0.0499400, 0.0070600",
    "c, 1.3, 0.0107360, 0.0628540, 0.2481800",
    "c, 4.4, 1",
    "c, 5.5, 1",
    "c, 6.6, 1",
    "d, BE , 0.3480000, 0.1803000, 0.0654000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "f, BE , 0.3250000, 0.1533000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "! BORON       (11s,6p,3d,2f) -> [5s,4p,3d,2f]",
    "! BORON       (10s,5p,2d,1f) -> [4s,3p,2d,1f]",
    "! BORON       (1s,1p,1d,1f)",
    "s, B , 5473.0000000, 820.9000000, 186.8000000, 52.8300000, 17.0800000, 5.9990000, 2.2080000, 0.2415000, 0.5879000, 0.0861000, 0.0291400",
    "c, 1.8, 0.0005550, 0.0042910, 0.0219490, 0.0844410, 0.2385570, 0.4350720, 0.3419550, -0.0095450",
    "c, 1.8, -0.0001120, -0.0008680, -0.0044840, -0.0176830, -0.0536390, -0.1190050, -0.1658240, 0.5959810",
    "c, 9.9, 1",
    "c, 10.10, 1",
    "c, 11.11, 1",
    "p, B , 12.0500000, 2.6130000, 0.7475000, 0.2385000, 0.0769800, 0.0209600",
    "c, 1.3, 0.0131180, 0.0798960, 0.2772750",
    "c, 4.4, 1",
    "c, 5.5, 1",
    "c, 6.6, 1",
    "d, B , 0.6610000, 0.1990000, 0.0604000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "f, B , 0.4900000, 0.1630000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "! CARBON       (11s,6p,3d,2f) -> [5s,4p,3d,2f]",
    "! CARBON       (10s,5p,2d,1f) -> [4s,3p,2d,1f]",
    "! CARBON       (1s,1p,1d,1f)",
    "s, C , 8236.0000000, 1235.0000000, 280.8000000, 79.2700000, 25.5900000, 8.9970000, 3.3190000, 0.3643000, 0.9059000, 0.1285000, 0.0440200",
    "c, 1.8, 0.0005310, 0.0041080, 0.0210870, 0.0818530, 0.2348170, 0.4344010, 0.3461290, -0.0089830",
    "c, 1.8, -0.0001130, -0.0008780, -0.0045400, -0.0181330, -0.0557600, -0.1268950, -0.1703520, 0.5986840",
    "c, 9.9, 1",
    "c, 10.10, 1",
    "c, 11.11, 1",
    "p, C , 18.7100000, 4.1330000, 1.2000000, 0.3827000, 0.1209000, 0.0356900",
    "c, 1.3, 0.0140310, 0.0868660, 0.2902160",
    "c, 4.4, 1",
    "c, 5.5, 1",
    "c, 6.6, 1",
    "d, C , 1.0970000, 0.3180000, 0.1000000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "f, C , 0.7610000, 0.2680000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "! NITROGEN       (11s,6p,3d,2f) -> [5s,4p,3d,2f]",
    "! NITROGEN       (10s,5p,2d,1f) -> [4s,3p,2d,1f]",
    "! NITROGEN       (1s,1p,1d,1f)",
    "s, N , 11420.0000000, 1712.0000000, 389.3000000, 110.0000000, 35.5700000, 12.5400000, 4.6440000, 0.5118000, 1.2930000, 0.1787000, 0.0576000",
    "c, 1.8, 0.0005230, 0.0040450, 0.0207750, 0.0807270, 0.2330740, 0.4335010, 0.3474720, -0.0085080",
    "c, 1.8, -0.0001150, -0.0008950, -0.0046240, -0.0185280, -0.0573390, -0.1320760, -0.1725100, 0.5999440",
    "c, 9.9, 1",
    "c, 10.10, 1",
    "c, 11.11, 1",
    "p, N , 26.6300000, 5.9480000, 1.7420000, 0.5550000, 0.1725000, 0.0491000",
    "c, 1.3, 0.0146700, 0.0917640, 0.2986830",
    "c, 4.4, 1",
    "c, 5.5, 1",
    "c, 6.6, 1",
    "d, N , 1.6540000, 0.4690000, 0.1510000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "f, N , 1.0930000, 0.3640000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "! OXYGEN       (11s,6p,3d,2f) -> [5s,4p,3d,2f]",
    "! OXYGEN       (10s,5p,2d,1f) -> [4s,3p,2d,1f]",
    "! OXYGEN       (1s,1p,1d,1f)",
    "s, O , 15330.0000000, 2299.0000000, 522.4000000, 147.3000000, 47.5500000, 16.7600000, 6.2070000, 0.6882000, 1.7520000, 0.2384000, 0.0737600",
    "c, 1.8, 0.0005080, 0.0039290, 0.0202430, 0.0791810, 0.2306870, 0.4331180, 0.3502600, -0.0081540",
    "c, 1.8, -0.0001150, -0.0008950, -0.0046360, -0.0187240, -0.0584630, -0.1364630, -0.1757400, 0.6034180",
    "c, 9.9, 1",
    "c, 10.10, 1",
    "c, 11.11, 1",
    "p, O , 34.4600000, 7.7490000, 2.2800000, 0.7156000, 0.2140000, 0.0597400",
    "c, 1.3, 0.0159280, 0.0997400, 0.3104920",
    "c, 4.4, 1",
    "c, 5.5, 1",
    "c, 6.6, 1",
    "d, O , 2.3140000, 0.6450000, 0.2140000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "f, O , 1.4280000, 0.5000000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "! FLUORINE       (11s,6p,3d,2f) -> [5s,4p,3d,2f]",
    "! FLUORINE       (10s,5p,2d,1f) -> [4s,3p,2d,1f]",
    "! FLUORINE       (1s,1p,1d,1f)",
    "s, F , 19500.0000000, 2923.0000000, 664.5000000, 187.5000000, 60.6200000, 21.4200000, 7.9500000, 0.8815000, 2.2570000, 0.3041000, 0.0915800",
    "c, 1.8, 0.0005070, 0.0039230, 0.0202000, 0.0790100, 0.2304390, 0.4328720, 0.3499640, -0.0078920",
    "c, 1.8, -0.0001170, -0.0009120, -0.0047170, -0.0190860, -0.0596550, -0.1400100, -0.1767820, 0.6050430",
    "c, 9.9, 1",
    "c, 10.10, 1",
    "c, 11.11, 1",
    "p, F , 43.8800000, 9.9260000, 2.9300000, 0.9132000, 0.2672000, 0.0736100",
    "c, 1.3, 0.0166650, 0.1044720, 0.3172600",
    "c, 4.4, 1",
    "c, 5.5, 1",
    "c, 6.6, 1",
    "d, F , 3.1070000, 0.8550000, 0.2920000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "f, F , 1.9170000, 0.7240000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "! NEON       (11s,6p,3d,2f) -> [5s,4p,3d,2f]",
    "! NEON       (10s,5p,2d,1f) -> [4s,3p,2d,1f]",
    "! NEON       (1s,1p,1d,1f)",
    "s, NE , 24350.0000000, 3650.0000000, 829.6000000, 234.0000000, 75.6100000, 26.7300000, 9.9270000, 1.1020000, 2.8360000, 0.3782000, 0.1133000",
    "c, 1.8, 0.0005020, 0.0038810, 0.0199970, 0.0784180, 0.2296760, 0.4327220, 0.3506420, -0.0076450",
    "c, 1.8, -0.0001180, -0.0009150, -0.0047370, -0.0192330, -0.0603690, -0.1425080, -0.1777100, 0.6058360",
    "c, 9.9, 1",
    "c, 10.10, 1",
    "c, 11.11, 1",
    "p, NE , 54.7000000, 12.4300000, 3.6790000, 1.1430000, 0.3300000, 0.0917500",
    "c, 1.3, 0.0171510, 0.1076560, 0.3216810",
    "c, 4.4, 1",
    "c, 5.5, 1",
    "c, 6.6, 1",
    "d, NE , 4.0140000, 1.0960000, 0.3860000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "f, NE , 2.5440000, 1.0840000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "! SODIUM       (17s,11p,3d,2f) -> [6s,5p,3d,2f]",
    "! SODIUM       (16s,10p,2d,1f) -> [5s,4p,2d,1f]",
    "! SODIUM       (1s,1p,1d,1f)",
    "s, NA , 423000.0000000, 63340.0000000, 14410.0000000, 4077.0000000, 1328.0000000, 478.6000000, 186.2000000, 76.9200000, 33.3200000, 15.0000000, 6.8690000, 2.6830000, 1.1090000, 0.0601500, 0.4540000, 0.0238200, 0.0066500",
    "c, 1.14, 0.180618D-04, 0.140430D-03, 0.738438D-03, 0.311182D-02, 0.112081D-01, 0.352828D-01, 0.959897D-01, 0.213735D+00, 0.348688D+00, 0.324566D+00, 0.112633D+00, 0.706797D-02, 0.598010D-03, -0.530870D-05",
    "c, 1.14, -0.440653D-05, -0.343443D-04, -0.180114D-03, -0.763900D-03, -0.275248D-02, -0.886016D-02, -0.247939D-01, -0.605995D-01, -0.116446D+00, -0.162437D+00, -0.438891D-01, 0.337917D+00, 0.561347D+00, 0.406754D-02",
    "c, 1.14, 0.663019D-06, 0.515769D-05, 0.271250D-04, 0.114635D-03, 0.415118D-03, 0.132978D-02, 0.375595D-02, 0.914025D-02, 0.179859D-01, 0.251477D-01, 0.763522D-02, -0.614589D-01, -0.115721D+00, 0.626406D+00",
    "c, 15.15, 1",
    "c, 16.16, 1",
    "c, 17.17, 1",
    "p, NA , 243.3000000, 57.3900000, 18.1000000, 6.5750000, 2.5210000, 0.9607000, 0.3512000, 0.0982700, 0.0373400, 0.0150000, 0.0070000",
    "c, 1.8, 0.224392D-02, 0.173997D-01, 0.774125D-01, 0.219102D+00, 0.378522D+00, 0.394902D+00, 0.160424D+00, 0.233311D-02",
    "c, 1.8, -0.222401D-03, -0.174277D-02, -0.775456D-02, -0.225187D-01, -0.384330D-01, -0.450177D-01, -0.192132D-01, 0.182697D+00",
    "c, 9.9, 1",
    "c, 10.10, 1",
    "c, 11.11, 1",
    "d, NA , 0.1367000, 0.0636000, 0.0223000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "f, NA , 0.1397000, 0.0714000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "! MAGNESIUM       (16s,11p,3d,2f) -> [6s,5p,3d,2f]",
    "! MAGNESIUM       (15s,10p,2d,1f) -> [5s,4p,2d,1f]",
    "! MAGNESIUM       (1s,1p,1d,1f)",
    "s, MG , 164900.0000000, 24710.0000000, 5628.0000000, 1596.0000000, 521.0000000, 188.0000000, 73.0100000, 29.9000000, 12.5400000, 4.3060000, 1.8260000, 0.7417000, 0.0761200, 0.1457000, 0.0331000, 0.0129000",
    "c, 1.13, 0.729929D-04, 0.566652D-03, 0.296269D-02, 0.122962D-01, 0.427324D-01, 0.123013D+00, 0.274832D+00, 0.401818D+00, 0.264697D+00, 0.332612D-01, -0.441335D-02, 0.206024D-02, 0.708195D-03",
    "c, 1.13, -0.184248D-04, -0.143500D-03, -0.748710D-03, -0.314407D-02, -0.110481D-01, -0.336058D-01, -0.825946D-01, -0.159314D+00, -0.152888D+00, 0.190849D+00, 0.579964D+00, 0.372029D+00, -0.119344D-01",
    "c, 1.13, 0.355176D-05, 0.276420D-04, 0.144404D-03, 0.605744D-03, 0.213527D-02, 0.649934D-02, 0.161446D-01, 0.315766D-01, 0.316374D-01, -0.439140D-01, -0.151093D+00, -0.217668D+00, 0.547245D+00",
    "c, 14.14, 1",
    "c, 15.15, 1",
    "c, 16.16, 1",
    "p, MG , 316.9000000, 74.8600000, 23.7200000, 8.6690000, 3.3630000, 1.3100000, 0.4911000, 0.2364000, 0.0873300, 0.0323700, 0.0074500",
    "c, 1.8, 0.207532D-02, 0.162869D-01, 0.738697D-01, 0.214297D+00, 0.382154D+00, 0.398178D+00, 0.152878D+00, -0.437540D-02",
    "c, 1.8, -0.329727D-03, -0.258754D-02, -0.119120D-01, -0.350227D-01, -0.639968D-01, -0.704436D-01, -0.375836D-01, 0.177043D+00",
    "c, 9.9, 1",
    "c, 10.10, 1",
    "c, 11.11, 1",
    "d, MG , 0.1260000, 0.2940000, 0.0468000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "f, MG , 0.2520000, 0.0940000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "! ALUMINUM       (16s,10p,3d,2f) -> [6s,5p,3d,2f]",
    "! ALUMINUM       (15s,9p,2d,1f) -> [5s,4p,2d,1f]",
    "! ALUMINUM       (1s,1p,1d,1f)",
    "s, AL , 205500.0000000, 30780.0000000, 7006.0000000, 1985.0000000, 649.1000000, 235.0000000, 91.6200000, 37.6700000, 15.9100000, 5.8500000, 2.5420000, 1.0570000, 0.1455000, 0.2931000, 0.0565000, 0.0221000",
    "c, 1.13, 0.678836D-04, 0.527149D-03, 0.276203D-02, 0.114728D-01, 0.398188D-01, 0.115040D+00, 0.260887D+00, 0.396386D+00, 0.284597D+00, 0.444583D-01, -0.489838D-02, 0.261253D-02, 0.722068D-03",
    "c, 1.13, -0.176377D-04, -0.137195D-03, -0.718910D-03, -0.301146D-02, -0.106014D-01, -0.321345D-01, -0.803156D-01, -0.156794D+00, -0.168376D+00, 0.126879D+00, 0.561494D+00, 0.436613D+00, -0.114563D-01",
    "c, 1.13, 0.407315D-05, 0.316566D-04, 0.166116D-03, 0.694992D-03, 0.245511D-02, 0.744598D-02, 0.188253D-01, 0.372772D-01, 0.419496D-01, -0.354375D-01, -0.175132D+00, -0.276203D+00, 0.652809D+00",
    "c, 14.14, 1",
    "c, 15.15, 1",
    "c, 16.16, 1",
    "p, AL , 444.4000000, 105.1000000, 33.4700000, 12.3300000, 4.8690000, 1.9610000, 0.1888000, 0.7834000, 0.0555700, 0.0146000",
    "c, 1.7, 0.162786D-02, 0.130687D-01, 0.612341D-01, 0.187870D+00, 0.360452D+00, 0.408454D+00, 0.976514D-02",
    "c, 1.7, -0.286341D-03, -0.242308D-02, -0.108658D-01, -0.364307D-01, -0.641074D-01, -0.972239D-01, 0.503448D+00",
    "c, 8.8, 1",
    "c, 9.9, 1",
    "c, 10.10, 1",
    "d, AL , 0.1090000, 0.3330000, 0.0356000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "f, AL , 0.2440000, 0.0858000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "! SILICON       (16s,10p,3d,2f) -> [6s,5p,3d,2f]",
    "! SILICON       (15s,9p,2d,1f) -> [5s,4p,2d,1f]",
    "! SILICON       (1s,1p,1d,1f)",
    "s, SI , 254900.0000000, 38190.0000000, 8690.0000000, 2462.0000000, 804.8000000, 291.3000000, 113.6000000, 46.7500000, 19.8200000, 7.7080000, 3.3400000, 1.4020000, 0.2070000, 0.4387000, 0.0794400, 0.0330000",
    "c, 1.13, 0.625101D-04, 0.485553D-03, 0.254516D-02, 0.105866D-01, 0.368787D-01, 0.107479D+00, 0.247936D+00, 0.390927D+00, 0.302026D+00, 0.559236D-01, -0.402406D-02, 0.258030D-02, 0.607930D-03",
    "c, 1.13, -0.166370D-04, -0.129310D-03, -0.678828D-03, -0.284117D-02, -0.100551D-01, -0.305774D-01, -0.777256D-01, -0.154236D+00, -0.180368D+00, 0.798218D-01, 0.547441D+00, 0.480119D+00, -0.106996D-01",
    "c, 1.13, 0.426257D-05, 0.331062D-04, 0.174015D-03, 0.727574D-03, 0.258333D-02, 0.786354D-02, 0.202155D-01, 0.407320D-01, 0.499358D-01, -0.249396D-01, -0.190350D+00, -0.318350D+00, 0.681180D+00",
    "c, 14.14, 1",
    "c, 15.15, 1",
    "c, 16.16, 1",
    "p, SI , 481.5000000, 113.9000000, 36.2300000, 13.3400000, 5.2520000, 2.1200000, 0.2528000, 0.8561000, 0.0788900, 0.0237000",
    "c, 1.7, 0.192045D-02, 0.153552D-01, 0.713991D-01, 0.213052D+00, 0.390354D+00, 0.393721D+00, 0.395630D-02",
    "c, 1.7, -0.405220D-03, -0.335896D-02, -0.152860D-01, -0.489218D-01, -0.855008D-01, -0.112137D+00, 0.551919D+00",
    "c, 8.8, 1",
    "c, 9.9, 1",
    "c, 10.10, 1",
    "d, SI , 0.1590000, 0.4810000, 0.0556000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "f, SI , 0.3360000, 0.1250000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "! PHOSPHOROUS       (16s,10p,3d,2f) -> [6s,5p,3d,2f]",
    "! PHOSPHOROUS       (15s,9p,2d,1f) -> [5s,4p,2d,1f]",
    "! PHOSPHOROUS       (1s,1p,1d,1f)",
    "s, P , 312400.0000000, 46800.0000000, 10650.0000000, 3018.0000000, 986.8000000, 357.4000000, 139.6000000, 57.6300000, 24.6000000, 10.1200000, 4.2830000, 1.8050000, 0.2782000, 0.6158000, 0.1055000, 0.0409000",
    "c, 1.13, 0.576960D-04, 0.448296D-03, 0.234939D-02, 0.978265D-02, 0.341467D-01, 0.100204D+00, 0.234372D+00, 0.382434D+00, 0.318088D+00, 0.707788D-01, -0.181799D-02, 0.216180D-02, 0.432297D-03",
    "c, 1.13, -0.156709D-04, -0.121724D-03, -0.639672D-03, -0.267426D-02, -0.949831D-02, -0.289349D-01, -0.745121D-01, -0.149938D+00, -0.189467D+00, 0.363270D-01, 0.528816D+00, 0.519115D+00, -0.925695D-02",
    "c, 1.13, 0.430631D-05, 0.334194D-04, 0.175885D-03, 0.734340D-03, 0.261775D-02, 0.797852D-02, 0.207940D-01, 0.424446D-01, 0.563436D-01, -0.127358D-01, -0.196495D+00, -0.353555D+00, 0.700912D+00",
    "c, 14.14, 1",
    "c, 15.15, 1",
    "c, 16.16, 1",
    "p, P , 504.9000000, 119.4000000, 37.9600000, 13.9500000, 5.4570000, 2.1770000, 0.2877000, 0.8010000, 0.0971400, 0.0307000",
    "c, 1.7, 0.233728D-02, 0.185410D-01, 0.849693D-01, 0.244615D+00, 0.422766D+00, 0.368439D+00, -0.379005D-02",
    "c, 1.7, -0.555236D-03, -0.445913D-02, -0.206350D-01, -0.617694D-01, -0.108924D+00, -0.105599D+00, 0.576981D+00",
    "c, 8.8, 1",
    "c, 9.9, 1",
    "c, 10.10, 1",
    "d, P , 0.2160000, 0.6520000, 0.0775000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "f, P , 0.4520000, 0.1650000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "! SULFUR       (16s,10p,3d,2f) -> [6s,5p,3d,2f]",
    "! SULFUR       (15s,9p,2d,1f) -> [5s,4p,2d,1f]",
    "! SULFUR       (1s,1p,1d,1f)",
    "s, S , 374100.0000000, 56050.0000000, 12760.0000000, 3615.0000000, 1183.0000000, 428.8000000, 167.8000000, 69.4700000, 29.8400000, 12.7200000, 5.2440000, 2.2190000, 0.3490000, 0.7767000, 0.1322000, 0.0497000",
    "c, 1.13, 0.542140D-04, 0.420855D-03, 0.220698D-02, 0.919258D-02, 0.321123D-01, 0.946683D-01, 0.223630D+00, 0.374393D+00, 0.329108D+00, 0.847038D-01, 0.440851D-03, 0.164827D-02, 0.301306D-03",
    "c, 1.13, -0.149837D-04, -0.116198D-03, -0.611583D-03, -0.255370D-02, -0.908708D-02, -0.277045D-01, -0.720020D-01, -0.146439D+00, -0.195150D+00, 0.819193D-02, 0.516601D+00, 0.542178D+00, -0.918072D-02",
    "c, 1.13, 0.435066D-05, 0.337140D-04, 0.177674D-03, 0.741116D-03, 0.264591D-02, 0.807487D-02, 0.212276D-01, 0.438323D-01, 0.612716D-01, -0.361510D-02, -0.204510D+00, -0.381871D+00, 0.714147D+00",
    "c, 14.14, 1",
    "c, 15.15, 1",
    "c, 16.16, 1",
    "p, S , 574.4000000, 135.8000000, 43.1900000, 15.8700000, 6.2080000, 2.4830000, 0.3229000, 0.8688000, 0.1098000, 0.0351000",
    "c, 1.7, 0.242264D-02, 0.192796D-01, 0.885401D-01, 0.254654D+00, 0.433984D+00, 0.354953D+00, -0.502977D-02",
    "c, 1.7, -0.620102D-03, -0.493882D-02, -0.232647D-01, -0.685195D-01, -0.123896D+00, -0.969499D-01, 0.569394D+00",
    "c, 8.8, 1",
    "c, 9.9, 1",
    "c, 10.10, 1",
    "d, S , 0.2690000, 0.8190000, 0.1010000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "f, S , 0.5570000, 0.2180000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "! CHLORINE       (16s,10p,3d,2f) -> [6s,5p,3d,2f]",
    "! CHLORINE       (15s,9p,2d,1f) -> [5s,4p,2d,1f]",
    "! CHLORINE       (1s,1p,1d,1f)",
    "s, CL , 456100.0000000, 68330.0000000, 15550.0000000, 4405.0000000, 1439.0000000, 520.4000000, 203.1000000, 83.9600000, 36.2000000, 15.8300000, 6.3340000, 2.6940000, 0.4313000, 0.9768000, 0.1625000, 0.0591000",
    "c, 1.13, 0.492970D-04, 0.383029D-03, 0.200854D-02, 0.838558D-02, 0.294703D-01, 0.878325D-01, 0.211473D+00, 0.365364D+00, 0.340884D+00, 0.102133D+00, 0.311675D-02, 0.105751D-02, 0.156136D-03",
    "c, 1.13, -0.138304D-04, -0.107279D-03, -0.565083D-03, -0.236135D-02, -0.845886D-02, -0.259638D-01, -0.686362D-01, -0.141874D+00, -0.199319D+00, -0.195662D-01, 0.499741D+00, 0.563736D+00, -0.835091D-02",
    "c, 1.13, 0.418546D-05, 0.324395D-04, 0.171105D-03, 0.714176D-03, 0.256705D-02, 0.788552D-02, 0.210867D-01, 0.442264D-01, 0.651670D-01, 0.603012D-02, -0.206495D+00, -0.405871D+00, 0.725661D+00",
    "c, 14.14, 1",
    "c, 15.15, 1",
    "c, 16.16, 1",
    "p, CL , 663.3000000, 156.8000000, 49.9800000, 18.4200000, 7.2400000, 2.9220000, 0.3818000, 1.0220000, 0.1301000, 0.0419000",
    "c, 1.7, 0.240448D-02, 0.192148D-01, 0.885097D-01, 0.256020D+00, 0.436927D+00, 0.350334D+00, -0.458423D-02",
    "c, 1.7, -0.652145D-03, -0.519445D-02, -0.246938D-01, -0.728167D-01, -0.134030D+00, -0.947742D-01, 0.564667D+00",
    "c, 8.8, 1",
    "c, 9.9, 1",
    "c, 10.10, 1",
    "d, CL , 1.0460000, 0.3440000, 0.1350000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "f, CL , 0.7060000, 0.3120000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "! ARGON       (16s,10p,3d,2f) -> [6s,5p,3d,2f]",
    "! ARGON       (15s,9p,2d,1f) -> [5s,4p,2d,1f]",
    "! ARGON       (1s,1p,1d,1f)",
    "s, AR , 545000.0000000, 81640.0000000, 18580.0000000, 5261.0000000, 1717.0000000, 619.9000000, 241.6000000, 99.7900000, 43.1500000, 19.1400000, 7.4880000, 3.2050000, 0.5204000, 1.1960000, 0.1954000, 0.0685000",
    "c, 1.13, 0.455828D-04, 0.354108D-03, 0.185797D-02, 0.776851D-02, 0.274232D-01, 0.823836D-01, 0.201230D+00, 0.356781D+00, 0.349563D+00, 0.118266D+00, 0.560190D-02, 0.483473D-03, 0.292025D-04",
    "c, 1.13, -0.129551D-04, -0.100428D-03, -0.529583D-03, -0.221396D-02, -0.796845D-02, -0.245803D-01, -0.657798D-01, -0.137942D+00, -0.201630D+00, -0.412834D-01, 0.484680D+00, 0.579224D+00, -0.727553D-02",
    "c, 1.13, 0.404990D-05, 0.313691D-04, 0.165646D-03, 0.691662D-03, 0.249790D-02, 0.771074D-02, 0.208714D-01, 0.443965D-01, 0.680224D-01, 0.141350D-01, -0.207489D+00, -0.425045D+00, 0.733627D+00",
    "c, 14.14, 1",
    "c, 15.15, 1",
    "c, 16.16, 1",
    "p, AR , 761.8000000, 180.2000000, 57.5000000, 21.2400000, 8.3880000, 3.4160000, 0.4523000, 1.2060000, 0.1545000, 0.0487000",
    "c, 1.7, 0.236976D-02, 0.190199D-01, 0.880807D-01, 0.256377D+00, 0.438711D+00, 0.347569D+00, -0.523882D-02",
    "c, 1.7, -0.667211D-03, -0.532717D-02, -0.255494D-01, -0.757197D-01, -0.141133D+00, -0.932768D-01, 0.562450D+00",
    "c, 8.8, 1",
    "c, 9.9, 1",
    "c, 10.10, 1",
    "d, AR , 0.4100000, 1.2540000, 0.1690000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "f, AR , 0.8900000, 0.4060000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    ],

'jun-cc-pvtz': [
    "! #####################",
    "! ##                 ##",
    "! ##   jun-cc-pVTZ   ##",
    "! ##                 ##",
    "! #####################",
    "!",
    "! HYDROGEN       (6s,3p,2d) -> [4s,3p,2d]",
    "! HYDROGEN       (5s,2p,1d) -> [3s,2p,1d]",
    "! HYDROGEN       (1s,1p,1d)",
    "s, H , 33.8700000, 5.0950000, 1.1590000, 0.3258000, 0.1027000",
    "c, 1.3, 0.0060680, 0.0453080, 0.2028220",
    "c, 4.4, 1",
    "c, 5.5, 1",
    "p, H , 1.4070000, 0.3880000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "d, H , 1.0570000",
    "c, 1.1, 1",
    "! HELIUM       (7s,3p,2d) -> [4s,3p,2d]",
    "! HELIUM       (6s,2p,1d) -> [3s,2p,1d]",
    "! HELIUM       (1s,1p,1d)",
    "s, HE , 234.0000000, 35.1600000, 7.9890000, 2.2120000, 0.6669000, 0.2089000",
    "c, 1.4, 0.0025870, 0.0195330, 0.0909980, 0.2720500",
    "c, 5.5, 1",
    "c, 6.6, 1",
    "p, HE , 3.0440000, 0.7580000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "d, HE , 1.9650000",
    "c, 1.1, 1",
    "! LITHIUM       (12s,6p,3d,2f) -> [5s,4p,3d,2f]",
    "! LITHIUM       (11s,5p,2d,1f) -> [4s,3p,2d,1f]",
    "! LITHIUM       (1s,1p,1d,1f)",
    "s, LI , 5988.0000000, 898.9000000, 205.9000000, 59.2400000, 19.8700000, 7.4060000, 2.9300000, 1.1890000, 0.4798000, 0.0750900, 0.0283200, 0.0076000",
    "c, 1.9, 0.0001330, 0.0010250, 0.0052720, 0.0209290, 0.0663400, 0.1657750, 0.3150380, 0.3935230, 0.1908700",
    "c, 1.9, -0.0000210, -0.0001610, -0.0008200, -0.0033260, -0.0105190, -0.0280970, -0.0559360, -0.0992370, -0.1121890",
    "c, 10.10, 1",
    "c, 11.11, 1",
    "c, 12.12, 1",
    "p, LI , 3.2660000, 0.6511000, 0.1696000, 0.0557800, 0.0205000, 0.0091000",
    "c, 1.3, 0.0086300, 0.0475380, 0.2097720",
    "c, 4.4, 1",
    "c, 5.5, 1",
    "c, 6.6, 1",
    "d, LI , 0.1874000, 0.0801000, 0.0371000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "f, LI , 0.1829000",
    "c, 1.1, 1",
    "! BERYLLIUM       (12s,6p,3d,2f) -> [5s,4p,3d,2f]",
    "! BERYLLIUM       (11s,5p,2d,1f) -> [4s,3p,2d,1f]",
    "! BERYLLIUM       (1s,1p,1d,1f)",
    "s, BE , 6863.0000000, 1030.0000000, 234.7000000, 66.5600000, 21.6900000, 7.7340000, 2.9160000, 1.1300000, 0.1101000, 0.2577000, 0.0440900, 0.0150300",
    "c, 1.9, 0.0002360, 0.0018260, 0.0094520, 0.0379570, 0.1199650, 0.2821620, 0.4274040, 0.2662780, -0.0072750",
    "c, 1.9, -0.0000430, -0.0003330, -0.0017360, -0.0070120, -0.0231260, -0.0581380, -0.1145560, -0.1359080, 0.5774410",
    "c, 10.10, 1",
    "c, 11.11, 1",
    "c, 12.12, 1",
    "p, BE , 7.4360000, 1.5770000, 0.4352000, 0.1438000, 0.0499400, 0.0070600",
    "c, 1.3, 0.0107360, 0.0628540, 0.2481800",
    "c, 4.4, 1",
    "c, 5.5, 1",
    "c, 6.6, 1",
    "d, BE , 0.3480000, 0.1803000, 0.0654000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "f, BE , 0.3250000",
    "c, 1.1, 1",
    "! BORON       (11s,6p,3d,2f) -> [5s,4p,3d,2f]",
    "! BORON       (10s,5p,2d,1f) -> [4s,3p,2d,1f]",
    "! BORON       (1s,1p,1d,1f)",
    "s, B , 5473.0000000, 820.9000000, 186.8000000, 52.8300000, 17.0800000, 5.9990000, 2.2080000, 0.2415000, 0.5879000, 0.0861000, 0.0291400",
    "c, 1.8, 0.0005550, 0.0042910, 0.0219490, 0.0844410, 0.2385570, 0.4350720, 0.3419550, -0.0095450",
    "c, 1.8, -0.0001120, -0.0008680, -0.0044840, -0.0176830, -0.0536390, -0.1190050, -0.1658240, 0.5959810",
    "c, 9.9, 1",
    "c, 10.10, 1",
    "c, 11.11, 1",
    "p, B , 12.0500000, 2.6130000, 0.7475000, 0.2385000, 0.0769800, 0.0209600",
    "c, 1.3, 0.0131180, 0.0798960, 0.2772750",
    "c, 4.4, 1",
    "c, 5.5, 1",
    "c, 6.6, 1",
    "d, B , 0.6610000, 0.1990000, 0.0604000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "f, B , 0.4900000",
    "c, 1.1, 1",
    "! CARBON       (11s,6p,3d,2f) -> [5s,4p,3d,2f]",
    "! CARBON       (10s,5p,2d,1f) -> [4s,3p,2d,1f]",
    "! CARBON       (1s,1p,1d,1f)",
    "s, C , 8236.0000000, 1235.0000000, 280.8000000, 79.2700000, 25.5900000, 8.9970000, 3.3190000, 0.3643000, 0.9059000, 0.1285000, 0.0440200",
    "c, 1.8, 0.0005310, 0.0041080, 0.0210870, 0.0818530, 0.2348170, 0.4344010, 0.3461290, -0.0089830",
    "c, 1.8, -0.0001130, -0.0008780, -0.0045400, -0.0181330, -0.0557600, -0.1268950, -0.1703520, 0.5986840",
    "c, 9.9, 1",
    "c, 10.10, 1",
    "c, 11.11, 1",
    "p, C , 18.7100000, 4.1330000, 1.2000000, 0.3827000, 0.1209000, 0.0356900",
    "c, 1.3, 0.0140310, 0.0868660, 0.2902160",
    "c, 4.4, 1",
    "c, 5.5, 1",
    "c, 6.6, 1",
    "d, C , 1.0970000, 0.3180000, 0.1000000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "f, C , 0.7610000",
    "c, 1.1, 1",
    "! NITROGEN       (11s,6p,3d,2f) -> [5s,4p,3d,2f]",
    "! NITROGEN       (10s,5p,2d,1f) -> [4s,3p,2d,1f]",
    "! NITROGEN       (1s,1p,1d,1f)",
    "s, N , 11420.0000000, 1712.0000000, 389.3000000, 110.0000000, 35.5700000, 12.5400000, 4.6440000, 0.5118000, 1.2930000, 0.1787000, 0.0576000",
    "c, 1.8, 0.0005230, 0.0040450, 0.0207750, 0.0807270, 0.2330740, 0.4335010, 0.3474720, -0.0085080",
    "c, 1.8, -0.0001150, -0.0008950, -0.0046240, -0.0185280, -0.0573390, -0.1320760, -0.1725100, 0.5999440",
    "c, 9.9, 1",
    "c, 10.10, 1",
    "c, 11.11, 1",
    "p, N , 26.6300000, 5.9480000, 1.7420000, 0.5550000, 0.1725000, 0.0491000",
    "c, 1.3, 0.0146700, 0.0917640, 0.2986830",
    "c, 4.4, 1",
    "c, 5.5, 1",
    "c, 6.6, 1",
    "d, N , 1.6540000, 0.4690000, 0.1510000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "f, N , 1.0930000",
    "c, 1.1, 1",
    "! OXYGEN       (11s,6p,3d,2f) -> [5s,4p,3d,2f]",
    "! OXYGEN       (10s,5p,2d,1f) -> [4s,3p,2d,1f]",
    "! OXYGEN       (1s,1p,1d,1f)",
    "s, O , 15330.0000000, 2299.0000000, 522.4000000, 147.3000000, 47.5500000, 16.7600000, 6.2070000, 0.6882000, 1.7520000, 0.2384000, 0.0737600",
    "c, 1.8, 0.0005080, 0.0039290, 0.0202430, 0.0791810, 0.2306870, 0.4331180, 0.3502600, -0.0081540",
    "c, 1.8, -0.0001150, -0.0008950, -0.0046360, -0.0187240, -0.0584630, -0.1364630, -0.1757400, 0.6034180",
    "c, 9.9, 1",
    "c, 10.10, 1",
    "c, 11.11, 1",
    "p, O , 34.4600000, 7.7490000, 2.2800000, 0.7156000, 0.2140000, 0.0597400",
    "c, 1.3, 0.0159280, 0.0997400, 0.3104920",
    "c, 4.4, 1",
    "c, 5.5, 1",
    "c, 6.6, 1",
    "d, O , 2.3140000, 0.6450000, 0.2140000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "f, O , 1.4280000",
    "c, 1.1, 1",
    "! FLUORINE       (11s,6p,3d,2f) -> [5s,4p,3d,2f]",
    "! FLUORINE       (10s,5p,2d,1f) -> [4s,3p,2d,1f]",
    "! FLUORINE       (1s,1p,1d,1f)",
    "s, F , 19500.0000000, 2923.0000000, 664.5000000, 187.5000000, 60.6200000, 21.4200000, 7.9500000, 0.8815000, 2.2570000, 0.3041000, 0.0915800",
    "c, 1.8, 0.0005070, 0.0039230, 0.0202000, 0.0790100, 0.2304390, 0.4328720, 0.3499640, -0.0078920",
    "c, 1.8, -0.0001170, -0.0009120, -0.0047170, -0.0190860, -0.0596550, -0.1400100, -0.1767820, 0.6050430",
    "c, 9.9, 1",
    "c, 10.10, 1",
    "c, 11.11, 1",
    "p, F , 43.8800000, 9.9260000, 2.9300000, 0.9132000, 0.2672000, 0.0736100",
    "c, 1.3, 0.0166650, 0.1044720, 0.3172600",
    "c, 4.4, 1",
    "c, 5.5, 1",
    "c, 6.6, 1",
    "d, F , 3.1070000, 0.8550000, 0.2920000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "f, F , 1.9170000",
    "c, 1.1, 1",
    "! NEON       (11s,6p,3d,2f) -> [5s,4p,3d,2f]",
    "! NEON       (10s,5p,2d,1f) -> [4s,3p,2d,1f]",
    "! NEON       (1s,1p,1d,1f)",
    "s, NE , 24350.0000000, 3650.0000000, 829.6000000, 234.0000000, 75.6100000, 26.7300000, 9.9270000, 1.1020000, 2.8360000, 0.3782000, 0.1133000",
    "c, 1.8, 0.0005020, 0.0038810, 0.0199970, 0.0784180, 0.2296760, 0.4327220, 0.3506420, -0.0076450",
    "c, 1.8, -0.0001180, -0.0009150, -0.0047370, -0.0192330, -0.0603690, -0.1425080, -0.1777100, 0.6058360",
    "c, 9.9, 1",
    "c, 10.10, 1",
    "c, 11.11, 1",
    "p, NE , 54.7000000, 12.4300000, 3.6790000, 1.1430000, 0.3300000, 0.0917500",
    "c, 1.3, 0.0171510, 0.1076560, 0.3216810",
    "c, 4.4, 1",
    "c, 5.5, 1",
    "c, 6.6, 1",
    "d, NE , 4.0140000, 1.0960000, 0.3860000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "f, NE , 2.5440000",
    "c, 1.1, 1",
    "! SODIUM       (17s,11p,3d,2f) -> [6s,5p,3d,2f]",
    "! SODIUM       (16s,10p,2d,1f) -> [5s,4p,2d,1f]",
    "! SODIUM       (1s,1p,1d,1f)",
    "s, NA , 423000.0000000, 63340.0000000, 14410.0000000, 4077.0000000, 1328.0000000, 478.6000000, 186.2000000, 76.9200000, 33.3200000, 15.0000000, 6.8690000, 2.6830000, 1.1090000, 0.0601500, 0.4540000, 0.0238200, 0.0066500",
    "c, 1.14, 0.180618D-04, 0.140430D-03, 0.738438D-03, 0.311182D-02, 0.112081D-01, 0.352828D-01, 0.959897D-01, 0.213735D+00, 0.348688D+00, 0.324566D+00, 0.112633D+00, 0.706797D-02, 0.598010D-03, -0.530870D-05",
    "c, 1.14, -0.440653D-05, -0.343443D-04, -0.180114D-03, -0.763900D-03, -0.275248D-02, -0.886016D-02, -0.247939D-01, -0.605995D-01, -0.116446D+00, -0.162437D+00, -0.438891D-01, 0.337917D+00, 0.561347D+00, 0.406754D-02",
    "c, 1.14, 0.663019D-06, 0.515769D-05, 0.271250D-04, 0.114635D-03, 0.415118D-03, 0.132978D-02, 0.375595D-02, 0.914025D-02, 0.179859D-01, 0.251477D-01, 0.763522D-02, -0.614589D-01, -0.115721D+00, 0.626406D+00",
    "c, 15.15, 1",
    "c, 16.16, 1",
    "c, 17.17, 1",
    "p, NA , 243.3000000, 57.3900000, 18.1000000, 6.5750000, 2.5210000, 0.9607000, 0.3512000, 0.0982700, 0.0373400, 0.0150000, 0.0070000",
    "c, 1.8, 0.224392D-02, 0.173997D-01, 0.774125D-01, 0.219102D+00, 0.378522D+00, 0.394902D+00, 0.160424D+00, 0.233311D-02",
    "c, 1.8, -0.222401D-03, -0.174277D-02, -0.775456D-02, -0.225187D-01, -0.384330D-01, -0.450177D-01, -0.192132D-01, 0.182697D+00",
    "c, 9.9, 1",
    "c, 10.10, 1",
    "c, 11.11, 1",
    "d, NA , 0.1367000, 0.0636000, 0.0223000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "f, NA , 0.1397000",
    "c, 1.1, 1",
    "! MAGNESIUM       (16s,11p,3d,2f) -> [6s,5p,3d,2f]",
    "! MAGNESIUM       (15s,10p,2d,1f) -> [5s,4p,2d,1f]",
    "! MAGNESIUM       (1s,1p,1d,1f)",
    "s, MG , 164900.0000000, 24710.0000000, 5628.0000000, 1596.0000000, 521.0000000, 188.0000000, 73.0100000, 29.9000000, 12.5400000, 4.3060000, 1.8260000, 0.7417000, 0.0761200, 0.1457000, 0.0331000, 0.0129000",
    "c, 1.13, 0.729929D-04, 0.566652D-03, 0.296269D-02, 0.122962D-01, 0.427324D-01, 0.123013D+00, 0.274832D+00, 0.401818D+00, 0.264697D+00, 0.332612D-01, -0.441335D-02, 0.206024D-02, 0.708195D-03",
    "c, 1.13, -0.184248D-04, -0.143500D-03, -0.748710D-03, -0.314407D-02, -0.110481D-01, -0.336058D-01, -0.825946D-01, -0.159314D+00, -0.152888D+00, 0.190849D+00, 0.579964D+00, 0.372029D+00, -0.119344D-01",
    "c, 1.13, 0.355176D-05, 0.276420D-04, 0.144404D-03, 0.605744D-03, 0.213527D-02, 0.649934D-02, 0.161446D-01, 0.315766D-01, 0.316374D-01, -0.439140D-01, -0.151093D+00, -0.217668D+00, 0.547245D+00",
    "c, 14.14, 1",
    "c, 15.15, 1",
    "c, 16.16, 1",
    "p, MG , 316.9000000, 74.8600000, 23.7200000, 8.6690000, 3.3630000, 1.3100000, 0.4911000, 0.2364000, 0.0873300, 0.0323700, 0.0074500",
    "c, 1.8, 0.207532D-02, 0.162869D-01, 0.738697D-01, 0.214297D+00, 0.382154D+00, 0.398178D+00, 0.152878D+00, -0.437540D-02",
    "c, 1.8, -0.329727D-03, -0.258754D-02, -0.119120D-01, -0.350227D-01, -0.639968D-01, -0.704436D-01, -0.375836D-01, 0.177043D+00",
    "c, 9.9, 1",
    "c, 10.10, 1",
    "c, 11.11, 1",
    "d, MG , 0.1260000, 0.2940000, 0.0468000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "f, MG , 0.2520000",
    "c, 1.1, 1",
    "! ALUMINUM       (16s,10p,3d,2f) -> [6s,5p,3d,2f]",
    "! ALUMINUM       (15s,9p,2d,1f) -> [5s,4p,2d,1f]",
    "! ALUMINUM       (1s,1p,1d,1f)",
    "s, AL , 205500.0000000, 30780.0000000, 7006.0000000, 1985.0000000, 649.1000000, 235.0000000, 91.6200000, 37.6700000, 15.9100000, 5.8500000, 2.5420000, 1.0570000, 0.1455000, 0.2931000, 0.0565000, 0.0221000",
    "c, 1.13, 0.678836D-04, 0.527149D-03, 0.276203D-02, 0.114728D-01, 0.398188D-01, 0.115040D+00, 0.260887D+00, 0.396386D+00, 0.284597D+00, 0.444583D-01, -0.489838D-02, 0.261253D-02, 0.722068D-03",
    "c, 1.13, -0.176377D-04, -0.137195D-03, -0.718910D-03, -0.301146D-02, -0.106014D-01, -0.321345D-01, -0.803156D-01, -0.156794D+00, -0.168376D+00, 0.126879D+00, 0.561494D+00, 0.436613D+00, -0.114563D-01",
    "c, 1.13, 0.407315D-05, 0.316566D-04, 0.166116D-03, 0.694992D-03, 0.245511D-02, 0.744598D-02, 0.188253D-01, 0.372772D-01, 0.419496D-01, -0.354375D-01, -0.175132D+00, -0.276203D+00, 0.652809D+00",
    "c, 14.14, 1",
    "c, 15.15, 1",
    "c, 16.16, 1",
    "p, AL , 444.4000000, 105.1000000, 33.4700000, 12.3300000, 4.8690000, 1.9610000, 0.1888000, 0.7834000, 0.0555700, 0.0146000",
    "c, 1.7, 0.162786D-02, 0.130687D-01, 0.612341D-01, 0.187870D+00, 0.360452D+00, 0.408454D+00, 0.976514D-02",
    "c, 1.7, -0.286341D-03, -0.242308D-02, -0.108658D-01, -0.364307D-01, -0.641074D-01, -0.972239D-01, 0.503448D+00",
    "c, 8.8, 1",
    "c, 9.9, 1",
    "c, 10.10, 1",
    "d, AL , 0.1090000, 0.3330000, 0.0356000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "f, AL , 0.2440000",
    "c, 1.1, 1",
    "! SILICON       (16s,10p,3d,2f) -> [6s,5p,3d,2f]",
    "! SILICON       (15s,9p,2d,1f) -> [5s,4p,2d,1f]",
    "! SILICON       (1s,1p,1d,1f)",
    "s, SI , 254900.0000000, 38190.0000000, 8690.0000000, 2462.0000000, 804.8000000, 291.3000000, 113.6000000, 46.7500000, 19.8200000, 7.7080000, 3.3400000, 1.4020000, 0.2070000, 0.4387000, 0.0794400, 0.0330000",
    "c, 1.13, 0.625101D-04, 0.485553D-03, 0.254516D-02, 0.105866D-01, 0.368787D-01, 0.107479D+00, 0.247936D+00, 0.390927D+00, 0.302026D+00, 0.559236D-01, -0.402406D-02, 0.258030D-02, 0.607930D-03",
    "c, 1.13, -0.166370D-04, -0.129310D-03, -0.678828D-03, -0.284117D-02, -0.100551D-01, -0.305774D-01, -0.777256D-01, -0.154236D+00, -0.180368D+00, 0.798218D-01, 0.547441D+00, 0.480119D+00, -0.106996D-01",
    "c, 1.13, 0.426257D-05, 0.331062D-04, 0.174015D-03, 0.727574D-03, 0.258333D-02, 0.786354D-02, 0.202155D-01, 0.407320D-01, 0.499358D-01, -0.249396D-01, -0.190350D+00, -0.318350D+00, 0.681180D+00",
    "c, 14.14, 1",
    "c, 15.15, 1",
    "c, 16.16, 1",
    "p, SI , 481.5000000, 113.9000000, 36.2300000, 13.3400000, 5.2520000, 2.1200000, 0.2528000, 0.8561000, 0.0788900, 0.0237000",
    "c, 1.7, 0.192045D-02, 0.153552D-01, 0.713991D-01, 0.213052D+00, 0.390354D+00, 0.393721D+00, 0.395630D-02",
    "c, 1.7, -0.405220D-03, -0.335896D-02, -0.152860D-01, -0.489218D-01, -0.855008D-01, -0.112137D+00, 0.551919D+00",
    "c, 8.8, 1",
    "c, 9.9, 1",
    "c, 10.10, 1",
    "d, SI , 0.1590000, 0.4810000, 0.0556000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "f, SI , 0.3360000",
    "c, 1.1, 1",
    "! PHOSPHOROUS       (16s,10p,3d,2f) -> [6s,5p,3d,2f]",
    "! PHOSPHOROUS       (15s,9p,2d,1f) -> [5s,4p,2d,1f]",
    "! PHOSPHOROUS       (1s,1p,1d,1f)",
    "s, P , 312400.0000000, 46800.0000000, 10650.0000000, 3018.0000000, 986.8000000, 357.4000000, 139.6000000, 57.6300000, 24.6000000, 10.1200000, 4.2830000, 1.8050000, 0.2782000, 0.6158000, 0.1055000, 0.0409000",
    "c, 1.13, 0.576960D-04, 0.448296D-03, 0.234939D-02, 0.978265D-02, 0.341467D-01, 0.100204D+00, 0.234372D+00, 0.382434D+00, 0.318088D+00, 0.707788D-01, -0.181799D-02, 0.216180D-02, 0.432297D-03",
    "c, 1.13, -0.156709D-04, -0.121724D-03, -0.639672D-03, -0.267426D-02, -0.949831D-02, -0.289349D-01, -0.745121D-01, -0.149938D+00, -0.189467D+00, 0.363270D-01, 0.528816D+00, 0.519115D+00, -0.925695D-02",
    "c, 1.13, 0.430631D-05, 0.334194D-04, 0.175885D-03, 0.734340D-03, 0.261775D-02, 0.797852D-02, 0.207940D-01, 0.424446D-01, 0.563436D-01, -0.127358D-01, -0.196495D+00, -0.353555D+00, 0.700912D+00",
    "c, 14.14, 1",
    "c, 15.15, 1",
    "c, 16.16, 1",
    "p, P , 504.9000000, 119.4000000, 37.9600000, 13.9500000, 5.4570000, 2.1770000, 0.2877000, 0.8010000, 0.0971400, 0.0307000",
    "c, 1.7, 0.233728D-02, 0.185410D-01, 0.849693D-01, 0.244615D+00, 0.422766D+00, 0.368439D+00, -0.379005D-02",
    "c, 1.7, -0.555236D-03, -0.445913D-02, -0.206350D-01, -0.617694D-01, -0.108924D+00, -0.105599D+00, 0.576981D+00",
    "c, 8.8, 1",
    "c, 9.9, 1",
    "c, 10.10, 1",
    "d, P , 0.2160000, 0.6520000, 0.0775000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "f, P , 0.4520000",
    "c, 1.1, 1",
    "! SULFUR       (16s,10p,3d,2f) -> [6s,5p,3d,2f]",
    "! SULFUR       (15s,9p,2d,1f) -> [5s,4p,2d,1f]",
    "! SULFUR       (1s,1p,1d,1f)",
    "s, S , 374100.0000000, 56050.0000000, 12760.0000000, 3615.0000000, 1183.0000000, 428.8000000, 167.8000000, 69.4700000, 29.8400000, 12.7200000, 5.2440000, 2.2190000, 0.3490000, 0.7767000, 0.1322000, 0.0497000",
    "c, 1.13, 0.542140D-04, 0.420855D-03, 0.220698D-02, 0.919258D-02, 0.321123D-01, 0.946683D-01, 0.223630D+00, 0.374393D+00, 0.329108D+00, 0.847038D-01, 0.440851D-03, 0.164827D-02, 0.301306D-03",
    "c, 1.13, -0.149837D-04, -0.116198D-03, -0.611583D-03, -0.255370D-02, -0.908708D-02, -0.277045D-01, -0.720020D-01, -0.146439D+00, -0.195150D+00, 0.819193D-02, 0.516601D+00, 0.542178D+00, -0.918072D-02",
    "c, 1.13, 0.435066D-05, 0.337140D-04, 0.177674D-03, 0.741116D-03, 0.264591D-02, 0.807487D-02, 0.212276D-01, 0.438323D-01, 0.612716D-01, -0.361510D-02, -0.204510D+00, -0.381871D+00, 0.714147D+00",
    "c, 14.14, 1",
    "c, 15.15, 1",
    "c, 16.16, 1",
    "p, S , 574.4000000, 135.8000000, 43.1900000, 15.8700000, 6.2080000, 2.4830000, 0.3229000, 0.8688000, 0.1098000, 0.0351000",
    "c, 1.7, 0.242264D-02, 0.192796D-01, 0.885401D-01, 0.254654D+00, 0.433984D+00, 0.354953D+00, -0.502977D-02",
    "c, 1.7, -0.620102D-03, -0.493882D-02, -0.232647D-01, -0.685195D-01, -0.123896D+00, -0.969499D-01, 0.569394D+00",
    "c, 8.8, 1",
    "c, 9.9, 1",
    "c, 10.10, 1",
    "d, S , 0.2690000, 0.8190000, 0.1010000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "f, S , 0.5570000",
    "c, 1.1, 1",
    "! CHLORINE       (16s,10p,3d,2f) -> [6s,5p,3d,2f]",
    "! CHLORINE       (15s,9p,2d,1f) -> [5s,4p,2d,1f]",
    "! CHLORINE       (1s,1p,1d,1f)",
    "s, CL , 456100.0000000, 68330.0000000, 15550.0000000, 4405.0000000, 1439.0000000, 520.4000000, 203.1000000, 83.9600000, 36.2000000, 15.8300000, 6.3340000, 2.6940000, 0.4313000, 0.9768000, 0.1625000, 0.0591000",
    "c, 1.13, 0.492970D-04, 0.383029D-03, 0.200854D-02, 0.838558D-02, 0.294703D-01, 0.878325D-01, 0.211473D+00, 0.365364D+00, 0.340884D+00, 0.102133D+00, 0.311675D-02, 0.105751D-02, 0.156136D-03",
    "c, 1.13, -0.138304D-04, -0.107279D-03, -0.565083D-03, -0.236135D-02, -0.845886D-02, -0.259638D-01, -0.686362D-01, -0.141874D+00, -0.199319D+00, -0.195662D-01, 0.499741D+00, 0.563736D+00, -0.835091D-02",
    "c, 1.13, 0.418546D-05, 0.324395D-04, 0.171105D-03, 0.714176D-03, 0.256705D-02, 0.788552D-02, 0.210867D-01, 0.442264D-01, 0.651670D-01, 0.603012D-02, -0.206495D+00, -0.405871D+00, 0.725661D+00",
    "c, 14.14, 1",
    "c, 15.15, 1",
    "c, 16.16, 1",
    "p, CL , 663.3000000, 156.8000000, 49.9800000, 18.4200000, 7.2400000, 2.9220000, 0.3818000, 1.0220000, 0.1301000, 0.0419000",
    "c, 1.7, 0.240448D-02, 0.192148D-01, 0.885097D-01, 0.256020D+00, 0.436927D+00, 0.350334D+00, -0.458423D-02",
    "c, 1.7, -0.652145D-03, -0.519445D-02, -0.246938D-01, -0.728167D-01, -0.134030D+00, -0.947742D-01, 0.564667D+00",
    "c, 8.8, 1",
    "c, 9.9, 1",
    "c, 10.10, 1",
    "d, CL , 1.0460000, 0.3440000, 0.1350000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "f, CL , 0.7060000",
    "c, 1.1, 1",
    "! ARGON       (16s,10p,3d,2f) -> [6s,5p,3d,2f]",
    "! ARGON       (15s,9p,2d,1f) -> [5s,4p,2d,1f]",
    "! ARGON       (1s,1p,1d,1f)",
    "s, AR , 545000.0000000, 81640.0000000, 18580.0000000, 5261.0000000, 1717.0000000, 619.9000000, 241.6000000, 99.7900000, 43.1500000, 19.1400000, 7.4880000, 3.2050000, 0.5204000, 1.1960000, 0.1954000, 0.0685000",
    "c, 1.13, 0.455828D-04, 0.354108D-03, 0.185797D-02, 0.776851D-02, 0.274232D-01, 0.823836D-01, 0.201230D+00, 0.356781D+00, 0.349563D+00, 0.118266D+00, 0.560190D-02, 0.483473D-03, 0.292025D-04",
    "c, 1.13, -0.129551D-04, -0.100428D-03, -0.529583D-03, -0.221396D-02, -0.796845D-02, -0.245803D-01, -0.657798D-01, -0.137942D+00, -0.201630D+00, -0.412834D-01, 0.484680D+00, 0.579224D+00, -0.727553D-02",
    "c, 1.13, 0.404990D-05, 0.313691D-04, 0.165646D-03, 0.691662D-03, 0.249790D-02, 0.771074D-02, 0.208714D-01, 0.443965D-01, 0.680224D-01, 0.141350D-01, -0.207489D+00, -0.425045D+00, 0.733627D+00",
    "c, 14.14, 1",
    "c, 15.15, 1",
    "c, 16.16, 1",
    "p, AR , 761.8000000, 180.2000000, 57.5000000, 21.2400000, 8.3880000, 3.4160000, 0.4523000, 1.2060000, 0.1545000, 0.0487000",
    "c, 1.7, 0.236976D-02, 0.190199D-01, 0.880807D-01, 0.256377D+00, 0.438711D+00, 0.347569D+00, -0.523882D-02",
    "c, 1.7, -0.667211D-03, -0.532717D-02, -0.255494D-01, -0.757197D-01, -0.141133D+00, -0.932768D-01, 0.562450D+00",
    "c, 8.8, 1",
    "c, 9.9, 1",
    "c, 10.10, 1",
    "d, AR , 0.4100000, 1.2540000, 0.1690000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "f, AR , 0.8900000",
    "c, 1.1, 1",
    ],

'may-cc-pvtz': [
    "! #####################",
    "! ##                 ##",
    "! ##   may-cc-pVTZ   ##",
    "! ##                 ##",
    "! #####################",
    "!",
    "! HYDROGEN       (6s,3p,2d) -> [4s,3p,2d]",
    "! HYDROGEN       (5s,2p,1d) -> [3s,2p,1d]",
    "! HYDROGEN       (1s,1p,1d)",
    "s, H , 33.8700000, 5.0950000, 1.1590000, 0.3258000, 0.1027000",
    "c, 1.3, 0.0060680, 0.0453080, 0.2028220",
    "c, 4.4, 1",
    "c, 5.5, 1",
    "p, H , 1.4070000, 0.3880000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "d, H , 1.0570000",
    "c, 1.1, 1",
    "! HELIUM       (7s,3p,2d) -> [4s,3p,2d]",
    "! HELIUM       (6s,2p,1d) -> [3s,2p,1d]",
    "! HELIUM       (1s,1p,1d)",
    "s, HE , 234.0000000, 35.1600000, 7.9890000, 2.2120000, 0.6669000, 0.2089000",
    "c, 1.4, 0.0025870, 0.0195330, 0.0909980, 0.2720500",
    "c, 5.5, 1",
    "c, 6.6, 1",
    "p, HE , 3.0440000, 0.7580000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "d, HE , 1.9650000",
    "c, 1.1, 1",
    "! LITHIUM       (12s,6p,3d,2f) -> [5s,4p,3d,2f]",
    "! LITHIUM       (11s,5p,2d,1f) -> [4s,3p,2d,1f]",
    "! LITHIUM       (1s,1p,1d,1f)",
    "s, LI , 5988.0000000, 898.9000000, 205.9000000, 59.2400000, 19.8700000, 7.4060000, 2.9300000, 1.1890000, 0.4798000, 0.0750900, 0.0283200, 0.0076000",
    "c, 1.9, 0.0001330, 0.0010250, 0.0052720, 0.0209290, 0.0663400, 0.1657750, 0.3150380, 0.3935230, 0.1908700",
    "c, 1.9, -0.0000210, -0.0001610, -0.0008200, -0.0033260, -0.0105190, -0.0280970, -0.0559360, -0.0992370, -0.1121890",
    "c, 10.10, 1",
    "c, 11.11, 1",
    "c, 12.12, 1",
    "p, LI , 3.2660000, 0.6511000, 0.1696000, 0.0557800, 0.0205000, 0.0091000",
    "c, 1.3, 0.0086300, 0.0475380, 0.2097720",
    "c, 4.4, 1",
    "c, 5.5, 1",
    "c, 6.6, 1",
    "d, LI , 0.1874000, 0.0801000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "f, LI , 0.1829000",
    "c, 1.1, 1",
    "! BERYLLIUM       (12s,6p,3d,2f) -> [5s,4p,3d,2f]",
    "! BERYLLIUM       (11s,5p,2d,1f) -> [4s,3p,2d,1f]",
    "! BERYLLIUM       (1s,1p,1d,1f)",
    "s, BE , 6863.0000000, 1030.0000000, 234.7000000, 66.5600000, 21.6900000, 7.7340000, 2.9160000, 1.1300000, 0.1101000, 0.2577000, 0.0440900, 0.0150300",
    "c, 1.9, 0.0002360, 0.0018260, 0.0094520, 0.0379570, 0.1199650, 0.2821620, 0.4274040, 0.2662780, -0.0072750",
    "c, 1.9, -0.0000430, -0.0003330, -0.0017360, -0.0070120, -0.0231260, -0.0581380, -0.1145560, -0.1359080, 0.5774410",
    "c, 10.10, 1",
    "c, 11.11, 1",
    "c, 12.12, 1",
    "p, BE , 7.4360000, 1.5770000, 0.4352000, 0.1438000, 0.0499400, 0.0070600",
    "c, 1.3, 0.0107360, 0.0628540, 0.2481800",
    "c, 4.4, 1",
    "c, 5.5, 1",
    "c, 6.6, 1",
    "d, BE , 0.3480000, 0.1803000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "f, BE , 0.3250000",
    "c, 1.1, 1",
    "! BORON       (11s,6p,3d,2f) -> [5s,4p,3d,2f]",
    "! BORON       (10s,5p,2d,1f) -> [4s,3p,2d,1f]",
    "! BORON       (1s,1p,1d,1f)",
    "s, B , 5473.0000000, 820.9000000, 186.8000000, 52.8300000, 17.0800000, 5.9990000, 2.2080000, 0.2415000, 0.5879000, 0.0861000, 0.0291400",
    "c, 1.8, 0.0005550, 0.0042910, 0.0219490, 0.0844410, 0.2385570, 0.4350720, 0.3419550, -0.0095450",
    "c, 1.8, -0.0001120, -0.0008680, -0.0044840, -0.0176830, -0.0536390, -0.1190050, -0.1658240, 0.5959810",
    "c, 9.9, 1",
    "c, 10.10, 1",
    "c, 11.11, 1",
    "p, B , 12.0500000, 2.6130000, 0.7475000, 0.2385000, 0.0769800, 0.0209600",
    "c, 1.3, 0.0131180, 0.0798960, 0.2772750",
    "c, 4.4, 1",
    "c, 5.5, 1",
    "c, 6.6, 1",
    "d, B , 0.6610000, 0.1990000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "f, B , 0.4900000",
    "c, 1.1, 1",
    "! CARBON       (11s,6p,3d,2f) -> [5s,4p,3d,2f]",
    "! CARBON       (10s,5p,2d,1f) -> [4s,3p,2d,1f]",
    "! CARBON       (1s,1p,1d,1f)",
    "s, C , 8236.0000000, 1235.0000000, 280.8000000, 79.2700000, 25.5900000, 8.9970000, 3.3190000, 0.3643000, 0.9059000, 0.1285000, 0.0440200",
    "c, 1.8, 0.0005310, 0.0041080, 0.0210870, 0.0818530, 0.2348170, 0.4344010, 0.3461290, -0.0089830",
    "c, 1.8, -0.0001130, -0.0008780, -0.0045400, -0.0181330, -0.0557600, -0.1268950, -0.1703520, 0.5986840",
    "c, 9.9, 1",
    "c, 10.10, 1",
    "c, 11.11, 1",
    "p, C , 18.7100000, 4.1330000, 1.2000000, 0.3827000, 0.1209000, 0.0356900",
    "c, 1.3, 0.0140310, 0.0868660, 0.2902160",
    "c, 4.4, 1",
    "c, 5.5, 1",
    "c, 6.6, 1",
    "d, C , 1.0970000, 0.3180000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "f, C , 0.7610000",
    "c, 1.1, 1",
    "! NITROGEN       (11s,6p,3d,2f) -> [5s,4p,3d,2f]",
    "! NITROGEN       (10s,5p,2d,1f) -> [4s,3p,2d,1f]",
    "! NITROGEN       (1s,1p,1d,1f)",
    "s, N , 11420.0000000, 1712.0000000, 389.3000000, 110.0000000, 35.5700000, 12.5400000, 4.6440000, 0.5118000, 1.2930000, 0.1787000, 0.0576000",
    "c, 1.8, 0.0005230, 0.0040450, 0.0207750, 0.0807270, 0.2330740, 0.4335010, 0.3474720, -0.0085080",
    "c, 1.8, -0.0001150, -0.0008950, -0.0046240, -0.0185280, -0.0573390, -0.1320760, -0.1725100, 0.5999440",
    "c, 9.9, 1",
    "c, 10.10, 1",
    "c, 11.11, 1",
    "p, N , 26.6300000, 5.9480000, 1.7420000, 0.5550000, 0.1725000, 0.0491000",
    "c, 1.3, 0.0146700, 0.0917640, 0.2986830",
    "c, 4.4, 1",
    "c, 5.5, 1",
    "c, 6.6, 1",
    "d, N , 1.6540000, 0.4690000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "f, N , 1.0930000",
    "c, 1.1, 1",
    "! OXYGEN       (11s,6p,3d,2f) -> [5s,4p,3d,2f]",
    "! OXYGEN       (10s,5p,2d,1f) -> [4s,3p,2d,1f]",
    "! OXYGEN       (1s,1p,1d,1f)",
    "s, O , 15330.0000000, 2299.0000000, 522.4000000, 147.3000000, 47.5500000, 16.7600000, 6.2070000, 0.6882000, 1.7520000, 0.2384000, 0.0737600",
    "c, 1.8, 0.0005080, 0.0039290, 0.0202430, 0.0791810, 0.2306870, 0.4331180, 0.3502600, -0.0081540",
    "c, 1.8, -0.0001150, -0.0008950, -0.0046360, -0.0187240, -0.0584630, -0.1364630, -0.1757400, 0.6034180",
    "c, 9.9, 1",
    "c, 10.10, 1",
    "c, 11.11, 1",
    "p, O , 34.4600000, 7.7490000, 2.2800000, 0.7156000, 0.2140000, 0.0597400",
    "c, 1.3, 0.0159280, 0.0997400, 0.3104920",
    "c, 4.4, 1",
    "c, 5.5, 1",
    "c, 6.6, 1",
    "d, O , 2.3140000, 0.6450000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "f, O , 1.4280000",
    "c, 1.1, 1",
    "! FLUORINE       (11s,6p,3d,2f) -> [5s,4p,3d,2f]",
    "! FLUORINE       (10s,5p,2d,1f) -> [4s,3p,2d,1f]",
    "! FLUORINE       (1s,1p,1d,1f)",
    "s, F , 19500.0000000, 2923.0000000, 664.5000000, 187.5000000, 60.6200000, 21.4200000, 7.9500000, 0.8815000, 2.2570000, 0.3041000, 0.0915800",
    "c, 1.8, 0.0005070, 0.0039230, 0.0202000, 0.0790100, 0.2304390, 0.4328720, 0.3499640, -0.0078920",
    "c, 1.8, -0.0001170, -0.0009120, -0.0047170, -0.0190860, -0.0596550, -0.1400100, -0.1767820, 0.6050430",
    "c, 9.9, 1",
    "c, 10.10, 1",
    "c, 11.11, 1",
    "p, F , 43.8800000, 9.9260000, 2.9300000, 0.9132000, 0.2672000, 0.0736100",
    "c, 1.3, 0.0166650, 0.1044720, 0.3172600",
    "c, 4.4, 1",
    "c, 5.5, 1",
    "c, 6.6, 1",
    "d, F , 3.1070000, 0.8550000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "f, F , 1.9170000",
    "c, 1.1, 1",
    "! NEON       (11s,6p,3d,2f) -> [5s,4p,3d,2f]",
    "! NEON       (10s,5p,2d,1f) -> [4s,3p,2d,1f]",
    "! NEON       (1s,1p,1d,1f)",
    "s, NE , 24350.0000000, 3650.0000000, 829.6000000, 234.0000000, 75.6100000, 26.7300000, 9.9270000, 1.1020000, 2.8360000, 0.3782000, 0.1133000",
    "c, 1.8, 0.0005020, 0.0038810, 0.0199970, 0.0784180, 0.2296760, 0.4327220, 0.3506420, -0.0076450",
    "c, 1.8, -0.0001180, -0.0009150, -0.0047370, -0.0192330, -0.0603690, -0.1425080, -0.1777100, 0.6058360",
    "c, 9.9, 1",
    "c, 10.10, 1",
    "c, 11.11, 1",
    "p, NE , 54.7000000, 12.4300000, 3.6790000, 1.1430000, 0.3300000, 0.0917500",
    "c, 1.3, 0.0171510, 0.1076560, 0.3216810",
    "c, 4.4, 1",
    "c, 5.5, 1",
    "c, 6.6, 1",
    "d, NE , 4.0140000, 1.0960000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "f, NE , 2.5440000",
    "c, 1.1, 1",
    "! SODIUM       (17s,11p,3d,2f) -> [6s,5p,3d,2f]",
    "! SODIUM       (16s,10p,2d,1f) -> [5s,4p,2d,1f]",
    "! SODIUM       (1s,1p,1d,1f)",
    "s, NA , 423000.0000000, 63340.0000000, 14410.0000000, 4077.0000000, 1328.0000000, 478.6000000, 186.2000000, 76.9200000, 33.3200000, 15.0000000, 6.8690000, 2.6830000, 1.1090000, 0.0601500, 0.4540000, 0.0238200, 0.0066500",
    "c, 1.14, 0.180618D-04, 0.140430D-03, 0.738438D-03, 0.311182D-02, 0.112081D-01, 0.352828D-01, 0.959897D-01, 0.213735D+00, 0.348688D+00, 0.324566D+00, 0.112633D+00, 0.706797D-02, 0.598010D-03, -0.530870D-05",
    "c, 1.14, -0.440653D-05, -0.343443D-04, -0.180114D-03, -0.763900D-03, -0.275248D-02, -0.886016D-02, -0.247939D-01, -0.605995D-01, -0.116446D+00, -0.162437D+00, -0.438891D-01, 0.337917D+00, 0.561347D+00, 0.406754D-02",
    "c, 1.14, 0.663019D-06, 0.515769D-05, 0.271250D-04, 0.114635D-03, 0.415118D-03, 0.132978D-02, 0.375595D-02, 0.914025D-02, 0.179859D-01, 0.251477D-01, 0.763522D-02, -0.614589D-01, -0.115721D+00, 0.626406D+00",
    "c, 15.15, 1",
    "c, 16.16, 1",
    "c, 17.17, 1",
    "p, NA , 243.3000000, 57.3900000, 18.1000000, 6.5750000, 2.5210000, 0.9607000, 0.3512000, 0.0982700, 0.0373400, 0.0150000, 0.0070000",
    "c, 1.8, 0.224392D-02, 0.173997D-01, 0.774125D-01, 0.219102D+00, 0.378522D+00, 0.394902D+00, 0.160424D+00, 0.233311D-02",
    "c, 1.8, -0.222401D-03, -0.174277D-02, -0.775456D-02, -0.225187D-01, -0.384330D-01, -0.450177D-01, -0.192132D-01, 0.182697D+00",
    "c, 9.9, 1",
    "c, 10.10, 1",
    "c, 11.11, 1",
    "d, NA , 0.1367000, 0.0636000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "f, NA , 0.1397000",
    "c, 1.1, 1",
    "! MAGNESIUM       (16s,11p,3d,2f) -> [6s,5p,3d,2f]",
    "! MAGNESIUM       (15s,10p,2d,1f) -> [5s,4p,2d,1f]",
    "! MAGNESIUM       (1s,1p,1d,1f)",
    "s, MG , 164900.0000000, 24710.0000000, 5628.0000000, 1596.0000000, 521.0000000, 188.0000000, 73.0100000, 29.9000000, 12.5400000, 4.3060000, 1.8260000, 0.7417000, 0.0761200, 0.1457000, 0.0331000, 0.0129000",
    "c, 1.13, 0.729929D-04, 0.566652D-03, 0.296269D-02, 0.122962D-01, 0.427324D-01, 0.123013D+00, 0.274832D+00, 0.401818D+00, 0.264697D+00, 0.332612D-01, -0.441335D-02, 0.206024D-02, 0.708195D-03",
    "c, 1.13, -0.184248D-04, -0.143500D-03, -0.748710D-03, -0.314407D-02, -0.110481D-01, -0.336058D-01, -0.825946D-01, -0.159314D+00, -0.152888D+00, 0.190849D+00, 0.579964D+00, 0.372029D+00, -0.119344D-01",
    "c, 1.13, 0.355176D-05, 0.276420D-04, 0.144404D-03, 0.605744D-03, 0.213527D-02, 0.649934D-02, 0.161446D-01, 0.315766D-01, 0.316374D-01, -0.439140D-01, -0.151093D+00, -0.217668D+00, 0.547245D+00",
    "c, 14.14, 1",
    "c, 15.15, 1",
    "c, 16.16, 1",
    "p, MG , 316.9000000, 74.8600000, 23.7200000, 8.6690000, 3.3630000, 1.3100000, 0.4911000, 0.2364000, 0.0873300, 0.0323700, 0.0074500",
    "c, 1.8, 0.207532D-02, 0.162869D-01, 0.738697D-01, 0.214297D+00, 0.382154D+00, 0.398178D+00, 0.152878D+00, -0.437540D-02",
    "c, 1.8, -0.329727D-03, -0.258754D-02, -0.119120D-01, -0.350227D-01, -0.639968D-01, -0.704436D-01, -0.375836D-01, 0.177043D+00",
    "c, 9.9, 1",
    "c, 10.10, 1",
    "c, 11.11, 1",
    "d, MG , 0.1260000, 0.2940000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "f, MG , 0.2520000",
    "c, 1.1, 1",
    "! ALUMINUM       (16s,10p,3d,2f) -> [6s,5p,3d,2f]",
    "! ALUMINUM       (15s,9p,2d,1f) -> [5s,4p,2d,1f]",
    "! ALUMINUM       (1s,1p,1d,1f)",
    "s, AL , 205500.0000000, 30780.0000000, 7006.0000000, 1985.0000000, 649.1000000, 235.0000000, 91.6200000, 37.6700000, 15.9100000, 5.8500000, 2.5420000, 1.0570000, 0.1455000, 0.2931000, 0.0565000, 0.0221000",
    "c, 1.13, 0.678836D-04, 0.527149D-03, 0.276203D-02, 0.114728D-01, 0.398188D-01, 0.115040D+00, 0.260887D+00, 0.396386D+00, 0.284597D+00, 0.444583D-01, -0.489838D-02, 0.261253D-02, 0.722068D-03",
    "c, 1.13, -0.176377D-04, -0.137195D-03, -0.718910D-03, -0.301146D-02, -0.106014D-01, -0.321345D-01, -0.803156D-01, -0.156794D+00, -0.168376D+00, 0.126879D+00, 0.561494D+00, 0.436613D+00, -0.114563D-01",
    "c, 1.13, 0.407315D-05, 0.316566D-04, 0.166116D-03, 0.694992D-03, 0.245511D-02, 0.744598D-02, 0.188253D-01, 0.372772D-01, 0.419496D-01, -0.354375D-01, -0.175132D+00, -0.276203D+00, 0.652809D+00",
    "c, 14.14, 1",
    "c, 15.15, 1",
    "c, 16.16, 1",
    "p, AL , 444.4000000, 105.1000000, 33.4700000, 12.3300000, 4.8690000, 1.9610000, 0.1888000, 0.7834000, 0.0555700, 0.0146000",
    "c, 1.7, 0.162786D-02, 0.130687D-01, 0.612341D-01, 0.187870D+00, 0.360452D+00, 0.408454D+00, 0.976514D-02",
    "c, 1.7, -0.286341D-03, -0.242308D-02, -0.108658D-01, -0.364307D-01, -0.641074D-01, -0.972239D-01, 0.503448D+00",
    "c, 8.8, 1",
    "c, 9.9, 1",
    "c, 10.10, 1",
    "d, AL , 0.1090000, 0.3330000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "f, AL , 0.2440000",
    "c, 1.1, 1",
    "! SILICON       (16s,10p,3d,2f) -> [6s,5p,3d,2f]",
    "! SILICON       (15s,9p,2d,1f) -> [5s,4p,2d,1f]",
    "! SILICON       (1s,1p,1d,1f)",
    "s, SI , 254900.0000000, 38190.0000000, 8690.0000000, 2462.0000000, 804.8000000, 291.3000000, 113.6000000, 46.7500000, 19.8200000, 7.7080000, 3.3400000, 1.4020000, 0.2070000, 0.4387000, 0.0794400, 0.0330000",
    "c, 1.13, 0.625101D-04, 0.485553D-03, 0.254516D-02, 0.105866D-01, 0.368787D-01, 0.107479D+00, 0.247936D+00, 0.390927D+00, 0.302026D+00, 0.559236D-01, -0.402406D-02, 0.258030D-02, 0.607930D-03",
    "c, 1.13, -0.166370D-04, -0.129310D-03, -0.678828D-03, -0.284117D-02, -0.100551D-01, -0.305774D-01, -0.777256D-01, -0.154236D+00, -0.180368D+00, 0.798218D-01, 0.547441D+00, 0.480119D+00, -0.106996D-01",
    "c, 1.13, 0.426257D-05, 0.331062D-04, 0.174015D-03, 0.727574D-03, 0.258333D-02, 0.786354D-02, 0.202155D-01, 0.407320D-01, 0.499358D-01, -0.249396D-01, -0.190350D+00, -0.318350D+00, 0.681180D+00",
    "c, 14.14, 1",
    "c, 15.15, 1",
    "c, 16.16, 1",
    "p, SI , 481.5000000, 113.9000000, 36.2300000, 13.3400000, 5.2520000, 2.1200000, 0.2528000, 0.8561000, 0.0788900, 0.0237000",
    "c, 1.7, 0.192045D-02, 0.153552D-01, 0.713991D-01, 0.213052D+00, 0.390354D+00, 0.393721D+00, 0.395630D-02",
    "c, 1.7, -0.405220D-03, -0.335896D-02, -0.152860D-01, -0.489218D-01, -0.855008D-01, -0.112137D+00, 0.551919D+00",
    "c, 8.8, 1",
    "c, 9.9, 1",
    "c, 10.10, 1",
    "d, SI , 0.1590000, 0.4810000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "f, SI , 0.3360000",
    "c, 1.1, 1",
    "! PHOSPHOROUS       (16s,10p,3d,2f) -> [6s,5p,3d,2f]",
    "! PHOSPHOROUS       (15s,9p,2d,1f) -> [5s,4p,2d,1f]",
    "! PHOSPHOROUS       (1s,1p,1d,1f)",
    "s, P , 312400.0000000, 46800.0000000, 10650.0000000, 3018.0000000, 986.8000000, 357.4000000, 139.6000000, 57.6300000, 24.6000000, 10.1200000, 4.2830000, 1.8050000, 0.2782000, 0.6158000, 0.1055000, 0.0409000",
    "c, 1.13, 0.576960D-04, 0.448296D-03, 0.234939D-02, 0.978265D-02, 0.341467D-01, 0.100204D+00, 0.234372D+00, 0.382434D+00, 0.318088D+00, 0.707788D-01, -0.181799D-02, 0.216180D-02, 0.432297D-03",
    "c, 1.13, -0.156709D-04, -0.121724D-03, -0.639672D-03, -0.267426D-02, -0.949831D-02, -0.289349D-01, -0.745121D-01, -0.149938D+00, -0.189467D+00, 0.363270D-01, 0.528816D+00, 0.519115D+00, -0.925695D-02",
    "c, 1.13, 0.430631D-05, 0.334194D-04, 0.175885D-03, 0.734340D-03, 0.261775D-02, 0.797852D-02, 0.207940D-01, 0.424446D-01, 0.563436D-01, -0.127358D-01, -0.196495D+00, -0.353555D+00, 0.700912D+00",
    "c, 14.14, 1",
    "c, 15.15, 1",
    "c, 16.16, 1",
    "p, P , 504.9000000, 119.4000000, 37.9600000, 13.9500000, 5.4570000, 2.1770000, 0.2877000, 0.8010000, 0.0971400, 0.0307000",
    "c, 1.7, 0.233728D-02, 0.185410D-01, 0.849693D-01, 0.244615D+00, 0.422766D+00, 0.368439D+00, -0.379005D-02",
    "c, 1.7, -0.555236D-03, -0.445913D-02, -0.206350D-01, -0.617694D-01, -0.108924D+00, -0.105599D+00, 0.576981D+00",
    "c, 8.8, 1",
    "c, 9.9, 1",
    "c, 10.10, 1",
    "d, P , 0.2160000, 0.6520000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "f, P , 0.4520000",
    "c, 1.1, 1",
    "! SULFUR       (16s,10p,3d,2f) -> [6s,5p,3d,2f]",
    "! SULFUR       (15s,9p,2d,1f) -> [5s,4p,2d,1f]",
    "! SULFUR       (1s,1p,1d,1f)",
    "s, S , 374100.0000000, 56050.0000000, 12760.0000000, 3615.0000000, 1183.0000000, 428.8000000, 167.8000000, 69.4700000, 29.8400000, 12.7200000, 5.2440000, 2.2190000, 0.3490000, 0.7767000, 0.1322000, 0.0497000",
    "c, 1.13, 0.542140D-04, 0.420855D-03, 0.220698D-02, 0.919258D-02, 0.321123D-01, 0.946683D-01, 0.223630D+00, 0.374393D+00, 0.329108D+00, 0.847038D-01, 0.440851D-03, 0.164827D-02, 0.301306D-03",
    "c, 1.13, -0.149837D-04, -0.116198D-03, -0.611583D-03, -0.255370D-02, -0.908708D-02, -0.277045D-01, -0.720020D-01, -0.146439D+00, -0.195150D+00, 0.819193D-02, 0.516601D+00, 0.542178D+00, -0.918072D-02",
    "c, 1.13, 0.435066D-05, 0.337140D-04, 0.177674D-03, 0.741116D-03, 0.264591D-02, 0.807487D-02, 0.212276D-01, 0.438323D-01, 0.612716D-01, -0.361510D-02, -0.204510D+00, -0.381871D+00, 0.714147D+00",
    "c, 14.14, 1",
    "c, 15.15, 1",
    "c, 16.16, 1",
    "p, S , 574.4000000, 135.8000000, 43.1900000, 15.8700000, 6.2080000, 2.4830000, 0.3229000, 0.8688000, 0.1098000, 0.0351000",
    "c, 1.7, 0.242264D-02, 0.192796D-01, 0.885401D-01, 0.254654D+00, 0.433984D+00, 0.354953D+00, -0.502977D-02",
    "c, 1.7, -0.620102D-03, -0.493882D-02, -0.232647D-01, -0.685195D-01, -0.123896D+00, -0.969499D-01, 0.569394D+00",
    "c, 8.8, 1",
    "c, 9.9, 1",
    "c, 10.10, 1",
    "d, S , 0.2690000, 0.8190000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "f, S , 0.5570000",
    "c, 1.1, 1",
    "! CHLORINE       (16s,10p,3d,2f) -> [6s,5p,3d,2f]",
    "! CHLORINE       (15s,9p,2d,1f) -> [5s,4p,2d,1f]",
    "! CHLORINE       (1s,1p,1d,1f)",
    "s, CL , 456100.0000000, 68330.0000000, 15550.0000000, 4405.0000000, 1439.0000000, 520.4000000, 203.1000000, 83.9600000, 36.2000000, 15.8300000, 6.3340000, 2.6940000, 0.4313000, 0.9768000, 0.1625000, 0.0591000",
    "c, 1.13, 0.492970D-04, 0.383029D-03, 0.200854D-02, 0.838558D-02, 0.294703D-01, 0.878325D-01, 0.211473D+00, 0.365364D+00, 0.340884D+00, 0.102133D+00, 0.311675D-02, 0.105751D-02, 0.156136D-03",
    "c, 1.13, -0.138304D-04, -0.107279D-03, -0.565083D-03, -0.236135D-02, -0.845886D-02, -0.259638D-01, -0.686362D-01, -0.141874D+00, -0.199319D+00, -0.195662D-01, 0.499741D+00, 0.563736D+00, -0.835091D-02",
    "c, 1.13, 0.418546D-05, 0.324395D-04, 0.171105D-03, 0.714176D-03, 0.256705D-02, 0.788552D-02, 0.210867D-01, 0.442264D-01, 0.651670D-01, 0.603012D-02, -0.206495D+00, -0.405871D+00, 0.725661D+00",
    "c, 14.14, 1",
    "c, 15.15, 1",
    "c, 16.16, 1",
    "p, CL , 663.3000000, 156.8000000, 49.9800000, 18.4200000, 7.2400000, 2.9220000, 0.3818000, 1.0220000, 0.1301000, 0.0419000",
    "c, 1.7, 0.240448D-02, 0.192148D-01, 0.885097D-01, 0.256020D+00, 0.436927D+00, 0.350334D+00, -0.458423D-02",
    "c, 1.7, -0.652145D-03, -0.519445D-02, -0.246938D-01, -0.728167D-01, -0.134030D+00, -0.947742D-01, 0.564667D+00",
    "c, 8.8, 1",
    "c, 9.9, 1",
    "c, 10.10, 1",
    "d, CL , 1.0460000, 0.3440000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "f, CL , 0.7060000",
    "c, 1.1, 1",
    "! ARGON       (16s,10p,3d,2f) -> [6s,5p,3d,2f]",
    "! ARGON       (15s,9p,2d,1f) -> [5s,4p,2d,1f]",
    "! ARGON       (1s,1p,1d,1f)",
    "s, AR , 545000.0000000, 81640.0000000, 18580.0000000, 5261.0000000, 1717.0000000, 619.9000000, 241.6000000, 99.7900000, 43.1500000, 19.1400000, 7.4880000, 3.2050000, 0.5204000, 1.1960000, 0.1954000, 0.0685000",
    "c, 1.13, 0.455828D-04, 0.354108D-03, 0.185797D-02, 0.776851D-02, 0.274232D-01, 0.823836D-01, 0.201230D+00, 0.356781D+00, 0.349563D+00, 0.118266D+00, 0.560190D-02, 0.483473D-03, 0.292025D-04",
    "c, 1.13, -0.129551D-04, -0.100428D-03, -0.529583D-03, -0.221396D-02, -0.796845D-02, -0.245803D-01, -0.657798D-01, -0.137942D+00, -0.201630D+00, -0.412834D-01, 0.484680D+00, 0.579224D+00, -0.727553D-02",
    "c, 1.13, 0.404990D-05, 0.313691D-04, 0.165646D-03, 0.691662D-03, 0.249790D-02, 0.771074D-02, 0.208714D-01, 0.443965D-01, 0.680224D-01, 0.141350D-01, -0.207489D+00, -0.425045D+00, 0.733627D+00",
    "c, 14.14, 1",
    "c, 15.15, 1",
    "c, 16.16, 1",
    "p, AR , 761.8000000, 180.2000000, 57.5000000, 21.2400000, 8.3880000, 3.4160000, 0.4523000, 1.2060000, 0.1545000, 0.0487000",
    "c, 1.7, 0.236976D-02, 0.190199D-01, 0.880807D-01, 0.256377D+00, 0.438711D+00, 0.347569D+00, -0.523882D-02",
    "c, 1.7, -0.667211D-03, -0.532717D-02, -0.255494D-01, -0.757197D-01, -0.141133D+00, -0.932768D-01, 0.562450D+00",
    "c, 8.8, 1",
    "c, 9.9, 1",
    "c, 10.10, 1",
    "d, AR , 0.4100000, 1.2540000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "f, AR , 0.8900000",
    "c, 1.1, 1",
    ],

'jul-cc-pvqz': [
    "! #####################",
    "! ##                 ##",
    "! ##   jul-cc-pVQZ   ##",
    "! ##                 ##",
    "! #####################",
    "!",
    "! HYDROGEN       (7s,4p,3d,2f) -> [5s,4p,3d,2f]",
    "! HYDROGEN       (6s,3p,2d,1f) -> [4s,3p,2d,1f]",
    "! HYDROGEN       (1s,1p,1d,1f)",
    "s, H , 82.6400000, 12.4100000, 2.8240000, 0.7977000, 0.2581000, 0.0898900",
    "c, 1.3, 0.0020060, 0.0153430, 0.0755790",
    "c, 4.4, 1",
    "c, 5.5, 1",
    "c, 6.6, 1",
    "p, H , 2.2920000, 0.8380000, 0.2920000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "d, H , 2.0620000, 0.6620000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "f, H , 1.3970000",
    "c, 1.1, 1",
    "! HELIUM       (8s,4p,3d,2f) -> [5s,4p,3d,2f]",
    "! HELIUM       (7s,3p,2d,1f) -> [4s,3p,2d,1f]",
    "! HELIUM       (1s,1p,1d,1f)",
    "s, HE , 528.5000000, 79.3100000, 18.0500000, 5.0850000, 1.6090000, 0.5363000, 0.1833000",
    "c, 1.4, 0.0009400, 0.0072140, 0.0359750, 0.1277820",
    "c, 5.5, 1",
    "c, 6.6, 1",
    "c, 7.7, 1",
    "p, HE , 5.9940000, 1.7450000, 0.5600000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "d, HE , 4.2990000, 1.2230000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "f, HE , 2.6800000",
    "c, 1.1, 1",
    "! LITHIUM       (13s,7p,4d,3f,2g) -> [6s,5p,4d,3f,2g]",
    "! LITHIUM       (12s,6p,3d,2f,1g) -> [5s,4p,3d,2f,1g]",
    "! LITHIUM       (1s,1p,1d,1f,1g)",
    "s, LI , 6601.0000000, 989.7000000, 225.7000000, 64.2900000, 21.1800000, 7.7240000, 3.0030000, 1.2120000, 0.4930000, 0.0951500, 0.0479100, 0.0222000, 0.0063600",
    "c, 1.9, 0.0001170, 0.0009110, 0.0047280, 0.0191970, 0.0630470, 0.1632080, 0.3148270, 0.3939360, 0.1969180",
    "c, 1.9, -0.0000180, -0.0001420, -0.0007410, -0.0030200, -0.0101230, -0.0270940, -0.0573590, -0.0938950, -0.1210910",
    "c, 10.10, 1",
    "c, 11.11, 1",
    "c, 12.12, 1",
    "c, 13.13, 1",
    "p, LI , 6.2500000, 1.3700000, 0.3672000, 0.1192000, 0.0447400, 0.0179500, 0.0075600",
    "c, 1.3, 0.0033880, 0.0193160, 0.0791040",
    "c, 4.4, 1",
    "c, 5.5, 1",
    "c, 6.6, 1",
    "c, 7.7, 1",
    "d, LI , 0.3440000, 0.1530000, 0.0680000, 0.0266000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "c, 4.4, 1",
    "f, LI , 0.2460000, 0.1292000, 0.0552000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "g, LI , 0.2380000, 0.1050000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "! BERYLLIUM       (13s,7p,4d,3f,2g) -> [6s,5p,4d,3f,2g]",
    "! BERYLLIUM       (12s,6p,3d,2f,1g) -> [5s,4p,3d,2f,1g]",
    "! BERYLLIUM       (1s,1p,1d,1f,1g)",
    "s, BE , 14630.0000000, 2191.0000000, 498.2000000, 140.9000000, 45.8600000, 16.4700000, 6.3190000, 2.5350000, 1.0350000, 0.2528000, 0.1052000, 0.0426100, 0.0143900",
    "c, 1.9, 0.0000920, 0.0007130, 0.0037350, 0.0154680, 0.0528740, 0.1456940, 0.3026810, 0.4049360, 0.2223870",
    "c, 1.9, -0.0000170, -0.0001300, -0.0006790, -0.0028570, -0.0098130, -0.0286090, -0.0637600, -0.1172310, -0.1212020",
    "c, 10.10, 1",
    "c, 11.11, 1",
    "c, 12.12, 1",
    "c, 13.13, 1",
    "p, BE , 14.0300000, 3.1680000, 0.9024000, 0.3036000, 0.1130000, 0.0428600, 0.0065000",
    "c, 1.3, 0.0040990, 0.0256260, 0.1037680",
    "c, 4.4, 1",
    "c, 5.5, 1",
    "c, 6.6, 1",
    "c, 7.7, 1",
    "d, BE , 1.0720000, 0.4410000, 0.1811000, 0.0554000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "c, 4.4, 1",
    "f, BE , 0.4810000, 0.2550000, 0.0930000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "g, BE , 0.4150000, 0.1834000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "! BORON       (13s,7p,4d,3f,2g) -> [6s,5p,4d,3f,2g]",
    "! BORON       (12s,6p,3d,2f,1g) -> [5s,4p,3d,2f,1g]",
    "! BORON       (1s,1p,1d,1f,1g)",
    "s, B , 23870.0000000, 3575.0000000, 812.8000000, 229.7000000, 74.6900000, 26.8100000, 10.3200000, 4.1780000, 1.7270000, 0.4704000, 0.1896000, 0.0739400, 0.0272100",
    "c, 1.9, 0.0000880, 0.0006870, 0.0036000, 0.0149490, 0.0514350, 0.1433020, 0.3009350, 0.4035260, 0.2253400",
    "c, 1.9, -0.0000180, -0.0001390, -0.0007250, -0.0030630, -0.0105810, -0.0313650, -0.0710120, -0.1321030, -0.1230720",
    "c, 10.10, 1",
    "c, 11.11, 1",
    "c, 12.12, 1",
    "c, 13.13, 1",
    "p, B , 22.2600000, 5.0580000, 1.4870000, 0.5071000, 0.1812000, 0.0646300, 0.0187800",
    "c, 1.3, 0.0050950, 0.0332060, 0.1323140",
    "c, 4.4, 1",
    "c, 5.5, 1",
    "c, 6.6, 1",
    "c, 7.7, 1",
    "d, B , 1.1100000, 0.4020000, 0.1450000, 0.0466000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "c, 4.4, 1",
    "f, B , 0.8820000, 0.3110000, 0.1130000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "g, B , 0.6730000, 0.2730000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "! CARBON       (13s,7p,4d,3f,2g) -> [6s,5p,4d,3f,2g]",
    "! CARBON       (12s,6p,3d,2f,1g) -> [5s,4p,3d,2f,1g]",
    "! CARBON       (1s,1p,1d,1f,1g)",
    "s, C , 33980.0000000, 5089.0000000, 1157.0000000, 326.6000000, 106.1000000, 38.1100000, 14.7500000, 6.0350000, 2.5300000, 0.7355000, 0.2905000, 0.1111000, 0.0414500",
    "c, 1.9, 0.0000910, 0.0007040, 0.0036930, 0.0153600, 0.0529290, 0.1470430, 0.3056310, 0.3993450, 0.2170510",
    "c, 1.9, -0.0000190, -0.0001510, -0.0007850, -0.0033240, -0.0115120, -0.0341600, -0.0771730, -0.1414930, -0.1180190",
    "c, 10.10, 1",
    "c, 11.11, 1",
    "c, 12.12, 1",
    "c, 13.13, 1",
    "p, C , 34.5100000, 7.9150000, 2.3680000, 0.8132000, 0.2890000, 0.1007000, 0.0321800",
    "c, 1.3, 0.0053780, 0.0361320, 0.1424930",
    "c, 4.4, 1",
    "c, 5.5, 1",
    "c, 6.6, 1",
    "c, 7.7, 1",
    "d, C , 1.8480000, 0.6490000, 0.2280000, 0.0766000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "c, 4.4, 1",
    "f, C , 1.4190000, 0.4850000, 0.1870000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "g, C , 1.0110000, 0.4240000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "! NITROGEN       (13s,7p,4d,3f,2g) -> [6s,5p,4d,3f,2g]",
    "! NITROGEN       (12s,6p,3d,2f,1g) -> [5s,4p,3d,2f,1g]",
    "! NITROGEN       (1s,1p,1d,1f,1g)",
    "s, N , 45840.0000000, 6868.0000000, 1563.0000000, 442.4000000, 144.3000000, 52.1800000, 20.3400000, 8.3810000, 3.5290000, 1.0540000, 0.4118000, 0.1552000, 0.0546400",
    "c, 1.9, 0.0000920, 0.0007170, 0.0037490, 0.0155320, 0.0531460, 0.1467870, 0.3046630, 0.3976840, 0.2176410",
    "c, 1.9, -0.0000200, -0.0001590, -0.0008240, -0.0034780, -0.0119660, -0.0353880, -0.0800770, -0.1467220, -0.1163600",
    "c, 10.10, 1",
    "c, 11.11, 1",
    "c, 12.12, 1",
    "c, 13.13, 1",
    "p, N , 49.3300000, 11.3700000, 3.4350000, 1.1820000, 0.4173000, 0.1428000, 0.0440200",
    "c, 1.3, 0.0055330, 0.0379620, 0.1490280",
    "c, 4.4, 1",
    "c, 5.5, 1",
    "c, 6.6, 1",
    "c, 7.7, 1",
    "d, N , 2.8370000, 0.9680000, 0.3350000, 0.1110000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "c, 4.4, 1",
    "f, N , 2.0270000, 0.6850000, 0.2450000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "g, N , 1.4270000, 0.5590000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "! OXYGEN       (13s,7p,4d,3f,2g) -> [6s,5p,4d,3f,2g]",
    "! OXYGEN       (12s,6p,3d,2f,1g) -> [5s,4p,3d,2f,1g]",
    "! OXYGEN       (1s,1p,1d,1f,1g)",
    "s, O , 61420.0000000, 9199.0000000, 2091.0000000, 590.9000000, 192.3000000, 69.3200000, 26.9700000, 11.1000000, 4.6820000, 1.4280000, 0.5547000, 0.2067000, 0.0695900",
    "c, 1.9, 0.0000900, 0.0006980, 0.0036640, 0.0152180, 0.0524230, 0.1459210, 0.3052580, 0.3985080, 0.2169800",
    "c, 1.9, -0.0000200, -0.0001590, -0.0008290, -0.0035080, -0.0121560, -0.0362610, -0.0829920, -0.1520900, -0.1153310",
    "c, 10.10, 1",
    "c, 11.11, 1",
    "c, 12.12, 1",
    "c, 13.13, 1",
    "p, O , 63.4200000, 14.6600000, 4.4590000, 1.5310000, 0.5302000, 0.1750000, 0.0534800",
    "c, 1.3, 0.0060440, 0.0417990, 0.1611430",
    "c, 4.4, 1",
    "c, 5.5, 1",
    "c, 6.6, 1",
    "c, 7.7, 1",
    "d, O , 3.7750000, 1.3000000, 0.4440000, 0.1540000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "c, 4.4, 1",
    "f, O , 2.6660000, 0.8590000, 0.3240000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "g, O , 1.8460000, 0.7140000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "! FLUORINE       (13s,7p,4d,3f,2g) -> [6s,5p,4d,3f,2g]",
    "! FLUORINE       (12s,6p,3d,2f,1g) -> [5s,4p,3d,2f,1g]",
    "! FLUORINE       (1s,1p,1d,1f,1g)",
    "s, F , 74530.0000000, 11170.0000000, 2543.0000000, 721.0000000, 235.9000000, 85.6000000, 33.5500000, 13.9300000, 5.9150000, 1.8430000, 0.7124000, 0.2637000, 0.0859400",
    "c, 1.9, 0.0000950, 0.0007380, 0.0038580, 0.0159260, 0.0542890, 0.1495130, 0.3082520, 0.3948530, 0.2110310",
    "c, 1.9, -0.0000220, -0.0001720, -0.0008910, -0.0037480, -0.0128620, -0.0380610, -0.0862390, -0.1558650, -0.1109140",
    "c, 10.10, 1",
    "c, 11.11, 1",
    "c, 12.12, 1",
    "c, 13.13, 1",
    "p, F , 80.3900000, 18.6300000, 5.6940000, 1.9530000, 0.6702000, 0.2166000, 0.0656800",
    "c, 1.3, 0.0063470, 0.0442040, 0.1685140",
    "c, 4.4, 1",
    "c, 5.5, 1",
    "c, 6.6, 1",
    "c, 7.7, 1",
    "d, F , 5.0140000, 1.7250000, 0.5860000, 0.2070000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "c, 4.4, 1",
    "f, F , 3.5620000, 1.1480000, 0.4600000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "g, F , 2.3760000, 0.9240000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "! NEON       (13s,7p,4d,3f,2g) -> [6s,5p,4d,3f,2g]",
    "! NEON       (12s,6p,3d,2f,1g) -> [5s,4p,3d,2f,1g]",
    "! NEON       (1s,1p,1d,1f,1g)",
    "s, NE , 99920.0000000, 14960.0000000, 3399.0000000, 958.9000000, 311.2000000, 111.7000000, 43.3200000, 17.8000000, 7.5030000, 2.3370000, 0.9001000, 0.3301000, 0.1054000",
    "c, 1.9, 0.0000860, 0.0006690, 0.0035180, 0.0146670, 0.0509620, 0.1437440, 0.3045620, 0.4001050, 0.2186440",
    "c, 1.9, -0.0000200, -0.0001580, -0.0008240, -0.0035000, -0.0122330, -0.0370170, -0.0861130, -0.1583810, -0.1142880",
    "c, 10.10, 1",
    "c, 11.11, 1",
    "c, 12.12, 1",
    "c, 13.13, 1",
    "p, NE , 99.6800000, 23.1500000, 7.1080000, 2.4410000, 0.8339000, 0.2662000, 0.0817800",
    "c, 1.3, 0.0065660, 0.0459790, 0.1734190",
    "c, 4.4, 1",
    "c, 5.5, 1",
    "c, 6.6, 1",
    "c, 7.7, 1",
    "d, NE , 6.4710000, 2.2130000, 0.7470000, 0.2730000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "c, 4.4, 1",
    "f, NE , 4.6570000, 1.5240000, 0.6890000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "g, NE , 2.9830000, 1.2240000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "! SODIUM       (20s,13p,4d,3f,2g) -> [7s,6p,4d,3f,2g]",
    "! SODIUM       (19s,12p,3d,2f,1g) -> [6s,5p,3d,2f,1g]",
    "! SODIUM       (1s,1p,1d,1f,1g)",
    "s, NA , 1224000.0000000, 183200.0000000, 41700.0000000, 11810.0000000, 3853.0000000, 1391.0000000, 542.5000000, 224.9000000, 97.9300000, 44.3100000, 20.6500000, 9.7290000, 4.2280000, 1.9690000, 0.8890000, 0.3964000, 0.0699300, 0.0328900, 0.0161200, 0.0050300",
    "c, 1.16, 0.478894D-05, 0.372395D-04, 0.195831D-03, 0.826698D-03, 0.300251D-02, 0.970310D-02, 0.282337D-01, 0.732058D-01, 0.162897D+00, 0.288708D+00, 0.346829D+00, 0.206865D+00, 0.328009D-01, -0.647736D-03, 0.145878D-02, -0.178346D-03",
    "c, 1.16, -0.116958D-05, -0.909110D-05, -0.478499D-04, -0.201962D-03, -0.735837D-03, -0.238746D-02, -0.704969D-02, -0.187856D-01, -0.446153D-01, -0.897741D-01, -0.142940D+00, -0.124315D+00, 0.999648D-01, 0.417080D+00, 0.475123D+00, 0.163268D+00",
    "c, 1.16, 0.175871D-06, 0.136594D-05, 0.719795D-05, 0.303349D-04, 0.110752D-03, 0.358596D-03, 0.106272D-02, 0.282687D-02, 0.676742D-02, 0.136480D-01, 0.222814D-01, 0.196011D-01, -0.167708D-01, -0.773734D-01, -0.113501D+00, -0.139130D+00",
    "c, 17.17, 1",
    "c, 18.18, 1",
    "c, 19.19, 1",
    "c, 20.20, 1",
    "p, NA , 413.4000000, 97.9800000, 31.3700000, 11.6200000, 4.6710000, 1.9180000, 0.7775000, 0.3013000, 0.2275000, 0.0752700, 0.0312600, 0.0134200, 0.0077200",
    "c, 1.9, 0.908196D-03, 0.741773D-02, 0.357464D-01, 0.118520D+00, 0.261403D+00, 0.378395D+00, 0.334632D+00, 0.126844D+00, -0.147117D-01",
    "c, 1.9, -0.901741D-04, -0.739342D-03, -0.357309D-02, -0.120142D-01, -0.267178D-01, -0.392753D-01, -0.376083D-01, -0.433228D-01, 0.518003D-01",
    "c, 10.10, 1",
    "c, 11.11, 1",
    "c, 12.12, 1",
    "c, 13.13, 1",
    "d, NA , 0.1538000, 0.0865000, 0.0487000, 0.0210000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "c, 4.4, 1",
    "f, NA , 0.1912000, 0.1036000, 0.0453000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "g, NA , 0.1722000, 0.0866000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "! MAGNESIUM       (17s,13p,4d,3f,2g) -> [7s,6p,4d,3f,2g]",
    "! MAGNESIUM       (16s,12p,3d,2f,1g) -> [6s,5p,3d,2f,1g]",
    "! MAGNESIUM       (1s,1p,1d,1f,1g)",
    "s, MG , 327600.0000000, 49050.0000000, 11150.0000000, 3152.0000000, 1025.0000000, 368.8000000, 143.2000000, 58.9600000, 25.4000000, 11.1500000, 4.0040000, 1.7010000, 0.7060000, 0.1410000, 0.0680800, 0.0306300, 0.0123900",
    "c, 1.13, 0.309608D-04, 0.240954D-03, 0.126660D-02, 0.533359D-02, 0.190770D-01, 0.588058D-01, 0.151454D+00, 0.300716D+00, 0.381149D+00, 0.213584D+00, 0.231210D-01, -0.230757D-02, 0.128900D-02",
    "c, 1.13, -0.783173D-05, -0.607935D-04, -0.321197D-03, -0.134955D-02, -0.490570D-02, -0.153561D-01, -0.423409D-01, -0.940603D-01, -0.163425D+00, -0.124754D+00, 0.235623D+00, 0.577563D+00, 0.335232D+00",
    "c, 1.13, 0.150908D-05, 0.117134D-04, 0.618980D-04, 0.260088D-03, 0.946218D-03, 0.296595D-02, 0.821245D-02, 0.183977D-01, 0.326657D-01, 0.257315D-01, -0.535351D-01, -0.156895D+00, -0.206659D+00",
    "c, 14.14, 1",
    "c, 15.15, 1",
    "c, 16.16, 1",
    "c, 17.17, 1",
    "p, MG , 539.6000000, 127.9000000, 41.0200000, 15.2500000, 6.1660000, 2.5610000, 1.0600000, 0.4176000, 0.2690000, 0.1223000, 0.0547600, 0.0238800, 0.0070600",
    "c, 1.9, 0.833969D-03, 0.689215D-02, 0.337874D-01, 0.114401D+00, 0.259514D+00, 0.385095D+00, 0.335373D+00, 0.110641D+00, -0.121315D-01",
    "c, 1.9, -0.132076D-03, -0.109538D-02, -0.539495D-02, -0.185572D-01, -0.427375D-01, -0.647684D-01, -0.627818D-01, -0.244912D-01, 0.104761D+00",
    "c, 10.10, 1",
    "c, 11.11, 1",
    "c, 12.12, 1",
    "c, 13.13, 1",
    "d, MG , 0.1060000, 0.1944000, 0.3570000, 0.0382000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "c, 4.4, 1",
    "f, MG , 0.1810000, 0.3590000, 0.0700000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "g, MG , 0.3070000, 0.1480000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "! ALUMINUM       (17s,12p,4d,3f,2g) -> [7s,6p,4d,3f,2g]",
    "! ALUMINUM       (16s,11p,3d,2f,1g) -> [6s,5p,3d,2f,1g]",
    "! ALUMINUM       (1s,1p,1d,1f,1g)",
    "s, AL , 419600.0000000, 62830.0000000, 14290.0000000, 4038.0000000, 1312.0000000, 470.5000000, 181.8000000, 74.4600000, 31.9000000, 13.9600000, 5.1800000, 2.2650000, 0.9664000, 0.2447000, 0.1184000, 0.0502100, 0.0183000",
    "c, 1.13, 0.278219D-04, 0.216330D-03, 0.113754D-02, 0.479635D-02, 0.172389D-01, 0.538066D-01, 0.141326D+00, 0.289268D+00, 0.384825D+00, 0.232852D+00, 0.293330D-01, -0.300574D-02, 0.166673D-02",
    "c, 1.13, -0.723754D-05, -0.561733D-04, -0.296528D-03, -0.124913D-02, -0.455101D-02, -0.144393D-01, -0.403464D-01, -0.922618D-01, -0.164510D+00, -0.141296D+00, 0.195365D+00, 0.572475D+00, 0.374041D+00",
    "c, 1.13, 0.167150D-05, 0.129641D-04, 0.685101D-04, 0.288274D-03, 0.105276D-02, 0.333878D-02, 0.939217D-02, 0.216047D-01, 0.395873D-01, 0.349180D-01, -0.528415D-01, -0.191878D+00, -0.254115D+00",
    "c, 14.14, 1",
    "c, 15.15, 1",
    "c, 16.16, 1",
    "c, 17.17, 1",
    "p, AL , 891.3000000, 211.3000000, 68.2800000, 25.7000000, 10.6300000, 4.6020000, 2.0150000, 0.8706000, 0.2972000, 0.1100000, 0.0398900, 0.0121000",
    "c, 1.8, 0.491755D-03, 0.415843D-02, 0.212538D-01, 0.764058D-01, 0.194277D+00, 0.334428D+00, 0.375026D+00, 0.204041D+00",
    "c, 1.8, -0.888695D-04, -0.745823D-03, -0.387025D-02, -0.139350D-01, -0.366860D-01, -0.627797D-01, -0.789602D-01, -0.288589D-01",
    "c, 9.9, 1",
    "c, 10.10, 1",
    "c, 11.11, 1",
    "c, 12.12, 1",
    "d, AL , 0.0804000, 0.1990000, 0.4940000, 0.0282000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "c, 4.4, 1",
    "f, AL , 0.1540000, 0.4010000, 0.0582000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "g, AL , 0.3570000, 0.1530000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "! SILICON       (17s,12p,4d,3f,2g) -> [7s,6p,4d,3f,2g]",
    "! SILICON       (16s,11p,3d,2f,1g) -> [6s,5p,3d,2f,1g]",
    "! SILICON       (1s,1p,1d,1f,1g)",
    "s, SI , 513000.0000000, 76820.0000000, 17470.0000000, 4935.0000000, 1602.0000000, 574.1000000, 221.5000000, 90.5400000, 38.7400000, 16.9500000, 6.4520000, 2.8740000, 1.2500000, 0.3599000, 0.1699000, 0.0706600, 0.0275000",
    "c, 1.13, 0.260920D-04, 0.202905D-03, 0.106715D-02, 0.450597D-02, 0.162359D-01, 0.508913D-01, 0.135155D+00, 0.281292D+00, 0.385336D+00, 0.245651D+00, 0.343145D-01, -0.334884D-02, 0.187625D-02",
    "c, 1.13, -0.694880D-05, -0.539641D-04, -0.284716D-03, -0.120203D-02, -0.438397D-02, -0.139776D-01, -0.393516D-01, -0.914283D-01, -0.165609D+00, -0.152505D+00, 0.168524D+00, 0.569284D+00, 0.398056D+00",
    "c, 1.13, 0.178068D-05, 0.138148D-04, 0.730005D-04, 0.307666D-03, 0.112563D-02, 0.358435D-02, 0.101728D-01, 0.237520D-01, 0.443483D-01, 0.419041D-01, -0.502504D-01, -0.216578D+00, -0.286448D+00",
    "c, 14.14, 1",
    "c, 15.15, 1",
    "c, 16.16, 1",
    "c, 17.17, 1",
    "p, SI , 1122.0000000, 266.0000000, 85.9200000, 32.3300000, 13.3700000, 5.8000000, 2.5590000, 1.1240000, 0.3988000, 0.1533000, 0.0572800, 0.0200000",
    "c, 1.8, 0.448143D-03, 0.381639D-02, 0.198105D-01, 0.727017D-01, 0.189839D+00, 0.335672D+00, 0.379365D+00, 0.201193D+00",
    "c, 1.8, -0.964883D-04, -0.811971D-03, -0.430087D-02, -0.157502D-01, -0.429541D-01, -0.752574D-01, -0.971446D-01, -0.227507D-01",
    "c, 9.9, 1",
    "c, 10.10, 1",
    "c, 11.11, 1",
    "c, 12.12, 1",
    "d, SI , 0.1200000, 0.3020000, 0.7600000, 0.0435000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "c, 4.4, 1",
    "f, SI , 0.2120000, 0.5410000, 0.0846000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "g, SI , 0.4610000, 0.2120000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "! PHOSPHOROUS       (17s,12p,4d,3f,2g) -> [7s,6p,4d,3f,2g]",
    "! PHOSPHOROUS       (16s,11p,3d,2f,1g) -> [6s,5p,3d,2f,1g]",
    "! PHOSPHOROUS       (1s,1p,1d,1f,1g)",
    "s, P , 615200.0000000, 92120.0000000, 20950.0000000, 5920.0000000, 1922.0000000, 688.0000000, 265.0000000, 108.2000000, 46.2200000, 20.2300000, 7.8590000, 3.5470000, 1.5640000, 0.4888000, 0.2266000, 0.0933100, 0.0354000",
    "c, 1.13, 0.247450D-04, 0.192465D-03, 0.101202D-02, 0.427261D-02, 0.154161D-01, 0.485976D-01, 0.130060D+00, 0.274514D+00, 0.385402D+00, 0.255934D+00, 0.391237D-01, -0.368010D-02, 0.208211D-02",
    "c, 1.13, -0.672205D-05, -0.522311D-04, -0.275361D-03, -0.116307D-02, -0.424281D-02, -0.136114D-01, -0.385114D-01, -0.906643D-01, -0.166584D+00, -0.161447D+00, 0.146781D+00, 0.566682D+00, 0.416433D+00",
    "c, 1.13, 0.184740D-05, 0.143380D-04, 0.757228D-04, 0.319205D-03, 0.116851D-02, 0.374267D-02, 0.106817D-01, 0.252657D-01, 0.479283D-01, 0.477096D-01, -0.466525D-01, -0.234968D+00, -0.311337D+00",
    "c, 14.14, 1",
    "c, 15.15, 1",
    "c, 16.16, 1",
    "c, 17.17, 1",
    "p, P , 1367.0000000, 324.0000000, 104.6000000, 39.3700000, 16.2600000, 7.0560000, 3.1300000, 1.3940000, 0.5179000, 0.2032000, 0.0769800, 0.0272000",
    "c, 1.8, 0.421015D-03, 0.360985D-02, 0.189217D-01, 0.705560D-01, 0.188157D+00, 0.338709D+00, 0.381943D+00, 0.195261D+00",
    "c, 1.8, -0.100827D-03, -0.854499D-03, -0.457116D-02, -0.170327D-01, -0.475204D-01, -0.852786D-01, -0.109676D+00, -0.161181D-01",
    "c, 9.9, 1",
    "c, 10.10, 1",
    "c, 11.11, 1",
    "c, 12.12, 1",
    "d, P , 0.1650000, 0.4130000, 1.0360000, 0.0594000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "c, 4.4, 1",
    "f, P , 0.2800000, 0.7030000, 0.1090000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "g, P , 0.5970000, 0.2500000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "! SULFUR       (17s,12p,4d,3f,2g) -> [7s,6p,4d,3f,2g]",
    "! SULFUR       (16s,11p,3d,2f,1g) -> [6s,5p,3d,2f,1g]",
    "! SULFUR       (1s,1p,1d,1f,1g)",
    "s, S , 727800.0000000, 109000.0000000, 24800.0000000, 7014.0000000, 2278.0000000, 814.7000000, 313.4000000, 127.7000000, 54.4800000, 23.8500000, 9.4280000, 4.2900000, 1.9090000, 0.6270000, 0.2873000, 0.1172000, 0.0428000",
    "c, 1.13, 0.236025D-04, 0.183482D-03, 0.964278D-03, 0.406537D-02, 0.146973D-01, 0.465081D-01, 0.125508D+00, 0.268433D+00, 0.384809D+00, 0.265372D+00, 0.437326D-01, -0.378807D-02, 0.218083D-02",
    "c, 1.13, -0.652179D-05, -0.506631D-04, -0.266833D-03, -0.112601D-02, -0.411186D-02, -0.132454D-01, -0.377004D-01, -0.898554D-01, -0.167098D+00, -0.169354D+00, 0.127824D+00, 0.564862D+00, 0.431767D+00",
    "c, 1.13, 0.189406D-05, 0.146948D-04, 0.775460D-04, 0.326509D-03, 0.119686D-02, 0.384799D-02, 0.110539D-01, 0.264645D-01, 0.508771D-01, 0.530030D-01, -0.425518D-01, -0.250853D+00, -0.333152D+00",
    "c, 14.14, 1",
    "c, 15.15, 1",
    "c, 16.16, 1",
    "c, 17.17, 1",
    "p, S , 1546.0000000, 366.4000000, 118.4000000, 44.5300000, 18.3800000, 7.9650000, 3.5410000, 1.5910000, 0.6205000, 0.2420000, 0.0901400, 0.0317000",
    "c, 1.8, 0.441183D-03, 0.377571D-02, 0.198360D-01, 0.742063D-01, 0.197327D+00, 0.351851D+00, 0.378687D+00, 0.170931D+00",
    "c, 1.8, -0.113110D-03, -0.958581D-03, -0.513471D-02, -0.192641D-01, -0.535980D-01, -0.960333D-01, -0.118183D+00, 0.923194D-02",
    "c, 9.9, 1",
    "c, 10.10, 1",
    "c, 11.11, 1",
    "c, 12.12, 1",
    "d, S , 0.2030000, 0.5040000, 1.2500000, 0.0748000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "c, 4.4, 1",
    "f, S , 0.3350000, 0.8690000, 0.1400000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "g, S , 0.6830000, 0.2970000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "! CHLORINE       (17s,12p,4d,3f,2g) -> [7s,6p,4d,3f,2g]",
    "! CHLORINE       (16s,11p,3d,2f,1g) -> [6s,5p,3d,2f,1g]",
    "! CHLORINE       (1s,1p,1d,1f,1g)",
    "s, CL , 834900.0000000, 125000.0000000, 28430.0000000, 8033.0000000, 2608.0000000, 933.9000000, 360.0000000, 147.0000000, 62.8800000, 27.6000000, 11.0800000, 5.0750000, 2.2780000, 0.7775000, 0.3527000, 0.1431000, 0.0519000",
    "c, 1.13, 0.231688D-04, 0.180154D-03, 0.947782D-03, 0.400139D-02, 0.144629D-01, 0.456586D-01, 0.123248D+00, 0.264369D+00, 0.382989D+00, 0.270934D+00, 0.471404D-01, -0.371766D-02, 0.219158D-02",
    "c, 1.13, -0.649649D-05, -0.504895D-04, -0.266113D-03, -0.112499D-02, -0.410497D-02, -0.131987D-01, -0.375342D-01, -0.897233D-01, -0.167671D+00, -0.174763D+00, 0.114909D+00, 0.563618D+00, 0.441606D+00",
    "c, 1.13, 0.196645D-05, 0.152620D-04, 0.806086D-04, 0.339960D-03, 0.124551D-02, 0.399612D-02, 0.114751D-01, 0.275504D-01, 0.532917D-01, 0.571246D-01, -0.395201D-01, -0.264343D+00, -0.349291D+00",
    "c, 14.14, 1",
    "c, 15.15, 1",
    "c, 16.16, 1",
    "c, 17.17, 1",
    "p, CL , 1703.0000000, 403.6000000, 130.3000000, 49.0500000, 20.2600000, 8.7870000, 3.9190000, 1.7650000, 0.7207000, 0.2839000, 0.1060000, 0.0376000",
    "c, 1.8, 0.474039D-03, 0.406412D-02, 0.213355D-01, 0.794611D-01, 0.208927D+00, 0.364945D+00, 0.371725D+00, 0.146292D+00",
    "c, 1.8, -0.128266D-03, -0.109356D-02, -0.583429D-02, -0.219258D-01, -0.601385D-01, -0.106929D+00, -0.122454D+00, 0.383619D-01",
    "c, 9.9, 1",
    "c, 10.10, 1",
    "c, 11.11, 1",
    "c, 12.12, 1",
    "d, CL , 0.2540000, 0.6280000, 1.5510000, 0.0952000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "c, 4.4, 1",
    "f, CL , 0.4230000, 1.0890000, 0.2170000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "g, CL , 0.8270000, 0.3780000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "! ARGON       (17s,12p,4d,3f,2g) -> [7s,6p,4d,3f,2g]",
    "! ARGON       (16s,11p,3d,2f,1g) -> [6s,5p,3d,2f,1g]",
    "! ARGON       (1s,1p,1d,1f,1g)",
    "s, AR , 950600.0000000, 142300.0000000, 32360.0000000, 9145.0000000, 2970.0000000, 1064.0000000, 410.8000000, 168.0000000, 71.9900000, 31.6700000, 12.8900000, 5.9290000, 2.6780000, 0.9416000, 0.4239000, 0.1714000, 0.0610000",
    "c, 1.13, 0.227545D-04, 0.176945D-03, 0.931282D-03, 0.392860D-02, 0.142064D-01, 0.448114D-01, 0.121001D+00, 0.260579D+00, 0.381364D+00, 0.276058D+00, 0.505179D-01, -0.359866D-02, 0.218798D-02",
    "c, 1.13, -0.646201D-05, -0.502346D-04, -0.264804D-03, -0.111895D-02, -0.408276D-02, -0.131216D-01, -0.372855D-01, -0.894709D-01, -0.168054D+00, -0.179594D+00, 0.102953D+00, 0.562630D+00, 0.450355D+00",
    "c, 1.13, 0.202056D-05, 0.156851D-04, 0.828617D-04, 0.349264D-03, 0.127976D-02, 0.410365D-02, 0.117789D-01, 0.283868D-01, 0.552406D-01, 0.607492D-01, -0.362012D-01, -0.275398D+00, -0.362845D+00",
    "c, 14.14, 1",
    "c, 15.15, 1",
    "c, 16.16, 1",
    "c, 17.17, 1",
    "p, AR , 1890.0000000, 447.8000000, 144.6000000, 54.4600000, 22.5100000, 9.7740000, 4.3680000, 1.9590000, 0.8260000, 0.3297000, 0.1242000, 0.0435000",
    "c, 1.8, 0.495752D-03, 0.425172D-02, 0.223277D-01, 0.830878D-01, 0.217110D+00, 0.374507D+00, 0.366445D+00, 0.129245D+00",
    "c, 1.8, -0.138863D-03, -0.118870D-02, -0.632553D-02, -0.238813D-01, -0.649238D-01, -0.115444D+00, -0.123651D+00, 0.649055D-01",
    "c, 9.9, 1",
    "c, 10.10, 1",
    "c, 11.11, 1",
    "c, 12.12, 1",
    "d, AR , 0.3110000, 0.7630000, 1.8730000, 0.1160000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "c, 4.4, 1",
    "f, AR , 0.5430000, 1.3250000, 0.2940000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "g, AR , 1.0070000, 0.4590000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    ],

'jun-cc-pvqz': [
    "! #####################",
    "! ##                 ##",
    "! ##   jun-cc-pVQZ   ##",
    "! ##                 ##",
    "! #####################",
    "!",
    "! HYDROGEN       (7s,4p,3d,2f) -> [5s,4p,3d,2f]",
    "! HYDROGEN       (6s,3p,2d,1f) -> [4s,3p,2d,1f]",
    "! HYDROGEN       (1s,1p,1d,1f)",
    "s, H , 82.6400000, 12.4100000, 2.8240000, 0.7977000, 0.2581000, 0.0898900",
    "c, 1.3, 0.0020060, 0.0153430, 0.0755790",
    "c, 4.4, 1",
    "c, 5.5, 1",
    "c, 6.6, 1",
    "p, H , 2.2920000, 0.8380000, 0.2920000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "d, H , 2.0620000, 0.6620000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "f, H , 1.3970000",
    "c, 1.1, 1",
    "! HELIUM       (8s,4p,3d,2f) -> [5s,4p,3d,2f]",
    "! HELIUM       (7s,3p,2d,1f) -> [4s,3p,2d,1f]",
    "! HELIUM       (1s,1p,1d,1f)",
    "s, HE , 528.5000000, 79.3100000, 18.0500000, 5.0850000, 1.6090000, 0.5363000, 0.1833000",
    "c, 1.4, 0.0009400, 0.0072140, 0.0359750, 0.1277820",
    "c, 5.5, 1",
    "c, 6.6, 1",
    "c, 7.7, 1",
    "p, HE , 5.9940000, 1.7450000, 0.5600000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "d, HE , 4.2990000, 1.2230000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "f, HE , 2.6800000",
    "c, 1.1, 1",
    "! LITHIUM       (13s,7p,4d,3f,2g) -> [6s,5p,4d,3f,2g]",
    "! LITHIUM       (12s,6p,3d,2f,1g) -> [5s,4p,3d,2f,1g]",
    "! LITHIUM       (1s,1p,1d,1f,1g)",
    "s, LI , 6601.0000000, 989.7000000, 225.7000000, 64.2900000, 21.1800000, 7.7240000, 3.0030000, 1.2120000, 0.4930000, 0.0951500, 0.0479100, 0.0222000, 0.0063600",
    "c, 1.9, 0.0001170, 0.0009110, 0.0047280, 0.0191970, 0.0630470, 0.1632080, 0.3148270, 0.3939360, 0.1969180",
    "c, 1.9, -0.0000180, -0.0001420, -0.0007410, -0.0030200, -0.0101230, -0.0270940, -0.0573590, -0.0938950, -0.1210910",
    "c, 10.10, 1",
    "c, 11.11, 1",
    "c, 12.12, 1",
    "c, 13.13, 1",
    "p, LI , 6.2500000, 1.3700000, 0.3672000, 0.1192000, 0.0447400, 0.0179500, 0.0075600",
    "c, 1.3, 0.0033880, 0.0193160, 0.0791040",
    "c, 4.4, 1",
    "c, 5.5, 1",
    "c, 6.6, 1",
    "c, 7.7, 1",
    "d, LI , 0.3440000, 0.1530000, 0.0680000, 0.0266000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "c, 4.4, 1",
    "f, LI , 0.2460000, 0.1292000, 0.0552000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "g, LI , 0.2380000",
    "c, 1.1, 1",
    "! BERYLLIUM       (13s,7p,4d,3f,2g) -> [6s,5p,4d,3f,2g]",
    "! BERYLLIUM       (12s,6p,3d,2f,1g) -> [5s,4p,3d,2f,1g]",
    "! BERYLLIUM       (1s,1p,1d,1f,1g)",
    "s, BE , 14630.0000000, 2191.0000000, 498.2000000, 140.9000000, 45.8600000, 16.4700000, 6.3190000, 2.5350000, 1.0350000, 0.2528000, 0.1052000, 0.0426100, 0.0143900",
    "c, 1.9, 0.0000920, 0.0007130, 0.0037350, 0.0154680, 0.0528740, 0.1456940, 0.3026810, 0.4049360, 0.2223870",
    "c, 1.9, -0.0000170, -0.0001300, -0.0006790, -0.0028570, -0.0098130, -0.0286090, -0.0637600, -0.1172310, -0.1212020",
    "c, 10.10, 1",
    "c, 11.11, 1",
    "c, 12.12, 1",
    "c, 13.13, 1",
    "p, BE , 14.0300000, 3.1680000, 0.9024000, 0.3036000, 0.1130000, 0.0428600, 0.0065000",
    "c, 1.3, 0.0040990, 0.0256260, 0.1037680",
    "c, 4.4, 1",
    "c, 5.5, 1",
    "c, 6.6, 1",
    "c, 7.7, 1",
    "d, BE , 1.0720000, 0.4410000, 0.1811000, 0.0554000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "c, 4.4, 1",
    "f, BE , 0.4810000, 0.2550000, 0.0930000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "g, BE , 0.4150000",
    "c, 1.1, 1",
    "! BORON       (13s,7p,4d,3f,2g) -> [6s,5p,4d,3f,2g]",
    "! BORON       (12s,6p,3d,2f,1g) -> [5s,4p,3d,2f,1g]",
    "! BORON       (1s,1p,1d,1f,1g)",
    "s, B , 23870.0000000, 3575.0000000, 812.8000000, 229.7000000, 74.6900000, 26.8100000, 10.3200000, 4.1780000, 1.7270000, 0.4704000, 0.1896000, 0.0739400, 0.0272100",
    "c, 1.9, 0.0000880, 0.0006870, 0.0036000, 0.0149490, 0.0514350, 0.1433020, 0.3009350, 0.4035260, 0.2253400",
    "c, 1.9, -0.0000180, -0.0001390, -0.0007250, -0.0030630, -0.0105810, -0.0313650, -0.0710120, -0.1321030, -0.1230720",
    "c, 10.10, 1",
    "c, 11.11, 1",
    "c, 12.12, 1",
    "c, 13.13, 1",
    "p, B , 22.2600000, 5.0580000, 1.4870000, 0.5071000, 0.1812000, 0.0646300, 0.0187800",
    "c, 1.3, 0.0050950, 0.0332060, 0.1323140",
    "c, 4.4, 1",
    "c, 5.5, 1",
    "c, 6.6, 1",
    "c, 7.7, 1",
    "d, B , 1.1100000, 0.4020000, 0.1450000, 0.0466000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "c, 4.4, 1",
    "f, B , 0.8820000, 0.3110000, 0.1130000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "g, B , 0.6730000",
    "c, 1.1, 1",
    "! CARBON       (13s,7p,4d,3f,2g) -> [6s,5p,4d,3f,2g]",
    "! CARBON       (12s,6p,3d,2f,1g) -> [5s,4p,3d,2f,1g]",
    "! CARBON       (1s,1p,1d,1f,1g)",
    "s, C , 33980.0000000, 5089.0000000, 1157.0000000, 326.6000000, 106.1000000, 38.1100000, 14.7500000, 6.0350000, 2.5300000, 0.7355000, 0.2905000, 0.1111000, 0.0414500",
    "c, 1.9, 0.0000910, 0.0007040, 0.0036930, 0.0153600, 0.0529290, 0.1470430, 0.3056310, 0.3993450, 0.2170510",
    "c, 1.9, -0.0000190, -0.0001510, -0.0007850, -0.0033240, -0.0115120, -0.0341600, -0.0771730, -0.1414930, -0.1180190",
    "c, 10.10, 1",
    "c, 11.11, 1",
    "c, 12.12, 1",
    "c, 13.13, 1",
    "p, C , 34.5100000, 7.9150000, 2.3680000, 0.8132000, 0.2890000, 0.1007000, 0.0321800",
    "c, 1.3, 0.0053780, 0.0361320, 0.1424930",
    "c, 4.4, 1",
    "c, 5.5, 1",
    "c, 6.6, 1",
    "c, 7.7, 1",
    "d, C , 1.8480000, 0.6490000, 0.2280000, 0.0766000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "c, 4.4, 1",
    "f, C , 1.4190000, 0.4850000, 0.1870000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "g, C , 1.0110000",
    "c, 1.1, 1",
    "! NITROGEN       (13s,7p,4d,3f,2g) -> [6s,5p,4d,3f,2g]",
    "! NITROGEN       (12s,6p,3d,2f,1g) -> [5s,4p,3d,2f,1g]",
    "! NITROGEN       (1s,1p,1d,1f,1g)",
    "s, N , 45840.0000000, 6868.0000000, 1563.0000000, 442.4000000, 144.3000000, 52.1800000, 20.3400000, 8.3810000, 3.5290000, 1.0540000, 0.4118000, 0.1552000, 0.0546400",
    "c, 1.9, 0.0000920, 0.0007170, 0.0037490, 0.0155320, 0.0531460, 0.1467870, 0.3046630, 0.3976840, 0.2176410",
    "c, 1.9, -0.0000200, -0.0001590, -0.0008240, -0.0034780, -0.0119660, -0.0353880, -0.0800770, -0.1467220, -0.1163600",
    "c, 10.10, 1",
    "c, 11.11, 1",
    "c, 12.12, 1",
    "c, 13.13, 1",
    "p, N , 49.3300000, 11.3700000, 3.4350000, 1.1820000, 0.4173000, 0.1428000, 0.0440200",
    "c, 1.3, 0.0055330, 0.0379620, 0.1490280",
    "c, 4.4, 1",
    "c, 5.5, 1",
    "c, 6.6, 1",
    "c, 7.7, 1",
    "d, N , 2.8370000, 0.9680000, 0.3350000, 0.1110000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "c, 4.4, 1",
    "f, N , 2.0270000, 0.6850000, 0.2450000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "g, N , 1.4270000",
    "c, 1.1, 1",
    "! OXYGEN       (13s,7p,4d,3f,2g) -> [6s,5p,4d,3f,2g]",
    "! OXYGEN       (12s,6p,3d,2f,1g) -> [5s,4p,3d,2f,1g]",
    "! OXYGEN       (1s,1p,1d,1f,1g)",
    "s, O , 61420.0000000, 9199.0000000, 2091.0000000, 590.9000000, 192.3000000, 69.3200000, 26.9700000, 11.1000000, 4.6820000, 1.4280000, 0.5547000, 0.2067000, 0.0695900",
    "c, 1.9, 0.0000900, 0.0006980, 0.0036640, 0.0152180, 0.0524230, 0.1459210, 0.3052580, 0.3985080, 0.2169800",
    "c, 1.9, -0.0000200, -0.0001590, -0.0008290, -0.0035080, -0.0121560, -0.0362610, -0.0829920, -0.1520900, -0.1153310",
    "c, 10.10, 1",
    "c, 11.11, 1",
    "c, 12.12, 1",
    "c, 13.13, 1",
    "p, O , 63.4200000, 14.6600000, 4.4590000, 1.5310000, 0.5302000, 0.1750000, 0.0534800",
    "c, 1.3, 0.0060440, 0.0417990, 0.1611430",
    "c, 4.4, 1",
    "c, 5.5, 1",
    "c, 6.6, 1",
    "c, 7.7, 1",
    "d, O , 3.7750000, 1.3000000, 0.4440000, 0.1540000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "c, 4.4, 1",
    "f, O , 2.6660000, 0.8590000, 0.3240000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "g, O , 1.8460000",
    "c, 1.1, 1",
    "! FLUORINE       (13s,7p,4d,3f,2g) -> [6s,5p,4d,3f,2g]",
    "! FLUORINE       (12s,6p,3d,2f,1g) -> [5s,4p,3d,2f,1g]",
    "! FLUORINE       (1s,1p,1d,1f,1g)",
    "s, F , 74530.0000000, 11170.0000000, 2543.0000000, 721.0000000, 235.9000000, 85.6000000, 33.5500000, 13.9300000, 5.9150000, 1.8430000, 0.7124000, 0.2637000, 0.0859400",
    "c, 1.9, 0.0000950, 0.0007380, 0.0038580, 0.0159260, 0.0542890, 0.1495130, 0.3082520, 0.3948530, 0.2110310",
    "c, 1.9, -0.0000220, -0.0001720, -0.0008910, -0.0037480, -0.0128620, -0.0380610, -0.0862390, -0.1558650, -0.1109140",
    "c, 10.10, 1",
    "c, 11.11, 1",
    "c, 12.12, 1",
    "c, 13.13, 1",
    "p, F , 80.3900000, 18.6300000, 5.6940000, 1.9530000, 0.6702000, 0.2166000, 0.0656800",
    "c, 1.3, 0.0063470, 0.0442040, 0.1685140",
    "c, 4.4, 1",
    "c, 5.5, 1",
    "c, 6.6, 1",
    "c, 7.7, 1",
    "d, F , 5.0140000, 1.7250000, 0.5860000, 0.2070000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "c, 4.4, 1",
    "f, F , 3.5620000, 1.1480000, 0.4600000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "g, F , 2.3760000",
    "c, 1.1, 1",
    "! NEON       (13s,7p,4d,3f,2g) -> [6s,5p,4d,3f,2g]",
    "! NEON       (12s,6p,3d,2f,1g) -> [5s,4p,3d,2f,1g]",
    "! NEON       (1s,1p,1d,1f,1g)",
    "s, NE , 99920.0000000, 14960.0000000, 3399.0000000, 958.9000000, 311.2000000, 111.7000000, 43.3200000, 17.8000000, 7.5030000, 2.3370000, 0.9001000, 0.3301000, 0.1054000",
    "c, 1.9, 0.0000860, 0.0006690, 0.0035180, 0.0146670, 0.0509620, 0.1437440, 0.3045620, 0.4001050, 0.2186440",
    "c, 1.9, -0.0000200, -0.0001580, -0.0008240, -0.0035000, -0.0122330, -0.0370170, -0.0861130, -0.1583810, -0.1142880",
    "c, 10.10, 1",
    "c, 11.11, 1",
    "c, 12.12, 1",
    "c, 13.13, 1",
    "p, NE , 99.6800000, 23.1500000, 7.1080000, 2.4410000, 0.8339000, 0.2662000, 0.0817800",
    "c, 1.3, 0.0065660, 0.0459790, 0.1734190",
    "c, 4.4, 1",
    "c, 5.5, 1",
    "c, 6.6, 1",
    "c, 7.7, 1",
    "d, NE , 6.4710000, 2.2130000, 0.7470000, 0.2730000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "c, 4.4, 1",
    "f, NE , 4.6570000, 1.5240000, 0.6890000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "g, NE , 2.9830000",
    "c, 1.1, 1",
    "! SODIUM       (20s,13p,4d,3f,2g) -> [7s,6p,4d,3f,2g]",
    "! SODIUM       (19s,12p,3d,2f,1g) -> [6s,5p,3d,2f,1g]",
    "! SODIUM       (1s,1p,1d,1f,1g)",
    "s, NA , 1224000.0000000, 183200.0000000, 41700.0000000, 11810.0000000, 3853.0000000, 1391.0000000, 542.5000000, 224.9000000, 97.9300000, 44.3100000, 20.6500000, 9.7290000, 4.2280000, 1.9690000, 0.8890000, 0.3964000, 0.0699300, 0.0328900, 0.0161200, 0.0050300",
    "c, 1.16, 0.478894D-05, 0.372395D-04, 0.195831D-03, 0.826698D-03, 0.300251D-02, 0.970310D-02, 0.282337D-01, 0.732058D-01, 0.162897D+00, 0.288708D+00, 0.346829D+00, 0.206865D+00, 0.328009D-01, -0.647736D-03, 0.145878D-02, -0.178346D-03",
    "c, 1.16, -0.116958D-05, -0.909110D-05, -0.478499D-04, -0.201962D-03, -0.735837D-03, -0.238746D-02, -0.704969D-02, -0.187856D-01, -0.446153D-01, -0.897741D-01, -0.142940D+00, -0.124315D+00, 0.999648D-01, 0.417080D+00, 0.475123D+00, 0.163268D+00",
    "c, 1.16, 0.175871D-06, 0.136594D-05, 0.719795D-05, 0.303349D-04, 0.110752D-03, 0.358596D-03, 0.106272D-02, 0.282687D-02, 0.676742D-02, 0.136480D-01, 0.222814D-01, 0.196011D-01, -0.167708D-01, -0.773734D-01, -0.113501D+00, -0.139130D+00",
    "c, 17.17, 1",
    "c, 18.18, 1",
    "c, 19.19, 1",
    "c, 20.20, 1",
    "p, NA , 413.4000000, 97.9800000, 31.3700000, 11.6200000, 4.6710000, 1.9180000, 0.7775000, 0.3013000, 0.2275000, 0.0752700, 0.0312600, 0.0134200, 0.0077200",
    "c, 1.9, 0.908196D-03, 0.741773D-02, 0.357464D-01, 0.118520D+00, 0.261403D+00, 0.378395D+00, 0.334632D+00, 0.126844D+00, -0.147117D-01",
    "c, 1.9, -0.901741D-04, -0.739342D-03, -0.357309D-02, -0.120142D-01, -0.267178D-01, -0.392753D-01, -0.376083D-01, -0.433228D-01, 0.518003D-01",
    "c, 10.10, 1",
    "c, 11.11, 1",
    "c, 12.12, 1",
    "c, 13.13, 1",
    "d, NA , 0.1538000, 0.0865000, 0.0487000, 0.0210000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "c, 4.4, 1",
    "f, NA , 0.1912000, 0.1036000, 0.0453000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "g, NA , 0.1722000",
    "c, 1.1, 1",
    "! MAGNESIUM       (17s,13p,4d,3f,2g) -> [7s,6p,4d,3f,2g]",
    "! MAGNESIUM       (16s,12p,3d,2f,1g) -> [6s,5p,3d,2f,1g]",
    "! MAGNESIUM       (1s,1p,1d,1f,1g)",
    "s, MG , 327600.0000000, 49050.0000000, 11150.0000000, 3152.0000000, 1025.0000000, 368.8000000, 143.2000000, 58.9600000, 25.4000000, 11.1500000, 4.0040000, 1.7010000, 0.7060000, 0.1410000, 0.0680800, 0.0306300, 0.0123900",
    "c, 1.13, 0.309608D-04, 0.240954D-03, 0.126660D-02, 0.533359D-02, 0.190770D-01, 0.588058D-01, 0.151454D+00, 0.300716D+00, 0.381149D+00, 0.213584D+00, 0.231210D-01, -0.230757D-02, 0.128900D-02",
    "c, 1.13, -0.783173D-05, -0.607935D-04, -0.321197D-03, -0.134955D-02, -0.490570D-02, -0.153561D-01, -0.423409D-01, -0.940603D-01, -0.163425D+00, -0.124754D+00, 0.235623D+00, 0.577563D+00, 0.335232D+00",
    "c, 1.13, 0.150908D-05, 0.117134D-04, 0.618980D-04, 0.260088D-03, 0.946218D-03, 0.296595D-02, 0.821245D-02, 0.183977D-01, 0.326657D-01, 0.257315D-01, -0.535351D-01, -0.156895D+00, -0.206659D+00",
    "c, 14.14, 1",
    "c, 15.15, 1",
    "c, 16.16, 1",
    "c, 17.17, 1",
    "p, MG , 539.6000000, 127.9000000, 41.0200000, 15.2500000, 6.1660000, 2.5610000, 1.0600000, 0.4176000, 0.2690000, 0.1223000, 0.0547600, 0.0238800, 0.0070600",
    "c, 1.9, 0.833969D-03, 0.689215D-02, 0.337874D-01, 0.114401D+00, 0.259514D+00, 0.385095D+00, 0.335373D+00, 0.110641D+00, -0.121315D-01",
    "c, 1.9, -0.132076D-03, -0.109538D-02, -0.539495D-02, -0.185572D-01, -0.427375D-01, -0.647684D-01, -0.627818D-01, -0.244912D-01, 0.104761D+00",
    "c, 10.10, 1",
    "c, 11.11, 1",
    "c, 12.12, 1",
    "c, 13.13, 1",
    "d, MG , 0.1060000, 0.1944000, 0.3570000, 0.0382000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "c, 4.4, 1",
    "f, MG , 0.1810000, 0.3590000, 0.0700000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "g, MG , 0.3070000",
    "c, 1.1, 1",
    "! ALUMINUM       (17s,12p,4d,3f,2g) -> [7s,6p,4d,3f,2g]",
    "! ALUMINUM       (16s,11p,3d,2f,1g) -> [6s,5p,3d,2f,1g]",
    "! ALUMINUM       (1s,1p,1d,1f,1g)",
    "s, AL , 419600.0000000, 62830.0000000, 14290.0000000, 4038.0000000, 1312.0000000, 470.5000000, 181.8000000, 74.4600000, 31.9000000, 13.9600000, 5.1800000, 2.2650000, 0.9664000, 0.2447000, 0.1184000, 0.0502100, 0.0183000",
    "c, 1.13, 0.278219D-04, 0.216330D-03, 0.113754D-02, 0.479635D-02, 0.172389D-01, 0.538066D-01, 0.141326D+00, 0.289268D+00, 0.384825D+00, 0.232852D+00, 0.293330D-01, -0.300574D-02, 0.166673D-02",
    "c, 1.13, -0.723754D-05, -0.561733D-04, -0.296528D-03, -0.124913D-02, -0.455101D-02, -0.144393D-01, -0.403464D-01, -0.922618D-01, -0.164510D+00, -0.141296D+00, 0.195365D+00, 0.572475D+00, 0.374041D+00",
    "c, 1.13, 0.167150D-05, 0.129641D-04, 0.685101D-04, 0.288274D-03, 0.105276D-02, 0.333878D-02, 0.939217D-02, 0.216047D-01, 0.395873D-01, 0.349180D-01, -0.528415D-01, -0.191878D+00, -0.254115D+00",
    "c, 14.14, 1",
    "c, 15.15, 1",
    "c, 16.16, 1",
    "c, 17.17, 1",
    "p, AL , 891.3000000, 211.3000000, 68.2800000, 25.7000000, 10.6300000, 4.6020000, 2.0150000, 0.8706000, 0.2972000, 0.1100000, 0.0398900, 0.0121000",
    "c, 1.8, 0.491755D-03, 0.415843D-02, 0.212538D-01, 0.764058D-01, 0.194277D+00, 0.334428D+00, 0.375026D+00, 0.204041D+00",
    "c, 1.8, -0.888695D-04, -0.745823D-03, -0.387025D-02, -0.139350D-01, -0.366860D-01, -0.627797D-01, -0.789602D-01, -0.288589D-01",
    "c, 9.9, 1",
    "c, 10.10, 1",
    "c, 11.11, 1",
    "c, 12.12, 1",
    "d, AL , 0.0804000, 0.1990000, 0.4940000, 0.0282000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "c, 4.4, 1",
    "f, AL , 0.1540000, 0.4010000, 0.0582000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "g, AL , 0.3570000",
    "c, 1.1, 1",
    "! SILICON       (17s,12p,4d,3f,2g) -> [7s,6p,4d,3f,2g]",
    "! SILICON       (16s,11p,3d,2f,1g) -> [6s,5p,3d,2f,1g]",
    "! SILICON       (1s,1p,1d,1f,1g)",
    "s, SI , 513000.0000000, 76820.0000000, 17470.0000000, 4935.0000000, 1602.0000000, 574.1000000, 221.5000000, 90.5400000, 38.7400000, 16.9500000, 6.4520000, 2.8740000, 1.2500000, 0.3599000, 0.1699000, 0.0706600, 0.0275000",
    "c, 1.13, 0.260920D-04, 0.202905D-03, 0.106715D-02, 0.450597D-02, 0.162359D-01, 0.508913D-01, 0.135155D+00, 0.281292D+00, 0.385336D+00, 0.245651D+00, 0.343145D-01, -0.334884D-02, 0.187625D-02",
    "c, 1.13, -0.694880D-05, -0.539641D-04, -0.284716D-03, -0.120203D-02, -0.438397D-02, -0.139776D-01, -0.393516D-01, -0.914283D-01, -0.165609D+00, -0.152505D+00, 0.168524D+00, 0.569284D+00, 0.398056D+00",
    "c, 1.13, 0.178068D-05, 0.138148D-04, 0.730005D-04, 0.307666D-03, 0.112563D-02, 0.358435D-02, 0.101728D-01, 0.237520D-01, 0.443483D-01, 0.419041D-01, -0.502504D-01, -0.216578D+00, -0.286448D+00",
    "c, 14.14, 1",
    "c, 15.15, 1",
    "c, 16.16, 1",
    "c, 17.17, 1",
    "p, SI , 1122.0000000, 266.0000000, 85.9200000, 32.3300000, 13.3700000, 5.8000000, 2.5590000, 1.1240000, 0.3988000, 0.1533000, 0.0572800, 0.0200000",
    "c, 1.8, 0.448143D-03, 0.381639D-02, 0.198105D-01, 0.727017D-01, 0.189839D+00, 0.335672D+00, 0.379365D+00, 0.201193D+00",
    "c, 1.8, -0.964883D-04, -0.811971D-03, -0.430087D-02, -0.157502D-01, -0.429541D-01, -0.752574D-01, -0.971446D-01, -0.227507D-01",
    "c, 9.9, 1",
    "c, 10.10, 1",
    "c, 11.11, 1",
    "c, 12.12, 1",
    "d, SI , 0.1200000, 0.3020000, 0.7600000, 0.0435000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "c, 4.4, 1",
    "f, SI , 0.2120000, 0.5410000, 0.0846000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "g, SI , 0.4610000",
    "c, 1.1, 1",
    "! PHOSPHOROUS       (17s,12p,4d,3f,2g) -> [7s,6p,4d,3f,2g]",
    "! PHOSPHOROUS       (16s,11p,3d,2f,1g) -> [6s,5p,3d,2f,1g]",
    "! PHOSPHOROUS       (1s,1p,1d,1f,1g)",
    "s, P , 615200.0000000, 92120.0000000, 20950.0000000, 5920.0000000, 1922.0000000, 688.0000000, 265.0000000, 108.2000000, 46.2200000, 20.2300000, 7.8590000, 3.5470000, 1.5640000, 0.4888000, 0.2266000, 0.0933100, 0.0354000",
    "c, 1.13, 0.247450D-04, 0.192465D-03, 0.101202D-02, 0.427261D-02, 0.154161D-01, 0.485976D-01, 0.130060D+00, 0.274514D+00, 0.385402D+00, 0.255934D+00, 0.391237D-01, -0.368010D-02, 0.208211D-02",
    "c, 1.13, -0.672205D-05, -0.522311D-04, -0.275361D-03, -0.116307D-02, -0.424281D-02, -0.136114D-01, -0.385114D-01, -0.906643D-01, -0.166584D+00, -0.161447D+00, 0.146781D+00, 0.566682D+00, 0.416433D+00",
    "c, 1.13, 0.184740D-05, 0.143380D-04, 0.757228D-04, 0.319205D-03, 0.116851D-02, 0.374267D-02, 0.106817D-01, 0.252657D-01, 0.479283D-01, 0.477096D-01, -0.466525D-01, -0.234968D+00, -0.311337D+00",
    "c, 14.14, 1",
    "c, 15.15, 1",
    "c, 16.16, 1",
    "c, 17.17, 1",
    "p, P , 1367.0000000, 324.0000000, 104.6000000, 39.3700000, 16.2600000, 7.0560000, 3.1300000, 1.3940000, 0.5179000, 0.2032000, 0.0769800, 0.0272000",
    "c, 1.8, 0.421015D-03, 0.360985D-02, 0.189217D-01, 0.705560D-01, 0.188157D+00, 0.338709D+00, 0.381943D+00, 0.195261D+00",
    "c, 1.8, -0.100827D-03, -0.854499D-03, -0.457116D-02, -0.170327D-01, -0.475204D-01, -0.852786D-01, -0.109676D+00, -0.161181D-01",
    "c, 9.9, 1",
    "c, 10.10, 1",
    "c, 11.11, 1",
    "c, 12.12, 1",
    "d, P , 0.1650000, 0.4130000, 1.0360000, 0.0594000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "c, 4.4, 1",
    "f, P , 0.2800000, 0.7030000, 0.1090000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "g, P , 0.5970000",
    "c, 1.1, 1",
    "! SULFUR       (17s,12p,4d,3f,2g) -> [7s,6p,4d,3f,2g]",
    "! SULFUR       (16s,11p,3d,2f,1g) -> [6s,5p,3d,2f,1g]",
    "! SULFUR       (1s,1p,1d,1f,1g)",
    "s, S , 727800.0000000, 109000.0000000, 24800.0000000, 7014.0000000, 2278.0000000, 814.7000000, 313.4000000, 127.7000000, 54.4800000, 23.8500000, 9.4280000, 4.2900000, 1.9090000, 0.6270000, 0.2873000, 0.1172000, 0.0428000",
    "c, 1.13, 0.236025D-04, 0.183482D-03, 0.964278D-03, 0.406537D-02, 0.146973D-01, 0.465081D-01, 0.125508D+00, 0.268433D+00, 0.384809D+00, 0.265372D+00, 0.437326D-01, -0.378807D-02, 0.218083D-02",
    "c, 1.13, -0.652179D-05, -0.506631D-04, -0.266833D-03, -0.112601D-02, -0.411186D-02, -0.132454D-01, -0.377004D-01, -0.898554D-01, -0.167098D+00, -0.169354D+00, 0.127824D+00, 0.564862D+00, 0.431767D+00",
    "c, 1.13, 0.189406D-05, 0.146948D-04, 0.775460D-04, 0.326509D-03, 0.119686D-02, 0.384799D-02, 0.110539D-01, 0.264645D-01, 0.508771D-01, 0.530030D-01, -0.425518D-01, -0.250853D+00, -0.333152D+00",
    "c, 14.14, 1",
    "c, 15.15, 1",
    "c, 16.16, 1",
    "c, 17.17, 1",
    "p, S , 1546.0000000, 366.4000000, 118.4000000, 44.5300000, 18.3800000, 7.9650000, 3.5410000, 1.5910000, 0.6205000, 0.2420000, 0.0901400, 0.0317000",
    "c, 1.8, 0.441183D-03, 0.377571D-02, 0.198360D-01, 0.742063D-01, 0.197327D+00, 0.351851D+00, 0.378687D+00, 0.170931D+00",
    "c, 1.8, -0.113110D-03, -0.958581D-03, -0.513471D-02, -0.192641D-01, -0.535980D-01, -0.960333D-01, -0.118183D+00, 0.923194D-02",
    "c, 9.9, 1",
    "c, 10.10, 1",
    "c, 11.11, 1",
    "c, 12.12, 1",
    "d, S , 0.2030000, 0.5040000, 1.2500000, 0.0748000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "c, 4.4, 1",
    "f, S , 0.3350000, 0.8690000, 0.1400000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "g, S , 0.6830000",
    "c, 1.1, 1",
    "! CHLORINE       (17s,12p,4d,3f,2g) -> [7s,6p,4d,3f,2g]",
    "! CHLORINE       (16s,11p,3d,2f,1g) -> [6s,5p,3d,2f,1g]",
    "! CHLORINE       (1s,1p,1d,1f,1g)",
    "s, CL , 834900.0000000, 125000.0000000, 28430.0000000, 8033.0000000, 2608.0000000, 933.9000000, 360.0000000, 147.0000000, 62.8800000, 27.6000000, 11.0800000, 5.0750000, 2.2780000, 0.7775000, 0.3527000, 0.1431000, 0.0519000",
    "c, 1.13, 0.231688D-04, 0.180154D-03, 0.947782D-03, 0.400139D-02, 0.144629D-01, 0.456586D-01, 0.123248D+00, 0.264369D+00, 0.382989D+00, 0.270934D+00, 0.471404D-01, -0.371766D-02, 0.219158D-02",
    "c, 1.13, -0.649649D-05, -0.504895D-04, -0.266113D-03, -0.112499D-02, -0.410497D-02, -0.131987D-01, -0.375342D-01, -0.897233D-01, -0.167671D+00, -0.174763D+00, 0.114909D+00, 0.563618D+00, 0.441606D+00",
    "c, 1.13, 0.196645D-05, 0.152620D-04, 0.806086D-04, 0.339960D-03, 0.124551D-02, 0.399612D-02, 0.114751D-01, 0.275504D-01, 0.532917D-01, 0.571246D-01, -0.395201D-01, -0.264343D+00, -0.349291D+00",
    "c, 14.14, 1",
    "c, 15.15, 1",
    "c, 16.16, 1",
    "c, 17.17, 1",
    "p, CL , 1703.0000000, 403.6000000, 130.3000000, 49.0500000, 20.2600000, 8.7870000, 3.9190000, 1.7650000, 0.7207000, 0.2839000, 0.1060000, 0.0376000",
    "c, 1.8, 0.474039D-03, 0.406412D-02, 0.213355D-01, 0.794611D-01, 0.208927D+00, 0.364945D+00, 0.371725D+00, 0.146292D+00",
    "c, 1.8, -0.128266D-03, -0.109356D-02, -0.583429D-02, -0.219258D-01, -0.601385D-01, -0.106929D+00, -0.122454D+00, 0.383619D-01",
    "c, 9.9, 1",
    "c, 10.10, 1",
    "c, 11.11, 1",
    "c, 12.12, 1",
    "d, CL , 0.2540000, 0.6280000, 1.5510000, 0.0952000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "c, 4.4, 1",
    "f, CL , 0.4230000, 1.0890000, 0.2170000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "g, CL , 0.8270000",
    "c, 1.1, 1",
    "! ARGON       (17s,12p,4d,3f,2g) -> [7s,6p,4d,3f,2g]",
    "! ARGON       (16s,11p,3d,2f,1g) -> [6s,5p,3d,2f,1g]",
    "! ARGON       (1s,1p,1d,1f,1g)",
    "s, AR , 950600.0000000, 142300.0000000, 32360.0000000, 9145.0000000, 2970.0000000, 1064.0000000, 410.8000000, 168.0000000, 71.9900000, 31.6700000, 12.8900000, 5.9290000, 2.6780000, 0.9416000, 0.4239000, 0.1714000, 0.0610000",
    "c, 1.13, 0.227545D-04, 0.176945D-03, 0.931282D-03, 0.392860D-02, 0.142064D-01, 0.448114D-01, 0.121001D+00, 0.260579D+00, 0.381364D+00, 0.276058D+00, 0.505179D-01, -0.359866D-02, 0.218798D-02",
    "c, 1.13, -0.646201D-05, -0.502346D-04, -0.264804D-03, -0.111895D-02, -0.408276D-02, -0.131216D-01, -0.372855D-01, -0.894709D-01, -0.168054D+00, -0.179594D+00, 0.102953D+00, 0.562630D+00, 0.450355D+00",
    "c, 1.13, 0.202056D-05, 0.156851D-04, 0.828617D-04, 0.349264D-03, 0.127976D-02, 0.410365D-02, 0.117789D-01, 0.283868D-01, 0.552406D-01, 0.607492D-01, -0.362012D-01, -0.275398D+00, -0.362845D+00",
    "c, 14.14, 1",
    "c, 15.15, 1",
    "c, 16.16, 1",
    "c, 17.17, 1",
    "p, AR , 1890.0000000, 447.8000000, 144.6000000, 54.4600000, 22.5100000, 9.7740000, 4.3680000, 1.9590000, 0.8260000, 0.3297000, 0.1242000, 0.0435000",
    "c, 1.8, 0.495752D-03, 0.425172D-02, 0.223277D-01, 0.830878D-01, 0.217110D+00, 0.374507D+00, 0.366445D+00, 0.129245D+00",
    "c, 1.8, -0.138863D-03, -0.118870D-02, -0.632553D-02, -0.238813D-01, -0.649238D-01, -0.115444D+00, -0.123651D+00, 0.649055D-01",
    "c, 9.9, 1",
    "c, 10.10, 1",
    "c, 11.11, 1",
    "c, 12.12, 1",
    "d, AR , 0.3110000, 0.7630000, 1.8730000, 0.1160000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "c, 4.4, 1",
    "f, AR , 0.5430000, 1.3250000, 0.2940000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "g, AR , 1.0070000",
    "c, 1.1, 1",
    ],

'may-cc-pvqz': [
    "! #####################",
    "! ##                 ##",
    "! ##   may-cc-pVQZ   ##",
    "! ##                 ##",
    "! #####################",
    "!",
    "! HYDROGEN       (7s,4p,3d,2f) -> [5s,4p,3d,2f]",
    "! HYDROGEN       (6s,3p,2d,1f) -> [4s,3p,2d,1f]",
    "! HYDROGEN       (1s,1p,1d,1f)",
    "s, H , 82.6400000, 12.4100000, 2.8240000, 0.7977000, 0.2581000, 0.0898900",
    "c, 1.3, 0.0020060, 0.0153430, 0.0755790",
    "c, 4.4, 1",
    "c, 5.5, 1",
    "c, 6.6, 1",
    "p, H , 2.2920000, 0.8380000, 0.2920000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "d, H , 2.0620000, 0.6620000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "f, H , 1.3970000",
    "c, 1.1, 1",
    "! HELIUM       (8s,4p,3d,2f) -> [5s,4p,3d,2f]",
    "! HELIUM       (7s,3p,2d,1f) -> [4s,3p,2d,1f]",
    "! HELIUM       (1s,1p,1d,1f)",
    "s, HE , 528.5000000, 79.3100000, 18.0500000, 5.0850000, 1.6090000, 0.5363000, 0.1833000",
    "c, 1.4, 0.0009400, 0.0072140, 0.0359750, 0.1277820",
    "c, 5.5, 1",
    "c, 6.6, 1",
    "c, 7.7, 1",
    "p, HE , 5.9940000, 1.7450000, 0.5600000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "d, HE , 4.2990000, 1.2230000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "f, HE , 2.6800000",
    "c, 1.1, 1",
    "! LITHIUM       (13s,7p,4d,3f,2g) -> [6s,5p,4d,3f,2g]",
    "! LITHIUM       (12s,6p,3d,2f,1g) -> [5s,4p,3d,2f,1g]",
    "! LITHIUM       (1s,1p,1d,1f,1g)",
    "s, LI , 6601.0000000, 989.7000000, 225.7000000, 64.2900000, 21.1800000, 7.7240000, 3.0030000, 1.2120000, 0.4930000, 0.0951500, 0.0479100, 0.0222000, 0.0063600",
    "c, 1.9, 0.0001170, 0.0009110, 0.0047280, 0.0191970, 0.0630470, 0.1632080, 0.3148270, 0.3939360, 0.1969180",
    "c, 1.9, -0.0000180, -0.0001420, -0.0007410, -0.0030200, -0.0101230, -0.0270940, -0.0573590, -0.0938950, -0.1210910",
    "c, 10.10, 1",
    "c, 11.11, 1",
    "c, 12.12, 1",
    "c, 13.13, 1",
    "p, LI , 6.2500000, 1.3700000, 0.3672000, 0.1192000, 0.0447400, 0.0179500, 0.0075600",
    "c, 1.3, 0.0033880, 0.0193160, 0.0791040",
    "c, 4.4, 1",
    "c, 5.5, 1",
    "c, 6.6, 1",
    "c, 7.7, 1",
    "d, LI , 0.3440000, 0.1530000, 0.0680000, 0.0266000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "c, 4.4, 1",
    "f, LI , 0.2460000, 0.1292000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "g, LI , 0.2380000",
    "c, 1.1, 1",
    "! BERYLLIUM       (13s,7p,4d,3f,2g) -> [6s,5p,4d,3f,2g]",
    "! BERYLLIUM       (12s,6p,3d,2f,1g) -> [5s,4p,3d,2f,1g]",
    "! BERYLLIUM       (1s,1p,1d,1f,1g)",
    "s, BE , 14630.0000000, 2191.0000000, 498.2000000, 140.9000000, 45.8600000, 16.4700000, 6.3190000, 2.5350000, 1.0350000, 0.2528000, 0.1052000, 0.0426100, 0.0143900",
    "c, 1.9, 0.0000920, 0.0007130, 0.0037350, 0.0154680, 0.0528740, 0.1456940, 0.3026810, 0.4049360, 0.2223870",
    "c, 1.9, -0.0000170, -0.0001300, -0.0006790, -0.0028570, -0.0098130, -0.0286090, -0.0637600, -0.1172310, -0.1212020",
    "c, 10.10, 1",
    "c, 11.11, 1",
    "c, 12.12, 1",
    "c, 13.13, 1",
    "p, BE , 14.0300000, 3.1680000, 0.9024000, 0.3036000, 0.1130000, 0.0428600, 0.0065000",
    "c, 1.3, 0.0040990, 0.0256260, 0.1037680",
    "c, 4.4, 1",
    "c, 5.5, 1",
    "c, 6.6, 1",
    "c, 7.7, 1",
    "d, BE , 1.0720000, 0.4410000, 0.1811000, 0.0554000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "c, 4.4, 1",
    "f, BE , 0.4810000, 0.2550000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "g, BE , 0.4150000",
    "c, 1.1, 1",
    "! BORON       (13s,7p,4d,3f,2g) -> [6s,5p,4d,3f,2g]",
    "! BORON       (12s,6p,3d,2f,1g) -> [5s,4p,3d,2f,1g]",
    "! BORON       (1s,1p,1d,1f,1g)",
    "s, B , 23870.0000000, 3575.0000000, 812.8000000, 229.7000000, 74.6900000, 26.8100000, 10.3200000, 4.1780000, 1.7270000, 0.4704000, 0.1896000, 0.0739400, 0.0272100",
    "c, 1.9, 0.0000880, 0.0006870, 0.0036000, 0.0149490, 0.0514350, 0.1433020, 0.3009350, 0.4035260, 0.2253400",
    "c, 1.9, -0.0000180, -0.0001390, -0.0007250, -0.0030630, -0.0105810, -0.0313650, -0.0710120, -0.1321030, -0.1230720",
    "c, 10.10, 1",
    "c, 11.11, 1",
    "c, 12.12, 1",
    "c, 13.13, 1",
    "p, B , 22.2600000, 5.0580000, 1.4870000, 0.5071000, 0.1812000, 0.0646300, 0.0187800",
    "c, 1.3, 0.0050950, 0.0332060, 0.1323140",
    "c, 4.4, 1",
    "c, 5.5, 1",
    "c, 6.6, 1",
    "c, 7.7, 1",
    "d, B , 1.1100000, 0.4020000, 0.1450000, 0.0466000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "c, 4.4, 1",
    "f, B , 0.8820000, 0.3110000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "g, B , 0.6730000",
    "c, 1.1, 1",
    "! CARBON       (13s,7p,4d,3f,2g) -> [6s,5p,4d,3f,2g]",
    "! CARBON       (12s,6p,3d,2f,1g) -> [5s,4p,3d,2f,1g]",
    "! CARBON       (1s,1p,1d,1f,1g)",
    "s, C , 33980.0000000, 5089.0000000, 1157.0000000, 326.6000000, 106.1000000, 38.1100000, 14.7500000, 6.0350000, 2.5300000, 0.7355000, 0.2905000, 0.1111000, 0.0414500",
    "c, 1.9, 0.0000910, 0.0007040, 0.0036930, 0.0153600, 0.0529290, 0.1470430, 0.3056310, 0.3993450, 0.2170510",
    "c, 1.9, -0.0000190, -0.0001510, -0.0007850, -0.0033240, -0.0115120, -0.0341600, -0.0771730, -0.1414930, -0.1180190",
    "c, 10.10, 1",
    "c, 11.11, 1",
    "c, 12.12, 1",
    "c, 13.13, 1",
    "p, C , 34.5100000, 7.9150000, 2.3680000, 0.8132000, 0.2890000, 0.1007000, 0.0321800",
    "c, 1.3, 0.0053780, 0.0361320, 0.1424930",
    "c, 4.4, 1",
    "c, 5.5, 1",
    "c, 6.6, 1",
    "c, 7.7, 1",
    "d, C , 1.8480000, 0.6490000, 0.2280000, 0.0766000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "c, 4.4, 1",
    "f, C , 1.4190000, 0.4850000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "g, C , 1.0110000",
    "c, 1.1, 1",
    "! NITROGEN       (13s,7p,4d,3f,2g) -> [6s,5p,4d,3f,2g]",
    "! NITROGEN       (12s,6p,3d,2f,1g) -> [5s,4p,3d,2f,1g]",
    "! NITROGEN       (1s,1p,1d,1f,1g)",
    "s, N , 45840.0000000, 6868.0000000, 1563.0000000, 442.4000000, 144.3000000, 52.1800000, 20.3400000, 8.3810000, 3.5290000, 1.0540000, 0.4118000, 0.1552000, 0.0546400",
    "c, 1.9, 0.0000920, 0.0007170, 0.0037490, 0.0155320, 0.0531460, 0.1467870, 0.3046630, 0.3976840, 0.2176410",
    "c, 1.9, -0.0000200, -0.0001590, -0.0008240, -0.0034780, -0.0119660, -0.0353880, -0.0800770, -0.1467220, -0.1163600",
    "c, 10.10, 1",
    "c, 11.11, 1",
    "c, 12.12, 1",
    "c, 13.13, 1",
    "p, N , 49.3300000, 11.3700000, 3.4350000, 1.1820000, 0.4173000, 0.1428000, 0.0440200",
    "c, 1.3, 0.0055330, 0.0379620, 0.1490280",
    "c, 4.4, 1",
    "c, 5.5, 1",
    "c, 6.6, 1",
    "c, 7.7, 1",
    "d, N , 2.8370000, 0.9680000, 0.3350000, 0.1110000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "c, 4.4, 1",
    "f, N , 2.0270000, 0.6850000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "g, N , 1.4270000",
    "c, 1.1, 1",
    "! OXYGEN       (13s,7p,4d,3f,2g) -> [6s,5p,4d,3f,2g]",
    "! OXYGEN       (12s,6p,3d,2f,1g) -> [5s,4p,3d,2f,1g]",
    "! OXYGEN       (1s,1p,1d,1f,1g)",
    "s, O , 61420.0000000, 9199.0000000, 2091.0000000, 590.9000000, 192.3000000, 69.3200000, 26.9700000, 11.1000000, 4.6820000, 1.4280000, 0.5547000, 0.2067000, 0.0695900",
    "c, 1.9, 0.0000900, 0.0006980, 0.0036640, 0.0152180, 0.0524230, 0.1459210, 0.3052580, 0.3985080, 0.2169800",
    "c, 1.9, -0.0000200, -0.0001590, -0.0008290, -0.0035080, -0.0121560, -0.0362610, -0.0829920, -0.1520900, -0.1153310",
    "c, 10.10, 1",
    "c, 11.11, 1",
    "c, 12.12, 1",
    "c, 13.13, 1",
    "p, O , 63.4200000, 14.6600000, 4.4590000, 1.5310000, 0.5302000, 0.1750000, 0.0534800",
    "c, 1.3, 0.0060440, 0.0417990, 0.1611430",
    "c, 4.4, 1",
    "c, 5.5, 1",
    "c, 6.6, 1",
    "c, 7.7, 1",
    "d, O , 3.7750000, 1.3000000, 0.4440000, 0.1540000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "c, 4.4, 1",
    "f, O , 2.6660000, 0.8590000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "g, O , 1.8460000",
    "c, 1.1, 1",
    "! FLUORINE       (13s,7p,4d,3f,2g) -> [6s,5p,4d,3f,2g]",
    "! FLUORINE       (12s,6p,3d,2f,1g) -> [5s,4p,3d,2f,1g]",
    "! FLUORINE       (1s,1p,1d,1f,1g)",
    "s, F , 74530.0000000, 11170.0000000, 2543.0000000, 721.0000000, 235.9000000, 85.6000000, 33.5500000, 13.9300000, 5.9150000, 1.8430000, 0.7124000, 0.2637000, 0.0859400",
    "c, 1.9, 0.0000950, 0.0007380, 0.0038580, 0.0159260, 0.0542890, 0.1495130, 0.3082520, 0.3948530, 0.2110310",
    "c, 1.9, -0.0000220, -0.0001720, -0.0008910, -0.0037480, -0.0128620, -0.0380610, -0.0862390, -0.1558650, -0.1109140",
    "c, 10.10, 1",
    "c, 11.11, 1",
    "c, 12.12, 1",
    "c, 13.13, 1",
    "p, F , 80.3900000, 18.6300000, 5.6940000, 1.9530000, 0.6702000, 0.2166000, 0.0656800",
    "c, 1.3, 0.0063470, 0.0442040, 0.1685140",
    "c, 4.4, 1",
    "c, 5.5, 1",
    "c, 6.6, 1",
    "c, 7.7, 1",
    "d, F , 5.0140000, 1.7250000, 0.5860000, 0.2070000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "c, 4.4, 1",
    "f, F , 3.5620000, 1.1480000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "g, F , 2.3760000",
    "c, 1.1, 1",
    "! NEON       (13s,7p,4d,3f,2g) -> [6s,5p,4d,3f,2g]",
    "! NEON       (12s,6p,3d,2f,1g) -> [5s,4p,3d,2f,1g]",
    "! NEON       (1s,1p,1d,1f,1g)",
    "s, NE , 99920.0000000, 14960.0000000, 3399.0000000, 958.9000000, 311.2000000, 111.7000000, 43.3200000, 17.8000000, 7.5030000, 2.3370000, 0.9001000, 0.3301000, 0.1054000",
    "c, 1.9, 0.0000860, 0.0006690, 0.0035180, 0.0146670, 0.0509620, 0.1437440, 0.3045620, 0.4001050, 0.2186440",
    "c, 1.9, -0.0000200, -0.0001580, -0.0008240, -0.0035000, -0.0122330, -0.0370170, -0.0861130, -0.1583810, -0.1142880",
    "c, 10.10, 1",
    "c, 11.11, 1",
    "c, 12.12, 1",
    "c, 13.13, 1",
    "p, NE , 99.6800000, 23.1500000, 7.1080000, 2.4410000, 0.8339000, 0.2662000, 0.0817800",
    "c, 1.3, 0.0065660, 0.0459790, 0.1734190",
    "c, 4.4, 1",
    "c, 5.5, 1",
    "c, 6.6, 1",
    "c, 7.7, 1",
    "d, NE , 6.4710000, 2.2130000, 0.7470000, 0.2730000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "c, 4.4, 1",
    "f, NE , 4.6570000, 1.5240000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "g, NE , 2.9830000",
    "c, 1.1, 1",
    "! SODIUM       (20s,13p,4d,3f,2g) -> [7s,6p,4d,3f,2g]",
    "! SODIUM       (19s,12p,3d,2f,1g) -> [6s,5p,3d,2f,1g]",
    "! SODIUM       (1s,1p,1d,1f,1g)",
    "s, NA , 1224000.0000000, 183200.0000000, 41700.0000000, 11810.0000000, 3853.0000000, 1391.0000000, 542.5000000, 224.9000000, 97.9300000, 44.3100000, 20.6500000, 9.7290000, 4.2280000, 1.9690000, 0.8890000, 0.3964000, 0.0699300, 0.0328900, 0.0161200, 0.0050300",
    "c, 1.16, 0.478894D-05, 0.372395D-04, 0.195831D-03, 0.826698D-03, 0.300251D-02, 0.970310D-02, 0.282337D-01, 0.732058D-01, 0.162897D+00, 0.288708D+00, 0.346829D+00, 0.206865D+00, 0.328009D-01, -0.647736D-03, 0.145878D-02, -0.178346D-03",
    "c, 1.16, -0.116958D-05, -0.909110D-05, -0.478499D-04, -0.201962D-03, -0.735837D-03, -0.238746D-02, -0.704969D-02, -0.187856D-01, -0.446153D-01, -0.897741D-01, -0.142940D+00, -0.124315D+00, 0.999648D-01, 0.417080D+00, 0.475123D+00, 0.163268D+00",
    "c, 1.16, 0.175871D-06, 0.136594D-05, 0.719795D-05, 0.303349D-04, 0.110752D-03, 0.358596D-03, 0.106272D-02, 0.282687D-02, 0.676742D-02, 0.136480D-01, 0.222814D-01, 0.196011D-01, -0.167708D-01, -0.773734D-01, -0.113501D+00, -0.139130D+00",
    "c, 17.17, 1",
    "c, 18.18, 1",
    "c, 19.19, 1",
    "c, 20.20, 1",
    "p, NA , 413.4000000, 97.9800000, 31.3700000, 11.6200000, 4.6710000, 1.9180000, 0.7775000, 0.3013000, 0.2275000, 0.0752700, 0.0312600, 0.0134200, 0.0077200",
    "c, 1.9, 0.908196D-03, 0.741773D-02, 0.357464D-01, 0.118520D+00, 0.261403D+00, 0.378395D+00, 0.334632D+00, 0.126844D+00, -0.147117D-01",
    "c, 1.9, -0.901741D-04, -0.739342D-03, -0.357309D-02, -0.120142D-01, -0.267178D-01, -0.392753D-01, -0.376083D-01, -0.433228D-01, 0.518003D-01",
    "c, 10.10, 1",
    "c, 11.11, 1",
    "c, 12.12, 1",
    "c, 13.13, 1",
    "d, NA , 0.1538000, 0.0865000, 0.0487000, 0.0210000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "c, 4.4, 1",
    "f, NA , 0.1912000, 0.1036000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "g, NA , 0.1722000",
    "c, 1.1, 1",
    "! MAGNESIUM       (17s,13p,4d,3f,2g) -> [7s,6p,4d,3f,2g]",
    "! MAGNESIUM       (16s,12p,3d,2f,1g) -> [6s,5p,3d,2f,1g]",
    "! MAGNESIUM       (1s,1p,1d,1f,1g)",
    "s, MG , 327600.0000000, 49050.0000000, 11150.0000000, 3152.0000000, 1025.0000000, 368.8000000, 143.2000000, 58.9600000, 25.4000000, 11.1500000, 4.0040000, 1.7010000, 0.7060000, 0.1410000, 0.0680800, 0.0306300, 0.0123900",
    "c, 1.13, 0.309608D-04, 0.240954D-03, 0.126660D-02, 0.533359D-02, 0.190770D-01, 0.588058D-01, 0.151454D+00, 0.300716D+00, 0.381149D+00, 0.213584D+00, 0.231210D-01, -0.230757D-02, 0.128900D-02",
    "c, 1.13, -0.783173D-05, -0.607935D-04, -0.321197D-03, -0.134955D-02, -0.490570D-02, -0.153561D-01, -0.423409D-01, -0.940603D-01, -0.163425D+00, -0.124754D+00, 0.235623D+00, 0.577563D+00, 0.335232D+00",
    "c, 1.13, 0.150908D-05, 0.117134D-04, 0.618980D-04, 0.260088D-03, 0.946218D-03, 0.296595D-02, 0.821245D-02, 0.183977D-01, 0.326657D-01, 0.257315D-01, -0.535351D-01, -0.156895D+00, -0.206659D+00",
    "c, 14.14, 1",
    "c, 15.15, 1",
    "c, 16.16, 1",
    "c, 17.17, 1",
    "p, MG , 539.6000000, 127.9000000, 41.0200000, 15.2500000, 6.1660000, 2.5610000, 1.0600000, 0.4176000, 0.2690000, 0.1223000, 0.0547600, 0.0238800, 0.0070600",
    "c, 1.9, 0.833969D-03, 0.689215D-02, 0.337874D-01, 0.114401D+00, 0.259514D+00, 0.385095D+00, 0.335373D+00, 0.110641D+00, -0.121315D-01",
    "c, 1.9, -0.132076D-03, -0.109538D-02, -0.539495D-02, -0.185572D-01, -0.427375D-01, -0.647684D-01, -0.627818D-01, -0.244912D-01, 0.104761D+00",
    "c, 10.10, 1",
    "c, 11.11, 1",
    "c, 12.12, 1",
    "c, 13.13, 1",
    "d, MG , 0.1060000, 0.1944000, 0.3570000, 0.0382000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "c, 4.4, 1",
    "f, MG , 0.1810000, 0.3590000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "g, MG , 0.3070000",
    "c, 1.1, 1",
    "! ALUMINUM       (17s,12p,4d,3f,2g) -> [7s,6p,4d,3f,2g]",
    "! ALUMINUM       (16s,11p,3d,2f,1g) -> [6s,5p,3d,2f,1g]",
    "! ALUMINUM       (1s,1p,1d,1f,1g)",
    "s, AL , 419600.0000000, 62830.0000000, 14290.0000000, 4038.0000000, 1312.0000000, 470.5000000, 181.8000000, 74.4600000, 31.9000000, 13.9600000, 5.1800000, 2.2650000, 0.9664000, 0.2447000, 0.1184000, 0.0502100, 0.0183000",
    "c, 1.13, 0.278219D-04, 0.216330D-03, 0.113754D-02, 0.479635D-02, 0.172389D-01, 0.538066D-01, 0.141326D+00, 0.289268D+00, 0.384825D+00, 0.232852D+00, 0.293330D-01, -0.300574D-02, 0.166673D-02",
    "c, 1.13, -0.723754D-05, -0.561733D-04, -0.296528D-03, -0.124913D-02, -0.455101D-02, -0.144393D-01, -0.403464D-01, -0.922618D-01, -0.164510D+00, -0.141296D+00, 0.195365D+00, 0.572475D+00, 0.374041D+00",
    "c, 1.13, 0.167150D-05, 0.129641D-04, 0.685101D-04, 0.288274D-03, 0.105276D-02, 0.333878D-02, 0.939217D-02, 0.216047D-01, 0.395873D-01, 0.349180D-01, -0.528415D-01, -0.191878D+00, -0.254115D+00",
    "c, 14.14, 1",
    "c, 15.15, 1",
    "c, 16.16, 1",
    "c, 17.17, 1",
    "p, AL , 891.3000000, 211.3000000, 68.2800000, 25.7000000, 10.6300000, 4.6020000, 2.0150000, 0.8706000, 0.2972000, 0.1100000, 0.0398900, 0.0121000",
    "c, 1.8, 0.491755D-03, 0.415843D-02, 0.212538D-01, 0.764058D-01, 0.194277D+00, 0.334428D+00, 0.375026D+00, 0.204041D+00",
    "c, 1.8, -0.888695D-04, -0.745823D-03, -0.387025D-02, -0.139350D-01, -0.366860D-01, -0.627797D-01, -0.789602D-01, -0.288589D-01",
    "c, 9.9, 1",
    "c, 10.10, 1",
    "c, 11.11, 1",
    "c, 12.12, 1",
    "d, AL , 0.0804000, 0.1990000, 0.4940000, 0.0282000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "c, 4.4, 1",
    "f, AL , 0.1540000, 0.4010000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "g, AL , 0.3570000",
    "c, 1.1, 1",
    "! SILICON       (17s,12p,4d,3f,2g) -> [7s,6p,4d,3f,2g]",
    "! SILICON       (16s,11p,3d,2f,1g) -> [6s,5p,3d,2f,1g]",
    "! SILICON       (1s,1p,1d,1f,1g)",
    "s, SI , 513000.0000000, 76820.0000000, 17470.0000000, 4935.0000000, 1602.0000000, 574.1000000, 221.5000000, 90.5400000, 38.7400000, 16.9500000, 6.4520000, 2.8740000, 1.2500000, 0.3599000, 0.1699000, 0.0706600, 0.0275000",
    "c, 1.13, 0.260920D-04, 0.202905D-03, 0.106715D-02, 0.450597D-02, 0.162359D-01, 0.508913D-01, 0.135155D+00, 0.281292D+00, 0.385336D+00, 0.245651D+00, 0.343145D-01, -0.334884D-02, 0.187625D-02",
    "c, 1.13, -0.694880D-05, -0.539641D-04, -0.284716D-03, -0.120203D-02, -0.438397D-02, -0.139776D-01, -0.393516D-01, -0.914283D-01, -0.165609D+00, -0.152505D+00, 0.168524D+00, 0.569284D+00, 0.398056D+00",
    "c, 1.13, 0.178068D-05, 0.138148D-04, 0.730005D-04, 0.307666D-03, 0.112563D-02, 0.358435D-02, 0.101728D-01, 0.237520D-01, 0.443483D-01, 0.419041D-01, -0.502504D-01, -0.216578D+00, -0.286448D+00",
    "c, 14.14, 1",
    "c, 15.15, 1",
    "c, 16.16, 1",
    "c, 17.17, 1",
    "p, SI , 1122.0000000, 266.0000000, 85.9200000, 32.3300000, 13.3700000, 5.8000000, 2.5590000, 1.1240000, 0.3988000, 0.1533000, 0.0572800, 0.0200000",
    "c, 1.8, 0.448143D-03, 0.381639D-02, 0.198105D-01, 0.727017D-01, 0.189839D+00, 0.335672D+00, 0.379365D+00, 0.201193D+00",
    "c, 1.8, -0.964883D-04, -0.811971D-03, -0.430087D-02, -0.157502D-01, -0.429541D-01, -0.752574D-01, -0.971446D-01, -0.227507D-01",
    "c, 9.9, 1",
    "c, 10.10, 1",
    "c, 11.11, 1",
    "c, 12.12, 1",
    "d, SI , 0.1200000, 0.3020000, 0.7600000, 0.0435000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "c, 4.4, 1",
    "f, SI , 0.2120000, 0.5410000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "g, SI , 0.4610000",
    "c, 1.1, 1",
    "! PHOSPHOROUS       (17s,12p,4d,3f,2g) -> [7s,6p,4d,3f,2g]",
    "! PHOSPHOROUS       (16s,11p,3d,2f,1g) -> [6s,5p,3d,2f,1g]",
    "! PHOSPHOROUS       (1s,1p,1d,1f,1g)",
    "s, P , 615200.0000000, 92120.0000000, 20950.0000000, 5920.0000000, 1922.0000000, 688.0000000, 265.0000000, 108.2000000, 46.2200000, 20.2300000, 7.8590000, 3.5470000, 1.5640000, 0.4888000, 0.2266000, 0.0933100, 0.0354000",
    "c, 1.13, 0.247450D-04, 0.192465D-03, 0.101202D-02, 0.427261D-02, 0.154161D-01, 0.485976D-01, 0.130060D+00, 0.274514D+00, 0.385402D+00, 0.255934D+00, 0.391237D-01, -0.368010D-02, 0.208211D-02",
    "c, 1.13, -0.672205D-05, -0.522311D-04, -0.275361D-03, -0.116307D-02, -0.424281D-02, -0.136114D-01, -0.385114D-01, -0.906643D-01, -0.166584D+00, -0.161447D+00, 0.146781D+00, 0.566682D+00, 0.416433D+00",
    "c, 1.13, 0.184740D-05, 0.143380D-04, 0.757228D-04, 0.319205D-03, 0.116851D-02, 0.374267D-02, 0.106817D-01, 0.252657D-01, 0.479283D-01, 0.477096D-01, -0.466525D-01, -0.234968D+00, -0.311337D+00",
    "c, 14.14, 1",
    "c, 15.15, 1",
    "c, 16.16, 1",
    "c, 17.17, 1",
    "p, P , 1367.0000000, 324.0000000, 104.6000000, 39.3700000, 16.2600000, 7.0560000, 3.1300000, 1.3940000, 0.5179000, 0.2032000, 0.0769800, 0.0272000",
    "c, 1.8, 0.421015D-03, 0.360985D-02, 0.189217D-01, 0.705560D-01, 0.188157D+00, 0.338709D+00, 0.381943D+00, 0.195261D+00",
    "c, 1.8, -0.100827D-03, -0.854499D-03, -0.457116D-02, -0.170327D-01, -0.475204D-01, -0.852786D-01, -0.109676D+00, -0.161181D-01",
    "c, 9.9, 1",
    "c, 10.10, 1",
    "c, 11.11, 1",
    "c, 12.12, 1",
    "d, P , 0.1650000, 0.4130000, 1.0360000, 0.0594000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "c, 4.4, 1",
    "f, P , 0.2800000, 0.7030000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "g, P , 0.5970000",
    "c, 1.1, 1",
    "! SULFUR       (17s,12p,4d,3f,2g) -> [7s,6p,4d,3f,2g]",
    "! SULFUR       (16s,11p,3d,2f,1g) -> [6s,5p,3d,2f,1g]",
    "! SULFUR       (1s,1p,1d,1f,1g)",
    "s, S , 727800.0000000, 109000.0000000, 24800.0000000, 7014.0000000, 2278.0000000, 814.7000000, 313.4000000, 127.7000000, 54.4800000, 23.8500000, 9.4280000, 4.2900000, 1.9090000, 0.6270000, 0.2873000, 0.1172000, 0.0428000",
    "c, 1.13, 0.236025D-04, 0.183482D-03, 0.964278D-03, 0.406537D-02, 0.146973D-01, 0.465081D-01, 0.125508D+00, 0.268433D+00, 0.384809D+00, 0.265372D+00, 0.437326D-01, -0.378807D-02, 0.218083D-02",
    "c, 1.13, -0.652179D-05, -0.506631D-04, -0.266833D-03, -0.112601D-02, -0.411186D-02, -0.132454D-01, -0.377004D-01, -0.898554D-01, -0.167098D+00, -0.169354D+00, 0.127824D+00, 0.564862D+00, 0.431767D+00",
    "c, 1.13, 0.189406D-05, 0.146948D-04, 0.775460D-04, 0.326509D-03, 0.119686D-02, 0.384799D-02, 0.110539D-01, 0.264645D-01, 0.508771D-01, 0.530030D-01, -0.425518D-01, -0.250853D+00, -0.333152D+00",
    "c, 14.14, 1",
    "c, 15.15, 1",
    "c, 16.16, 1",
    "c, 17.17, 1",
    "p, S , 1546.0000000, 366.4000000, 118.4000000, 44.5300000, 18.3800000, 7.9650000, 3.5410000, 1.5910000, 0.6205000, 0.2420000, 0.0901400, 0.0317000",
    "c, 1.8, 0.441183D-03, 0.377571D-02, 0.198360D-01, 0.742063D-01, 0.197327D+00, 0.351851D+00, 0.378687D+00, 0.170931D+00",
    "c, 1.8, -0.113110D-03, -0.958581D-03, -0.513471D-02, -0.192641D-01, -0.535980D-01, -0.960333D-01, -0.118183D+00, 0.923194D-02",
    "c, 9.9, 1",
    "c, 10.10, 1",
    "c, 11.11, 1",
    "c, 12.12, 1",
    "d, S , 0.2030000, 0.5040000, 1.2500000, 0.0748000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "c, 4.4, 1",
    "f, S , 0.3350000, 0.8690000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "g, S , 0.6830000",
    "c, 1.1, 1",
    "! CHLORINE       (17s,12p,4d,3f,2g) -> [7s,6p,4d,3f,2g]",
    "! CHLORINE       (16s,11p,3d,2f,1g) -> [6s,5p,3d,2f,1g]",
    "! CHLORINE       (1s,1p,1d,1f,1g)",
    "s, CL , 834900.0000000, 125000.0000000, 28430.0000000, 8033.0000000, 2608.0000000, 933.9000000, 360.0000000, 147.0000000, 62.8800000, 27.6000000, 11.0800000, 5.0750000, 2.2780000, 0.7775000, 0.3527000, 0.1431000, 0.0519000",
    "c, 1.13, 0.231688D-04, 0.180154D-03, 0.947782D-03, 0.400139D-02, 0.144629D-01, 0.456586D-01, 0.123248D+00, 0.264369D+00, 0.382989D+00, 0.270934D+00, 0.471404D-01, -0.371766D-02, 0.219158D-02",
    "c, 1.13, -0.649649D-05, -0.504895D-04, -0.266113D-03, -0.112499D-02, -0.410497D-02, -0.131987D-01, -0.375342D-01, -0.897233D-01, -0.167671D+00, -0.174763D+00, 0.114909D+00, 0.563618D+00, 0.441606D+00",
    "c, 1.13, 0.196645D-05, 0.152620D-04, 0.806086D-04, 0.339960D-03, 0.124551D-02, 0.399612D-02, 0.114751D-01, 0.275504D-01, 0.532917D-01, 0.571246D-01, -0.395201D-01, -0.264343D+00, -0.349291D+00",
    "c, 14.14, 1",
    "c, 15.15, 1",
    "c, 16.16, 1",
    "c, 17.17, 1",
    "p, CL , 1703.0000000, 403.6000000, 130.3000000, 49.0500000, 20.2600000, 8.7870000, 3.9190000, 1.7650000, 0.7207000, 0.2839000, 0.1060000, 0.0376000",
    "c, 1.8, 0.474039D-03, 0.406412D-02, 0.213355D-01, 0.794611D-01, 0.208927D+00, 0.364945D+00, 0.371725D+00, 0.146292D+00",
    "c, 1.8, -0.128266D-03, -0.109356D-02, -0.583429D-02, -0.219258D-01, -0.601385D-01, -0.106929D+00, -0.122454D+00, 0.383619D-01",
    "c, 9.9, 1",
    "c, 10.10, 1",
    "c, 11.11, 1",
    "c, 12.12, 1",
    "d, CL , 0.2540000, 0.6280000, 1.5510000, 0.0952000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "c, 4.4, 1",
    "f, CL , 0.4230000, 1.0890000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "g, CL , 0.8270000",
    "c, 1.1, 1",
    "! ARGON       (17s,12p,4d,3f,2g) -> [7s,6p,4d,3f,2g]",
    "! ARGON       (16s,11p,3d,2f,1g) -> [6s,5p,3d,2f,1g]",
    "! ARGON       (1s,1p,1d,1f,1g)",
    "s, AR , 950600.0000000, 142300.0000000, 32360.0000000, 9145.0000000, 2970.0000000, 1064.0000000, 410.8000000, 168.0000000, 71.9900000, 31.6700000, 12.8900000, 5.9290000, 2.6780000, 0.9416000, 0.4239000, 0.1714000, 0.0610000",
    "c, 1.13, 0.227545D-04, 0.176945D-03, 0.931282D-03, 0.392860D-02, 0.142064D-01, 0.448114D-01, 0.121001D+00, 0.260579D+00, 0.381364D+00, 0.276058D+00, 0.505179D-01, -0.359866D-02, 0.218798D-02",
    "c, 1.13, -0.646201D-05, -0.502346D-04, -0.264804D-03, -0.111895D-02, -0.408276D-02, -0.131216D-01, -0.372855D-01, -0.894709D-01, -0.168054D+00, -0.179594D+00, 0.102953D+00, 0.562630D+00, 0.450355D+00",
    "c, 1.13, 0.202056D-05, 0.156851D-04, 0.828617D-04, 0.349264D-03, 0.127976D-02, 0.410365D-02, 0.117789D-01, 0.283868D-01, 0.552406D-01, 0.607492D-01, -0.362012D-01, -0.275398D+00, -0.362845D+00",
    "c, 14.14, 1",
    "c, 15.15, 1",
    "c, 16.16, 1",
    "c, 17.17, 1",
    "p, AR , 1890.0000000, 447.8000000, 144.6000000, 54.4600000, 22.5100000, 9.7740000, 4.3680000, 1.9590000, 0.8260000, 0.3297000, 0.1242000, 0.0435000",
    "c, 1.8, 0.495752D-03, 0.425172D-02, 0.223277D-01, 0.830878D-01, 0.217110D+00, 0.374507D+00, 0.366445D+00, 0.129245D+00",
    "c, 1.8, -0.138863D-03, -0.118870D-02, -0.632553D-02, -0.238813D-01, -0.649238D-01, -0.115444D+00, -0.123651D+00, 0.649055D-01",
    "c, 9.9, 1",
    "c, 10.10, 1",
    "c, 11.11, 1",
    "c, 12.12, 1",
    "d, AR , 0.3110000, 0.7630000, 1.8730000, 0.1160000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "c, 4.4, 1",
    "f, AR , 0.5430000, 1.3250000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "g, AR , 1.0070000",
    "c, 1.1, 1",
    ],

'apr-cc-pvqz': [
    "! #####################",
    "! ##                 ##",
    "! ##   apr-cc-pVQZ   ##",
    "! ##                 ##",
    "! #####################",
    "!",
    "! HYDROGEN       (7s,4p,3d,2f) -> [5s,4p,3d,2f]",
    "! HYDROGEN       (6s,3p,2d,1f) -> [4s,3p,2d,1f]",
    "! HYDROGEN       (1s,1p,1d,1f)",
    "s, H , 82.6400000, 12.4100000, 2.8240000, 0.7977000, 0.2581000, 0.0898900",
    "c, 1.3, 0.0020060, 0.0153430, 0.0755790",
    "c, 4.4, 1",
    "c, 5.5, 1",
    "c, 6.6, 1",
    "p, H , 2.2920000, 0.8380000, 0.2920000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "d, H , 2.0620000, 0.6620000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "f, H , 1.3970000",
    "c, 1.1, 1",
    "! HELIUM       (8s,4p,3d,2f) -> [5s,4p,3d,2f]",
    "! HELIUM       (7s,3p,2d,1f) -> [4s,3p,2d,1f]",
    "! HELIUM       (1s,1p,1d,1f)",
    "s, HE , 528.5000000, 79.3100000, 18.0500000, 5.0850000, 1.6090000, 0.5363000, 0.1833000",
    "c, 1.4, 0.0009400, 0.0072140, 0.0359750, 0.1277820",
    "c, 5.5, 1",
    "c, 6.6, 1",
    "c, 7.7, 1",
    "p, HE , 5.9940000, 1.7450000, 0.5600000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "d, HE , 4.2990000, 1.2230000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "f, HE , 2.6800000",
    "c, 1.1, 1",
    "! LITHIUM       (13s,7p,4d,3f,2g) -> [6s,5p,4d,3f,2g]",
    "! LITHIUM       (12s,6p,3d,2f,1g) -> [5s,4p,3d,2f,1g]",
    "! LITHIUM       (1s,1p,1d,1f,1g)",
    "s, LI , 6601.0000000, 989.7000000, 225.7000000, 64.2900000, 21.1800000, 7.7240000, 3.0030000, 1.2120000, 0.4930000, 0.0951500, 0.0479100, 0.0222000, 0.0063600",
    "c, 1.9, 0.0001170, 0.0009110, 0.0047280, 0.0191970, 0.0630470, 0.1632080, 0.3148270, 0.3939360, 0.1969180",
    "c, 1.9, -0.0000180, -0.0001420, -0.0007410, -0.0030200, -0.0101230, -0.0270940, -0.0573590, -0.0938950, -0.1210910",
    "c, 10.10, 1",
    "c, 11.11, 1",
    "c, 12.12, 1",
    "c, 13.13, 1",
    "p, LI , 6.2500000, 1.3700000, 0.3672000, 0.1192000, 0.0447400, 0.0179500, 0.0075600",
    "c, 1.3, 0.0033880, 0.0193160, 0.0791040",
    "c, 4.4, 1",
    "c, 5.5, 1",
    "c, 6.6, 1",
    "c, 7.7, 1",
    "d, LI , 0.3440000, 0.1530000, 0.0680000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "f, LI , 0.2460000, 0.1292000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "g, LI , 0.2380000",
    "c, 1.1, 1",
    "! BERYLLIUM       (13s,7p,4d,3f,2g) -> [6s,5p,4d,3f,2g]",
    "! BERYLLIUM       (12s,6p,3d,2f,1g) -> [5s,4p,3d,2f,1g]",
    "! BERYLLIUM       (1s,1p,1d,1f,1g)",
    "s, BE , 14630.0000000, 2191.0000000, 498.2000000, 140.9000000, 45.8600000, 16.4700000, 6.3190000, 2.5350000, 1.0350000, 0.2528000, 0.1052000, 0.0426100, 0.0143900",
    "c, 1.9, 0.0000920, 0.0007130, 0.0037350, 0.0154680, 0.0528740, 0.1456940, 0.3026810, 0.4049360, 0.2223870",
    "c, 1.9, -0.0000170, -0.0001300, -0.0006790, -0.0028570, -0.0098130, -0.0286090, -0.0637600, -0.1172310, -0.1212020",
    "c, 10.10, 1",
    "c, 11.11, 1",
    "c, 12.12, 1",
    "c, 13.13, 1",
    "p, BE , 14.0300000, 3.1680000, 0.9024000, 0.3036000, 0.1130000, 0.0428600, 0.0065000",
    "c, 1.3, 0.0040990, 0.0256260, 0.1037680",
    "c, 4.4, 1",
    "c, 5.5, 1",
    "c, 6.6, 1",
    "c, 7.7, 1",
    "d, BE , 1.0720000, 0.4410000, 0.1811000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "f, BE , 0.4810000, 0.2550000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "g, BE , 0.4150000",
    "c, 1.1, 1",
    "! BORON       (13s,7p,4d,3f,2g) -> [6s,5p,4d,3f,2g]",
    "! BORON       (12s,6p,3d,2f,1g) -> [5s,4p,3d,2f,1g]",
    "! BORON       (1s,1p,1d,1f,1g)",
    "s, B , 23870.0000000, 3575.0000000, 812.8000000, 229.7000000, 74.6900000, 26.8100000, 10.3200000, 4.1780000, 1.7270000, 0.4704000, 0.1896000, 0.0739400, 0.0272100",
    "c, 1.9, 0.0000880, 0.0006870, 0.0036000, 0.0149490, 0.0514350, 0.1433020, 0.3009350, 0.4035260, 0.2253400",
    "c, 1.9, -0.0000180, -0.0001390, -0.0007250, -0.0030630, -0.0105810, -0.0313650, -0.0710120, -0.1321030, -0.1230720",
    "c, 10.10, 1",
    "c, 11.11, 1",
    "c, 12.12, 1",
    "c, 13.13, 1",
    "p, B , 22.2600000, 5.0580000, 1.4870000, 0.5071000, 0.1812000, 0.0646300, 0.0187800",
    "c, 1.3, 0.0050950, 0.0332060, 0.1323140",
    "c, 4.4, 1",
    "c, 5.5, 1",
    "c, 6.6, 1",
    "c, 7.7, 1",
    "d, B , 1.1100000, 0.4020000, 0.1450000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "f, B , 0.8820000, 0.3110000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "g, B , 0.6730000",
    "c, 1.1, 1",
    "! CARBON       (13s,7p,4d,3f,2g) -> [6s,5p,4d,3f,2g]",
    "! CARBON       (12s,6p,3d,2f,1g) -> [5s,4p,3d,2f,1g]",
    "! CARBON       (1s,1p,1d,1f,1g)",
    "s, C , 33980.0000000, 5089.0000000, 1157.0000000, 326.6000000, 106.1000000, 38.1100000, 14.7500000, 6.0350000, 2.5300000, 0.7355000, 0.2905000, 0.1111000, 0.0414500",
    "c, 1.9, 0.0000910, 0.0007040, 0.0036930, 0.0153600, 0.0529290, 0.1470430, 0.3056310, 0.3993450, 0.2170510",
    "c, 1.9, -0.0000190, -0.0001510, -0.0007850, -0.0033240, -0.0115120, -0.0341600, -0.0771730, -0.1414930, -0.1180190",
    "c, 10.10, 1",
    "c, 11.11, 1",
    "c, 12.12, 1",
    "c, 13.13, 1",
    "p, C , 34.5100000, 7.9150000, 2.3680000, 0.8132000, 0.2890000, 0.1007000, 0.0321800",
    "c, 1.3, 0.0053780, 0.0361320, 0.1424930",
    "c, 4.4, 1",
    "c, 5.5, 1",
    "c, 6.6, 1",
    "c, 7.7, 1",
    "d, C , 1.8480000, 0.6490000, 0.2280000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "f, C , 1.4190000, 0.4850000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "g, C , 1.0110000",
    "c, 1.1, 1",
    "! NITROGEN       (13s,7p,4d,3f,2g) -> [6s,5p,4d,3f,2g]",
    "! NITROGEN       (12s,6p,3d,2f,1g) -> [5s,4p,3d,2f,1g]",
    "! NITROGEN       (1s,1p,1d,1f,1g)",
    "s, N , 45840.0000000, 6868.0000000, 1563.0000000, 442.4000000, 144.3000000, 52.1800000, 20.3400000, 8.3810000, 3.5290000, 1.0540000, 0.4118000, 0.1552000, 0.0546400",
    "c, 1.9, 0.0000920, 0.0007170, 0.0037490, 0.0155320, 0.0531460, 0.1467870, 0.3046630, 0.3976840, 0.2176410",
    "c, 1.9, -0.0000200, -0.0001590, -0.0008240, -0.0034780, -0.0119660, -0.0353880, -0.0800770, -0.1467220, -0.1163600",
    "c, 10.10, 1",
    "c, 11.11, 1",
    "c, 12.12, 1",
    "c, 13.13, 1",
    "p, N , 49.3300000, 11.3700000, 3.4350000, 1.1820000, 0.4173000, 0.1428000, 0.0440200",
    "c, 1.3, 0.0055330, 0.0379620, 0.1490280",
    "c, 4.4, 1",
    "c, 5.5, 1",
    "c, 6.6, 1",
    "c, 7.7, 1",
    "d, N , 2.8370000, 0.9680000, 0.3350000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "f, N , 2.0270000, 0.6850000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "g, N , 1.4270000",
    "c, 1.1, 1",
    "! OXYGEN       (13s,7p,4d,3f,2g) -> [6s,5p,4d,3f,2g]",
    "! OXYGEN       (12s,6p,3d,2f,1g) -> [5s,4p,3d,2f,1g]",
    "! OXYGEN       (1s,1p,1d,1f,1g)",
    "s, O , 61420.0000000, 9199.0000000, 2091.0000000, 590.9000000, 192.3000000, 69.3200000, 26.9700000, 11.1000000, 4.6820000, 1.4280000, 0.5547000, 0.2067000, 0.0695900",
    "c, 1.9, 0.0000900, 0.0006980, 0.0036640, 0.0152180, 0.0524230, 0.1459210, 0.3052580, 0.3985080, 0.2169800",
    "c, 1.9, -0.0000200, -0.0001590, -0.0008290, -0.0035080, -0.0121560, -0.0362610, -0.0829920, -0.1520900, -0.1153310",
    "c, 10.10, 1",
    "c, 11.11, 1",
    "c, 12.12, 1",
    "c, 13.13, 1",
    "p, O , 63.4200000, 14.6600000, 4.4590000, 1.5310000, 0.5302000, 0.1750000, 0.0534800",
    "c, 1.3, 0.0060440, 0.0417990, 0.1611430",
    "c, 4.4, 1",
    "c, 5.5, 1",
    "c, 6.6, 1",
    "c, 7.7, 1",
    "d, O , 3.7750000, 1.3000000, 0.4440000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "f, O , 2.6660000, 0.8590000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "g, O , 1.8460000",
    "c, 1.1, 1",
    "! FLUORINE       (13s,7p,4d,3f,2g) -> [6s,5p,4d,3f,2g]",
    "! FLUORINE       (12s,6p,3d,2f,1g) -> [5s,4p,3d,2f,1g]",
    "! FLUORINE       (1s,1p,1d,1f,1g)",
    "s, F , 74530.0000000, 11170.0000000, 2543.0000000, 721.0000000, 235.9000000, 85.6000000, 33.5500000, 13.9300000, 5.9150000, 1.8430000, 0.7124000, 0.2637000, 0.0859400",
    "c, 1.9, 0.0000950, 0.0007380, 0.0038580, 0.0159260, 0.0542890, 0.1495130, 0.3082520, 0.3948530, 0.2110310",
    "c, 1.9, -0.0000220, -0.0001720, -0.0008910, -0.0037480, -0.0128620, -0.0380610, -0.0862390, -0.1558650, -0.1109140",
    "c, 10.10, 1",
    "c, 11.11, 1",
    "c, 12.12, 1",
    "c, 13.13, 1",
    "p, F , 80.3900000, 18.6300000, 5.6940000, 1.9530000, 0.6702000, 0.2166000, 0.0656800",
    "c, 1.3, 0.0063470, 0.0442040, 0.1685140",
    "c, 4.4, 1",
    "c, 5.5, 1",
    "c, 6.6, 1",
    "c, 7.7, 1",
    "d, F , 5.0140000, 1.7250000, 0.5860000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "f, F , 3.5620000, 1.1480000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "g, F , 2.3760000",
    "c, 1.1, 1",
    "! NEON       (13s,7p,4d,3f,2g) -> [6s,5p,4d,3f,2g]",
    "! NEON       (12s,6p,3d,2f,1g) -> [5s,4p,3d,2f,1g]",
    "! NEON       (1s,1p,1d,1f,1g)",
    "s, NE , 99920.0000000, 14960.0000000, 3399.0000000, 958.9000000, 311.2000000, 111.7000000, 43.3200000, 17.8000000, 7.5030000, 2.3370000, 0.9001000, 0.3301000, 0.1054000",
    "c, 1.9, 0.0000860, 0.0006690, 0.0035180, 0.0146670, 0.0509620, 0.1437440, 0.3045620, 0.4001050, 0.2186440",
    "c, 1.9, -0.0000200, -0.0001580, -0.0008240, -0.0035000, -0.0122330, -0.0370170, -0.0861130, -0.1583810, -0.1142880",
    "c, 10.10, 1",
    "c, 11.11, 1",
    "c, 12.12, 1",
    "c, 13.13, 1",
    "p, NE , 99.6800000, 23.1500000, 7.1080000, 2.4410000, 0.8339000, 0.2662000, 0.0817800",
    "c, 1.3, 0.0065660, 0.0459790, 0.1734190",
    "c, 4.4, 1",
    "c, 5.5, 1",
    "c, 6.6, 1",
    "c, 7.7, 1",
    "d, NE , 6.4710000, 2.2130000, 0.7470000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "f, NE , 4.6570000, 1.5240000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "g, NE , 2.9830000",
    "c, 1.1, 1",
    "! SODIUM       (20s,13p,4d,3f,2g) -> [7s,6p,4d,3f,2g]",
    "! SODIUM       (19s,12p,3d,2f,1g) -> [6s,5p,3d,2f,1g]",
    "! SODIUM       (1s,1p,1d,1f,1g)",
    "s, NA , 1224000.0000000, 183200.0000000, 41700.0000000, 11810.0000000, 3853.0000000, 1391.0000000, 542.5000000, 224.9000000, 97.9300000, 44.3100000, 20.6500000, 9.7290000, 4.2280000, 1.9690000, 0.8890000, 0.3964000, 0.0699300, 0.0328900, 0.0161200, 0.0050300",
    "c, 1.16, 0.478894D-05, 0.372395D-04, 0.195831D-03, 0.826698D-03, 0.300251D-02, 0.970310D-02, 0.282337D-01, 0.732058D-01, 0.162897D+00, 0.288708D+00, 0.346829D+00, 0.206865D+00, 0.328009D-01, -0.647736D-03, 0.145878D-02, -0.178346D-03",
    "c, 1.16, -0.116958D-05, -0.909110D-05, -0.478499D-04, -0.201962D-03, -0.735837D-03, -0.238746D-02, -0.704969D-02, -0.187856D-01, -0.446153D-01, -0.897741D-01, -0.142940D+00, -0.124315D+00, 0.999648D-01, 0.417080D+00, 0.475123D+00, 0.163268D+00",
    "c, 1.16, 0.175871D-06, 0.136594D-05, 0.719795D-05, 0.303349D-04, 0.110752D-03, 0.358596D-03, 0.106272D-02, 0.282687D-02, 0.676742D-02, 0.136480D-01, 0.222814D-01, 0.196011D-01, -0.167708D-01, -0.773734D-01, -0.113501D+00, -0.139130D+00",
    "c, 17.17, 1",
    "c, 18.18, 1",
    "c, 19.19, 1",
    "c, 20.20, 1",
    "p, NA , 413.4000000, 97.9800000, 31.3700000, 11.6200000, 4.6710000, 1.9180000, 0.7775000, 0.3013000, 0.2275000, 0.0752700, 0.0312600, 0.0134200, 0.0077200",
    "c, 1.9, 0.908196D-03, 0.741773D-02, 0.357464D-01, 0.118520D+00, 0.261403D+00, 0.378395D+00, 0.334632D+00, 0.126844D+00, -0.147117D-01",
    "c, 1.9, -0.901741D-04, -0.739342D-03, -0.357309D-02, -0.120142D-01, -0.267178D-01, -0.392753D-01, -0.376083D-01, -0.433228D-01, 0.518003D-01",
    "c, 10.10, 1",
    "c, 11.11, 1",
    "c, 12.12, 1",
    "c, 13.13, 1",
    "d, NA , 0.1538000, 0.0865000, 0.0487000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "f, NA , 0.1912000, 0.1036000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "g, NA , 0.1722000",
    "c, 1.1, 1",
    "! MAGNESIUM       (17s,13p,4d,3f,2g) -> [7s,6p,4d,3f,2g]",
    "! MAGNESIUM       (16s,12p,3d,2f,1g) -> [6s,5p,3d,2f,1g]",
    "! MAGNESIUM       (1s,1p,1d,1f,1g)",
    "s, MG , 327600.0000000, 49050.0000000, 11150.0000000, 3152.0000000, 1025.0000000, 368.8000000, 143.2000000, 58.9600000, 25.4000000, 11.1500000, 4.0040000, 1.7010000, 0.7060000, 0.1410000, 0.0680800, 0.0306300, 0.0123900",
    "c, 1.13, 0.309608D-04, 0.240954D-03, 0.126660D-02, 0.533359D-02, 0.190770D-01, 0.588058D-01, 0.151454D+00, 0.300716D+00, 0.381149D+00, 0.213584D+00, 0.231210D-01, -0.230757D-02, 0.128900D-02",
    "c, 1.13, -0.783173D-05, -0.607935D-04, -0.321197D-03, -0.134955D-02, -0.490570D-02, -0.153561D-01, -0.423409D-01, -0.940603D-01, -0.163425D+00, -0.124754D+00, 0.235623D+00, 0.577563D+00, 0.335232D+00",
    "c, 1.13, 0.150908D-05, 0.117134D-04, 0.618980D-04, 0.260088D-03, 0.946218D-03, 0.296595D-02, 0.821245D-02, 0.183977D-01, 0.326657D-01, 0.257315D-01, -0.535351D-01, -0.156895D+00, -0.206659D+00",
    "c, 14.14, 1",
    "c, 15.15, 1",
    "c, 16.16, 1",
    "c, 17.17, 1",
    "p, MG , 539.6000000, 127.9000000, 41.0200000, 15.2500000, 6.1660000, 2.5610000, 1.0600000, 0.4176000, 0.2690000, 0.1223000, 0.0547600, 0.0238800, 0.0070600",
    "c, 1.9, 0.833969D-03, 0.689215D-02, 0.337874D-01, 0.114401D+00, 0.259514D+00, 0.385095D+00, 0.335373D+00, 0.110641D+00, -0.121315D-01",
    "c, 1.9, -0.132076D-03, -0.109538D-02, -0.539495D-02, -0.185572D-01, -0.427375D-01, -0.647684D-01, -0.627818D-01, -0.244912D-01, 0.104761D+00",
    "c, 10.10, 1",
    "c, 11.11, 1",
    "c, 12.12, 1",
    "c, 13.13, 1",
    "d, MG , 0.1060000, 0.1944000, 0.3570000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "f, MG , 0.1810000, 0.3590000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "g, MG , 0.3070000",
    "c, 1.1, 1",
    "! ALUMINUM       (17s,12p,4d,3f,2g) -> [7s,6p,4d,3f,2g]",
    "! ALUMINUM       (16s,11p,3d,2f,1g) -> [6s,5p,3d,2f,1g]",
    "! ALUMINUM       (1s,1p,1d,1f,1g)",
    "s, AL , 419600.0000000, 62830.0000000, 14290.0000000, 4038.0000000, 1312.0000000, 470.5000000, 181.8000000, 74.4600000, 31.9000000, 13.9600000, 5.1800000, 2.2650000, 0.9664000, 0.2447000, 0.1184000, 0.0502100, 0.0183000",
    "c, 1.13, 0.278219D-04, 0.216330D-03, 0.113754D-02, 0.479635D-02, 0.172389D-01, 0.538066D-01, 0.141326D+00, 0.289268D+00, 0.384825D+00, 0.232852D+00, 0.293330D-01, -0.300574D-02, 0.166673D-02",
    "c, 1.13, -0.723754D-05, -0.561733D-04, -0.296528D-03, -0.124913D-02, -0.455101D-02, -0.144393D-01, -0.403464D-01, -0.922618D-01, -0.164510D+00, -0.141296D+00, 0.195365D+00, 0.572475D+00, 0.374041D+00",
    "c, 1.13, 0.167150D-05, 0.129641D-04, 0.685101D-04, 0.288274D-03, 0.105276D-02, 0.333878D-02, 0.939217D-02, 0.216047D-01, 0.395873D-01, 0.349180D-01, -0.528415D-01, -0.191878D+00, -0.254115D+00",
    "c, 14.14, 1",
    "c, 15.15, 1",
    "c, 16.16, 1",
    "c, 17.17, 1",
    "p, AL , 891.3000000, 211.3000000, 68.2800000, 25.7000000, 10.6300000, 4.6020000, 2.0150000, 0.8706000, 0.2972000, 0.1100000, 0.0398900, 0.0121000",
    "c, 1.8, 0.491755D-03, 0.415843D-02, 0.212538D-01, 0.764058D-01, 0.194277D+00, 0.334428D+00, 0.375026D+00, 0.204041D+00",
    "c, 1.8, -0.888695D-04, -0.745823D-03, -0.387025D-02, -0.139350D-01, -0.366860D-01, -0.627797D-01, -0.789602D-01, -0.288589D-01",
    "c, 9.9, 1",
    "c, 10.10, 1",
    "c, 11.11, 1",
    "c, 12.12, 1",
    "d, AL , 0.0804000, 0.1990000, 0.4940000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "f, AL , 0.1540000, 0.4010000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "g, AL , 0.3570000",
    "c, 1.1, 1",
    "! SILICON       (17s,12p,4d,3f,2g) -> [7s,6p,4d,3f,2g]",
    "! SILICON       (16s,11p,3d,2f,1g) -> [6s,5p,3d,2f,1g]",
    "! SILICON       (1s,1p,1d,1f,1g)",
    "s, SI , 513000.0000000, 76820.0000000, 17470.0000000, 4935.0000000, 1602.0000000, 574.1000000, 221.5000000, 90.5400000, 38.7400000, 16.9500000, 6.4520000, 2.8740000, 1.2500000, 0.3599000, 0.1699000, 0.0706600, 0.0275000",
    "c, 1.13, 0.260920D-04, 0.202905D-03, 0.106715D-02, 0.450597D-02, 0.162359D-01, 0.508913D-01, 0.135155D+00, 0.281292D+00, 0.385336D+00, 0.245651D+00, 0.343145D-01, -0.334884D-02, 0.187625D-02",
    "c, 1.13, -0.694880D-05, -0.539641D-04, -0.284716D-03, -0.120203D-02, -0.438397D-02, -0.139776D-01, -0.393516D-01, -0.914283D-01, -0.165609D+00, -0.152505D+00, 0.168524D+00, 0.569284D+00, 0.398056D+00",
    "c, 1.13, 0.178068D-05, 0.138148D-04, 0.730005D-04, 0.307666D-03, 0.112563D-02, 0.358435D-02, 0.101728D-01, 0.237520D-01, 0.443483D-01, 0.419041D-01, -0.502504D-01, -0.216578D+00, -0.286448D+00",
    "c, 14.14, 1",
    "c, 15.15, 1",
    "c, 16.16, 1",
    "c, 17.17, 1",
    "p, SI , 1122.0000000, 266.0000000, 85.9200000, 32.3300000, 13.3700000, 5.8000000, 2.5590000, 1.1240000, 0.3988000, 0.1533000, 0.0572800, 0.0200000",
    "c, 1.8, 0.448143D-03, 0.381639D-02, 0.198105D-01, 0.727017D-01, 0.189839D+00, 0.335672D+00, 0.379365D+00, 0.201193D+00",
    "c, 1.8, -0.964883D-04, -0.811971D-03, -0.430087D-02, -0.157502D-01, -0.429541D-01, -0.752574D-01, -0.971446D-01, -0.227507D-01",
    "c, 9.9, 1",
    "c, 10.10, 1",
    "c, 11.11, 1",
    "c, 12.12, 1",
    "d, SI , 0.1200000, 0.3020000, 0.7600000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "f, SI , 0.2120000, 0.5410000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "g, SI , 0.4610000",
    "c, 1.1, 1",
    "! PHOSPHOROUS       (17s,12p,4d,3f,2g) -> [7s,6p,4d,3f,2g]",
    "! PHOSPHOROUS       (16s,11p,3d,2f,1g) -> [6s,5p,3d,2f,1g]",
    "! PHOSPHOROUS       (1s,1p,1d,1f,1g)",
    "s, P , 615200.0000000, 92120.0000000, 20950.0000000, 5920.0000000, 1922.0000000, 688.0000000, 265.0000000, 108.2000000, 46.2200000, 20.2300000, 7.8590000, 3.5470000, 1.5640000, 0.4888000, 0.2266000, 0.0933100, 0.0354000",
    "c, 1.13, 0.247450D-04, 0.192465D-03, 0.101202D-02, 0.427261D-02, 0.154161D-01, 0.485976D-01, 0.130060D+00, 0.274514D+00, 0.385402D+00, 0.255934D+00, 0.391237D-01, -0.368010D-02, 0.208211D-02",
    "c, 1.13, -0.672205D-05, -0.522311D-04, -0.275361D-03, -0.116307D-02, -0.424281D-02, -0.136114D-01, -0.385114D-01, -0.906643D-01, -0.166584D+00, -0.161447D+00, 0.146781D+00, 0.566682D+00, 0.416433D+00",
    "c, 1.13, 0.184740D-05, 0.143380D-04, 0.757228D-04, 0.319205D-03, 0.116851D-02, 0.374267D-02, 0.106817D-01, 0.252657D-01, 0.479283D-01, 0.477096D-01, -0.466525D-01, -0.234968D+00, -0.311337D+00",
    "c, 14.14, 1",
    "c, 15.15, 1",
    "c, 16.16, 1",
    "c, 17.17, 1",
    "p, P , 1367.0000000, 324.0000000, 104.6000000, 39.3700000, 16.2600000, 7.0560000, 3.1300000, 1.3940000, 0.5179000, 0.2032000, 0.0769800, 0.0272000",
    "c, 1.8, 0.421015D-03, 0.360985D-02, 0.189217D-01, 0.705560D-01, 0.188157D+00, 0.338709D+00, 0.381943D+00, 0.195261D+00",
    "c, 1.8, -0.100827D-03, -0.854499D-03, -0.457116D-02, -0.170327D-01, -0.475204D-01, -0.852786D-01, -0.109676D+00, -0.161181D-01",
    "c, 9.9, 1",
    "c, 10.10, 1",
    "c, 11.11, 1",
    "c, 12.12, 1",
    "d, P , 0.1650000, 0.4130000, 1.0360000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "f, P , 0.2800000, 0.7030000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "g, P , 0.5970000",
    "c, 1.1, 1",
    "! SULFUR       (17s,12p,4d,3f,2g) -> [7s,6p,4d,3f,2g]",
    "! SULFUR       (16s,11p,3d,2f,1g) -> [6s,5p,3d,2f,1g]",
    "! SULFUR       (1s,1p,1d,1f,1g)",
    "s, S , 727800.0000000, 109000.0000000, 24800.0000000, 7014.0000000, 2278.0000000, 814.7000000, 313.4000000, 127.7000000, 54.4800000, 23.8500000, 9.4280000, 4.2900000, 1.9090000, 0.6270000, 0.2873000, 0.1172000, 0.0428000",
    "c, 1.13, 0.236025D-04, 0.183482D-03, 0.964278D-03, 0.406537D-02, 0.146973D-01, 0.465081D-01, 0.125508D+00, 0.268433D+00, 0.384809D+00, 0.265372D+00, 0.437326D-01, -0.378807D-02, 0.218083D-02",
    "c, 1.13, -0.652179D-05, -0.506631D-04, -0.266833D-03, -0.112601D-02, -0.411186D-02, -0.132454D-01, -0.377004D-01, -0.898554D-01, -0.167098D+00, -0.169354D+00, 0.127824D+00, 0.564862D+00, 0.431767D+00",
    "c, 1.13, 0.189406D-05, 0.146948D-04, 0.775460D-04, 0.326509D-03, 0.119686D-02, 0.384799D-02, 0.110539D-01, 0.264645D-01, 0.508771D-01, 0.530030D-01, -0.425518D-01, -0.250853D+00, -0.333152D+00",
    "c, 14.14, 1",
    "c, 15.15, 1",
    "c, 16.16, 1",
    "c, 17.17, 1",
    "p, S , 1546.0000000, 366.4000000, 118.4000000, 44.5300000, 18.3800000, 7.9650000, 3.5410000, 1.5910000, 0.6205000, 0.2420000, 0.0901400, 0.0317000",
    "c, 1.8, 0.441183D-03, 0.377571D-02, 0.198360D-01, 0.742063D-01, 0.197327D+00, 0.351851D+00, 0.378687D+00, 0.170931D+00",
    "c, 1.8, -0.113110D-03, -0.958581D-03, -0.513471D-02, -0.192641D-01, -0.535980D-01, -0.960333D-01, -0.118183D+00, 0.923194D-02",
    "c, 9.9, 1",
    "c, 10.10, 1",
    "c, 11.11, 1",
    "c, 12.12, 1",
    "d, S , 0.2030000, 0.5040000, 1.2500000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "f, S , 0.3350000, 0.8690000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "g, S , 0.6830000",
    "c, 1.1, 1",
    "! CHLORINE       (17s,12p,4d,3f,2g) -> [7s,6p,4d,3f,2g]",
    "! CHLORINE       (16s,11p,3d,2f,1g) -> [6s,5p,3d,2f,1g]",
    "! CHLORINE       (1s,1p,1d,1f,1g)",
    "s, CL , 834900.0000000, 125000.0000000, 28430.0000000, 8033.0000000, 2608.0000000, 933.9000000, 360.0000000, 147.0000000, 62.8800000, 27.6000000, 11.0800000, 5.0750000, 2.2780000, 0.7775000, 0.3527000, 0.1431000, 0.0519000",
    "c, 1.13, 0.231688D-04, 0.180154D-03, 0.947782D-03, 0.400139D-02, 0.144629D-01, 0.456586D-01, 0.123248D+00, 0.264369D+00, 0.382989D+00, 0.270934D+00, 0.471404D-01, -0.371766D-02, 0.219158D-02",
    "c, 1.13, -0.649649D-05, -0.504895D-04, -0.266113D-03, -0.112499D-02, -0.410497D-02, -0.131987D-01, -0.375342D-01, -0.897233D-01, -0.167671D+00, -0.174763D+00, 0.114909D+00, 0.563618D+00, 0.441606D+00",
    "c, 1.13, 0.196645D-05, 0.152620D-04, 0.806086D-04, 0.339960D-03, 0.124551D-02, 0.399612D-02, 0.114751D-01, 0.275504D-01, 0.532917D-01, 0.571246D-01, -0.395201D-01, -0.264343D+00, -0.349291D+00",
    "c, 14.14, 1",
    "c, 15.15, 1",
    "c, 16.16, 1",
    "c, 17.17, 1",
    "p, CL , 1703.0000000, 403.6000000, 130.3000000, 49.0500000, 20.2600000, 8.7870000, 3.9190000, 1.7650000, 0.7207000, 0.2839000, 0.1060000, 0.0376000",
    "c, 1.8, 0.474039D-03, 0.406412D-02, 0.213355D-01, 0.794611D-01, 0.208927D+00, 0.364945D+00, 0.371725D+00, 0.146292D+00",
    "c, 1.8, -0.128266D-03, -0.109356D-02, -0.583429D-02, -0.219258D-01, -0.601385D-01, -0.106929D+00, -0.122454D+00, 0.383619D-01",
    "c, 9.9, 1",
    "c, 10.10, 1",
    "c, 11.11, 1",
    "c, 12.12, 1",
    "d, CL , 0.2540000, 0.6280000, 1.5510000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "f, CL , 0.4230000, 1.0890000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "g, CL , 0.8270000",
    "c, 1.1, 1",
    "! ARGON       (17s,12p,4d,3f,2g) -> [7s,6p,4d,3f,2g]",
    "! ARGON       (16s,11p,3d,2f,1g) -> [6s,5p,3d,2f,1g]",
    "! ARGON       (1s,1p,1d,1f,1g)",
    "s, AR , 950600.0000000, 142300.0000000, 32360.0000000, 9145.0000000, 2970.0000000, 1064.0000000, 410.8000000, 168.0000000, 71.9900000, 31.6700000, 12.8900000, 5.9290000, 2.6780000, 0.9416000, 0.4239000, 0.1714000, 0.0610000",
    "c, 1.13, 0.227545D-04, 0.176945D-03, 0.931282D-03, 0.392860D-02, 0.142064D-01, 0.448114D-01, 0.121001D+00, 0.260579D+00, 0.381364D+00, 0.276058D+00, 0.505179D-01, -0.359866D-02, 0.218798D-02",
    "c, 1.13, -0.646201D-05, -0.502346D-04, -0.264804D-03, -0.111895D-02, -0.408276D-02, -0.131216D-01, -0.372855D-01, -0.894709D-01, -0.168054D+00, -0.179594D+00, 0.102953D+00, 0.562630D+00, 0.450355D+00",
    "c, 1.13, 0.202056D-05, 0.156851D-04, 0.828617D-04, 0.349264D-03, 0.127976D-02, 0.410365D-02, 0.117789D-01, 0.283868D-01, 0.552406D-01, 0.607492D-01, -0.362012D-01, -0.275398D+00, -0.362845D+00",
    "c, 14.14, 1",
    "c, 15.15, 1",
    "c, 16.16, 1",
    "c, 17.17, 1",
    "p, AR , 1890.0000000, 447.8000000, 144.6000000, 54.4600000, 22.5100000, 9.7740000, 4.3680000, 1.9590000, 0.8260000, 0.3297000, 0.1242000, 0.0435000",
    "c, 1.8, 0.495752D-03, 0.425172D-02, 0.223277D-01, 0.830878D-01, 0.217110D+00, 0.374507D+00, 0.366445D+00, 0.129245D+00",
    "c, 1.8, -0.138863D-03, -0.118870D-02, -0.632553D-02, -0.238813D-01, -0.649238D-01, -0.115444D+00, -0.123651D+00, 0.649055D-01",
    "c, 9.9, 1",
    "c, 10.10, 1",
    "c, 11.11, 1",
    "c, 12.12, 1",
    "d, AR , 0.3110000, 0.7630000, 1.8730000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "c, 3.3, 1",
    "f, AR , 0.5430000, 1.3250000",
    "c, 1.1, 1",
    "c, 2.2, 1",
    "g, AR , 1.0070000",
    "c, 1.1, 1",
    ],
}
