#!/usr/bin/python
"""
Creates IconImages.py from ../images/*.gif
"""
#  Copyright (C) 2004  Henning Jacobs <henning@srcco.de>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  $Id: createIconImages.py 82 2004-07-11 13:01:44Z henning $

import base64
import glob
import os

imagefilenames = glob.glob("../images/*.gif")

fd = open("IconImages.py", "w")
fd.write("""
from Tkinter import *

IconImages = {}
IconImagesGrey = {}
""")

for fname in imagefilenames:
    iconname = os.path.splitext(os.path.basename(fname.lower()))[0]
    fd.write("\n"+ iconname + "_data = '''\\\n" +
        # Note: On Windows: 'rb' (binary read) is required!
        base64.encodestring(open(fname, "rb").read()) +  "'''")

fd.write("""
def createIconImages():
    if not IconImages:
        for key,value in zip(globals().keys(), globals().values()):
            if key[-5:] == "_data":
                icon = key[:-5]
                if icon[-5:] == "_grey":
                    icon = icon[:-5]
                    IconImagesGrey[icon] = PhotoImage(data=value)
                else:
                    IconImages[icon] = PhotoImage(data=value)
""")

fd.close()

