# pyOCD debugger
# Copyright (c) 2017 NXP
# Copyright (c) 2018-2020 Arm Limited
# Copyright (c) 2021 Chris Reed
# SPDX-License-Identifier: Apache-2.0
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import logging
from ...core.memory_map import (FlashRegion, RomRegion, RamRegion, MemoryMap)
from ...debug.svd.loader import SVDFile
from ..family.target_imxrt import IMXRT

LOG = logging.getLogger(__name__)

FCFB = 0x42464346
FCFB_ADDR = 0x60000000
IVT_ADDR = 0x60001000

FPB_CTRL = 0xE0002000
FPB_COMP0 = 0xE0002008

SRC_SBMR2 = 0x400F801C

FLASH_ALGO_QUADSPI = {
    'load_address' : 0x00000000,

    'instructions': [
    0xE00ABE00, 0x062D780D, 0x24084068, 0xD3000040, 0x1E644058, 0x1C49D1FA, 0x2A001E52, 0x4770D1F2,
    0x4605b570, 0x4616460c, 0xcc0fe002, 0x3e10c50f, 0xd2fa2e10, 0xd3022e08, 0xc503cc03, 0x2e043e08,
    0xcc01d307, 0x1f36c501, 0x7821e003, 0x1c647029, 0x1e761c6d, 0xbd70d2f9, 0x4770ba40, 0x4770ba40,
    0x4770ba40, 0x4770ba40, 0x4770ba40, 0x4770ba40, 0x4770ba40, 0x4770bac0, 0x4770bac0, 0x4770bac0,
    0x4770bac0, 0x4770bac0, 0x4770bac0, 0x4770bac0, 0x482fb51c, 0x482f9000, 0x08498901, 0x81010049,
    0x890a492d, 0x00520852, 0x8802810a, 0x07522304, 0xda022a00, 0x439a8802, 0x88088002, 0xd5020740,
    0x43988808, 0x48268008, 0x60414924, 0x60814925, 0x22806801, 0x22204391, 0x60014311, 0x466a4922,
    0x20004449, 0xfba8f002, 0xd1052800, 0x4449491e, 0xfeeaf000, 0xd0002800, 0xbd1c2001, 0x47702000,
    0xb5104919, 0x20004449, 0xf841f001, 0xd0002800, 0xbd102001, 0x07492105, 0x49131842, 0x2301b510,
    0x4449049b, 0xf0022000, 0x2800fbdd, 0x2001d000, 0x2105bd10, 0x07494613, 0x490b1842, 0x4449b510,
    0xf0002000, 0x2800ffc5, 0x2001d000, 0x0000bd10, 0xc0000006, 0x400b8000, 0x400d0000, 0xd928c520,
    0x400bc000, 0x0000ffff, 0x00000010, 0x49a4b5f8, 0x444948a2, 0x4ea46008, 0x603048a2, 0x28006830,
    0x6b30dafc, 0x03092101, 0x63304388, 0x28006b30, 0x489edafc, 0x499e6802, 0x400a2303, 0x18d202db,
    0x431a4b9c, 0x20036002, 0x61300300, 0x28006930, 0x6930dafc, 0x043f2701, 0x613043b8, 0x3a404a93,
    0x40086b10, 0x02092123, 0x49931840, 0x63104308, 0x20014c92, 0x49936120, 0x44494891, 0x25016008,
    0xe0009000, 0x46291c6d, 0xf0039800, 0x498efc13, 0xd8f74288, 0x498d6960, 0x1e694008, 0x0b490749,
    0x02294308, 0x390139ff, 0x0d890589, 0x61604308, 0x09c06a60, 0x1cc001c0, 0x69a06260, 0x04892103,
    0x61a04308, 0x498269a0, 0x21054008, 0x18400689, 0x69e061a0, 0x4008497f, 0x07492103, 0x497e1840,
    0x61e04308, 0x210369e0, 0x43080409, 0x6a6061e0, 0x02c921e7, 0x21214388, 0x184002c9, 0x68306260,
    0x603043b8, 0x43b86b30, 0x69306330, 0x613043b8, 0x486abdf8, 0x68013080, 0x02922203, 0x60014311,
    0x48664770, 0x68013080, 0x02922203, 0x60014391, 0xb5f74770, 0x4969460c, 0x4615b08a, 0x44792214,
    0xf7ff4668, 0x4965febd, 0x44792214, 0xa8053108, 0xfeb6f7ff, 0xd0012d00, 0xd1362d01, 0x3e404e53,
    0x09876b30, 0x01bf4855, 0x200769c2, 0x438205c0, 0xd02c2d00, 0x2c00a805, 0x2c09d027, 0x2401d900,
    0x5c430061, 0x78401808, 0x05c02107, 0x069b05c9, 0x0e9b1840, 0x4d520184, 0x09a4433b, 0x43146828,
    0x43382702, 0x980a6028, 0xffbbf7ff, 0x42986b30, 0x6333d000, 0x69c14841, 0xd00042a1, 0x980a61c4,
    0xffa7f7ff, 0x43b86828, 0xb00d6028, 0x4668bdf0, 0xb570e7d1, 0x4a3b4616, 0x444a2000, 0x46046812,
    0xd0082900, 0x29014d35, 0x2902d007, 0x2404d00a, 0x46206030, 0x4610bd70, 0x6968e7fa, 0x0f810580,
    0xe00d4610, 0x482969e8, 0x6b003840, 0x0e890681, 0xf0034834, 0x2112fb4f, 0x69e94348, 0x0f490189,
    0xf0031c49, 0xe7e3fb47, 0x20044603, 0xd1042b00, 0xd0022900, 0x6008482c, 0x47702000, 0x44484821,
    0x47706800, 0x481db510, 0x05806940, 0x481d0f81, 0x44481c49, 0xf0036800, 0xbd10fb2d, 0x4604b5f8,
    0x460d4818, 0x68004448, 0xf0034920, 0x4606fb23, 0x2103e009, 0xf0034630, 0x9000fb1d, 0xbf00e000,
    0x90001e40, 0x2200d2fb, 0x46281e64, 0x415043d2, 0x43e14605, 0x430143e8, 0xbdf8d1eb, 0x016e3600,
    0x00000004, 0x00012058, 0x400d8000, 0x400d8100, 0xc0c0c0c0, 0x18131818, 0x0f1a2323, 0x400fc000,
    0x1f78a400, 0x0000000c, 0x08954400, 0xfff8e0ff, 0xe3ffffcf, 0x9c7fff80, 0x03800001, 0x000039b2,
    0x402a8000, 0x1c9c3800, 0x09e4f580, 0x000f4240, 0x4d5ab5f8, 0x462e485a, 0x460c9000, 0x46084637,
    0xfb8bf002, 0xd0042800, 0x6ee06e26, 0x6e679000, 0x6d206ea5, 0x6d602800, 0x2800d027, 0x4951d004,
    0x63c82006, 0x62c64850, 0x28006d20, 0x494dd006, 0x31402001, 0x484c62c8, 0x61c63040, 0x23114949,
    0x630b3140, 0x30404848, 0x22016207, 0x6245634a, 0x6285638a, 0x62c563ca, 0x31804942, 0x6305600a,
    0x5d002045, 0xd0032808, 0x2800e00f, 0xe024d1d7, 0x2001493c, 0x62083140, 0x32404a3b, 0x61c86115,
    0x618860d5, 0x61486095, 0x7b206055, 0xd0012803, 0xd1062801, 0x30404833, 0x49336283, 0x31409800,
    0x46206188, 0xfb40f002, 0xd0062800, 0x2101482d, 0x62413040, 0x3040482c, 0x6da06147, 0x6de02800,
    0x2800d02a, 0x4927d005, 0x31402006, 0x48266008, 0x6da06306, 0xd0052800, 0x21044822, 0x62413040,
    0x63c64821, 0x2111481f, 0x62413040, 0x3140491e, 0x2201614f, 0x610d6202, 0x60cd61c2, 0x608d6182,
    0x604d6142, 0x2a037b22, 0x2a01d001, 0x2214d103, 0x98006102, 0xbdf86008, 0xd1d42800, 0x2104bdf8,
    0xd00f2800, 0x29037b01, 0x6c01d10b, 0x06493060, 0xda012900, 0xe003210f, 0x29007e41, 0x211ed101,
    0x21007601, 0x47704608, 0x62884908, 0x47702000, 0x6a894906, 0x20006001, 0x00004770, 0x000010f1,
    0x000130f1, 0x401f8180, 0x401f8380, 0x400f8000, 0x4605b5f0, 0xb08548f7, 0xc80f4478, 0xc40f466c,
    0x01284ef5, 0x59f00d07, 0x0ed206ea, 0x40912101, 0xd00a4008, 0x040059f0, 0xd0080f80, 0x46042000,
    0x03c059f0, 0xd0050fc0, 0xb0054620, 0xf000bdf0, 0xe7f4fc44, 0x48e849e9, 0x1a6a4fe7, 0x37803040,
    0xd036428d, 0x2d0ddc18, 0x49e5d023, 0xd0291869, 0x05122201, 0xd0761a89, 0xd1184291, 0x46076901,
    0xf0034620, 0x6a3afae1, 0xf0032300, 0x6b31f90b, 0xd01307c9, 0xe0122116, 0x05002003, 0x1a104dd9,
    0x2101d048, 0x1a400589, 0x2808d073, 0x2000d078, 0x6830e7cb, 0x0e400640, 0xe0394360, 0x434c2114,
    0xe7c21820, 0xe06e6930, 0xe0002016, 0x43602014, 0x4605e7bb, 0x68396b00, 0x0e760646, 0xf0034620,
    0x693afab3, 0xf0032300, 0x4374f8dd, 0x18206b29, 0x04d22203, 0xd0064011, 0x04d22201, 0xd0041a89,
    0xd1444291, 0x0880e002, 0x0840e000, 0x318049bd, 0x4abd6b09, 0xd0984011, 0x03d22201, 0xd0071a89,
    0x03db23ff, 0xd0901ac9, 0xd1304291, 0xe78c0880, 0xe78a0840, 0x6b396a38, 0x0e760646, 0xf0034620,
    0x682afa83, 0xf0032300, 0x4374f8ad, 0x18206a39, 0x04d22203, 0xd0074011, 0x04d22201, 0xd0051a89,
    0xd1144291, 0xe01de003, 0xe0000880, 0x49a50840, 0x6b093180, 0x0f892201, 0x07d20789, 0xd0971889,
    0x18891052, 0x1889d0d2, 0x42d1d092, 0xf003d0d0, 0x6a28f90a, 0x07804669, 0x58080f00, 0xe7ffe755,
    0xe752489a, 0x07806a30, 0xe78dd590, 0x4604b510, 0xf7ff4897, 0x4993ff2d, 0x2c003140, 0x2c01d009,
    0x2c02d009, 0x2c03d00e, 0x2000d00f, 0x43482112, 0x6809bd10, 0x6809e001, 0x06890a09, 0xf0030e89,
    0xe7f3f939, 0x0c096809, 0x6809e7f7, 0xe7f40e09, 0x4c88b510, 0x01816960, 0x69a14885, 0x1202d514,
    0xd0094011, 0x03122201, 0xd00a1a89, 0xd0054291, 0x69612000, 0xe0170ec9, 0x42404879, 0xfef8f7ff,
    0xf000e7f7, 0xe7f4fb5a, 0x04922203, 0xd0134011, 0x04922201, 0xd0121a88, 0xd0111a80, 0xd1094290,
    0xf7ff200d, 0x6921fee5, 0x0f490749, 0xf0031c49, 0xbd10f901, 0xbd102000, 0xfedaf7ff, 0x2002bd10,
    0xffa4f7ff, 0xb510bd10, 0xd0012800, 0xf89bf003, 0x48642101, 0x30800789, 0x49676181, 0x03d26b0a,
    0x2201d5fc, 0x61420412, 0x04096901, 0x6182d5fc, 0x2001bd10, 0x0780495b, 0x61483180, 0x22104770,
    0x2800495d, 0x638ad001, 0x634a4770, 0x485a4770, 0x22016b01, 0x63014311, 0x48574770, 0x08496b01,
    0x63010049, 0xb5104770, 0xff92f7ff, 0x69494951, 0x0f4904c9, 0xf0031c49, 0xbd10f8bd, 0x4604b510,
    0x42404847, 0xfe94f7ff, 0x2c004946, 0x2c01d009, 0x2c02d009, 0x2c03d00e, 0x2000d00f, 0x43482112,
    0x6b09bd10, 0x6b09e001, 0x06890a09, 0xf0030e89, 0xe7f3f8a1, 0x0c096b09, 0x6b09e7f7, 0xe7f40e09,
    0x4c3cb510, 0x06406960, 0x6960d50a, 0xd5030600, 0xf7ff2001, 0xe005ffd3, 0xf7ff2002, 0xe001ff37,
    0xff56f7ff, 0x03496961, 0x1c490f49, 0xf882f003, 0xb510bd10, 0xffb7f7ff, 0x6949492e, 0x0f890589,
    0xf0031c49, 0xbd10f877, 0x4c2ab510, 0x064069e0, 0xf000d502, 0xe001fab2, 0xffebf7ff, 0x068969e1,
    0x1c490e89, 0xf866f003, 0xb510bd10, 0xf0030003, 0x0d17f973, 0x1613100d, 0x211f1c19, 0x2a282624,
    0x4b49472e, 0x55534f4d, 0x005e5a58, 0xff8bf7ff, 0xf7ffbd10, 0xbd10ffb5, 0xffcbf7ff, 0xf7ffbd10,
    0xbd10ffd3, 0xfa89f000, 0x2001bd10, 0xbd1003c0, 0xe039200d, 0x4240480a, 0x2000e036, 0x2001e004,
    0x2002e002, 0x2003e000, 0xff78f7ff, 0x480bbd10, 0x0000e02a, 0x000036a0, 0x400d8000, 0x0070000d,
    0xffeffff3, 0x400d80c0, 0x00808000, 0x017d7840, 0x0030000d, 0x400fc000, 0x400d8240, 0x0020000d,
    0xe01148fd, 0xe0042000, 0xe0022001, 0xe0002002, 0xf7ff2003, 0xbd10febb, 0xe00548f8, 0x300848f7,
    0x48f7e002, 0x48f7e000, 0xfde2f7ff, 0x2000bd10, 0x48f5bd10, 0x22036801, 0x60014311, 0x680148f3,
    0x43112202, 0x49f26001, 0xbf002000, 0x42881c40, 0x48f0d3fb, 0x221f6a01, 0x43910212, 0x43114aee,
    0x20016201, 0x49e84770, 0x680a2000, 0x431a2303, 0x49ea600a, 0x2302680a, 0x600a431a, 0xbf0049e4,
    0x42881c40, 0x49e3d3fb, 0x221f6a08, 0x43900212, 0x43104ae1, 0x20016208, 0xb5104770, 0x690a49e0,
    0x039b2303, 0x7843439a, 0x0c1b079b, 0x2301431a, 0x431a041b, 0x690a610a, 0x24027800, 0x43a207c0,
    0x43020f80, 0x018020c1, 0x610a4302, 0x28006908, 0x6908dafc, 0x61084398, 0xb518bd10, 0x48d02400,
    0x69019400, 0xd5040489, 0x22406901, 0x61014311, 0x4668e002, 0xffd1f7ff, 0x6b0148ca, 0x08490049,
    0x6b016301, 0x43910482, 0x60046301, 0x22636b01, 0x43110392, 0x20016301, 0x48c1bd18, 0x22406901,
    0x61014391, 0x6b0148bf, 0x43110482, 0x47706301, 0x49bbb510, 0x2303680a, 0x439a039b, 0x079b7903,
    0x431a0c1b, 0x041b2301, 0x600a431a, 0x7800680a, 0x06404cb5, 0x0e404022, 0x10d84302, 0x600a4302,
    0x28006808, 0x6808dafc, 0x60084398, 0x2001bd10, 0x030049ab, 0x47706008, 0x49a9b530, 0x23036b0a,
    0x439a039b, 0x079b7b03, 0x431a0c1b, 0x041b2301, 0x630a431a, 0x4ca46b0a, 0x4022347e, 0x07e47804,
    0x43220fe4, 0x432210dc, 0x6842630a, 0x4a9c0094, 0x324008a4, 0x68846114, 0x08a400a4, 0x8a446214,
    0x04647c05, 0x0c6407ed, 0x89c00c2d, 0x0400432c, 0x60144304, 0x28006b08, 0x6b08dafc, 0x63084398,
    0x2001bd30, 0x0300498e, 0x47706308, 0x2000498c, 0x47706108, 0x498ab510, 0x23036a0a, 0x439a039b,
    0x079b7843, 0x431a0c1b, 0x041b2301, 0x620a431a, 0x78006a0a, 0x07c02402, 0x0f8043a2, 0x20c14302,
    0x43020180, 0x6a08620a, 0xdafc2800, 0x43986a08, 0xbd106208, 0x2000497a, 0x47706208, 0x4b78b5f0,
    0x33402200, 0x24036b19, 0x43a103a4, 0x07a47b04, 0x43210c24, 0x04242401, 0x63194321, 0x008d6841,
    0x08ad496c, 0x600d3980, 0x00ad6885, 0x610d08ad, 0x4d6d6b19, 0x402900e6, 0x78407805, 0x0e6d066d,
    0x10e54329, 0x28024329, 0x4d68d01e, 0x28040127, 0x2808d018, 0x2810d014, 0x4339d010, 0x35404d5d,
    0x4e626b28, 0x403043f6, 0x63284310, 0x6b186319, 0xdafc2800, 0x43a06b18, 0xbdf06318, 0xe7ed462a,
    0xe7fb4331, 0xe7f94339, 0xe7e74331, 0x49542001, 0x31400300, 0x47706308, 0x4b4eb5f0, 0x3b802200,
    0x24036a19, 0x43a103a4, 0x07a47b04, 0x43210c24, 0x04242401, 0x62194321, 0x00896841, 0x63190889,
    0x4d446881, 0x08890089, 0x60293d40, 0x4d466a19, 0x402900e6, 0x78407805, 0x0e6d066d, 0x10e54329,
    0x28024329, 0x2503d01e, 0x012707ad, 0xd0172804, 0xd0132808, 0xd00f2810, 0x48364339, 0x6b053040,
    0x08ad00ad, 0x63054315, 0x6a186219, 0xdafc2800, 0x43a06a18, 0xbdf06218, 0xe7ee462a, 0xe7fb4331,
    0xe7f94339, 0xe7e84331, 0x492a2001, 0x39800300, 0x47706208, 0x7881b510, 0x07894a26, 0x3a400f89,
    0x23036a14, 0x439c039b, 0x079b78c3, 0x431c0c1b, 0x041b2301, 0x6214431c, 0x2c007804, 0x10dcd001,
    0x78404321, 0xd0022800, 0x05402001, 0x6a104301, 0x347c4c1d, 0x43084020, 0x6a106210, 0xdafc2800,
    0x43986a10, 0xbd106210, 0x49122001, 0x39400300, 0x47706208, 0x4b0fb510, 0x00c0681a, 0x408424bf,
    0x248043a2, 0x43144084, 0x0689601c, 0x40810e89, 0x60194311, 0x0000bd10, 0x0030000d, 0x00e0000d,
    0x0070000d, 0x00a0000d, 0x400fc080, 0x402e0140, 0x00061a80, 0x400d8100, 0x00001701, 0x402e0340,
    0x400d8000, 0x400d9000, 0xffffef80, 0x00808000, 0x680a4927, 0x208000c3, 0x43024098, 0x4770600a,
    0xb5104b23, 0x6b1a3b40, 0x24bf00c0, 0x43a24084, 0x40842480, 0x631c4314, 0x0e890689, 0x43114081,
    0xe7c76319, 0x3940491a, 0x00c36b0a, 0x40982080, 0x630a4302, 0xb5184770, 0x46682400, 0xf7ff9400,
    0x4814feb9, 0x00496b01, 0x63010849, 0x04426b01, 0x63014391, 0x6b016004, 0x03922263, 0x63014311,
    0xbd182001, 0x6a01480c, 0x43912240, 0x48096201, 0x04426b01, 0x63014311, 0x48084770, 0x06c06b00,
    0x4807d501, 0x48074770, 0x68004448, 0x00004770, 0x400d8100, 0x400da000, 0x400d8000, 0x400d8240,
    0x016e3600, 0x00000004, 0x460cb570, 0xf0024606, 0x0005fa35, 0x4622d10b, 0x32802301, 0x46302100,
    0xf8e6f002, 0x28017c60, 0x2000d101, 0x46287420, 0xb570bd70, 0x4605b08a, 0x466e2000, 0x200f7030,
    0x90022401, 0x74329403, 0x32ff460a, 0x32719301, 0x46214623, 0xf0024628, 0x4669f8cb, 0x94024628,
    0xffd5f001, 0xbd70b00a, 0x2004b5ff, 0x460db083, 0xd0292900, 0x36ff462e, 0x7b7036c1, 0xd0062800,
    0x9a059b06, 0xf7ff9803, 0x2800ffd4, 0x7b30d11c, 0x3480462c, 0xd10a2802, 0x30304620, 0x466bc887,
    0x4620c307, 0xc80f3040, 0xc40f3430, 0x46293c40, 0x9a059b06, 0xf0029803, 0x7b31f8cb, 0xd1032902,
    0xcd0e466d, 0xc48e3430, 0xbdf0b007, 0xb089b5ff, 0x4616461d, 0x9809460c, 0xffc6f7ff, 0xd1142800,
    0x70084669, 0x200e2701, 0x90029703, 0x4622740e, 0x326132ff, 0x4639463b, 0x98099501, 0xf878f002,
    0x97024669, 0xf0019809, 0xb00dff82, 0xb5ffbdf0, 0xb0832004, 0x4696469c, 0xd0d52900, 0x35ff460d,
    0x7b2835c1, 0x3480460c, 0xd10b2802, 0x30104620, 0x466ac889, 0xc28969e6, 0x30204620, 0x3410c88d,
    0x3c20c48d, 0x46724663, 0xf0029803, 0x7b29f8ae, 0xd1b92902, 0xcd0e466d, 0xc44e3410, 0xb5f7e7b4,
    0x4616b082, 0xd051000d, 0xd84f2e01, 0x34ff462c, 0x7a2034c1, 0xd0002800, 0x28002001, 0x6c28d046,
    0x0fc70640, 0xf0029802, 0x2e00fa62, 0x7a20d02b, 0xd0092800, 0x5d412046, 0x9802463a, 0xf919f7ff,
    0x98024629, 0xfdaaf001, 0x28007ba0, 0x2100d003, 0xf0029802, 0x466afa5e, 0x98022102, 0xf959f7ff,
    0xd0022f00, 0x08409800, 0xaa019000, 0x98022100, 0xf94ff7ff, 0x98019900, 0xfcbcf002, 0x1c40210a,
    0x08804348, 0x7a21e010, 0xd0072900, 0x9802463a, 0xf8eff7ff, 0x98024629, 0xfd80f001, 0x28007ba0,
    0x2101d0d9, 0xbf00e7d4, 0xd2fc1e40, 0xbdf0b005, 0xb089b5ff, 0x460d4617, 0xf0014608, 0x4606fd47,
    0x46292200, 0xf7ff9809, 0x463bff9a, 0x46294632, 0xf7ff9809, 0x0004ff19, 0x2002d13f, 0x70084669,
    0x24012009, 0x94039002, 0x5d412047, 0x30ff4628, 0x29003081, 0x7c01d006, 0xd0032900, 0x91027c41,
    0x91037c01, 0x97014669, 0x990c740e, 0x6c009105, 0x98029006, 0x01002101, 0x32801942, 0x98099b03,
    0xffb6f001, 0x94024669, 0xf0019809, 0x0004fec0, 0x463bd113, 0x46294632, 0xf7ff9809, 0x0004ff38,
    0x20ffd10b, 0x5d4030d0, 0xd0062800, 0x4632463b, 0x98094629, 0xff0af7ff, 0x98094604, 0xf9d1f002,
    0x46292201, 0xf7ff9809, 0x4620ff4a, 0xb5f3e71d, 0x2600b08b, 0x9d0c4669, 0x2101700e, 0x210b9103,
    0x46699102, 0x2047740e, 0x46375d40, 0x28004634, 0x4628d009, 0x308130ff, 0x29007d01, 0x7d41d003,
    0x7d009102, 0x22009003, 0x980b990c, 0xff27f7ff, 0x950a3550, 0x9009cd01, 0xd01a2800, 0x22004633,
    0x980b990c, 0xfea0f7ff, 0xd13e0004, 0x96019802, 0x980c0101, 0x180a9b03, 0x32802101, 0xf001980b,
    0x2001ff57, 0x46699002, 0xf001980b, 0x0004fe60, 0x9809d12b, 0x18361c7f, 0xd3db2f04, 0xd1242c00,
    0x90092000, 0x980c4606, 0x30ff9d0a, 0x900a30c1, 0x2f00cd80, 0x2200d013, 0x990c9b09, 0xf7ff980b,
    0x0004fec6, 0x980ad111, 0x28007bc0, 0x2200d007, 0x990c9b09, 0xf7ff980b, 0x0004fe99, 0x9809d105,
    0x19c01c76, 0x2e049009, 0x980bd3e2, 0xf959f002, 0x990c2201, 0xf7ff980b, 0x4620fed2, 0xb5f7e6a5,
    0x4617b08a, 0x4608460d, 0xfc70f001, 0x22004606, 0x980a4629, 0xfec3f7ff, 0x4632463b, 0x980a4629,
    0xfe42f7ff, 0xd1390004, 0x97014669, 0x20057008, 0x90022401, 0x740e9403, 0x5d402047, 0xd0092800,
    0x30ff4628, 0x7b013081, 0xd0032900, 0x91027b41, 0x90037b00, 0x21019802, 0x19420100, 0x9b033280,
    0xf001980a, 0x4669fee5, 0x980a9402, 0xfdeff001, 0xd1130004, 0x4632463b, 0x980a4629, 0xfe67f7ff,
    0xd10b0004, 0x30d020ff, 0x28005d40, 0x463bd006, 0x46294632, 0xf7ff980a, 0x4604fe39, 0xf002980a,
    0x2201f900, 0x980a4629, 0xfe79f7ff, 0xe64c4620, 0xb08ab5f7, 0x460d4617, 0xf0014608, 0x4606fc17,
    0x46292200, 0xf7ff980a, 0x463bfe6a, 0x46294632, 0xf7ff980a, 0x0004fde9, 0x4669d139, 0x70089701,
    0x24012008, 0x94039002, 0x2047740e, 0x28005d40, 0x4628d009, 0x308130ff, 0x29007f01, 0x7f41d003,
    0x7f009102, 0x98029003, 0x01002101, 0x32801942, 0x980a9b03, 0xfe8cf001, 0x94024669, 0xf001980a,
    0x0004fd96, 0x463bd113, 0x46294632, 0xf7ff980a, 0x0004fe0e, 0x20ffd10b, 0x5d4030d0, 0xd0062800,
    0x4632463b, 0x980a4629, 0xfde0f7ff, 0x980a4604, 0xf8a7f002, 0x46292201, 0xf7ff980a, 0x4620fe20,
    0xb5f0e5f3, 0x20044607, 0x461db089, 0x460e4614, 0xd00f2a00, 0x46682124, 0xfb0af002, 0x46692003,
    0x20017008, 0x95089002, 0x96019003, 0x46389407, 0xfd5df001, 0xbdf0b009, 0xb08fb5ff, 0x460c2000,
    0x900b900a, 0x900d900c, 0x25016811, 0x2905461e, 0x6851d202, 0xd3152940, 0x6c117425, 0x0f490249,
    0xf002000b, 0x0d07fbf9, 0x050b0905, 0x000d0705, 0xe00b2702, 0xe0092704, 0xe0072701, 0xe0052703,
    0xe03f7420, 0x05098831, 0xd03b0f0f, 0x90002000, 0x90024669, 0x20037508, 0x95097108, 0x95049503,
    0x2f019108, 0x2f02d007, 0x2f03d003, 0x2f04d02d, 0x48fdd104, 0x48fce001, 0x900a3830, 0xaa0a2301,
    0x980f4619, 0xfe04f001, 0x980fa901, 0xfd0ff001, 0xd1182800, 0x01006830, 0xd0050f00, 0x040088b0,
    0xd0010e01, 0x90000e00, 0x46202100, 0x74213080, 0xd00d2f01, 0x2f022202, 0x2f03d013, 0x2f04d029,
    0x7421d01f, 0xb0132000, 0x48e7bdf0, 0xe7d4300a, 0x064a9900, 0x4ae5d4f6, 0x20c36402, 0x20404001,
    0x9900e01e, 0xd4ed078b, 0x43114be1, 0x02086403, 0x74259000, 0x20047525, 0x98007560, 0x746561a0,
    0x9900e7e0, 0xd4dd078b, 0x33304bd8, 0x64034311, 0x9900e007, 0xd4d5060a, 0x323d4ad5, 0x20806402,
    0x91004301, 0xb5f7e7e5, 0x02402001, 0x2700b098, 0x46689001, 0x24017407, 0x9702460d, 0x29009403,
    0x48ccd072, 0xc84d4478, 0xc14da90d, 0x466a2003, 0xa8097010, 0x20109007, 0x462a9008, 0x21013280,
    0x98189b03, 0xfd94f001, 0x94024669, 0xf0019818, 0x2800fc9e, 0x9809d158, 0xd1081c40, 0x1c40980a,
    0x980bd105, 0xd1021c40, 0x1c40980c, 0x2210d007, 0xa80da909, 0xf9e1f002, 0xd1452800, 0x2300e034,
    0x4629461a, 0xf7ff9818, 0x2800fcaf, 0x2009d17b, 0x20029002, 0x70084669, 0x462aa80d, 0x90052610,
    0x960632ff, 0x21013211, 0x98189b03, 0xfd60f001, 0x94024669, 0xf0019818, 0x2800fc6a, 0x2300d163,
    0x4629461a, 0xf0019818, 0x2800fdb0, 0x9002d15b, 0x46692003, 0xa8097008, 0x96089007, 0xf0019818,
    0x2800fc56, 0xe7c2d14f, 0x90162032, 0x90152000, 0x21406c28, 0x64284308, 0x5d412046, 0x22012602,
    0xf7fe9818, 0xe038fe26, 0x2400e03d, 0x94129411, 0x94149413, 0x6d282101, 0x42880609, 0x488ed901,
    0x488ee000, 0x498e9011, 0x1840b2f0, 0x2301498d, 0x90124308, 0x2100aa11, 0xf0019818, 0x2003fd19,
    0x94024669, 0xa8097008, 0x20109007, 0x98189008, 0xfc1df001, 0xd0060004, 0xd0142f00, 0x2f00981a,
    0xd0106006, 0x2210e010, 0xa80da909, 0xf965f002, 0xd00c2800, 0x2f001c76, 0x9815d1f0, 0x1c409916,
    0x42889015, 0x4c78d3c1, 0xb01b4620, 0x2701bdf0, 0xb5ffe7e4, 0xb0824608, 0x9000305c, 0x68c8460b,
    0x27013308, 0xda032800, 0x1ec0463a, 0xe0014082, 0x08c21c40, 0x24ff9802, 0x9e026502, 0x68489201,
    0x340136ff, 0x28403681, 0x6434d201, 0x8d18e00a, 0x0f020600, 0x40904638, 0x03d22201, 0xd1004290,
    0x64304620, 0x24004d61, 0x00424620, 0x7f1718d2, 0xd00d2f00, 0x40ba2201, 0xd20142aa, 0x46844615,
    0xd90542a2, 0x053f2701, 0xd20142ba, 0x46864614, 0x28041c40, 0x6475d3e9, 0x98026534, 0x30c130ff,
    0xd10142a5, 0xe0002201, 0x72422200, 0x98012201, 0x42900612, 0x3140d92d, 0x28007e08, 0x9800d008,
    0x79014460, 0x60019804, 0x44709800, 0xe0187901, 0x00404660, 0x7f4018c0, 0x22dc2121, 0xd0022820,
    0xd10528d8, 0x9804e002, 0xe0016001, 0x60029804, 0x00404670, 0x7f4018c0, 0xd0022820, 0xd10528d8,
    0x9805e002, 0xe0016001, 0x60029805, 0xb0062000, 0x4660bdf0, 0x18c00040, 0x98047f41, 0x46706001,
    0x18c00040, 0xe7ec7f41, 0xb08db5ff, 0x90052004, 0x460f980f, 0x90033008, 0x305c980f, 0x20009009,
    0x98109004, 0x02006800, 0x28010f00, 0x9803d105, 0x03006800, 0x90040fc0, 0x2000d071, 0x99107338,
    0x78094606, 0x070aab0b, 0x21460f12, 0x900055ca, 0x90062018, 0x90072000, 0x4638aa0a, 0xf7ff990f,
    0x2101ff48, 0x06096d38, 0xd9014288, 0x90062020, 0x88009810, 0x0f000400, 0x4639d151, 0x9a0f9b10,
    0xf7ff980d, 0x9005fdd9, 0xd1f52800, 0x68009803, 0xd51d0281, 0x90072002, 0x7a009803, 0x0f4e0601,
    0x0ec006c0, 0x0000e01c, 0x24010435, 0x20010401, 0x20020401, 0x00002724, 0x8a2004ee, 0x8a1804ed,
    0x00040200, 0xa604b000, 0x00004e2a, 0x00ffffff, 0xd5060240, 0x68809803, 0x0f4e0201, 0x0ec002c0,
    0x980f9000, 0x30409a06, 0x49fc1dfc, 0x900834f9, 0xd0022a20, 0x612048fa, 0x7e00e012, 0x28004bf9,
    0x9809d03b, 0x68004af8, 0xd50105c5, 0xe00348f7, 0xd5320600, 0x302248f3, 0x61206162, 0xe0a9e001,
    0x20016161, 0x463d7338, 0x358048f1, 0x48f16328, 0x980a6128, 0xb2c14af0, 0x04009806, 0x43114301,
    0x65299001, 0xb2c9990b, 0x43114301, 0x01402023, 0x63206021, 0x68009810, 0x0f010100, 0x9910d00f,
    0x060a6849, 0xd00a0e12, 0x9904b2c8, 0x90002600, 0xd0212900, 0x90000040, 0x6123e01e, 0x9904e7d0,
    0xd0192900, 0xd1170f00, 0x28209806, 0x48d5d104, 0x60281c40, 0x606848d9, 0x980d4639, 0xfaa4f7ff,
    0x28009005, 0x466ad166, 0x980d4639, 0xfddbf7ff, 0x28009005, 0x2600d1f6, 0x28189806, 0x2002d006,
    0x98049007, 0xd0202800, 0xe00320ee, 0x28009804, 0x20edd00a, 0x22406c39, 0x64394311, 0x43019901,
    0x430148c7, 0xe0376029, 0x68009803, 0xd5030281, 0x89009803, 0xe0030400, 0xd5040240, 0x68809803,
    0x90020e00, 0x2003e01f, 0x9808e019, 0x28007e00, 0x9809d00a, 0x06816800, 0x06c0d40a, 0x206cd513,
    0x20009002, 0xe00e9007, 0x68009803, 0xd5010281, 0xe7e620ec, 0xd5010240, 0xe7e2206c, 0x90022013,
    0x46062000, 0x99029000, 0x43089801, 0x06099907, 0x49a94308, 0x60284308, 0x463a9910, 0x32ff7809,
    0x32c10609, 0x0f0b2000, 0x2b009201, 0x0f09d003, 0xd0042901, 0x9800e06b, 0x90001980, 0x990fe049,
    0x29406849, 0x9903d3f7, 0x058a6b89, 0x0309d5f3, 0x22050f09, 0xd0014211, 0xe00b20a5, 0xd5090789,
    0x9b104639, 0x980d9a0f, 0xffa1f000, 0x28009005, 0x2001d14d, 0x220a9903, 0x04098f09, 0x42110e89,
    0x4990d007, 0x67616721, 0x29209906, 0x498ed109, 0x2211e006, 0xd03a4211, 0x6721498c, 0x498c6761,
    0x210167a1, 0x2e009a01, 0xd0117351, 0x29009904, 0x2e01d033, 0x2127d02e, 0x43080289, 0x06099900,
    0x43080a09, 0x43084983, 0x48836068, 0xe01760a8, 0x28009800, 0x9a04d00f, 0x2a004980, 0xb2c0d005,
    0x497f1840, 0x60684308, 0xb2c0e00a, 0x497d1840, 0x60684308, 0x487ce00b, 0x98046068, 0xd0062800,
    0x20019901, 0x6c387388, 0x43082140, 0x98056438, 0xbdf0b011, 0x09002126, 0x2e01e7ce, 0x2107d00c,
    0x43080289, 0x06099900, 0x43080a09, 0x4308496f, 0x486f6068, 0xe7ea60a8, 0x09002106, 0xb5f7e7f0,
    0xb0984e6c, 0xd008000d, 0x466a2308, 0x98182100, 0xfc37f7ff, 0xd1640004, 0x2404e001, 0x4966e061,
    0x42889800, 0x4634d001, 0x4668e05b, 0x60287900, 0x79804668, 0x280a1c40, 0x200ad900, 0x981a9016,
    0x28002108, 0x0209d000, 0xaa029816, 0x981800c3, 0xfc17f7ff, 0xd1440004, 0x46282164, 0xff28f001,
    0xe03b2600, 0xaa0200f0, 0x18835c11, 0x020079d8, 0x20ff180a, 0x42820200, 0x4850d002, 0xd12c4282,
    0x20022100, 0x1819020f, 0x43397909, 0xd5f91e40, 0x008778d8, 0x2800981a, 0x0209d000, 0x020020ff,
    0xd10c4282, 0xd9002f50, 0x462a2750, 0x3208463b, 0xf7ff9818, 0x0004fbe6, 0x606fd113, 0x483fe00d,
    0xd10a4282, 0x463b462a, 0x9818325c, 0xfbd9f7ff, 0xd1060004, 0x20582101, 0x1c765541, 0x42869816,
    0x4620d3c0, 0xb5f7e541, 0xb088460d, 0x46282103, 0x230873e9, 0x71433040, 0x642b2358, 0x73292401,
    0xd0012a00, 0x64292159, 0x210f71c4, 0x87c48781, 0x2001462e, 0x024036ff, 0x64303681, 0x64700240,
    0x46306530, 0x90073040, 0x46297244, 0xf7ff9808, 0x2800f91b, 0x4822d172, 0x90002700, 0x97034821,
    0x90012301, 0x466a9702, 0x98084619, 0xfa00f001, 0x97039702, 0x481c4f1a, 0xe0373780, 0x00002004,
    0x08180402, 0x08200412, 0x00002204, 0x0a20043e, 0x00000406, 0x24040405, 0x08000400, 0x00012404,
    0x8a000400, 0x06ff06ff, 0x000006ff, 0x06000600, 0x32101e00, 0xb2000200, 0x7c01a604, 0x00040200,
    0xa604b000, 0x26043000, 0x00002404, 0x32000200, 0x7c012604, 0x00004e27, 0x50444653, 0x0000ff84,
    0x8b188720, 0xa3028f10, 0xa7048f10, 0x23019001, 0x2100466a, 0x98089700, 0xf9baf001, 0x02c02013,
    0x23029006, 0x49feaa06, 0xf0009808, 0x2800fefc, 0x2308d114, 0x2110aa04, 0xf0009808, 0x2800fee0,
    0x9805d10c, 0xb28049f7, 0x98049005, 0xd1044288, 0x98052159, 0x42880209, 0x48f3d002, 0xbdf0b00b,
    0xaa042308, 0x98082127, 0xfec9f000, 0xd1f52800, 0x04009804, 0x90040e00, 0x28093817, 0x9904d8ed,
    0x40882001, 0x200f6528, 0x90060300, 0xaa062302, 0x98082100, 0xfec7f000, 0xd1df2800, 0x49e3462c,
    0x60213480, 0x606149e2, 0x60a149e2, 0x4ae349e2, 0x4fe44be3, 0xc48e3410, 0x60274fdc, 0x60674fe2,
    0x60a74fdc, 0xc40e3410, 0x60a74fe0, 0x60616022, 0x60e74fdf, 0x61274fdd, 0x4fde35ff, 0xc58e3511,
    0x34144fd2, 0x602f3fa0, 0x606f4fdb, 0xc48e4fdb, 0x4fd6c40e, 0x602260a7, 0x4fd56061, 0x4fd360e7,
    0x4cca6127, 0x3ca03d20, 0x4cd5602c, 0x4cd5606c, 0x462f60ac, 0x37304cd1, 0xc70ec71e, 0x656c4ccb,
    0x652964ea, 0x65ac4cca, 0x37144cc8, 0xc70e65ec, 0x66e949cd, 0x72312102, 0x72722203, 0x22017131,
    0x74317172, 0x74712109, 0x73312104, 0x73732305, 0x210b7531, 0x99077571, 0xe77f730a, 0x2504b5f7,
    0x4617b092, 0x2a00460c, 0x7878d004, 0x42887839, 0x2500d101, 0x4620e087, 0x21083040, 0x71419011,
    0x25037878, 0x28422601, 0x2841d001, 0x2502d103, 0x21049811, 0x78787141, 0xd0012882, 0xd1002842,
    0x20002621, 0x90014669, 0x70087408, 0x90022001, 0xa8092120, 0xfd9cf001, 0x200278f9, 0x29060242,
    0x2907d00b, 0x2908d012, 0x2001d001, 0x0229e02b, 0x43131d8b, 0x930931ff, 0x0229e005, 0x3366460b,
    0x31994313, 0x43119309, 0xe01c910d, 0x460f0229, 0x376602b2, 0x4317062b, 0x431f06b5, 0x432f46ac,
    0x31992599, 0x4311042d, 0x4319432f, 0x22334665, 0x04524329, 0x97094311, 0x2e21910d, 0x6c21d103,
    0x43112240, 0x90036421, 0x20019911, 0x06017188, 0x498e6521, 0x498e6021, 0x21036061, 0x73a17361,
    0x31c921ff, 0x200a5508, 0x46216760, 0xf7fe9812, 0x0005ffab, 0xaa09d117, 0x9b032101, 0xf0019812,
    0x4669f897, 0xf0009812, 0x4605ffa2, 0x217d4881, 0x00c94448, 0xf0016800, 0xe001fd3d, 0x1e40bf00,
    0x28009011, 0x4628d1fa, 0xbdf0b015, 0xb09cb5f7, 0x460c981e, 0x02286805, 0x28050f00, 0x2700d011,
    0x22304975, 0xa80d4479, 0xf82af7fe, 0x0f000428, 0x0328900a, 0x980a0f05, 0xd0042800, 0xd1132803,
    0x2701e001, 0x2d00e7ec, 0x2d03d010, 0x2800d10c, 0x2003d00a, 0x20107320, 0x981e6420, 0x02006800,
    0x28040f00, 0xe019d018, 0xe1952604, 0xf7fe4668, 0x4606facf, 0xf7fe2000, 0x2e00fac7, 0x466ad106,
    0x981c4621, 0xff2af7ff, 0xd1ee0006, 0x73202000, 0x64202010, 0xe0022003, 0x64202050, 0x90092006,
    0x4328980a, 0x2701d100, 0x990a4620, 0x29033040, 0x2101d008, 0x46217141, 0xf7fe981c, 0x0006ff35,
    0xe001d1d3, 0xe7f52108, 0x2d002000, 0x2f00d004, 0x2001d001, 0x2002e000, 0xa90d0100, 0x23011842,
    0x981c4619, 0xf814f001, 0x46692000, 0x75089002, 0x71082003, 0x90032001, 0xa80b9004, 0xa9019008,
    0xf000981c, 0x0006ff14, 0xa808d1af, 0x28c27b00, 0x2101d1ab, 0x2d000409, 0xd01da808, 0x460a7c40,
    0x40823830, 0x46206522, 0x30ff2201, 0x30810312, 0x11126442, 0x65016402, 0x73202003, 0x64202010,
    0x40472001, 0x46294620, 0x30c130ff, 0x35804625, 0x29009019, 0xe078d002, 0xe7e07b80, 0x2803980a,
    0x2101d173, 0x20027421, 0x82617460, 0x75622206, 0x23007521, 0x22074669, 0x70ca700b, 0xd04a2f00,
    0x466a2182, 0x61a07051, 0x6628481c, 0x3872481b, 0x481b6668, 0x981e66a8, 0x06007800, 0xe0310f00,
    0x00000555, 0x52005100, 0x00004e29, 0x8b1887a0, 0xb3068f10, 0x0000a704, 0x87008700, 0x87aa8700,
    0x87058700, 0x87708700, 0xb70b8f10, 0x87558700, 0x87028700, 0x87a08700, 0xa3808f10, 0x87808700,
    0x87008f10, 0x00008730, 0x87108700, 0x42464346, 0x56010400, 0x0000000c, 0x00001d04, 0x04000472,
    0x20010400, 0xd0022803, 0x728b9919, 0x9919e01a, 0x72882001, 0x2181e016, 0x7059466b, 0x4bfe61a0,
    0x662b48fe, 0x48fe6668, 0x210166a8, 0x77214620, 0x70423020, 0x48f87001, 0x38726321, 0x6768672b,
    0x67a848f7, 0xf7fe9800, 0x48f6f9df, 0x48f66328, 0x1de06128, 0x30f9990a, 0xd0032900, 0xd0162f00,
    0xe0152321, 0x73212101, 0x602949f0, 0x606949f0, 0x1d8949ee, 0x49ef6101, 0x49ec6141, 0x65293115,
    0x31d049ea, 0x21236001, 0x63010149, 0x2301e084, 0xd0012f00, 0xe0002122, 0x468e2102, 0xd0012f00,
    0xe000212c, 0x911a210c, 0xd0012f00, 0xe0002129, 0x910a2109, 0xd0012f00, 0xe0002128, 0x91002108,
    0x4ad80299, 0x3a18069b, 0x469c188a, 0x4bda431a, 0x602a431a, 0x23194672, 0x015b0292, 0x9b1a18d2,
    0x069b4696, 0x4bd5431a, 0x606b4313, 0x029a9b0a, 0x009b23c1, 0x920a18d2, 0x1c9a60aa, 0x4663188a,
    0x4bcf431a, 0x4acf4313, 0x188a642b, 0x431a4663, 0x43134bcd, 0x02122203, 0x188a622b, 0x431a4663,
    0x061b2303, 0x626a431a, 0x4ac662aa, 0x320d9b0a, 0x188a62eb, 0x431a4663, 0x43134bc4, 0x9b006103,
    0x069b4672, 0x23c1431a, 0x4313049b, 0x61434abd, 0x188a321c, 0x431a4663, 0x43134bbd, 0x4672652b,
    0x22f7656a, 0x188d0092, 0x431d4663, 0x46724bb9, 0x6005431d, 0x221b6042, 0x18890152, 0x4ab64663,
    0x43114319, 0x2f006301, 0x6c20d003, 0x43082140, 0x99196420, 0x73082002, 0xb01f4630, 0xb5f7bdf0,
    0x49ae460c, 0x4617b0a6, 0x44792220, 0xf7fda81d, 0x6838fe67, 0x0f000200, 0xd0092807, 0x90002000,
    0x03006838, 0xd0050f00, 0x73202003, 0xe0142050, 0xe7f42001, 0xf7fea801, 0x4605f91b, 0xf7fe2000,
    0x2d00f913, 0xaa01d106, 0x98264621, 0xfd76f7ff, 0xd1140006, 0x73202000, 0x46252010, 0x35402108,
    0x71696420, 0x98264621, 0xfd8ef7fe, 0xd1f00006, 0x03006838, 0xd0030f01, 0x28030f00, 0xe09ed003,
    0xaa1d2301, 0x2301e001, 0x2101aa21, 0xf0009826, 0x2008fe6f, 0x22007168, 0x9826a904, 0xfbbff7ff,
    0xd1220006, 0xaa02ab03, 0x4620a904, 0xf971f7ff, 0x28009800, 0x2050d103, 0x20036420, 0x46257320,
    0x35804870, 0x48706328, 0x68396128, 0x0f020308, 0x30ff4620, 0x900130c1, 0x2a0338c0, 0x0409d006,
    0x2a030f0a, 0x0f09d002, 0xe068d01b, 0x62294974, 0x60294974, 0x60694974, 0x64294974, 0x39dc4971,
    0x49706529, 0x60013921, 0x0149213b, 0x496d6301, 0x610139eb, 0x6141496e, 0x03006838, 0xd02f0f00,
    0x2201e04a, 0x06126d21, 0xd3024291, 0x218e2220, 0x2218e001, 0x9b0221c2, 0xb2db0412, 0x43134c65,
    0x652b4323, 0x43119b03, 0x4313b2db, 0x43234a62, 0x60034311, 0x21476101, 0x614101c9, 0x29009900,
    0x495ed00a, 0x495e6029, 0x21236069, 0x63010149, 0x20019901, 0xe0227388, 0x6029495a, 0xe7f34952,
    0x46692000, 0x27067008, 0x208270cf, 0x98007048, 0xf86af7fe, 0x74202001, 0x74612102, 0x61a121e7,
    0x75207567, 0x48348260, 0x6628300f, 0x38724832, 0x48386668, 0x66a81ec0, 0x20029901, 0x46307308,
    0xbdf0b029, 0xb0b4b5f7, 0x90004847, 0x46156810, 0x0f000200, 0x2809460c, 0x2600d01b, 0x22504943,
    0xa81e4479, 0xfd7cf7fd, 0x90022000, 0x30404620, 0x90012104, 0x68287141, 0x04000301, 0x20100f05,
    0x64200f0f, 0xd0062f00, 0xd01b2f02, 0xd01f2f03, 0x2601e169, 0xa804e7e2, 0xf82af7fe, 0x20009000,
    0xf822f7fe, 0x28009800, 0xaa04d107, 0x98344621, 0xfc84f7ff, 0x28009000, 0x9901d1ea, 0x71482001,
    0xe0032000, 0x20049901, 0x20037148, 0xe0087320, 0x73202003, 0x99012008, 0x71482e00, 0x2001d101,
    0x2d009002, 0x2d02d003, 0x2d03d001, 0x4638d1d0, 0xd1004328, 0xe03b2601, 0x04000472, 0x04020400,
    0x20010400, 0x00000406, 0x24040405, 0x0820040c, 0x24043308, 0x00002004, 0x03110000, 0x03060000,
    0x03f90000, 0x00000305, 0x03fa0000, 0x03ed0000, 0x03de0000, 0x03230000, 0x039f0000, 0x000019ae,
    0xa7040705, 0x8b2007fd, 0xa704b306, 0x00000706, 0x0000a304, 0x08000400, 0x0b000400, 0x0b2004fc,
    0x27043306, 0x8b2004fd, 0x00004e29, 0x000017f8, 0xd0022d02, 0xd0022d03, 0x2004e004, 0x2008e000,
    0x71489901, 0x6c212040, 0xd0012e00, 0xe0004381, 0x64214301, 0x98344621, 0xfc36f7fe, 0x28009000,
    0x2e00d18a, 0x2f02d008, 0x2f03d002, 0xe001d10c, 0xe0092001, 0xe0072002, 0xd0022f02, 0xd1032f03,
    0x2003e001, 0x2004e000, 0xa91e0100, 0x23011842, 0x98344619, 0xfd0cf000, 0x9a02a905, 0xf7ff9834,
    0x9000fa5e, 0xd17d2800, 0xaa32ab33, 0x4620a905, 0xf80ff7ff, 0x73202003, 0x30804620, 0x630149fd,
    0x610149fd, 0xd0012e00, 0xe0002302, 0x2e002322, 0x210cd001, 0x212ce000, 0x2e00468e, 0x2109d001,
    0x2129e000, 0x2e009102, 0x2208d001, 0x2228e000, 0x0d8f07a9, 0x46399204, 0x07aa9701, 0x370b0992,
    0x4317069b, 0x431f469c, 0x431f4bec, 0x46736007, 0x029b1d0f, 0x9b02431f, 0x069b4317, 0x9302431f,
    0x049b2301, 0x6047431f, 0x3720460f, 0x46634317, 0x4be2431f, 0x431f4696, 0x460f6507, 0x431737d8,
    0x431f4663, 0x431f4bdd, 0x33f91de3, 0x1c8f601f, 0x46624317, 0x4ad94317, 0x611f4317, 0x9a04460f,
    0x02923780, 0x22014317, 0x31600292, 0x4311615f, 0x63192702, 0xd0012d02, 0xd10f2d03, 0x46739901,
    0x43191d49, 0x43199b02, 0x43194bcd, 0x99016201, 0x43111d89, 0x32cd22ff, 0x55176401, 0x61a12100,
    0xe0002d02, 0xd002e03f, 0xd0032d03, 0x2201e005, 0xe0010492, 0x04d22201, 0x2e0061a2, 0x6c22d010,
    0x431a2380, 0x22016422, 0x551a2379, 0x66024abd, 0x66424abd, 0x74202001, 0xd0072d00, 0xe0067467,
    0x69a22301, 0x431a05db, 0xe7ef61a2, 0x22067461, 0x75207562, 0x46688260, 0x2e007301, 0x2d02d008,
    0x2d03d002, 0xe007d002, 0xe0122041, 0xe0102081, 0xd00b2d02, 0xd00b2d03, 0x20087341, 0x73c84669,
    0xf7fd9803, 0x9800fec1, 0xbdf0b037, 0xe0002042, 0x46692082, 0xe7f07348, 0x2704b5f7, 0x460c4616,
    0xd04d2900, 0xd04b2e00, 0x462001f9, 0xf8e0f001, 0x46252101, 0x71a93540, 0x65200608, 0x6020489b,
    0x6060489b, 0x73602003, 0x20ff73a0, 0x550130c9, 0x02006830, 0x00030f00, 0xf9def001, 0x0c06060a,
    0x1d171711, 0x3023231d, 0x46214632, 0xf0009800, 0xe001f8d6, 0xe0032201, 0xd0180007, 0x2200e01e,
    0x98004621, 0xf9cff7ff, 0x4632e7f6, 0x98004621, 0xfb7cf7ff, 0x4632e7f0, 0x98004621, 0xfd3ff7ff,
    0x4632e7ea, 0x98004621, 0xfe1cf7ff, 0x4620e7e4, 0xfe55f7fd, 0x07007830, 0x71a80f00, 0x71282001,
    0xbdfe4638, 0x2004b5ff, 0x460fb081, 0xd01e2900, 0x35ff463d, 0x6c693581, 0x460c4249, 0x18d24014,
    0x400a4252, 0x31ca21ff, 0x42565dc9, 0xd10c2900, 0x29006d29, 0xe02ad009, 0x46394622, 0xf7fe9801,
    0x2800fcae, 0x6c69d103, 0x42b4190c, 0xb005d3f4, 0x6d29bdf0, 0x43884620, 0x2000d00e, 0x28001b32,
    0x4291d00c, 0x4622d80a, 0x98014639, 0xfcf0f7fe, 0xd1ec2800, 0xe0096d29, 0xe7ef2001, 0x46394622,
    0xf7fe9801, 0x2800fc8c, 0x6c69d1e1, 0x42b4190c, 0xe7dcd3df, 0xb089b5ff, 0x9c122004, 0x4616461f,
    0xd0222900, 0xd0202e00, 0xd01e2c00, 0xf0004608, 0x2103f8ed, 0x7011466a, 0x91032101, 0x91022100,
    0x4d4c7410, 0xd80042ac, 0x46694625, 0x96079701, 0x98099508, 0xfa8bf000, 0xd1062800, 0x008908a9,
    0x197f1b64, 0x2c00198e, 0xb00dd1eb, 0xb570bdf0, 0x460cb08e, 0x910c2100, 0x910b9100, 0x466a910d,
    0x46069102, 0x20037511, 0x25017110, 0x483a9503, 0x92089509, 0x462b900a, 0xaa0a9504, 0x46304629,
    0xfb56f000, 0x4630a901, 0xfa61f000, 0xd1142800, 0x22f79900, 0x4b2b4011, 0x3310040a, 0x910018d3,
    0x742522ff, 0x51133261, 0x220e7525, 0x61a17562, 0x74612104, 0x34c134ff, 0xb00e73e5, 0xb5f0bd70,
    0x20004607, 0x460db0a9, 0x24044616, 0x90254923, 0x90279026, 0x44792230, 0xa8199028, 0xfae0f7fd,
    0x03006830, 0xd1580f00, 0x20452104, 0x46285541, 0x3080491b, 0x491b6001, 0x46296041, 0xf7fe4638,
    0x0004fa23, 0x7830d149, 0x0f000600, 0xd10e2801, 0x49151de8, 0x670130f9, 0x14096741, 0x23006781,
    0x4629461a, 0xf7fe4638, 0x0004fa24, 0x6830d135, 0xe01b0300, 0x00000406, 0x24040405, 0x00200400,
    0x00040400, 0x04000471, 0x00002003, 0x42464346, 0x56010400, 0x0000ffff, 0x24010485, 0x00001242,
    0x08180403, 0x00012404, 0x06ff06ff, 0x01000f00, 0x1842a919, 0x46192301, 0xf0004638, 0x2200fad9,
    0x46384669, 0xf82bf7ff, 0xd1060004, 0x466a4633, 0x46384629, 0xfe68f7fe, 0x46204604, 0xb530e4f0,
    0x2403b089, 0x702c466d, 0x00492501, 0x95032400, 0x94029101, 0x742c466d, 0x93084669, 0xf0009207,
    0xb009f9c6, 0xb530bd30, 0x2402b089, 0x702c466d, 0x00492401, 0x94029101, 0x21009403, 0x46697429,
    0x92059306, 0xf9b3f000, 0x0000e7eb, 0x07406c00, 0x2001d501, 0x20004770, 0x6c004770, 0xd5010680,
    0x47702001, 0x47702000, 0x07c06c00, 0x2001d000, 0x6c004770, 0xd5010700, 0x47702001, 0x47702000,
    0x07806c00, 0x2001d501, 0x20004770, 0x6c004770, 0xd5010640, 0x47702001, 0x47702000, 0xb085b5f3,
    0x2404460e, 0xf0009805, 0x0005fcce, 0x2e00d07e, 0x7b30d07c, 0xd8792803, 0xd00a2800, 0xd0082801,
    0xd0062802, 0xd1042803, 0xf7ff4630, 0x2800ffd9, 0x20ffd002, 0xe00c3001, 0x2102aa03, 0xf7fd9805,
    0x49fefb98, 0x42889803, 0x6c30d306, 0xd4030600, 0x90002079, 0xe0219001, 0x00602400, 0x31601981,
    0x7e0f7e48, 0xd10b2800, 0x43472064, 0x214bd01d, 0xf0004638, 0x214bfeef, 0x42b94341, 0x1c40d200,
    0x283f213f, 0x4608d900, 0x0c400680, 0x30ff00a2, 0x46693001, 0x50881c64, 0xd3de2c02, 0x22026828,
    0x28000780, 0x2000da1c, 0x4630e01e, 0xff9ff7ff, 0x46024607, 0x9805a902, 0xfb86f7fd, 0x990248e0,
    0xd0092f00, 0xfec6f000, 0x217d0880, 0x434800c9, 0xf000214b, 0xe7d2febf, 0xfebcf000, 0xe7f40840,
    0x20016829, 0x60294311, 0x29006d31, 0x6d71d102, 0xd0022900, 0x9b0021c0, 0x6db1514b, 0xd1022900,
    0x29006df1, 0x21c4d004, 0xe0009b01, 0x514be006, 0xd0022800, 0x43906828, 0x24006028, 0xb0074620,
    0xb5f8bdf0, 0x20044607, 0x460e461c, 0xd0162f00, 0xd0142a00, 0xd0122c00, 0x48c14611, 0xfe8af000,
    0x46054601, 0x46304361, 0xfe84f000, 0x1c40e000, 0x43694601, 0x42b14361, 0x6038d3f9, 0xbdf82000,
    0xb085b5f0, 0x460e4db7, 0x95004607, 0xf0009501, 0x0004fc1a, 0x2e00d02b, 0xaa02d029, 0x46382102,
    0xfaf7f7fd, 0x2101aa03, 0xf7fd4638, 0x2601faf2, 0x02b64fad, 0x46394633, 0x9a024668, 0xffc1f7ff,
    0x46394633, 0x9a03a801, 0xffbbf7ff, 0x42a89800, 0x9500d900, 0x42a89801, 0x9501d900, 0x99019800,
    0xb2890400, 0x60604308, 0xb0052000, 0x2004bdf0, 0xb5f3e7fb, 0x2000b087, 0x460c9000, 0x98072504,
    0xfbe1f000, 0x28009003, 0x2c00d054, 0x4620d052, 0x46273040, 0x37509005, 0x30ff2600, 0x90023041,
    0x00b26838, 0x98030a81, 0x90011810, 0x7ba06601, 0x06c51d3f, 0x0eed7b60, 0x0d8006c0, 0x7be04305,
    0x0c400700, 0x46204305, 0xfed3f7ff, 0xd0022800, 0x02802001, 0x6f604305, 0xd00d2800, 0x2102aa04,
    0xf7fd9807, 0x2301fa96, 0x46686f61, 0xf7ff9a04, 0x9800ff68, 0x43050400, 0x67059801, 0x79c09805,
    0xd00e2800, 0x7c009802, 0xd00a0741, 0x22079902, 0x03407c49, 0x0d090709, 0x18800352, 0x4308b280,
    0x2009e001, 0x99010200, 0x60083180, 0x2e041c76, 0x2500d3b6, 0xb0094628, 0x4602bdf0, 0x2004b510,
    0xd0212a00, 0xd01f2900, 0x5c402044, 0xd10c2801, 0x084368d0, 0x2040005b, 0x46084303, 0xfe76f7ff,
    0xd0012800, 0x43032001, 0x68d060d3, 0x43082120, 0x4b5e60d0, 0x00812000, 0x6a0c1889, 0x620c401c,
    0x28031c40, 0x2000d3f7, 0xb510bd10, 0xfb5bf000, 0xd00b2800, 0x23012100, 0x008a07db, 0x32801812,
    0x431c6814, 0x1c496014, 0xd3f62904, 0xb5febd10, 0x20044605, 0x460e9000, 0xf0004628, 0x0004fb44,
    0x2e00d07e, 0x7830d0fc, 0xd8792803, 0x90017c30, 0x46202700, 0xfb3ff000, 0xf7ff4628, 0x6960ffd6,
    0x4308211e, 0x46256160, 0x68703580, 0x78306228, 0xd0022802, 0xd0022803, 0x8b30e003, 0x8c30e000,
    0x7b31b287, 0x1e497a30, 0x07490700, 0x09490b00, 0x99014308, 0x430807c9, 0x62684338, 0x28037830,
    0x69f0d14b, 0x07836a32, 0x2340d14a, 0x469e211c, 0x6bab63a9, 0x430b2101, 0x6bab63ab, 0xd1fc07db,
    0x430b6b2b, 0xe036632b, 0x31f91de1, 0x45724673, 0x6967d30f, 0x06bf089b, 0xe029d402, 0xc080c980,
    0xd2fb1e5b, 0x1a524671, 0x23206961, 0x61614319, 0x6f2be01e, 0x0d5b061b, 0xd2034293, 0xc908e018,
    0xc0081f12, 0xd2fa2a04, 0xd0102a00, 0x91016809, 0x468ca901, 0x23004601, 0x4667e007, 0x700f783f,
    0x1c7f4667, 0x46bc1c49, 0x42931c5b, 0x2200d3f5, 0x07096961, 0x2a00d401, 0x7830d1c6, 0xe0002802,
    0xd001e062, 0xd1482801, 0x69b26971, 0xd15b0788, 0x46842040, 0x63e8201c, 0xe0096be8, 0x05f5e100,
    0x3b9aca00, 0x0000ffff, 0x1dcd6500, 0xfcf0ff00, 0x43182301, 0x6be863e8, 0xd1fc07c0, 0xe02a4686,
    0x30ff4620, 0x30816963, 0xd521065b, 0x089b4663, 0xd2024562, 0xc980e00e, 0x1e5bc080, 0x4660d2fb,
    0xe0091a12, 0xdd032a00, 0xc080c980, 0xe0011f12, 0xc0802700, 0xd2f51e5b, 0x28004670, 0x6b28d104,
    0x43182301, 0x469e6328, 0x23406960, 0x61604318, 0x07006960, 0x2a00d401, 0x7830dcd2, 0xd1032800,
    0x21016b28, 0x63284308, 0xf0004620, 0x6960fa74, 0xd50b0700, 0x01006e68, 0x280e0f00, 0x48fed001,
    0x48fde001, 0x90001e40, 0xbdfe9800, 0xe7fa2000, 0x460eb5f8, 0x461f2104, 0x91004615, 0xfa53f000,
    0xd0230004, 0xd0212d00, 0x19f22100, 0x23104149, 0x1a9a2000, 0xd3194188, 0xf0004620, 0x4aeffa4c,
    0x200261a2, 0x19f161e0, 0x008b00b0, 0x19090081, 0x31ff31ff, 0xe0023102, 0xc140cd40, 0x42981c40,
    0x61a2d3fa, 0x61e02001, 0x90002000, 0xbdf89800, 0x4604b570, 0xb08a2004, 0xd0242900, 0x466e2000,
    0x20037030, 0x90022501, 0x74329503, 0x93012047, 0x28005c40, 0x4608d009, 0x308130ff, 0x2a007a02,
    0x7a42d003, 0x7a009202, 0x98029003, 0x01009b03, 0x21011842, 0x32804620, 0xffaaf7ff, 0x46204669,
    0xf7ff9502, 0xb00afeb4, 0xb5ffbd70, 0xb0912004, 0x900e460d, 0xd0792900, 0x30404628, 0x21018f82,
    0x4094460c, 0x93028fc2, 0x22039200, 0x711a466b, 0x91039104, 0x9108a90c, 0x29009913, 0x2108d001,
    0x2104e000, 0x99139109, 0x79c07519, 0xd0092800, 0x30ff4628, 0x79013081, 0xd0032900, 0x91037941,
    0x90047900, 0x9b049803, 0x19420100, 0x99033280, 0xf7ff9811, 0x6f2dff6d, 0xd0012d00, 0xe0002001,
    0x26002000, 0xa901900f, 0xf7ff9811, 0x900efe70, 0xd13b2800, 0x28009813, 0xa90ad019, 0xab0ca80b,
    0x781f2208, 0x785f700f, 0x1c407007, 0x1e921c49, 0x2a001c9b, 0x9800d1f5, 0x2800990b, 0xd004980a,
    0x46214008, 0xd10a4381, 0x4308e00e, 0x9800e00a, 0xd0062800, 0x4620990c, 0x28004388, 0x2701d004,
    0x980ce003, 0xe7f84020, 0x980f2700, 0xd00b4207, 0x43304628, 0x207dd00d, 0x210000c0, 0xf8aef7fd,
    0x43c02000, 0x41461e6d, 0xd1bc2f00, 0xb015980e, 0x4889bdf0, 0x900e1c40, 0xb5f7e7f8, 0x460db08a,
    0x980a2604, 0xf96ff000, 0xd0540007, 0xd0522d00, 0x46692001, 0x980c7008, 0x20009001, 0x20047408,
    0x90062400, 0x194200a0, 0x30204610, 0x29007841, 0x2301d03e, 0x59db025b, 0x0f9b059b, 0x192bd003,
    0x2b027f5b, 0x9102d034, 0x32307800, 0x90039205, 0x46292200, 0x980a9b0c, 0xff1af7ff, 0xd12b2800,
    0x21019802, 0x19420100, 0x9b033280, 0xf7ff980a, 0x2001fedf, 0x46699002, 0xf7ff980a, 0x0006fde8,
    0x8a68d11a, 0xd10e2800, 0x7f491929, 0xd00a2902, 0xd0082903, 0x46292200, 0x980a9b0c, 0xff25f7ff,
    0xd1090006, 0x2164e004, 0x21004348, 0xf846f7fd, 0x2c031c64, 0x4630d3b6, 0xbdf0b00d, 0xb087b5f3,
    0x2604460d, 0xf0009807, 0x0004f90e, 0x2d00d07e, 0x7c28d0fc, 0xd1022800, 0x28007f28, 0x6c28d009,
    0xd40406c0, 0xf7ff4628, 0x2800fc22, 0x2001d001, 0x2000e000, 0x494a9003, 0x42886828, 0x9807d166,
    0xff7ff7fc, 0x98074629, 0xf862f7fd, 0x30404628, 0x90029903, 0xd0022900, 0x21012200, 0x4628e005,
    0xfc05f7ff, 0x98024602, 0x98077981, 0xff71f7fc, 0xf7fc9807, 0x6820ff5e, 0x43b02602, 0x46206020,
    0xf8c9f000, 0x43306820, 0x68206020, 0x40084935, 0x79499902, 0xd1012908, 0x43080289, 0x43084932,
    0x07897b29, 0x43010e89, 0x46296021, 0xf7ff9807, 0x68a0fc97, 0x03c92101, 0x60a04388, 0xf7ff4628,
    0x2800fbc3, 0x68a0d004, 0x04c92101, 0x60a04308, 0x46204629, 0xfd21f7ff, 0x98074629, 0xfcb9f7ff,
    0x98074629, 0xfbcaf7ff, 0x21026820, 0x60204388, 0xf0004620, 0x4628f890, 0x30507c29, 0x29009004,
    0x9807d01c, 0x20049005, 0xe0002100, 0x9e04e05d, 0x460f9100, 0x9101ce02, 0xd00a2900, 0x9a004629,
    0xf0009805, 0x2800f890, 0x9a01d106, 0x18899900, 0x1c7f9100, 0xd3ed2f04, 0xd1460006, 0x28007f28,
    0x9807d027, 0x20049005, 0xd0202d00, 0x9e042100, 0x460f9100, 0xe009ce02, 0x00001b59, 0x5af05af0,
    0x42464346, 0x0000df0f, 0xffff0000, 0x29009101, 0x4629d00a, 0x98059a00, 0xfedff7ff, 0xd1062800,
    0x99009a01, 0x91001889, 0x2f041c7f, 0x0006d3e2, 0x9803d11b, 0xd0172800, 0x26026820, 0x60204330,
    0xf7ff4628, 0x4602fb64, 0x79819802, 0xf7fc9807, 0x4629fed0, 0xf7ff9807, 0x4629fc13, 0xf7ff9807,
    0x6820fb5d, 0x602043b0, 0x46302600, 0xb510e4a3, 0xf829f000, 0xd0032800, 0x6e013080, 0xd5fc0789,
    0xb510bd10, 0xf81ff000, 0xd0012800, 0xf813f000, 0xb570bd10, 0xf000460d, 0x0004f816, 0xf000d00a,
    0x2001f81a, 0x682102c0, 0xd0012d00, 0xe0004301, 0x60214381, 0x6801bd70, 0x43112201, 0x68016001,
    0xd1fc07c9, 0x46014770, 0x29002000, 0x4830d102, 0x68004478, 0x30804770, 0x07c96e01, 0x6e01d0fc,
    0xd5fc0789, 0xb5f04770, 0x4616b089, 0x4607460c, 0xf7ff2504, 0x2800ffe8, 0x2c00d048, 0x30ffd046,
    0x300230ff, 0x05806800, 0xd0020f80, 0x28027c60, 0x2501d025, 0x700d4669, 0x7d609601, 0x7d209002,
    0x20009003, 0x46207408, 0x90053018, 0x90062004, 0x22004633, 0x46384621, 0xfd9af7ff, 0x21019802,
    0x19020100, 0x32804638, 0xf7ff9b03, 0x4669fd61, 0x95024638, 0xfc6bf7ff, 0xd1170005, 0x2500e001,
    0x8a61e014, 0xd10c2900, 0x28027c60, 0x2803d009, 0x4633d007, 0x46212200, 0xf7ff4638, 0x4605fda6,
    0x2064e004, 0x21004348, 0xfec8f7fc, 0xe4124628, 0x000007f8, 0xb5704770, 0x8901487b, 0x00490849,
    0x497a8101, 0x0852890a, 0x810a0052, 0x23048802, 0x2a000752, 0x8802da02, 0x8002439a, 0x07408808,
    0x8808d502, 0x80084398, 0x68014871, 0xd5010489, 0xe0024970, 0x60414970, 0x60414970, 0x60814970,
    0x22806801, 0x22204391, 0x60014311, 0x6901486d, 0xd00307c9, 0x08496901, 0x61010049, 0x69604c6a,
    0x03814d6a, 0x29002000, 0x6961db14, 0xd4110389, 0x8f4ff3bf, 0x8f6ff3bf, 0xf3bf6128, 0xf3bf8f4f,
    0x69618f6f, 0x04522201, 0x61614311, 0x8f4ff3bf, 0x8f6ff3bf, 0x03c96961, 0x6961d421, 0xd41e03c9,
    0x31804959, 0xf3bf6048, 0x68088f4f, 0x0c490101, 0x0d8304c0, 0x461805ca, 0x07820c96, 0x622a4332,
    0xd2fa1e40, 0xd2f51e49, 0x8f4ff3bf, 0x21016960, 0x43080409, 0xf3bf6160, 0xf3bf8f4f, 0xf7ff8f6f,
    0xbd70ff89, 0x4d4ab5f8, 0x4a4a6968, 0x0180494a, 0x69a8d521, 0x031b2303, 0xd00e4018, 0x031b2301,
    0xd0161ac0, 0xd1034298, 0x04006b10, 0xd0100f80, 0x69692000, 0x0f490089, 0x6910e04c, 0x691003c0,
    0x0780d4f3, 0x2016d501, 0x2014e000, 0x4348493a, 0x4608e7ef, 0x6810e7ed, 0x681003c0, 0x0400d506,
    0xd0010f80, 0xe0062700, 0xe004460f, 0x4b320640, 0x43580e40, 0x6b100847, 0x6b1003c0, 0x0400d506,
    0xd0010f80, 0xe0082400, 0xe006460c, 0xd00107c0, 0xe0002416, 0x48282414, 0x48264344, 0x6a063040,
    0xf0006900, 0x4632fa21, 0xf0002300, 0x69a9f84b, 0x22031900, 0x40110492, 0x2201d011, 0x4b1f0492,
    0xd0161a89, 0xd0171a89, 0xd1074291, 0x07416928, 0x46380f49, 0xf0001c49, 0xe000f90d, 0x69692000,
    0x0f4904c9, 0xf0001c49, 0x4915f905, 0x60084449, 0x6819bdf8, 0xe0000c09, 0x06896819, 0xf0000e89,
    0x2112f8f9, 0xe7ea4348, 0x400b8000, 0x400d0000, 0x400bc000, 0xd928c520, 0x0000c520, 0x0000d928,
    0x0000ffff, 0xe000e000, 0xe000ed00, 0xe000ef40, 0x400fc000, 0x400d8000, 0x016e3600, 0x400d8100,
    0x0000000c, 0x4605b5fe, 0x460c4610, 0xd0734318, 0x468c46ae, 0x1aad2000, 0x419c4601, 0x4666d367,
    0x24012700, 0x1ab6463d, 0xd302419d, 0x463a4613, 0x46652421, 0x042f4676, 0x433e0c36, 0x1ab60c2d,
    0xd304419d, 0x041b0c15, 0x0412432b, 0x46653410, 0x062f4676, 0x433e0a36, 0x1ab60a2d, 0xd304419d,
    0x021b0e15, 0x0212432b, 0x46653408, 0x072f4676, 0x433e0936, 0x1ab6092d, 0xd304419d, 0x011b0f15,
    0x0112432b, 0x46651d24, 0x07af4676, 0x433e08b6, 0x1ab608ad, 0xd304419d, 0x009b0f95, 0x0092432b,
    0x46651ca4, 0x07ef4676, 0x433e0876, 0x1ab6086d, 0xd31a419d, 0x415b1892, 0xe0161c64, 0x46761800,
    0x41494665, 0x419d1ab7, 0x90009101, 0x4660d309, 0x41981ab1, 0x4684468e, 0x99019800, 0x1c402500,
    0x07dd4169, 0x432a0852, 0x1e64085b, 0x4672d5e6, 0xb0034663, 0xe7ffbdf0, 0x46012000, 0x46c046c0,
    0x4623462a, 0xb510e7f5, 0xf0002000, 0x46c0f907, 0x200146c0, 0xf8fcf000, 0x4603bd10, 0x430bb510,
    0xd10f079b, 0xd30d2a04, 0xc910c808, 0x42a31f12, 0xba18d0f8, 0x4288ba21, 0x2001d901, 0x2000bd10,
    0xbd1043c0, 0xd0032a00, 0xd00307d3, 0xe0071c52, 0xbd102000, 0x780c7803, 0x1c491c40, 0xd1071b1b,
    0x780c7803, 0x1c491c40, 0xd1011b1b, 0xd1f11e92, 0xbd104618, 0xc004e001, 0x29041f09, 0x078bd2fb,
    0x8002d501, 0x07c91c80, 0x7002d000, 0x29004770, 0x07c3d00b, 0x7002d002, 0x1e491c40, 0xd3042902,
    0xd5020783, 0x1c808002, 0xe7e31e89, 0xe7ee2200, 0xe7df2200, 0x09032200, 0xd32c428b, 0x428b0a03,
    0x2300d311, 0xe04e469c, 0x430b4603, 0x2200d43c, 0x428b0843, 0x0903d331, 0xd31c428b, 0x428b0a03,
    0x4694d301, 0x09c3e03f, 0xd301428b, 0x1ac001cb, 0x09834152, 0xd301428b, 0x1ac0018b, 0x09434152,
    0xd301428b, 0x1ac0014b, 0x09034152, 0xd301428b, 0x1ac0010b, 0x08c34152, 0xd301428b, 0x1ac000cb,
    0x08834152, 0xd301428b, 0x1ac0008b, 0x08434152, 0xd301428b, 0x1ac0004b, 0x1a414152, 0x4601d200,
    0x46104152, 0xe05d4770, 0xd0000fca, 0x10034249, 0x4240d300, 0x22004053, 0x0903469c, 0xd32d428b,
    0x428b0a03, 0x22fcd312, 0xba120189, 0x428b0a03, 0x0189d30c, 0x428b1192, 0x0189d308, 0x428b1192,
    0x0189d304, 0x1192d03a, 0x0989e000, 0x428b09c3, 0x01cbd301, 0x41521ac0, 0x428b0983, 0x018bd301,
    0x41521ac0, 0x428b0943, 0x014bd301, 0x41521ac0, 0x428b0903, 0x010bd301, 0x41521ac0, 0x428b08c3,
    0x00cbd301, 0x41521ac0, 0x428b0883, 0x008bd301, 0x41521ac0, 0x0843d2d9, 0xd301428b, 0x1ac0004b,
    0x1a414152, 0x4601d200, 0x41524663, 0x4610105b, 0x4240d301, 0xd5002b00, 0x47704249, 0x105b4663,
    0x4240d300, 0x2000b501, 0x46c046c0, 0x0000bd02, 0x20184901, 0xe7febeab, 0x00020026, 0xf000b510,
    0xf000f80b, 0xbd10f802, 0xb5104770, 0xd0012800, 0xffeef7ff, 0x0000bd10, 0x2100b510, 0xf000a002,
    0x2001f813, 0x0000bd10, 0x41474953, 0x3a545242, 0x6e624120, 0x616d726f, 0x6574206c, 0x6e696d72,
    0x6f697461, 0x0000006e, 0x4605b570, 0x200a460c, 0x1c6de000, 0xf812f000, 0xd0062d00, 0x28007828,
    0xe002d1f7, 0xf0001c64, 0x2c00f809, 0x7820d002, 0xd1f72800, 0xf000200a, 0xbd70f801, 0x4669b508,
    0x20037008, 0xbd08beab, 0x0c04b5f8, 0x4626b28b, 0x435eb282, 0x46100c0d, 0x43580c37, 0x19800436,
    0x41792100, 0x436e4616, 0x04360c37, 0x41791980, 0x436e4626, 0xbdf81989, 0x4674b430, 0x78251e64,
    0x42ab1c64, 0x461dd200, 0x005b5d63, 0xbc3018e3, 0x00004718, 0x08220000, 0x06180816, 0x0612041e,
    0x0411060e, 0x0216060c, 0x06180000, 0x060c0416, 0x0312021e, 0x01210216, 0x0116011a, 0x017d7840,
    0x02faf080, 0x05f5e100, 0x07735940, 0x33221100, 0x77665544, 0xbbaa9988, 0xffeeddcc, 0x0818045a,
    0x24ff3008, 0x00000000, 0x00000000, 0x0918055a, 0x25ff3108, 0x00000000, 0x00000000, 0x0a18065a,
    0x26ff3208, 0x00000000, 0x00000000, 0x2403049f, 0x00000000, 0x00000000, 0x00000000, 0x0760079f,
    0x27040b20, 0x00000000, 0x00000000, 0x8760879f, 0xa7048b20, 0x00000000, 0x00000000, 0x0818045a,
    0x24ff3008, 0x00000000, 0x00000000, 0x8b20075a, 0x0000a7ff, 0x00000000, 0x00000000, 0x0818045a,
    0x24ff3008, 0x00000000, 0x00000000, 0x0a18065a, 0x000026ff, 0x00000000, 0x00000000, 0x0b18075a,
    0x000027ff, 0x00000000, 0x00000000, 0x8a18065a, 0x0000a6ff, 0x00000000, 0x00000000, 0x8b20075a,
    0x0000a7ff, 0x00000000, 0x00000000, 0x402a8000, 0x00000000, 0x00000000, 0x00000000, 0x1f78a400,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000
    ],

    # Relative function addresses
    'pc_init': 0x00000091,
    'pc_unInit': 0x000000fd,
    'pc_program_page': 0x00000133,
    'pc_erase_sector': 0x00000115,
    'pc_eraseAll': 0x00000101,

    'static_base' : 0x00000000 + 0x00000020 + 0x00003d50,
    'begin_stack' : 0x20008000,
    'begin_data' : 0x20000000,
    'page_size' : 0x100,
    'analyzer_supported' : False,
    'analyzer_address' : 0x00000000,
    'page_buffers' : [0x20000000, 0x20000100],   # Enable double buffering
    'min_program_length' : 0x100,
}

FLASH_ALGO_HYPERFLASH = {
    'load_address' : 0x00000000,

    'instructions': [
    0xE00ABE00, 0x062D780D, 0x24084068, 0xD3000040, 0x1E644058, 0x1C49D1FA, 0x2A001E52, 0x4770D1F2,
    0x4605b570, 0x4616460c, 0xcc0fe002, 0x3e10c50f, 0xd2fa2e10, 0xd3022e08, 0xc503cc03, 0x2e043e08,
    0xcc01d307, 0x1f36c501, 0x7821e003, 0x1c647029, 0x1e761c6d, 0xbd70d2f9, 0x4770ba40, 0x4770ba40,
    0x4770ba40, 0x4770ba40, 0x4770ba40, 0x4770ba40, 0x4770ba40, 0x4770bac0, 0x4770bac0, 0x4770bac0,
    0x4770bac0, 0x4770bac0, 0x4770bac0, 0x4770bac0, 0x482fb51c, 0x482f9000, 0x08498901, 0x81010049,
    0x890a492d, 0x00520852, 0x8802810a, 0x07522304, 0xda022a00, 0x439a8802, 0x88088002, 0xd5020740,
    0x43988808, 0x48268008, 0x60414924, 0x60814925, 0x22806801, 0x22204391, 0x60014311, 0x466a4922,
    0x20004449, 0xfb9af002, 0xd1052800, 0x4449491e, 0xfedcf000, 0xd0002800, 0xbd1c2001, 0x47702000,
    0xb5104919, 0x20004449, 0xf833f001, 0xd0002800, 0xbd102001, 0x07492105, 0x49131842, 0x2301b510,
    0x4449049b, 0xf0022000, 0x2800fbcf, 0x2001d000, 0x2105bd10, 0x07494613, 0x490b1842, 0x4449b510,
    0xf0002000, 0x2800ffb7, 0x2001d000, 0x0000bd10, 0xc0233007, 0x400b8000, 0x400d0000, 0xd928c520,
    0x400bc000, 0x0000ffff, 0x00000010, 0x49a4b5f8, 0x444948a2, 0x4ea46008, 0x603048a2, 0x28006830,
    0x6b30dafc, 0x03092101, 0x63304388, 0x28006b30, 0x489edafc, 0x499e6802, 0x400a2303, 0x18d202db,
    0x431a4b9c, 0x20036002, 0x61300300, 0x28006930, 0x6930dafc, 0x043f2701, 0x613043b8, 0x3a404a93,
    0x40086b10, 0x02092123, 0x49931840, 0x63104308, 0x20014c92, 0x49936120, 0x44494891, 0x25016008,
    0xe0009000, 0x46291c6d, 0xf0039800, 0x498efbf7, 0xd8f74288, 0x498d6960, 0x1e694008, 0x0b490749,
    0x02294308, 0x390139ff, 0x0d890589, 0x61604308, 0x09c06a60, 0x1cc001c0, 0x69a06260, 0x04892103,
    0x61a04308, 0x498269a0, 0x21054008, 0x18400689, 0x69e061a0, 0x4008497f, 0x07492103, 0x497e1840,
    0x61e04308, 0x210369e0, 0x43080409, 0x6a6061e0, 0x02c921e7, 0x21214388, 0x184002c9, 0x68306260,
    0x603043b8, 0x43b86b30, 0x69306330, 0x613043b8, 0x486abdf8, 0x68013080, 0x02922203, 0x60014311,
    0x48664770, 0x68013080, 0x02922203, 0x60014391, 0xb5f74770, 0x4969460c, 0x4615b08a, 0x44792214,
    0xf7ff4668, 0x4965febd, 0x44792214, 0xa8053108, 0xfeb6f7ff, 0xd0012d00, 0xd1362d01, 0x3e404e53,
    0x09876b30, 0x01bf4855, 0x200769c2, 0x438205c0, 0xd02c2d00, 0x2c00a805, 0x2c09d027, 0x2401d900,
    0x5c430061, 0x78401808, 0x05c02107, 0x069b05c9, 0x0e9b1840, 0x4d520184, 0x09a4433b, 0x43146828,
    0x43382702, 0x980a6028, 0xffbbf7ff, 0x42986b30, 0x6333d000, 0x69c14841, 0xd00042a1, 0x980a61c4,
    0xffa7f7ff, 0x43b86828, 0xb00d6028, 0x4668bdf0, 0xb570e7d1, 0x4a3b4616, 0x444a2000, 0x46046812,
    0xd0082900, 0x29014d35, 0x2902d007, 0x2404d00a, 0x46206030, 0x4610bd70, 0x6968e7fa, 0x0f810580,
    0xe00d4610, 0x482969e8, 0x6b003840, 0x0e890681, 0xf0034834, 0x2112fb33, 0x69e94348, 0x0f490189,
    0xf0031c49, 0xe7e3fb2b, 0x20044603, 0xd1042b00, 0xd0022900, 0x6008482c, 0x47702000, 0x44484821,
    0x47706800, 0x481db510, 0x05806940, 0x481d0f81, 0x44481c49, 0xf0036800, 0xbd10fb11, 0x4604b5f8,
    0x460d4818, 0x68004448, 0xf0034920, 0x4606fb07, 0x2103e009, 0xf0034630, 0x9000fb01, 0xbf00e000,
    0x90001e40, 0x2200d2fb, 0x46281e64, 0x415043d2, 0x43e14605, 0x430143e8, 0xbdf8d1eb, 0x016e3600,
    0x00000004, 0x00012058, 0x400d8000, 0x400d8100, 0xc0c0c0c0, 0x18131818, 0x0f1a2323, 0x400fc000,
    0x1f78a400, 0x0000000c, 0x08954400, 0xfff8e0ff, 0xe3ffffcf, 0x9c7fff80, 0x03800001, 0x0000397a,
    0x402a8000, 0x1c9c3800, 0x09e4f580, 0x000f4240, 0x4d5ab5f8, 0x462e485a, 0x460c9000, 0x46084637,
    0xfb7df002, 0xd0042800, 0x6ee06e26, 0x6e679000, 0x6d206ea5, 0x6d602800, 0x2800d027, 0x4951d004,
    0x63c82006, 0x62c64850, 0x28006d20, 0x494dd006, 0x31402001, 0x484c62c8, 0x61c63040, 0x23114949,
    0x630b3140, 0x30404848, 0x22016207, 0x6245634a, 0x6285638a, 0x62c563ca, 0x31804942, 0x6305600a,
    0x5d002045, 0xd0032808, 0x2800e00f, 0xe024d1d7, 0x2001493c, 0x62083140, 0x32404a3b, 0x61c86115,
    0x618860d5, 0x61486095, 0x7b206055, 0xd0012803, 0xd1062801, 0x30404833, 0x49336283, 0x31409800,
    0x46206188, 0xfb32f002, 0xd0062800, 0x2101482d, 0x62413040, 0x3040482c, 0x6da06147, 0x6de02800,
    0x2800d02a, 0x4927d005, 0x31402006, 0x48266008, 0x6da06306, 0xd0052800, 0x21044822, 0x62413040,
    0x63c64821, 0x2111481f, 0x62413040, 0x3140491e, 0x2201614f, 0x610d6202, 0x60cd61c2, 0x608d6182,
    0x604d6142, 0x2a037b22, 0x2a01d001, 0x2214d103, 0x98006102, 0xbdf86008, 0xd1d42800, 0x2104bdf8,
    0xd00f2800, 0x29037b01, 0x6c01d10b, 0x06493060, 0xda012900, 0xe003210f, 0x29007e41, 0x211ed101,
    0x21007601, 0x47704608, 0x62884908, 0x47702000, 0x6a894906, 0x20006001, 0x00004770, 0x000010f1,
    0x000130f1, 0x401f8180, 0x401f8380, 0x400f8000, 0x4606b5f0, 0xb08548f8, 0xc80f4478, 0xc40f466c,
    0x01304ff6, 0x59790d05, 0x0ed206f2, 0x40902001, 0xd03c4201, 0x04005978, 0xd0080f80, 0x46042000,
    0x03c05978, 0xd0050fc0, 0xb0054620, 0xf000bdf0, 0xe7f4fc39, 0x4de948ea, 0x1a3249e8, 0x31803540,
    0xd0364286, 0x2e0ddc18, 0x48e6d023, 0xd0291830, 0x05092101, 0xd07c1a40, 0xd1184288, 0x46206a2e,
    0xf0036929, 0x4632fac5, 0xf0032300, 0x6b39f8ef, 0xd01307c9, 0xe0122116, 0x05002003, 0x4ada1a10,
    0x2101d041, 0x1a400589, 0x2808d066, 0x2000d06a, 0x6838e7cb, 0x0e400640, 0xe0324360, 0x434c2114,
    0xe7c21820, 0xe0606938, 0xe0002016, 0x43602014, 0x6b28e7bb, 0x0647690e, 0x46200e7f, 0xf0036809,
    0x4632fa97, 0xf0032300, 0x437cf8c1, 0x18206b29, 0x04d22203, 0xd0124011, 0x04d22201, 0xd1004291,
    0x49c10840, 0x6b093180, 0x40114ac0, 0x03d22201, 0xd0061a89, 0x42910212, 0x0880d197, 0x0880e795,
    0x0840e7ef, 0x6a08e791, 0x0647460d, 0x0e7f6816, 0x6b094620, 0xfa6cf003, 0x23004632, 0xf896f003,
    0x6a29437c, 0x22031820, 0x401104d2, 0x2201d012, 0x429104d2, 0x0840d100, 0x318049ab, 0x22016b09,
    0x07890f89, 0x18890792, 0x0052d0d7, 0xd19f42d1, 0xe009e7d7, 0xe7ef0880, 0x46696a10, 0x0f000780,
    0xe7625808, 0xe76048a2, 0x07806a38, 0xe79bd59e, 0x4604b510, 0xf7ff489f, 0x499bff3b, 0x2c003140,
    0x2c01d009, 0x2c02d009, 0x2c03d00e, 0x2000d00f, 0x43482112, 0x6809bd10, 0x6809e001, 0x06890a09,
    0xf0030e89, 0xe7f3f92b, 0x0c096809, 0x6809e7f7, 0xe7f40e09, 0x4c90b510, 0x01816960, 0x69a1488d,
    0x1202d514, 0xd0094011, 0x03122201, 0xd00a1a89, 0xd0054291, 0x69612000, 0xe0170ec9, 0x42404881,
    0xff06f7ff, 0xf000e7f7, 0xe7f4fb5d, 0x04922203, 0xd0134011, 0x04922201, 0xd0121a88, 0xd0111a80,
    0xd1094290, 0xf7ff200d, 0x6921fef3, 0x0f490749, 0xf0031c49, 0xbd10f8f3, 0xbd102000, 0xfee8f7ff,
    0x2002bd10, 0xffa4f7ff, 0xb510bd10, 0xd0012800, 0xf88df003, 0x486c2101, 0x30800789, 0x496f6181,
    0x03d26b0a, 0x2201d5fc, 0x61420412, 0x04096901, 0x6182d5fc, 0x2001bd10, 0x07804963, 0x61483180,
    0x22104770, 0x28004965, 0x638ad001, 0x634a4770, 0x48624770, 0x22016b01, 0x63014311, 0x485f4770,
    0x08496b01, 0x63010049, 0xb5104770, 0xff92f7ff, 0x69494959, 0x0f4904c9, 0xf0031c49, 0xbd10f8af,
    0x4604b510, 0x4240484f, 0xfea2f7ff, 0x2c00494e, 0x2c01d009, 0x2c02d009, 0x2c03d00e, 0x2000d00f,
    0x43482112, 0x6b09bd10, 0x6b09e001, 0x06890a09, 0xf0030e89, 0xe7f3f893, 0x0c096b09, 0x6b09e7f7,
    0xe7f40e09, 0x4c44b510, 0x06406960, 0x6960d50a, 0xd5030600, 0xf7ff2001, 0xe005ffd3, 0xf7ff2002,
    0xe001ff37, 0xff56f7ff, 0x03496961, 0x1c490f49, 0xf874f003, 0xb510bd10, 0xffb7f7ff, 0x69494936,
    0x0f890589, 0xf0031c49, 0xbd10f869, 0x0003b510, 0xf976f003, 0x100d0d17, 0x1c191613, 0x2624211f,
    0x302e2a28, 0x38363432, 0x43413e3c, 0xf7ff0047, 0xbd10ff9c, 0xffc6f7ff, 0xf7ffbd10, 0xbd10ffdc,
    0xf831f000, 0xf000bd10, 0xbd10fa9d, 0x03c02001, 0x200dbd10, 0x481be022, 0xe01f4240, 0xe0042000,
    0xe0022001, 0xe0002002, 0xf7ff2003, 0xbd10ff89, 0xe013481b, 0xe0114817, 0xe0042000, 0xe0022001,
    0xe0002002, 0xf7ff2003, 0xbd10fee3, 0xe0054815, 0x30084814, 0x480ae002, 0x4813e000, 0xfe18f7ff,
    0x2000bd10, 0xb510bd10, 0x69e04c0b, 0xd51d0640, 0xfa68f000, 0x0000e01d, 0x00003668, 0x400d8000,
    0x0070000d, 0xffeffff3, 0x400d80c0, 0x00808000, 0x017d7840, 0x0030000d, 0x400fc000, 0x400d8240,
    0x0020000d, 0x00e0000d, 0x00a0000d, 0xf7ff2003, 0x69e1ff8d, 0x0e890689, 0xf0021c49, 0xbd10ffef,
    0x48f8b508, 0x22036801, 0x60014311, 0x680148f6, 0x43112202, 0x20006001, 0x48f49000, 0x9900bf00,
    0x91001c49, 0xd3f94281, 0x6a0849f1, 0x0212221f, 0x4af04390, 0x62084310, 0xbd082001, 0x48e9b508,
    0x22036801, 0x60014311, 0x680148eb, 0x43112202, 0x20006001, 0x48e59000, 0x9900bf00, 0x91001c49,
    0xd3f94281, 0x6a0849e2, 0x0212221f, 0x4ae14390, 0x62084310, 0xbd082001, 0x49e0b510, 0x2303690a,
    0x439a039b, 0x079b7843, 0x431a0c1b, 0x041b2301, 0x610a431a, 0x7800690a, 0x07c02402, 0x0f8043a2,
    0x20c14302, 0x43020180, 0x6908610a, 0xdafc2800, 0x43986908, 0xbd106108, 0x2400b518, 0x940048cf,
    0x04896901, 0x6901d504, 0x43112240, 0xe0026101, 0xf7ff4668, 0x48caffd1, 0x00496b01, 0x63010849,
    0x04826b01, 0x63014391, 0x6b016004, 0x03922263, 0x63014311, 0xbd182001, 0x690148c0, 0x43912240,
    0x48bf6101, 0x04826b01, 0x63014311, 0xb5104770, 0x680a49ba, 0x039b2303, 0x7903439a, 0x0c1b079b,
    0x2301431a, 0x431a041b, 0x680a600a, 0x4cb57800, 0x40220640, 0x43020e40, 0x430210d8, 0x6808600a,
    0xdafc2800, 0x43986808, 0xbd106008, 0x49ab2001, 0x60080300, 0xb5304770, 0x6b0a49a8, 0x039b2303,
    0x7b03439a, 0x0c1b079b, 0x2301431a, 0x431a041b, 0x6b0a630a, 0x347e4ca3, 0x78044022, 0x0fe407e4,
    0x10dc4322, 0x630a4322, 0x00946842, 0x08a44a9b, 0x61143240, 0x00a46884, 0x621408a4, 0x7c058a44,
    0x07ed0464, 0x0c2d0c64, 0x432c89c0, 0x43040400, 0x6b086014, 0xdafc2800, 0x43986b08, 0xbd306308,
    0x498e2001, 0x63080300, 0x498c4770, 0x61082000, 0xb5104770, 0x6a0a4989, 0x039b2303, 0x7843439a,
    0x0c1b079b, 0x2301431a, 0x431a041b, 0x6a0a620a, 0x24027800, 0x43a207c0, 0x43020f80, 0x018020c1,
    0x620a4302, 0x28006a08, 0x6a08dafc, 0x62084398, 0x497abd10, 0x62082000, 0xb5f04770, 0x22004b77,
    0x6b193340, 0x03a42403, 0x7b0443a1, 0x0c2407a4, 0x24014321, 0x43210424, 0x68416319, 0x496c008d,
    0x398008ad, 0x6885600d, 0x08ad00ad, 0x6b19610d, 0x00e64d6c, 0x78054029, 0x066d7840, 0x43290e6d,
    0x432910e5, 0xd01e2802, 0x01274d67, 0xd0182804, 0xd0142808, 0xd0102810, 0x4d5d4339, 0x6b283540,
    0x43f64e61, 0x43104030, 0x63196328, 0x28006b18, 0x6b18dafc, 0x631843a0, 0x462abdf0, 0x4331e7ed,
    0x4339e7fb, 0x4331e7f9, 0x2001e7e7, 0x03004953, 0x63083140, 0xb5f04770, 0x22004b4d, 0x6a193b80,
    0x03a42403, 0x7b0443a1, 0x0c2407a4, 0x24014321, 0x43210424, 0x68416219, 0x08890089, 0x68816319,
    0x00894d43, 0x3d400889, 0x6a196029, 0x00e64d45, 0x78054029, 0x066d7840, 0x43290e6d, 0x432910e5,
    0xd01e2802, 0x07ad2503, 0x28040127, 0x2808d017, 0x2810d013, 0x4339d00f, 0x30404835, 0x00ad6b05,
    0x431508ad, 0x62196305, 0x28006a18, 0x6a18dafc, 0x621843a0, 0x462abdf0, 0x4331e7ee, 0x4339e7fb,
    0x4331e7f9, 0x2001e7e8, 0x03004929, 0x62083980, 0xb5104770, 0x4a267881, 0x0f890789, 0x6a143a40,
    0x039b2303, 0x78c3439c, 0x0c1b079b, 0x2301431c, 0x431c041b, 0x78046214, 0xd0012c00, 0x432110dc,
    0x28007840, 0x2001d002, 0x43010540, 0x4c1d6a10, 0x4020347c, 0x62104308, 0x28006a10, 0x6a10dafc,
    0x62104398, 0x2001bd10, 0x03004911, 0x62083940, 0xb5104770, 0x681a4b0e, 0x24bf00c0, 0x43a24084,
    0x40842480, 0x601c4314, 0x0e890689, 0x43114081, 0xbd106019, 0x680a4906, 0x208000c3, 0x43024098,
    0x4770600a, 0x400fc080, 0x402e0140, 0x00061a80, 0x400d8100, 0x00001701, 0x402e0340, 0x400d8000,
    0x400d9000, 0xffffef80, 0x00808000, 0x4b22b510, 0x00c06b1a, 0x408424bf, 0x248043a2, 0x43144084,
    0x0689631c, 0x40810e89, 0x63194311, 0x491abd10, 0x00c36b0a, 0x40982080, 0x630a4302, 0xb518e7d1,
    0x46682400, 0xf7ff9400, 0x4814fec4, 0x00496b01, 0x63010849, 0x04426b01, 0x63014391, 0x6b016004,
    0x03922263, 0x63014311, 0xbd182001, 0x38c0480a, 0x22406a01, 0x62014391, 0x6b014808, 0x43110442,
    0xe7ae6301, 0x6b004806, 0xd50106c0, 0xe7a84805, 0x44484805, 0xe7a46800, 0x400d80c0, 0x400da000,
    0x400d8240, 0x016e3600, 0x00000004, 0x460cb570, 0xf0024606, 0x0005fa35, 0x4622d10b, 0x32802301,
    0x46302100, 0xf8e6f002, 0x28017c60, 0x2000d101, 0x46287420, 0xb570bd70, 0x4605b08a, 0x466e2000,
    0x200f7030, 0x90022401, 0x74329403, 0x32ff460a, 0x32719301, 0x46214623, 0xf0024628, 0x4669f8cb,
    0x94024628, 0xffd5f001, 0xbd70b00a, 0x2004b5ff, 0x460db083, 0xd0292900, 0x36ff462e, 0x7b7036c1,
    0xd0062800, 0x9a059b06, 0xf7ff9803, 0x2800ffd4, 0x7b30d11c, 0x3480462c, 0xd10a2802, 0x30304620,
    0x466bc887, 0x4620c307, 0xc80f3040, 0xc40f3430, 0x46293c40, 0x9a059b06, 0xf0029803, 0x7b31f8cb,
    0xd1032902, 0xcd0e466d, 0xc48e3430, 0xbdf0b007, 0xb089b5ff, 0x4616461d, 0x9809460c, 0xffc6f7ff,
    0xd1142800, 0x70084669, 0x200e2701, 0x90029703, 0x4622740e, 0x326132ff, 0x4639463b, 0x98099501,
    0xf878f002, 0x97024669, 0xf0019809, 0xb00dff82, 0xb5ffbdf0, 0xb0832004, 0x4696469c, 0xd0d52900,
    0x35ff460d, 0x7b2835c1, 0x3480460c, 0xd10b2802, 0x30104620, 0x466ac889, 0xc28969e6, 0x30204620,
    0x3410c88d, 0x3c20c48d, 0x46724663, 0xf0029803, 0x7b29f8ae, 0xd1b92902, 0xcd0e466d, 0xc44e3410,
    0xb5f7e7b4, 0x4616b082, 0xd051000d, 0xd84f2e01, 0x34ff462c, 0x7a2034c1, 0xd0002800, 0x28002001,
    0x6c28d046, 0x0fc70640, 0xf0029802, 0x2e00fa62, 0x7a20d02b, 0xd0092800, 0x5d412046, 0x9802463a,
    0xf927f7ff, 0x98024629, 0xfdaaf001, 0x28007ba0, 0x2100d003, 0xf0029802, 0x466afa5e, 0x98022102,
    0xf967f7ff, 0xd0022f00, 0x08409800, 0xaa019000, 0x98022100, 0xf95df7ff, 0x98019900, 0xfcaef002,
    0x1c40210a, 0x08804348, 0x7a21e010, 0xd0072900, 0x9802463a, 0xf8fdf7ff, 0x98024629, 0xfd80f001,
    0x28007ba0, 0x2101d0d9, 0xbf00e7d4, 0xd2fc1e40, 0xbdf0b005, 0xb089b5ff, 0x460d4617, 0xf0014608,
    0x4606fd47, 0x46292200, 0xf7ff9809, 0x463bff9a, 0x46294632, 0xf7ff9809, 0x0004ff19, 0x2002d13f,
    0x70084669, 0x24012009, 0x94039002, 0x5d412047, 0x30ff4628, 0x29003081, 0x7c01d006, 0xd0032900,
    0x91027c41, 0x91037c01, 0x97014669, 0x990c740e, 0x6c009105, 0x98029006, 0x01002101, 0x32801942,
    0x98099b03, 0xffb6f001, 0x94024669, 0xf0019809, 0x0004fec0, 0x463bd113, 0x46294632, 0xf7ff9809,
    0x0004ff38, 0x20ffd10b, 0x5d4030d0, 0xd0062800, 0x4632463b, 0x98094629, 0xff0af7ff, 0x98094604,
    0xf9d1f002, 0x46292201, 0xf7ff9809, 0x4620ff4a, 0xb5f3e71d, 0x2600b08b, 0x9d0c4669, 0x2101700e,
    0x210b9103, 0x46699102, 0x2047740e, 0x46375d40, 0x28004634, 0x4628d009, 0x308130ff, 0x29007d01,
    0x7d41d003, 0x7d009102, 0x22009003, 0x980b990c, 0xff27f7ff, 0x950a3550, 0x9009cd01, 0xd01a2800,
    0x22004633, 0x980b990c, 0xfea0f7ff, 0xd13e0004, 0x96019802, 0x980c0101, 0x180a9b03, 0x32802101,
    0xf001980b, 0x2001ff57, 0x46699002, 0xf001980b, 0x0004fe60, 0x9809d12b, 0x18361c7f, 0xd3db2f04,
    0xd1242c00, 0x90092000, 0x980c4606, 0x30ff9d0a, 0x900a30c1, 0x2f00cd80, 0x2200d013, 0x990c9b09,
    0xf7ff980b, 0x0004fec6, 0x980ad111, 0x28007bc0, 0x2200d007, 0x990c9b09, 0xf7ff980b, 0x0004fe99,
    0x9809d105, 0x19c01c76, 0x2e049009, 0x980bd3e2, 0xf959f002, 0x990c2201, 0xf7ff980b, 0x4620fed2,
    0xb5f7e6a5, 0x4617b08a, 0x4608460d, 0xfc70f001, 0x22004606, 0x980a4629, 0xfec3f7ff, 0x4632463b,
    0x980a4629, 0xfe42f7ff, 0xd1390004, 0x97014669, 0x20057008, 0x90022401, 0x740e9403, 0x5d402047,
    0xd0092800, 0x30ff4628, 0x7b013081, 0xd0032900, 0x91027b41, 0x90037b00, 0x21019802, 0x19420100,
    0x9b033280, 0xf001980a, 0x4669fee5, 0x980a9402, 0xfdeff001, 0xd1130004, 0x4632463b, 0x980a4629,
    0xfe67f7ff, 0xd10b0004, 0x30d020ff, 0x28005d40, 0x463bd006, 0x46294632, 0xf7ff980a, 0x4604fe39,
    0xf002980a, 0x2201f900, 0x980a4629, 0xfe79f7ff, 0xe64c4620, 0xb08ab5f7, 0x460d4617, 0xf0014608,
    0x4606fc17, 0x46292200, 0xf7ff980a, 0x463bfe6a, 0x46294632, 0xf7ff980a, 0x0004fde9, 0x4669d139,
    0x70089701, 0x24012008, 0x94039002, 0x2047740e, 0x28005d40, 0x4628d009, 0x308130ff, 0x29007f01,
    0x7f41d003, 0x7f009102, 0x98029003, 0x01002101, 0x32801942, 0x980a9b03, 0xfe8cf001, 0x94024669,
    0xf001980a, 0x0004fd96, 0x463bd113, 0x46294632, 0xf7ff980a, 0x0004fe0e, 0x20ffd10b, 0x5d4030d0,
    0xd0062800, 0x4632463b, 0x980a4629, 0xfde0f7ff, 0x980a4604, 0xf8a7f002, 0x46292201, 0xf7ff980a,
    0x4620fe20, 0xb5f0e5f3, 0x20044607, 0x461db089, 0x460e4614, 0xd00f2a00, 0x46682124, 0xfafcf002,
    0x46692003, 0x20017008, 0x95089002, 0x96019003, 0x46389407, 0xfd5df001, 0xbdf0b009, 0xb08fb5ff,
    0x460c2000, 0x900b900a, 0x900d900c, 0x25016811, 0x2905461e, 0x6851d202, 0xd3152940, 0x6c117425,
    0x0f490249, 0xf002000b, 0x0d07fbeb, 0x050b0905, 0x000d0705, 0xe00b2702, 0xe0092704, 0xe0072701,
    0xe0052703, 0xe03f7420, 0x05098831, 0xd03b0f0f, 0x90002000, 0x90024669, 0x20037508, 0x95097108,
    0x95049503, 0x2f019108, 0x2f02d007, 0x2f03d003, 0x2f04d02d, 0x48fdd104, 0x48fce001, 0x900a3830,
    0xaa0a2301, 0x980f4619, 0xfe04f001, 0x980fa901, 0xfd0ff001, 0xd1182800, 0x01006830, 0xd0050f00,
    0x040088b0, 0xd0010e01, 0x90000e00, 0x46202100, 0x74213080, 0xd00d2f01, 0x2f022202, 0x2f03d013,
    0x2f04d029, 0x7421d01f, 0xb0132000, 0x48e7bdf0, 0xe7d4300a, 0x064a9900, 0x4ae5d4f6, 0x20c36402,
    0x20404001, 0x9900e01e, 0xd4ed078b, 0x43114be1, 0x02086403, 0x74259000, 0x20047525, 0x98007560,
    0x746561a0, 0x9900e7e0, 0xd4dd078b, 0x33304bd8, 0x64034311, 0x9900e007, 0xd4d5060a, 0x323d4ad5,
    0x20806402, 0x91004301, 0xb5f7e7e5, 0x02402001, 0x2700b098, 0x46689001, 0x24017407, 0x9702460d,
    0x29009403, 0x48ccd072, 0xc84d4478, 0xc14da90d, 0x466a2003, 0xa8097010, 0x20109007, 0x462a9008,
    0x21013280, 0x98189b03, 0xfd94f001, 0x94024669, 0xf0019818, 0x2800fc9e, 0x9809d158, 0xd1081c40,
    0x1c40980a, 0x980bd105, 0xd1021c40, 0x1c40980c, 0x2210d007, 0xa80da909, 0xf9d3f002, 0xd1452800,
    0x2300e034, 0x4629461a, 0xf7ff9818, 0x2800fcaf, 0x2009d17b, 0x20029002, 0x70084669, 0x462aa80d,
    0x90052610, 0x960632ff, 0x21013211, 0x98189b03, 0xfd60f001, 0x94024669, 0xf0019818, 0x2800fc6a,
    0x2300d163, 0x4629461a, 0xf0019818, 0x2800fdb0, 0x9002d15b, 0x46692003, 0xa8097008, 0x96089007,
    0xf0019818, 0x2800fc56, 0xe7c2d14f, 0x90162032, 0x90152000, 0x21406c28, 0x64284308, 0x5d412046,
    0x22012602, 0xf7fe9818, 0xe038fe34, 0x2400e03d, 0x94129411, 0x94149413, 0x6d282101, 0x42880609,
    0x488ed901, 0x488ee000, 0x498e9011, 0x1840b2f0, 0x2301498d, 0x90124308, 0x2100aa11, 0xf0019818,
    0x2003fd19, 0x94024669, 0xa8097008, 0x20109007, 0x98189008, 0xfc1df001, 0xd0060004, 0xd0142f00,
    0x2f00981a, 0xd0106006, 0x2210e010, 0xa80da909, 0xf957f002, 0xd00c2800, 0x2f001c76, 0x9815d1f0,
    0x1c409916, 0x42889015, 0x4c78d3c1, 0xb01b4620, 0x2701bdf0, 0xb5ffe7e4, 0xb0824608, 0x9000305c,
    0x68c8460b, 0x27013308, 0xda032800, 0x1ec0463a, 0xe0014082, 0x08c21c40, 0x24ff9802, 0x9e026502,
    0x68489201, 0x340136ff, 0x28403681, 0x6434d201, 0x8d18e00a, 0x0f020600, 0x40904638, 0x03d22201,
    0xd1004290, 0x64304620, 0x24004d61, 0x00424620, 0x7f1718d2, 0xd00d2f00, 0x40ba2201, 0xd20142aa,
    0x46844615, 0xd90542a2, 0x053f2701, 0xd20142ba, 0x46864614, 0x28041c40, 0x6475d3e9, 0x98026534,
    0x30c130ff, 0xd10142a5, 0xe0002201, 0x72422200, 0x98012201, 0x42900612, 0x3140d92d, 0x28007e08,
    0x9800d008, 0x79014460, 0x60019804, 0x44709800, 0xe0187901, 0x00404660, 0x7f4018c0, 0x22dc2121,
    0xd0022820, 0xd10528d8, 0x9804e002, 0xe0016001, 0x60029804, 0x00404670, 0x7f4018c0, 0xd0022820,
    0xd10528d8, 0x9805e002, 0xe0016001, 0x60029805, 0xb0062000, 0x4660bdf0, 0x18c00040, 0x98047f41,
    0x46706001, 0x18c00040, 0xe7ec7f41, 0xb08db5ff, 0x90052004, 0x460f980f, 0x90033008, 0x305c980f,
    0x20009009, 0x98109004, 0x02006800, 0x28010f00, 0x9803d105, 0x03006800, 0x90040fc0, 0x2000d071,
    0x99107338, 0x78094606, 0x070aab0b, 0x21460f12, 0x900055ca, 0x90062018, 0x90072000, 0x4638aa0a,
    0xf7ff990f, 0x2101ff48, 0x06096d38, 0xd9014288, 0x90062020, 0x88009810, 0x0f000400, 0x4639d151,
    0x9a0f9b10, 0xf7ff980d, 0x9005fdd9, 0xd1f52800, 0x68009803, 0xd51d0281, 0x90072002, 0x7a009803,
    0x0f4e0601, 0x0ec006c0, 0x0000e01c, 0x24010435, 0x20010401, 0x20020401, 0x00002708, 0x8a2004ee,
    0x8a1804ed, 0x00040200, 0xa604b000, 0x00004e2a, 0x00ffffff, 0xd5060240, 0x68809803, 0x0f4e0201,
    0x0ec002c0, 0x980f9000, 0x30409a06, 0x49fc1dfc, 0x900834f9, 0xd0022a20, 0x612048fa, 0x7e00e012,
    0x28004bf9, 0x9809d03b, 0x68004af8, 0xd50105c5, 0xe00348f7, 0xd5320600, 0x302248f3, 0x61206162,
    0xe0a9e001, 0x20016161, 0x463d7338, 0x358048f1, 0x48f16328, 0x980a6128, 0xb2c14af0, 0x04009806,
    0x43114301, 0x65299001, 0xb2c9990b, 0x43114301, 0x01402023, 0x63206021, 0x68009810, 0x0f010100,
    0x9910d00f, 0x060a6849, 0xd00a0e12, 0x9904b2c8, 0x90002600, 0xd0212900, 0x90000040, 0x6123e01e,
    0x9904e7d0, 0xd0192900, 0xd1170f00, 0x28209806, 0x48d5d104, 0x60281c40, 0x606848d9, 0x980d4639,
    0xfaa4f7ff, 0x28009005, 0x466ad166, 0x980d4639, 0xfddbf7ff, 0x28009005, 0x2600d1f6, 0x28189806,
    0x2002d006, 0x98049007, 0xd0202800, 0xe00320ee, 0x28009804, 0x20edd00a, 0x22406c39, 0x64394311,
    0x43019901, 0x430148c7, 0xe0376029, 0x68009803, 0xd5030281, 0x89009803, 0xe0030400, 0xd5040240,
    0x68809803, 0x90020e00, 0x2003e01f, 0x9808e019, 0x28007e00, 0x9809d00a, 0x06816800, 0x06c0d40a,
    0x206cd513, 0x20009002, 0xe00e9007, 0x68009803, 0xd5010281, 0xe7e620ec, 0xd5010240, 0xe7e2206c,
    0x90022013, 0x46062000, 0x99029000, 0x43089801, 0x06099907, 0x49a94308, 0x60284308, 0x463a9910,
    0x32ff7809, 0x32c10609, 0x0f0b2000, 0x2b009201, 0x0f09d003, 0xd0042901, 0x9800e06b, 0x90001980,
    0x990fe049, 0x29406849, 0x9903d3f7, 0x058a6b89, 0x0309d5f3, 0x22050f09, 0xd0014211, 0xe00b20a5,
    0xd5090789, 0x9b104639, 0x980d9a0f, 0xffa1f000, 0x28009005, 0x2001d14d, 0x220a9903, 0x04098f09,
    0x42110e89, 0x4990d007, 0x67616721, 0x29209906, 0x498ed109, 0x2211e006, 0xd03a4211, 0x6721498c,
    0x498c6761, 0x210167a1, 0x2e009a01, 0xd0117351, 0x29009904, 0x2e01d033, 0x2127d02e, 0x43080289,
    0x06099900, 0x43080a09, 0x43084983, 0x48836068, 0xe01760a8, 0x28009800, 0x9a04d00f, 0x2a004980,
    0xb2c0d005, 0x497f1840, 0x60684308, 0xb2c0e00a, 0x497d1840, 0x60684308, 0x487ce00b, 0x98046068,
    0xd0062800, 0x20019901, 0x6c387388, 0x43082140, 0x98056438, 0xbdf0b011, 0x09002126, 0x2e01e7ce,
    0x2107d00c, 0x43080289, 0x06099900, 0x43080a09, 0x4308496f, 0x486f6068, 0xe7ea60a8, 0x09002106,
    0xb5f7e7f0, 0xb0984e6c, 0xd008000d, 0x466a2308, 0x98182100, 0xfc37f7ff, 0xd1640004, 0x2404e001,
    0x4966e061, 0x42889800, 0x4634d001, 0x4668e05b, 0x60287900, 0x79804668, 0x280a1c40, 0x200ad900,
    0x981a9016, 0x28002108, 0x0209d000, 0xaa029816, 0x981800c3, 0xfc17f7ff, 0xd1440004, 0x46282164,
    0xff1af001, 0xe03b2600, 0xaa0200f0, 0x18835c11, 0x020079d8, 0x20ff180a, 0x42820200, 0x4850d002,
    0xd12c4282, 0x20022100, 0x1819020f, 0x43397909, 0xd5f91e40, 0x008778d8, 0x2800981a, 0x0209d000,
    0x020020ff, 0xd10c4282, 0xd9002f50, 0x462a2750, 0x3208463b, 0xf7ff9818, 0x0004fbe6, 0x606fd113,
    0x483fe00d, 0xd10a4282, 0x463b462a, 0x9818325c, 0xfbd9f7ff, 0xd1060004, 0x20582101, 0x1c765541,
    0x42869816, 0x4620d3c0, 0xb5f7e541, 0xb088460d, 0x46282103, 0x230873e9, 0x71433040, 0x642b2358,
    0x73292401, 0xd0012a00, 0x64292159, 0x210f71c4, 0x87c48781, 0x2001462e, 0x024036ff, 0x64303681,
    0x64700240, 0x46306530, 0x90073040, 0x46297244, 0xf7ff9808, 0x2800f91b, 0x4822d172, 0x90002700,
    0x97034821, 0x90012301, 0x466a9702, 0x98084619, 0xfa00f001, 0x97039702, 0x481c4f1a, 0xe0373780,
    0x00002004, 0x08180402, 0x08200412, 0x00002204, 0x0a20043e, 0x00000406, 0x24040405, 0x08000400,
    0x00012404, 0x8a000400, 0x06ff06ff, 0x000006ff, 0x06000600, 0x32101e00, 0xb2000200, 0x7c01a604,
    0x00040200, 0xa604b000, 0x26043000, 0x00002404, 0x32000200, 0x7c012604, 0x00004e27, 0x50444653,
    0x0000ff84, 0x8b188720, 0xa3028f10, 0xa7048f10, 0x23019001, 0x2100466a, 0x98089700, 0xf9baf001,
    0x02c02013, 0x23029006, 0x49feaa06, 0xf0009808, 0x2800fefc, 0x2308d114, 0x2110aa04, 0xf0009808,
    0x2800fee0, 0x9805d10c, 0xb28049f7, 0x98049005, 0xd1044288, 0x98052159, 0x42880209, 0x48f3d002,
    0xbdf0b00b, 0xaa042308, 0x98082127, 0xfec9f000, 0xd1f52800, 0x04009804, 0x90040e00, 0x28093817,
    0x9904d8ed, 0x40882001, 0x200f6528, 0x90060300, 0xaa062302, 0x98082100, 0xfec7f000, 0xd1df2800,
    0x49e3462c, 0x60213480, 0x606149e2, 0x60a149e2, 0x4ae349e2, 0x4fe44be3, 0xc48e3410, 0x60274fdc,
    0x60674fe2, 0x60a74fdc, 0xc40e3410, 0x60a74fe0, 0x60616022, 0x60e74fdf, 0x61274fdd, 0x4fde35ff,
    0xc58e3511, 0x34144fd2, 0x602f3fa0, 0x606f4fdb, 0xc48e4fdb, 0x4fd6c40e, 0x602260a7, 0x4fd56061,
    0x4fd360e7, 0x4cca6127, 0x3ca03d20, 0x4cd5602c, 0x4cd5606c, 0x462f60ac, 0x37304cd1, 0xc70ec71e,
    0x656c4ccb, 0x652964ea, 0x65ac4cca, 0x37144cc8, 0xc70e65ec, 0x66e949cd, 0x72312102, 0x72722203,
    0x22017131, 0x74317172, 0x74712109, 0x73312104, 0x73732305, 0x210b7531, 0x99077571, 0xe77f730a,
    0x2504b5f7, 0x4617b092, 0x2a00460c, 0x7878d004, 0x42887839, 0x2500d101, 0x4620e087, 0x21083040,
    0x71419011, 0x25037878, 0x28422601, 0x2841d001, 0x2502d103, 0x21049811, 0x78787141, 0xd0012882,
    0xd1002842, 0x20002621, 0x90014669, 0x70087408, 0x90022001, 0xa8092120, 0xfd8ef001, 0x200278f9,
    0x29060242, 0x2907d00b, 0x2908d012, 0x2001d001, 0x0229e02b, 0x43131d8b, 0x930931ff, 0x0229e005,
    0x3366460b, 0x31994313, 0x43119309, 0xe01c910d, 0x460f0229, 0x376602b2, 0x4317062b, 0x431f06b5,
    0x432f46ac, 0x31992599, 0x4311042d, 0x4319432f, 0x22334665, 0x04524329, 0x97094311, 0x2e21910d,
    0x6c21d103, 0x43112240, 0x90036421, 0x20019911, 0x06017188, 0x498e6521, 0x498e6021, 0x21036061,
    0x73a17361, 0x31c921ff, 0x200a5508, 0x46216760, 0xf7fe9812, 0x0005ffab, 0xaa09d117, 0x9b032101,
    0xf0019812, 0x4669f897, 0xf0009812, 0x4605ffa2, 0x217d4881, 0x00c94448, 0xf0016800, 0xe001fd2f,
    0x1e40bf00, 0x28009011, 0x4628d1fa, 0xbdf0b015, 0xb09cb5f7, 0x460c981e, 0x02286805, 0x28050f00,
    0x2700d011, 0x22304975, 0xa80d4479, 0xf838f7fe, 0x0f000428, 0x0328900a, 0x980a0f05, 0xd0042800,
    0xd1132803, 0x2701e001, 0x2d00e7ec, 0x2d03d010, 0x2800d10c, 0x2003d00a, 0x20107320, 0x981e6420,
    0x02006800, 0x28040f00, 0xe019d018, 0xe1952604, 0xf7fe4668, 0x4606fadd, 0xf7fe2000, 0x2e00fad5,
    0x466ad106, 0x981c4621, 0xff2af7ff, 0xd1ee0006, 0x73202000, 0x64202010, 0xe0022003, 0x64202050,
    0x90092006, 0x4328980a, 0x2701d100, 0x990a4620, 0x29033040, 0x2101d008, 0x46217141, 0xf7fe981c,
    0x0006ff35, 0xe001d1d3, 0xe7f52108, 0x2d002000, 0x2f00d004, 0x2001d001, 0x2002e000, 0xa90d0100,
    0x23011842, 0x981c4619, 0xf814f001, 0x46692000, 0x75089002, 0x71082003, 0x90032001, 0xa80b9004,
    0xa9019008, 0xf000981c, 0x0006ff14, 0xa808d1af, 0x28c27b00, 0x2101d1ab, 0x2d000409, 0xd01da808,
    0x460a7c40, 0x40823830, 0x46206522, 0x30ff2201, 0x30810312, 0x11126442, 0x65016402, 0x73202003,
    0x64202010, 0x40472001, 0x46294620, 0x30c130ff, 0x35804625, 0x29009019, 0xe078d002, 0xe7e07b80,
    0x2803980a, 0x2101d173, 0x20027421, 0x82617460, 0x75622206, 0x23007521, 0x22074669, 0x70ca700b,
    0xd04a2f00, 0x466a2182, 0x61a07051, 0x6628481c, 0x3872481b, 0x481b6668, 0x981e66a8, 0x06007800,
    0xe0310f00, 0x00000555, 0x52005100, 0x00004e29, 0x8b1887a0, 0xb3068f10, 0x0000a704, 0x87008700,
    0x87aa8700, 0x87058700, 0x87708700, 0xb70b8f10, 0x87558700, 0x87028700, 0x87a08700, 0xa3808f10,
    0x87808700, 0x87008f10, 0x00008730, 0x87108700, 0x42464346, 0x56010400, 0x0000000c, 0x00001ce8,
    0x04000472, 0x20010400, 0xd0022803, 0x728b9919, 0x9919e01a, 0x72882001, 0x2181e016, 0x7059466b,
    0x4bfe61a0, 0x662b48fe, 0x48fe6668, 0x210166a8, 0x77214620, 0x70423020, 0x48f87001, 0x38726321,
    0x6768672b, 0x67a848f7, 0xf7fe9800, 0x48f6f9ed, 0x48f66328, 0x1de06128, 0x30f9990a, 0xd0032900,
    0xd0162f00, 0xe0152321, 0x73212101, 0x602949f0, 0x606949f0, 0x1d8949ee, 0x49ef6101, 0x49ec6141,
    0x65293115, 0x31d049ea, 0x21236001, 0x63010149, 0x2301e084, 0xd0012f00, 0xe0002122, 0x468e2102,
    0xd0012f00, 0xe000212c, 0x911a210c, 0xd0012f00, 0xe0002129, 0x910a2109, 0xd0012f00, 0xe0002128,
    0x91002108, 0x4ad80299, 0x3a18069b, 0x469c188a, 0x4bda431a, 0x602a431a, 0x23194672, 0x015b0292,
    0x9b1a18d2, 0x069b4696, 0x4bd5431a, 0x606b4313, 0x029a9b0a, 0x009b23c1, 0x920a18d2, 0x1c9a60aa,
    0x4663188a, 0x4bcf431a, 0x4acf4313, 0x188a642b, 0x431a4663, 0x43134bcd, 0x02122203, 0x188a622b,
    0x431a4663, 0x061b2303, 0x626a431a, 0x4ac662aa, 0x320d9b0a, 0x188a62eb, 0x431a4663, 0x43134bc4,
    0x9b006103, 0x069b4672, 0x23c1431a, 0x4313049b, 0x61434abd, 0x188a321c, 0x431a4663, 0x43134bbd,
    0x4672652b, 0x22f7656a, 0x188d0092, 0x431d4663, 0x46724bb9, 0x6005431d, 0x221b6042, 0x18890152,
    0x4ab64663, 0x43114319, 0x2f006301, 0x6c20d003, 0x43082140, 0x99196420, 0x73082002, 0xb01f4630,
    0xb5f7bdf0, 0x49ae460c, 0x4617b0a6, 0x44792220, 0xf7fda81d, 0x6838fe75, 0x0f000200, 0xd0092807,
    0x90002000, 0x03006838, 0xd0050f00, 0x73202003, 0xe0142050, 0xe7f42001, 0xf7fea801, 0x4605f929,
    0xf7fe2000, 0x2d00f921, 0xaa01d106, 0x98264621, 0xfd76f7ff, 0xd1140006, 0x73202000, 0x46252010,
    0x35402108, 0x71696420, 0x98264621, 0xfd8ef7fe, 0xd1f00006, 0x03006838, 0xd0030f01, 0x28030f00,
    0xe09ed003, 0xaa1d2301, 0x2301e001, 0x2101aa21, 0xf0009826, 0x2008fe6f, 0x22007168, 0x9826a904,
    0xfbbff7ff, 0xd1220006, 0xaa02ab03, 0x4620a904, 0xf971f7ff, 0x28009800, 0x2050d103, 0x20036420,
    0x46257320, 0x35804870, 0x48706328, 0x68396128, 0x0f020308, 0x30ff4620, 0x900130c1, 0x2a0338c0,
    0x0409d006, 0x2a030f0a, 0x0f09d002, 0xe068d01b, 0x62294974, 0x60294974, 0x60694974, 0x64294974,
    0x39dc4971, 0x49706529, 0x60013921, 0x0149213b, 0x496d6301, 0x610139eb, 0x6141496e, 0x03006838,
    0xd02f0f00, 0x2201e04a, 0x06126d21, 0xd3024291, 0x218e2220, 0x2218e001, 0x9b0221c2, 0xb2db0412,
    0x43134c65, 0x652b4323, 0x43119b03, 0x4313b2db, 0x43234a62, 0x60034311, 0x21476101, 0x614101c9,
    0x29009900, 0x495ed00a, 0x495e6029, 0x21236069, 0x63010149, 0x20019901, 0xe0227388, 0x6029495a,
    0xe7f34952, 0x46692000, 0x27067008, 0x208270cf, 0x98007048, 0xf878f7fe, 0x74202001, 0x74612102,
    0x61a121e7, 0x75207567, 0x48348260, 0x6628300f, 0x38724832, 0x48386668, 0x66a81ec0, 0x20029901,
    0x46307308, 0xbdf0b029, 0xb0b4b5f7, 0x90004847, 0x46156810, 0x0f000200, 0x2809460c, 0x2600d01b,
    0x22504943, 0xa81e4479, 0xfd8af7fd, 0x90022000, 0x30404620, 0x90012104, 0x68287141, 0x04000301,
    0x20100f05, 0x64200f0f, 0xd0062f00, 0xd01b2f02, 0xd01f2f03, 0x2601e169, 0xa804e7e2, 0xf838f7fe,
    0x20009000, 0xf830f7fe, 0x28009800, 0xaa04d107, 0x98344621, 0xfc84f7ff, 0x28009000, 0x9901d1ea,
    0x71482001, 0xe0032000, 0x20049901, 0x20037148, 0xe0087320, 0x73202003, 0x99012008, 0x71482e00,
    0x2001d101, 0x2d009002, 0x2d02d003, 0x2d03d001, 0x4638d1d0, 0xd1004328, 0xe03b2601, 0x04000472,
    0x04020400, 0x20010400, 0x00000406, 0x24040405, 0x0820040c, 0x24043308, 0x00002004, 0x03110000,
    0x03060000, 0x03f90000, 0x00000305, 0x03fa0000, 0x03ed0000, 0x03de0000, 0x03230000, 0x039f0000,
    0x00001992, 0xa7040705, 0x8b2007fd, 0xa704b306, 0x00000706, 0x0000a304, 0x08000400, 0x0b000400,
    0x0b2004fc, 0x27043306, 0x8b2004fd, 0x00004e29, 0x000017dc, 0xd0022d02, 0xd0022d03, 0x2004e004,
    0x2008e000, 0x71489901, 0x6c212040, 0xd0012e00, 0xe0004381, 0x64214301, 0x98344621, 0xfc36f7fe,
    0x28009000, 0x2e00d18a, 0x2f02d008, 0x2f03d002, 0xe001d10c, 0xe0092001, 0xe0072002, 0xd0022f02,
    0xd1032f03, 0x2003e001, 0x2004e000, 0xa91e0100, 0x23011842, 0x98344619, 0xfd0cf000, 0x9a02a905,
    0xf7ff9834, 0x9000fa5e, 0xd17d2800, 0xaa32ab33, 0x4620a905, 0xf80ff7ff, 0x73202003, 0x30804620,
    0x630149fd, 0x610149fd, 0xd0012e00, 0xe0002302, 0x2e002322, 0x210cd001, 0x212ce000, 0x2e00468e,
    0x2109d001, 0x2129e000, 0x2e009102, 0x2208d001, 0x2228e000, 0x0d8f07a9, 0x46399204, 0x07aa9701,
    0x370b0992, 0x4317069b, 0x431f469c, 0x431f4bec, 0x46736007, 0x029b1d0f, 0x9b02431f, 0x069b4317,
    0x9302431f, 0x049b2301, 0x6047431f, 0x3720460f, 0x46634317, 0x4be2431f, 0x431f4696, 0x460f6507,
    0x431737d8, 0x431f4663, 0x431f4bdd, 0x33f91de3, 0x1c8f601f, 0x46624317, 0x4ad94317, 0x611f4317,
    0x9a04460f, 0x02923780, 0x22014317, 0x31600292, 0x4311615f, 0x63192702, 0xd0012d02, 0xd10f2d03,
    0x46739901, 0x43191d49, 0x43199b02, 0x43194bcd, 0x99016201, 0x43111d89, 0x32cd22ff, 0x55176401,
    0x61a12100, 0xe0002d02, 0xd002e03f, 0xd0032d03, 0x2201e005, 0xe0010492, 0x04d22201, 0x2e0061a2,
    0x6c22d010, 0x431a2380, 0x22016422, 0x551a2379, 0x66024abd, 0x66424abd, 0x74202001, 0xd0072d00,
    0xe0067467, 0x69a22301, 0x431a05db, 0xe7ef61a2, 0x22067461, 0x75207562, 0x46688260, 0x2e007301,
    0x2d02d008, 0x2d03d002, 0xe007d002, 0xe0122041, 0xe0102081, 0xd00b2d02, 0xd00b2d03, 0x20087341,
    0x73c84669, 0xf7fd9803, 0x9800fecf, 0xbdf0b037, 0xe0002042, 0x46692082, 0xe7f07348, 0x2704b5f7,
    0x460c4616, 0xd04d2900, 0xd04b2e00, 0x462001f9, 0xf8d2f001, 0x46252101, 0x71a93540, 0x65200608,
    0x6020489b, 0x6060489b, 0x73602003, 0x20ff73a0, 0x550130c9, 0x02006830, 0x00030f00, 0xf9d0f001,
    0x0c06060a, 0x1d171711, 0x3023231d, 0x46214632, 0xf0009800, 0xe001f8d6, 0xe0032201, 0xd0180007,
    0x2200e01e, 0x98004621, 0xf9cff7ff, 0x4632e7f6, 0x98004621, 0xfb7cf7ff, 0x4632e7f0, 0x98004621,
    0xfd3ff7ff, 0x4632e7ea, 0x98004621, 0xfe1cf7ff, 0x4620e7e4, 0xfe63f7fd, 0x07007830, 0x71a80f00,
    0x71282001, 0xbdfe4638, 0x2004b5ff, 0x460fb081, 0xd01e2900, 0x35ff463d, 0x6c693581, 0x460c4249,
    0x18d24014, 0x400a4252, 0x31ca21ff, 0x42565dc9, 0xd10c2900, 0x29006d29, 0xe02ad009, 0x46394622,
    0xf7fe9801, 0x2800fcae, 0x6c69d103, 0x42b4190c, 0xb005d3f4, 0x6d29bdf0, 0x43884620, 0x2000d00e,
    0x28001b32, 0x4291d00c, 0x4622d80a, 0x98014639, 0xfcf0f7fe, 0xd1ec2800, 0xe0096d29, 0xe7ef2001,
    0x46394622, 0xf7fe9801, 0x2800fc8c, 0x6c69d1e1, 0x42b4190c, 0xe7dcd3df, 0xb089b5ff, 0x9c122004,
    0x4616461f, 0xd0222900, 0xd0202e00, 0xd01e2c00, 0xf0004608, 0x2103f8ed, 0x7011466a, 0x91032101,
    0x91022100, 0x4d4c7410, 0xd80042ac, 0x46694625, 0x96079701, 0x98099508, 0xfa8bf000, 0xd1062800,
    0x008908a9, 0x197f1b64, 0x2c00198e, 0xb00dd1eb, 0xb570bdf0, 0x460cb08e, 0x910c2100, 0x910b9100,
    0x466a910d, 0x46069102, 0x20037511, 0x25017110, 0x483a9503, 0x92089509, 0x462b900a, 0xaa0a9504,
    0x46304629, 0xfb56f000, 0x4630a901, 0xfa61f000, 0xd1142800, 0x22f79900, 0x4b2b4011, 0x3310040a,
    0x910018d3, 0x742522ff, 0x51133261, 0x220e7525, 0x61a17562, 0x74612104, 0x34c134ff, 0xb00e73e5,
    0xb5f0bd70, 0x20004607, 0x460db0a9, 0x24044616, 0x90254923, 0x90279026, 0x44792230, 0xa8199028,
    0xfaeef7fd, 0x03006830, 0xd1580f00, 0x20452104, 0x46285541, 0x3080491b, 0x491b6001, 0x46296041,
    0xf7fe4638, 0x0004fa23, 0x7830d149, 0x0f000600, 0xd10e2801, 0x49151de8, 0x670130f9, 0x14096741,
    0x23006781, 0x4629461a, 0xf7fe4638, 0x0004fa24, 0x6830d135, 0xe01b0300, 0x00000406, 0x24040405,
    0x00200400, 0x00040400, 0x04000471, 0x00002003, 0x42464346, 0x56010400, 0x0000ffff, 0x24010485,
    0x00001226, 0x08180403, 0x00012404, 0x06ff06ff, 0x01000f00, 0x1842a919, 0x46192301, 0xf0004638,
    0x2200fad9, 0x46384669, 0xf82bf7ff, 0xd1060004, 0x466a4633, 0x46384629, 0xfe68f7fe, 0x46204604,
    0xb530e4f0, 0x2403b089, 0x702c466d, 0x00492501, 0x95032400, 0x94029101, 0x742c466d, 0x93084669,
    0xf0009207, 0xb009f9c6, 0xb530bd30, 0x2402b089, 0x702c466d, 0x00492401, 0x94029101, 0x21009403,
    0x46697429, 0x92059306, 0xf9b3f000, 0x0000e7eb, 0x07406c00, 0x2001d501, 0x20004770, 0x6c004770,
    0xd5010680, 0x47702001, 0x47702000, 0x07c06c00, 0x2001d000, 0x6c004770, 0xd5010700, 0x47702001,
    0x47702000, 0x07806c00, 0x2001d501, 0x20004770, 0x6c004770, 0xd5010640, 0x47702001, 0x47702000,
    0xb085b5f3, 0x2404460e, 0xf0009805, 0x0005fcce, 0x2e00d07e, 0x7b30d07c, 0xd8792803, 0xd00a2800,
    0xd0082801, 0xd0062802, 0xd1042803, 0xf7ff4630, 0x2800ffd9, 0x20ffd002, 0xe00c3001, 0x2102aa03,
    0xf7fd9805, 0x49fefba6, 0x42889803, 0x6c30d306, 0xd4030600, 0x90002079, 0xe0219001, 0x00602400,
    0x31601981, 0x7e0f7e48, 0xd10b2800, 0x43472064, 0x214bd01d, 0xf0004638, 0x214bfee1, 0x42b94341,
    0x1c40d200, 0x283f213f, 0x4608d900, 0x0c400680, 0x30ff00a2, 0x46693001, 0x50881c64, 0xd3de2c02,
    0x22026828, 0x28000780, 0x2000da1c, 0x4630e01e, 0xff9ff7ff, 0x46024607, 0x9805a902, 0xfb94f7fd,
    0x990248e0, 0xd0092f00, 0xfeb8f000, 0x217d0880, 0x434800c9, 0xf000214b, 0xe7d2feb1, 0xfeaef000,
    0xe7f40840, 0x20016829, 0x60294311, 0x29006d31, 0x6d71d102, 0xd0022900, 0x9b0021c0, 0x6db1514b,
    0xd1022900, 0x29006df1, 0x21c4d004, 0xe0009b01, 0x514be006, 0xd0022800, 0x43906828, 0x24006028,
    0xb0074620, 0xb5f8bdf0, 0x20044607, 0x460e461c, 0xd0162f00, 0xd0142a00, 0xd0122c00, 0x48c14611,
    0xfe7cf000, 0x46054601, 0x46304361, 0xfe76f000, 0x1c40e000, 0x43694601, 0x42b14361, 0x6038d3f9,
    0xbdf82000, 0xb085b5f0, 0x460e4db7, 0x95004607, 0xf0009501, 0x0004fc1a, 0x2e00d02b, 0xaa02d029,
    0x46382102, 0xfb05f7fd, 0x2101aa03, 0xf7fd4638, 0x2601fb00, 0x02b64fad, 0x46394633, 0x9a024668,
    0xffc1f7ff, 0x46394633, 0x9a03a801, 0xffbbf7ff, 0x42a89800, 0x9500d900, 0x42a89801, 0x9501d900,
    0x99019800, 0xb2890400, 0x60604308, 0xb0052000, 0x2004bdf0, 0xb5f3e7fb, 0x2000b087, 0x460c9000,
    0x98072504, 0xfbe1f000, 0x28009003, 0x2c00d054, 0x4620d052, 0x46273040, 0x37509005, 0x30ff2600,
    0x90023041, 0x00b26838, 0x98030a81, 0x90011810, 0x7ba06601, 0x06c51d3f, 0x0eed7b60, 0x0d8006c0,
    0x7be04305, 0x0c400700, 0x46204305, 0xfed3f7ff, 0xd0022800, 0x02802001, 0x6f604305, 0xd00d2800,
    0x2102aa04, 0xf7fd9807, 0x2301faa4, 0x46686f61, 0xf7ff9a04, 0x9800ff68, 0x43050400, 0x67059801,
    0x79c09805, 0xd00e2800, 0x7c009802, 0xd00a0741, 0x22079902, 0x03407c49, 0x0d090709, 0x18800352,
    0x4308b280, 0x2009e001, 0x99010200, 0x60083180, 0x2e041c76, 0x2500d3b6, 0xb0094628, 0x4602bdf0,
    0x2004b510, 0xd0212a00, 0xd01f2900, 0x5c402044, 0xd10c2801, 0x084368d0, 0x2040005b, 0x46084303,
    0xfe76f7ff, 0xd0012800, 0x43032001, 0x68d060d3, 0x43082120, 0x4b5e60d0, 0x00812000, 0x6a0c1889,
    0x620c401c, 0x28031c40, 0x2000d3f7, 0xb510bd10, 0xfb5bf000, 0xd00b2800, 0x23012100, 0x008a07db,
    0x32801812, 0x431c6814, 0x1c496014, 0xd3f62904, 0xb5febd10, 0x20044605, 0x460e9000, 0xf0004628,
    0x0004fb44, 0x2e00d07e, 0x7830d0fc, 0xd8792803, 0x90017c30, 0x46202700, 0xfb3ff000, 0xf7ff4628,
    0x6960ffd6, 0x4308211e, 0x46256160, 0x68703580, 0x78306228, 0xd0022802, 0xd0022803, 0x8b30e003,
    0x8c30e000, 0x7b31b287, 0x1e497a30, 0x07490700, 0x09490b00, 0x99014308, 0x430807c9, 0x62684338,
    0x28037830, 0x69f0d14b, 0x07836a32, 0x2340d14a, 0x469e211c, 0x6bab63a9, 0x430b2101, 0x6bab63ab,
    0xd1fc07db, 0x430b6b2b, 0xe036632b, 0x31f91de1, 0x45724673, 0x6967d30f, 0x06bf089b, 0xe029d402,
    0xc080c980, 0xd2fb1e5b, 0x1a524671, 0x23206961, 0x61614319, 0x6f2be01e, 0x0d5b061b, 0xd2034293,
    0xc908e018, 0xc0081f12, 0xd2fa2a04, 0xd0102a00, 0x91016809, 0x468ca901, 0x23004601, 0x4667e007,
    0x700f783f, 0x1c7f4667, 0x46bc1c49, 0x42931c5b, 0x2200d3f5, 0x07096961, 0x2a00d401, 0x7830d1c6,
    0xe0002802, 0xd001e062, 0xd1482801, 0x69b26971, 0xd15b0788, 0x46842040, 0x63e8201c, 0xe0096be8,
    0x05f5e100, 0x3b9aca00, 0x0000ffff, 0x1dcd6500, 0xfcf0ff00, 0x43182301, 0x6be863e8, 0xd1fc07c0,
    0xe02a4686, 0x30ff4620, 0x30816963, 0xd521065b, 0x089b4663, 0xd2024562, 0xc980e00e, 0x1e5bc080,
    0x4660d2fb, 0xe0091a12, 0xdd032a00, 0xc080c980, 0xe0011f12, 0xc0802700, 0xd2f51e5b, 0x28004670,
    0x6b28d104, 0x43182301, 0x469e6328, 0x23406960, 0x61604318, 0x07006960, 0x2a00d401, 0x7830dcd2,
    0xd1032800, 0x21016b28, 0x63284308, 0xf0004620, 0x6960fa74, 0xd50b0700, 0x01006e68, 0x280e0f00,
    0x48fed001, 0x48fde001, 0x90001e40, 0xbdfe9800, 0xe7fa2000, 0x460eb5f8, 0x461f2104, 0x91004615,
    0xfa53f000, 0xd0230004, 0xd0212d00, 0x19f22100, 0x23104149, 0x1a9a2000, 0xd3194188, 0xf0004620,
    0x4aeffa4c, 0x200261a2, 0x19f161e0, 0x008b00b0, 0x19090081, 0x31ff31ff, 0xe0023102, 0xc140cd40,
    0x42981c40, 0x61a2d3fa, 0x61e02001, 0x90002000, 0xbdf89800, 0x4604b570, 0xb08a2004, 0xd0242900,
    0x466e2000, 0x20037030, 0x90022501, 0x74329503, 0x93012047, 0x28005c40, 0x4608d009, 0x308130ff,
    0x2a007a02, 0x7a42d003, 0x7a009202, 0x98029003, 0x01009b03, 0x21011842, 0x32804620, 0xffaaf7ff,
    0x46204669, 0xf7ff9502, 0xb00afeb4, 0xb5ffbd70, 0xb0912004, 0x900e460d, 0xd0792900, 0x30404628,
    0x21018f82, 0x4094460c, 0x93028fc2, 0x22039200, 0x711a466b, 0x91039104, 0x9108a90c, 0x29009913,
    0x2108d001, 0x2104e000, 0x99139109, 0x79c07519, 0xd0092800, 0x30ff4628, 0x79013081, 0xd0032900,
    0x91037941, 0x90047900, 0x9b049803, 0x19420100, 0x99033280, 0xf7ff9811, 0x6f2dff6d, 0xd0012d00,
    0xe0002001, 0x26002000, 0xa901900f, 0xf7ff9811, 0x900efe70, 0xd13b2800, 0x28009813, 0xa90ad019,
    0xab0ca80b, 0x781f2208, 0x785f700f, 0x1c407007, 0x1e921c49, 0x2a001c9b, 0x9800d1f5, 0x2800990b,
    0xd004980a, 0x46214008, 0xd10a4381, 0x4308e00e, 0x9800e00a, 0xd0062800, 0x4620990c, 0x28004388,
    0x2701d004, 0x980ce003, 0xe7f84020, 0x980f2700, 0xd00b4207, 0x43304628, 0x207dd00d, 0x210000c0,
    0xf8bcf7fd, 0x43c02000, 0x41461e6d, 0xd1bc2f00, 0xb015980e, 0x4889bdf0, 0x900e1c40, 0xb5f7e7f8,
    0x460db08a, 0x980a2604, 0xf96ff000, 0xd0540007, 0xd0522d00, 0x46692001, 0x980c7008, 0x20009001,
    0x20047408, 0x90062400, 0x194200a0, 0x30204610, 0x29007841, 0x2301d03e, 0x59db025b, 0x0f9b059b,
    0x192bd003, 0x2b027f5b, 0x9102d034, 0x32307800, 0x90039205, 0x46292200, 0x980a9b0c, 0xff1af7ff,
    0xd12b2800, 0x21019802, 0x19420100, 0x9b033280, 0xf7ff980a, 0x2001fedf, 0x46699002, 0xf7ff980a,
    0x0006fde8, 0x8a68d11a, 0xd10e2800, 0x7f491929, 0xd00a2902, 0xd0082903, 0x46292200, 0x980a9b0c,
    0xff25f7ff, 0xd1090006, 0x2164e004, 0x21004348, 0xf854f7fd, 0x2c031c64, 0x4630d3b6, 0xbdf0b00d,
    0xb087b5f3, 0x2604460d, 0xf0009807, 0x0004f90e, 0x2d00d07e, 0x7c28d0fc, 0xd1022800, 0x28007f28,
    0x6c28d009, 0xd40406c0, 0xf7ff4628, 0x2800fc22, 0x2001d001, 0x2000e000, 0x494a9003, 0x42886828,
    0x9807d166, 0xff8df7fc, 0x98074629, 0xf870f7fd, 0x30404628, 0x90029903, 0xd0022900, 0x21012200,
    0x4628e005, 0xfc05f7ff, 0x98024602, 0x98077981, 0xff7ff7fc, 0xf7fc9807, 0x6820ff6c, 0x43b02602,
    0x46206020, 0xf8c9f000, 0x43306820, 0x68206020, 0x40084935, 0x79499902, 0xd1012908, 0x43080289,
    0x43084932, 0x07897b29, 0x43010e89, 0x46296021, 0xf7ff9807, 0x68a0fc97, 0x03c92101, 0x60a04388,
    0xf7ff4628, 0x2800fbc3, 0x68a0d004, 0x04c92101, 0x60a04308, 0x46204629, 0xfd21f7ff, 0x98074629,
    0xfcb9f7ff, 0x98074629, 0xfbcaf7ff, 0x21026820, 0x60204388, 0xf0004620, 0x4628f890, 0x30507c29,
    0x29009004, 0x9807d01c, 0x20049005, 0xe0002100, 0x9e04e05d, 0x460f9100, 0x9101ce02, 0xd00a2900,
    0x9a004629, 0xf0009805, 0x2800f890, 0x9a01d106, 0x18899900, 0x1c7f9100, 0xd3ed2f04, 0xd1460006,
    0x28007f28, 0x9807d027, 0x20049005, 0xd0202d00, 0x9e042100, 0x460f9100, 0xe009ce02, 0x00001b59,
    0x5af05af0, 0x42464346, 0x0000df0f, 0xffff0000, 0x29009101, 0x4629d00a, 0x98059a00, 0xfedff7ff,
    0xd1062800, 0x99009a01, 0x91001889, 0x2f041c7f, 0x0006d3e2, 0x9803d11b, 0xd0172800, 0x26026820,
    0x60204330, 0xf7ff4628, 0x4602fb64, 0x79819802, 0xf7fc9807, 0x4629fede, 0xf7ff9807, 0x4629fc13,
    0xf7ff9807, 0x6820fb5d, 0x602043b0, 0x46302600, 0xb510e4a3, 0xf829f000, 0xd0032800, 0x6e013080,
    0xd5fc0789, 0xb510bd10, 0xf81ff000, 0xd0012800, 0xf813f000, 0xb570bd10, 0xf000460d, 0x0004f816,
    0xf000d00a, 0x2001f81a, 0x682102c0, 0xd0012d00, 0xe0004301, 0x60214381, 0x6801bd70, 0x43112201,
    0x68016001, 0xd1fc07c9, 0x46014770, 0x29002000, 0x4830d102, 0x68004478, 0x30804770, 0x07c96e01,
    0x6e01d0fc, 0xd5fc0789, 0xb5f04770, 0x4616b089, 0x4607460c, 0xf7ff2504, 0x2800ffe8, 0x2c00d048,
    0x30ffd046, 0x300230ff, 0x05806800, 0xd0020f80, 0x28027c60, 0x2501d025, 0x700d4669, 0x7d609601,
    0x7d209002, 0x20009003, 0x46207408, 0x90053018, 0x90062004, 0x22004633, 0x46384621, 0xfd9af7ff,
    0x21019802, 0x19020100, 0x32804638, 0xf7ff9b03, 0x4669fd61, 0x95024638, 0xfc6bf7ff, 0xd1170005,
    0x2500e001, 0x8a61e014, 0xd10c2900, 0x28027c60, 0x2803d009, 0x4633d007, 0x46212200, 0xf7ff4638,
    0x4605fda6, 0x2064e004, 0x21004348, 0xfed6f7fc, 0xe4124628, 0x000007dc, 0xb5704770, 0x89014875,
    0x00490849, 0x49748101, 0x0852890a, 0x810a0052, 0x23048802, 0x2a000752, 0x8802da02, 0x8002439a,
    0x07408808, 0x8808d502, 0x80084398, 0x496b486c, 0x496c6041, 0x68016081, 0x43912280, 0x43112220,
    0x48696001, 0x07c96901, 0x6901d003, 0x00490849, 0x4c666101, 0x21006960, 0x4d650380, 0xdb112800,
    0x8f4ff3bf, 0x8f6ff3bf, 0xf3bf6129, 0xf3bf8f4f, 0x69608f6f, 0x04522201, 0x61604310, 0x8f4ff3bf,
    0x8f6ff3bf, 0x03c06960, 0x4858d41e, 0x60413080, 0x8f4ff3bf, 0x01016800, 0x04c00c49, 0x05ca0d83,
    0x0c964618, 0x43320782, 0x1e40622a, 0x1e49d2fa, 0xf3bfd2f5, 0x69608f4f, 0x04092101, 0x61604308,
    0x8f4ff3bf, 0x8f6ff3bf, 0xff96f7ff, 0xb5f8bd70, 0x69684d48, 0x49494a48, 0xd5220180, 0x230369a8,
    0x4018031b, 0x2301d007, 0x1ac0031b, 0x4298d00c, 0x6b10d108, 0x6910e006, 0x691003c0, 0x0400d506,
    0xd0010f80, 0xe0082000, 0xe0064608, 0xd5010780, 0xe0002016, 0x49392014, 0x69694348, 0x0f490089,
    0x6810e03d, 0x681003c0, 0x0400d506, 0xd0010f80, 0xe0062700, 0xe004460f, 0x4b300640, 0x43580e40,
    0x6b100847, 0x6b1003c0, 0x0400d506, 0xd0010f80, 0xe0082400, 0xe006460c, 0xd00107c0, 0xe0002416,
    0x48262414, 0x48244344, 0x6a063040, 0xf0006900, 0x4632fa1f, 0xf0002300, 0x69a9f849, 0x4a201900,
    0xd0114011, 0x04922201, 0x1a894b1e, 0x1a89d016, 0x4291d017, 0x6928d107, 0x0f490741, 0x1c494638,
    0xf90cf000, 0x2000e000, 0x04c96969, 0x1c490f49, 0xf904f000, 0x44494914, 0xbdf86008, 0x0c096819,
    0x6819e000, 0x0e890689, 0xf8f8f000, 0x43482112, 0x0000e7ea, 0x400b8000, 0x400d0000, 0xd928c520,
    0x400bc000, 0x0000ffff, 0xe000e000, 0xe000ed00, 0xe000ef40, 0x400fc000, 0x400d8000, 0x016e3600,
    0x000c0000, 0x400d8100, 0x0000000c, 0x4605b5fe, 0x460c4610, 0xd0734318, 0x468c46ae, 0x1aad2000,
    0x419c4601, 0x4666d367, 0x24012700, 0x1ab6463d, 0xd302419d, 0x463a4613, 0x46652421, 0x042f4676,
    0x433e0c36, 0x1ab60c2d, 0xd304419d, 0x041b0c15, 0x0412432b, 0x46653410, 0x062f4676, 0x433e0a36,
    0x1ab60a2d, 0xd304419d, 0x021b0e15, 0x0212432b, 0x46653408, 0x072f4676, 0x433e0936, 0x1ab6092d,
    0xd304419d, 0x011b0f15, 0x0112432b, 0x46651d24, 0x07af4676, 0x433e08b6, 0x1ab608ad, 0xd304419d,
    0x009b0f95, 0x0092432b, 0x46651ca4, 0x07ef4676, 0x433e0876, 0x1ab6086d, 0xd31a419d, 0x415b1892,
    0xe0161c64, 0x46761800, 0x41494665, 0x419d1ab7, 0x90009101, 0x4660d309, 0x41981ab1, 0x4684468e,
    0x99019800, 0x1c402500, 0x07dd4169, 0x432a0852, 0x1e64085b, 0x4672d5e6, 0xb0034663, 0xe7ffbdf0,
    0x46012000, 0x46c046c0, 0x4623462a, 0xb510e7f5, 0xf0002000, 0x46c0f907, 0x200146c0, 0xf8fcf000,
    0x4603bd10, 0x430bb510, 0xd10f079b, 0xd30d2a04, 0xc910c808, 0x42a31f12, 0xba18d0f8, 0x4288ba21,
    0x2001d901, 0x2000bd10, 0xbd1043c0, 0xd0032a00, 0xd00307d3, 0xe0071c52, 0xbd102000, 0x780c7803,
    0x1c491c40, 0xd1071b1b, 0x780c7803, 0x1c491c40, 0xd1011b1b, 0xd1f11e92, 0xbd104618, 0xc004e001,
    0x29041f09, 0x078bd2fb, 0x8002d501, 0x07c91c80, 0x7002d000, 0x29004770, 0x07c3d00b, 0x7002d002,
    0x1e491c40, 0xd3042902, 0xd5020783, 0x1c808002, 0xe7e31e89, 0xe7ee2200, 0xe7df2200, 0x09032200,
    0xd32c428b, 0x428b0a03, 0x2300d311, 0xe04e469c, 0x430b4603, 0x2200d43c, 0x428b0843, 0x0903d331,
    0xd31c428b, 0x428b0a03, 0x4694d301, 0x09c3e03f, 0xd301428b, 0x1ac001cb, 0x09834152, 0xd301428b,
    0x1ac0018b, 0x09434152, 0xd301428b, 0x1ac0014b, 0x09034152, 0xd301428b, 0x1ac0010b, 0x08c34152,
    0xd301428b, 0x1ac000cb, 0x08834152, 0xd301428b, 0x1ac0008b, 0x08434152, 0xd301428b, 0x1ac0004b,
    0x1a414152, 0x4601d200, 0x46104152, 0xe05d4770, 0xd0000fca, 0x10034249, 0x4240d300, 0x22004053,
    0x0903469c, 0xd32d428b, 0x428b0a03, 0x22fcd312, 0xba120189, 0x428b0a03, 0x0189d30c, 0x428b1192,
    0x0189d308, 0x428b1192, 0x0189d304, 0x1192d03a, 0x0989e000, 0x428b09c3, 0x01cbd301, 0x41521ac0,
    0x428b0983, 0x018bd301, 0x41521ac0, 0x428b0943, 0x014bd301, 0x41521ac0, 0x428b0903, 0x010bd301,
    0x41521ac0, 0x428b08c3, 0x00cbd301, 0x41521ac0, 0x428b0883, 0x008bd301, 0x41521ac0, 0x0843d2d9,
    0xd301428b, 0x1ac0004b, 0x1a414152, 0x4601d200, 0x41524663, 0x4610105b, 0x4240d301, 0xd5002b00,
    0x47704249, 0x105b4663, 0x4240d300, 0x2000b501, 0x46c046c0, 0x0000bd02, 0x20184901, 0xe7febeab,
    0x00020026, 0xf000b510, 0xf000f80b, 0xbd10f802, 0xb5104770, 0xd0012800, 0xffeef7ff, 0x0000bd10,
    0x2100b510, 0xf000a002, 0x2001f813, 0x0000bd10, 0x41474953, 0x3a545242, 0x6e624120, 0x616d726f,
    0x6574206c, 0x6e696d72, 0x6f697461, 0x0000006e, 0x4605b570, 0x200a460c, 0x1c6de000, 0xf812f000,
    0xd0062d00, 0x28007828, 0xe002d1f7, 0xf0001c64, 0x2c00f809, 0x7820d002, 0xd1f72800, 0xf000200a,
    0xbd70f801, 0x4669b508, 0x20037008, 0xbd08beab, 0x0c04b5f8, 0x4626b28b, 0x435eb282, 0x46100c0d,
    0x43580c37, 0x19800436, 0x41792100, 0x436e4616, 0x04360c37, 0x41791980, 0x436e4626, 0xbdf81989,
    0x4674b430, 0x78251e64, 0x42ab1c64, 0x461dd200, 0x005b5d63, 0xbc3018e3, 0x00004718, 0x08220000,
    0x06180816, 0x0612041e, 0x0411060e, 0x0216060c, 0x06180000, 0x060c0416, 0x0312021e, 0x01210216,
    0x0116011a, 0x017d7840, 0x02faf080, 0x05f5e100, 0x07735940, 0x33221100, 0x77665544, 0xbbaa9988,
    0xffeeddcc, 0x0818045a, 0x24ff3008, 0x00000000, 0x00000000, 0x0918055a, 0x25ff3108, 0x00000000,
    0x00000000, 0x0a18065a, 0x26ff3208, 0x00000000, 0x00000000, 0x2403049f, 0x00000000, 0x00000000,
    0x00000000, 0x0760079f, 0x27040b20, 0x00000000, 0x00000000, 0x8760879f, 0xa7048b20, 0x00000000,
    0x00000000, 0x0818045a, 0x24ff3008, 0x00000000, 0x00000000, 0x8b20075a, 0x0000a7ff, 0x00000000,
    0x00000000, 0x0818045a, 0x24ff3008, 0x00000000, 0x00000000, 0x0a18065a, 0x000026ff, 0x00000000,
    0x00000000, 0x0b18075a, 0x000027ff, 0x00000000, 0x00000000, 0x8a18065a, 0x0000a6ff, 0x00000000,
    0x00000000, 0x8b20075a, 0x0000a7ff, 0x00000000, 0x00000000, 0x402a8000, 0x00000000, 0x00000000,
    0x00000000, 0x1f78a400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000
    ],

    # Relative function addresses
    'pc_init': 0x00000091,
    'pc_unInit': 0x000000fd,
    'pc_program_page': 0x00000133,
    'pc_erase_sector': 0x00000115,
    'pc_eraseAll': 0x00000101,

    'static_base' : 0x00000000 + 0x00000020 + 0x00003d18,
    'begin_stack' : 0x20004000,
    'begin_data' : 0x20000000 + 0x1000,
    'page_size' : 0x200,
    'analyzer_supported' : False,
    'analyzer_address' : 0x00000000,
    'page_buffers' : [0x20001000, 0x20001200],   # Enable double buffering
    'min_program_length' : 0x200,
}

class MIMXRT1052xxxxB_hyperflash(IMXRT):

    VENDOR = "NXP"

    # Note: itcm, dtcm, and ocram share a single 512 KB block of RAM that can be configurably
    # divided between those regions (this is called FlexRAM). Thus, the memory map regions for
    # each of these RAMs allocate the maximum possible of 512 KB, but that is the maximum and
    # will not actually be available in all regions simultaneously.
    MEMORY_MAP = MemoryMap(
        RamRegion(name="itcm",              start=0x00000000, length=0x80000), # 512 KB
        RomRegion(name="romcp",             start=0x00200000, length=0x18000), # 96 KB
        RomRegion(name="flexspi_alias",     start=0x08000000, length=0x8000000, alias='flexspi'), # 128 MB
        RamRegion(name="semc_alias",        start=0x10000000, length=0x10000000, alias='semc'), # 256 MB
        RamRegion(name="dtcm",              start=0x20000000, length=0x80000), # 512 KB
        RamRegion(name="ocram",             start=0x20200000, length=0x80000), # 512 KB
        FlashRegion(name="flexspi",         start=0x60000000, length=0x4000000, blocksize=0x40000,
            is_boot_memory=True, algo=FLASH_ALGO_HYPERFLASH, page_size=0x200),
        RamRegion(name="semc",              start=0x80000000, end=0xdfffffff, is_external=True)
        )

    def __init__(self, session):
        super(MIMXRT1052xxxxB_hyperflash, self).__init__(session, self.MEMORY_MAP)
        self._svd_location = SVDFile.from_builtin("MIMXRT1052.xml")


class MIMXRT1052xxxxB_quadspi(IMXRT):

    VENDOR = "NXP"

    # Note: itcm, dtcm, and ocram share a single 512 KB block of RAM that can be configurably
    # divided between those regions (this is called FlexRAM). Thus, the memory map regions for
    # each of these RAMs allocate the maximum possible of 512 KB, but that is the maximum and
    # will not actually be available in all regions simultaneously.
    MEMORY_MAP = MemoryMap(
        RamRegion(name="itcm",              start=0x00000000, length=0x80000), # 512 KB
        RomRegion(name="romcp",             start=0x00200000, length=0x18000), # 96 KB
        RomRegion(name="flexspi_alias",     start=0x08000000, length=0x8000000, alias='flexspi'), # 128 MB
        RamRegion(name="semc_alias",        start=0x10000000, length=0x10000000, alias='semc'), # 256 MB
        RamRegion(name="dtcm",              start=0x20000000, length=0x80000), # 512 KB
        RamRegion(name="ocram",             start=0x20200000, length=0x80000), # 512 KB
        FlashRegion(name="flexspi",         start=0x60000000, length=0x800000, blocksize=0x10000,
            is_boot_memory=True, algo=FLASH_ALGO_QUADSPI, page_size=0x100),
        RamRegion(name="semc",              start=0x80000000, end=0xdfffffff, is_external=True)
        )

    def __init__(self, session):
        super(MIMXRT1052xxxxB_quadspi, self).__init__(session, self.MEMORY_MAP)
        self._svd_location = SVDFile.from_builtin("MIMXRT1052.xml")
