# a helper program takes a list of unordered words and returns a sorted and counted list suitable for the "di" word list. Best run in python3 if non ASCII characters are being used.
import os, sys

os.chdir(os.path.abspath(os.path.dirname(sys.argv[0])))

mixed_list_of_words=["Акт","додати","вік","назад","повітря","все","і","такі","є","мистецтво","поганий","ліжко","великий","бітрейт","коробку","хлопчик","але","купити","може","автомобіль","кішка","плакати","вирізати","день","зробив","собака","сухий","є","кінець","далеко","мало","рис","потрібним","грип","літати","для","весело","газ","отримати","отримав","було","є","капелюх","її","його","його","вдарив","гарячий","як","лід","його","робота","ключ","право","лежав","на","чолі","давайте","брехня","багато","низько","чоловік","карта","може","чоловіки","новий","ні","не","зараз","геть","старий","один","наш","з","самостійно","платять","за","вирвати","кажучи","побіг","червоний","рядок","бігати","сиділи","побачив","скажімо","море","бачите","встановити","вона","сер","сидіти","шість","лижі","небо","синку","шпигун","сума","сонце","десять","занадто","верхня","спробувати","два","використання","війна","було","спосіб","хто","чому","перемога","так","ще","ви",
"стані","також","область","зброя","армія","геть","дитина","тому","банк","база","ведмідь","бити","був","дзвін","кращий","законопроект","розбовтувати","підірвали","пульсування","крапля","пляму","удар","синій","човен","тіло","книга","що","народився","як","висівки","брат","Bray","заварити","доверху","зайнятий","прийшов","догляд","випадок","місто","одягнений","молюск","клан","бавовна","кіготь","глина","кліп","ком","забивають","клуб","ключ","холодно","ну","кухар","круто","копіювати","кукурудза","вартість","корови","краб","ліжечка","обрізати","ворона","темно","угода","глибокий","чи","зроблено","двері","вниз","сіркою","перетягнути","малювати","малював","капати","падіння","барабан","кожен","вуха","схід","легко","край","яйця","інакше","навіть","ніколи","очі","обличчя","факт","справедлива","осінь","ферма","швидко","страх","відчуваю","ноги","впав","відчув","знайти","добре","вогонь","риба","прапор","клапоть","плоскі","недолік","блошиний","полетів","флекс","фліп","флоп","потік","продукти","харчування","ноги","чотири","вільний","жаба","з","повний","ігри","дав","дівчинка","давай","радий","тріумфування","куля","світіння","клей","золото","ні","добре","захоплення","грам","сірий","виріс","сітка","похмурим","посмішка","зчеплення","гравій","рости","личинка","волосся","зупинити","рука","важко","вже","голова","почути","тепло","відбудеться","допомогти","ось","високий","пагорб","тримати","діра","додому","надія","величезний","ідея","в","залізо","просто","тримати","тримав","добрий","цар","знав","знаю","леді","озеро","земля","нарешті","свинець","ліворуч","ноги","менше","життя","як","лінія","список","жити","довго","з","нетерпінням","втратив","голосно","любов","зробив","основний","зробити","багато","марка",
"зустрітися","молоко","розуму","шахта","міс","місяць","Більш","того","більшість","переміщати","багато","повинні","близько","потрібно","поруч","ніс","зверніть","увагу","що","іменник","один","раз","тільки","відкритий","більш","стор","пара","парк","частина","минуле","план","грати","тащаться","сюжет","плуг","сливи","вірш","шест","погане","молитися","прод","проп","раси","дощ","читати","відпочивати","багатий","їздити","кільце","підйом","дорога","рок","кімната","корінь","мотузка","троянди","правило","сейф","сказав","вітрило","такий","же","пісок","зберігати","парші","сканування","шрам","скат","місце","бачили","продати","передати","послав","корабель","магазин","показати","сторона","підписати","співати","розмір","занос","шкіри","пропустити","скит","горбиль","слем","ляпас","сани","ковзнув","струнка","ковзання","щілину","слот","повільно","кулі","зміг","заковика","оснастки","СНиП","сноб","сніг","затишно","грунт","деякі","пісня","найближчим","часом","тривалість","плюнув","спина","пляма","шпори","зірка","залишитися","стрижень","крок","тушкувати","перемішати","зупинити","наприклад","упевнений","плавали","лебідь","своп","вдарити","влада","плавати","хвіст","взяти","говорити","високий","команда","сказати","тест","ніж","що","їх","на","те","вони","тонкі","це","таким","чином","час","крихітні","сказав","тон","взяв","місто","пастка","піднос","дерево","похід","обробка","поїздка","рись","правда","трубка","поворот","тип","пристрій","на","дієслово","дуже","вид","почекайте","стіна","хочете","теплий","мити","носити","тиждень","ну","пішли","були","захід","що","коли","широкий","дружина","дикий","буде","вітер","дріт","бажання","з","дерево","робота","двір","свій",
"вище","після","знову","ж","вперед","дозволяють","поодинці","разом","в","тому","числі","кут","яблуко","запитав","почав","будучи","нижче","птиці","чорний","лезо","провину","порожній","вибух","пожежа","блеать","кровоточити","біп","змішати","благослови","сліпий","блимають","блок","кров","цвітіння","блеф","тупі","дошка","кістки","дужки","тасьма","мозок","гальмівний","бренд","латунь","хоробрий","бійка","хліб","брейк","цегла","наречена","принести","жвава","широка","смажити","зламався","виводок","струмок","мітла","бульйон","коричневий","кисть","побудувати","побудований","нести","зловити","причиною","клітини","центів","діаграма","перевірте","головний","дитина","тріск","претензії","зажим","брязкіт","зіткнення","застібка","клас","чистий","ясний","шип","клерк","натисніть","скелі","набір","висоти","чіплятися","дзвін","плащ","годинник","тупають","близько","тканина","хмара","гвоздику","клоун","клікнувши","грудку","узбережжя","може","граф","тріщини","ремесла","кран","аварія","повзати","розуму","струмок","повзучості","плакала","каркання","шахрай","культури","хрест","натовп","корона","крихта","кора","танці","проект","процідити","селезень","пили","драп","страх","сон","плаття","дрейф","дриль","пити","водити","машину","звисати","поїхали","рано","земля","вісім","насолоджуйтеся","рівні","кожен","поле","боротьба","по-перше","пластівці","спалах","спалах","пляма","флот","плоть","фільм","кидати","кремінь","поплавок","стадо","повінь","підлогу","муліне","борошно","пух","рідини","випадковість","Flunk","флеш","флейта","сила","знайшов","тендітна",
"рама","відверто","кажучи","урод","свіжий","волан","завивають","передній","мороз","фрукти","відблиски","скло","блиск","ковзання","зловтішатися","глобус","морок","блиск","рукавички","благодать","клас","трансплантат","зерно","великий","грант","виноград","графік","тримайтеся","трава","решітка","могила","соус","пасуться","великий","жадібність","зелений","вітати","гриль","бруд","молоти","стогін","наречений","група","гарчанням","виросли","грубий","Grump","думаю","щасливі","почув","серце","важка","кінь","годин","будинок","людина","відомий","великий","пізніше","дізнатися","чи","не","менш","залишити","рівень","світло","майор","марш","матч","можливо","означає","метал","може","миль","гроші","рот","музика","ніколи","ніч","на","північ","океан","часто","для","того","інші","фарба","папір","партія","шт","місце","плед","звичайна","літак","планка","завод","плити","благати","складки","Plink","повна","точка","потужність","Прес","ціна","гордість","друк","приз","зонд","доказ","гордий","довести","крадучись","чорнослив","тихий","цілком","радіо","готовий","правильно","річка","круглі","опіки","масштаб","волосистої","частини","голови","негідник","налякати","шарф","лаяти","совок","поспішна","втеча","Сфера","оцінка","нишпорити","розвідник","котися","лом","гвинт","скраб","підводне","потертості","насіння","сенс","служити","сім","повинні","форма","гострий","взуття","короткі","показано","зір","так","як","кататися","на","ковзанах","вміння","спідниця","череп","скунс","провисає","похила","шифер","гладкий","сон","мокрий","сніг","спав","скибочку","спритний","слайд","слиз","слінг","схил","спад","сльота","смак","маленький","розумний","розбити","мазок","запах","посмішка","халат","дим","закуски","равлик","змійка","малий","барабан",
"гарчання","крастися","нюхати","Шукач","хропіти","морда","вирішити","звук","південь","простір","вільний","іскру","говорити","спис","плямочка","швидкість","заклинання","витрачати","провів","Spike","розливу","хребет","шпиль","Спліт","зіпсувати","говорив","ложка","спорт","носик","спрей","гілочка","приземкуваті","кальмари","стек","персонал","сцена","пляма","сходи","акцій","черствий","стебло","кабіна","штамп","стояти","погляд","зірки","почати","держава","стейк","красти","пара","сталь","крутий","управляти","палиці","жорсткі","проте","палях","жало","сморід","інвентар","камінь","стояв","стілець","сутулість","магазин","шторм","історія","плита","ремінець","солома","бродячих","Стриптиз","бринькати","кабінет","стиль","цукор","болото","рій","піт","розгортки","солодкий","брижі","прокотилася","швидкі","свині","гойдалки","свист","Штурмове","стіл","терміни","їх","там","вони","товсті","річ","думаю","третій","тих","три","сьогодні","інструменти","все","сенсорний","слід","слід","торгівля","стежка","поїзд","бродяга","сміття","протектора","лікування","дерева","трюк","троль","Тромп","військ","форель","вантажівка","дійсно","стовбур","довіра","правда","дядько","під","землею","до","тих","пір","цінність","відвідування","голос","голосний","годинник","вода","хвилі","де","що","в","той","час","білий","цілі","чиї","крила","жінка","жінки","слова","світ","буде","пишіть","не","так","писав","років","молоді",
"через","дія","боюся","погодився","майже","завжди","кількість","відповідь","здавалося","навколо","став","стати","перш","позаду","належать","поруч","краще","відбілювач","блондинка","блузка","знизу","купив","тушкувати","філія","дихання","вітер","міст","яскравий","зламані","мустанга","бронза","переглядати","синяк","називається","не","можу","велика","рогата","худоба","зловили","центр","шанс","змінити","вибрати","церква","коло","шафа","зчеплення","колір","колонка","загальний","кутова","бавовна","звичайно","колиска","олівець","створювати","криза","пустеля","дизайн","прямі","доктор","дракон","під","час","ефект","або","енергія","двигун","достатньо","весь","за","винятком","очікувати","відомий","батько","фігура","заповнені","політ","квітка","ліс","заморожування","друг","переляк","бахрома","заморожені","сад","погляд","глюк","виноград","мастильні","матеріали","поганий","настрій","наземні","Grudge","дюймах","всередині","острів","сам","приєдналися","стрибали","убиті","довжина","підняли","слухати","трохи","матерія","мелодія","метод","середній","сучасний","момент","місяців","мати","народ","зауважте","число","офіс","кисень","пройшло","люди","період","людина","фраза",
"взяв","рівнини","планета","рослини","плеєр","будь","ласка","заставу","багато","кілька","фунтів","похвала","стрибати","молитва","красива","священик","князь","витягнув","штовхнув","підняв","а","насправді","причина","запис","область","залишаються","звіт","результат","повернення","ритм","прокат","мало","школа","палити","дряпати","каракуль","кричати","екран","сценарій","прокрутки","по-друге","здавалося","повинні","мовчить","просто","один","сестра","ескіз","сонливість","рукав","невелике","повільно","посміхнувся","гладка","забруднень","вирвати","чханні","мова","дух","сплеск","шини","губка","розтягнення","схопився","розростання","поширення","весна","спринт","паросток","ялина","квадрат","сквош","писк","вереск","косоокість","звиватися","шприц","повидло","стабільний","головний","продукт","крохмаль","голодувати","статуя","стійкий","стерео","липкий","скупий","стібка","штам","пасмо","смуга","струмок","вулиця","строгий","крок","страйк","рядок","смуга","інсульт","прогулянка","сильний","вдарив","суфікс","літо","поставку","зразок","згорнути","комутатор","системи","хоча","до","подорожі","корита","долини","йшли","вага","колеса","вікна","зима","в","межах","здивування","жовтий",
"проти","вже","тварини","другий","прибутку","тому","що","повірте","між","ковдру","цвісти","брат","приніс","печіння","капітал","капітан","століття","певний","клімат","піднявся","одягу","компанію","порівняти","містять","контроль","правильно","країна","вкриті","крикет","струм","вирішив","десяткового","деталі","далекі","розділені","долари","малювання","увійшов","вечір","точно","наприклад","пояснити","висловити","фактори","фермери","почуття","нарешті","пальці","квіти","вперед","вантажні","друзі","взагалі","гравітація","сам","історія","проте","сотень","полювання","включають","в","себе","комах","замість","цього","сміявся","листи","розташований","машина","міра","членів","мільйон","хвилин","вранці","природний","нічого","цифра","спостерігати","на","вулиці","картини","можливо","фотографія","планети","підготувати","сьогодення","крендель","друкованої","проблема","процес","виробляти","продукт","програма","проект","обіцянку","займенник","захистити","забезпечити","швидко","досяг","гребінець","науку","скутер","скребок","подряпини","вереск","розділ","оселилися","кілька","кричав","схоже","неглибокої","сковороді","тапочки","притиснутися","хтось","особливий","гармонь","стадіон","степлер","почав","станція","стремено","шлунка","дивно","стрейч","з","урахуванням","припустимо","поверхню","ковтати","светр","підсолодити","опухлі","символи","вчитель","думка","через","проблеми","труба","зазвичай","різні","село","погода","західний","будь","без","працівників","написано",
"насправді","доповнення","хоча","все","заметіль","філії","будівництво","бізнес","діти","одяг","повне","розглянути","описати","поділ","електричні","елементи","рівняння","все","захоплюючим","фізичні","вправи","обробкою","фракція","веснянки","трапилося","збільшити","вказують","промисловість","відсотки","мови","майнового","рух","північна","навпаки","приємно","посаду","можливо","практика","практика","дорогоцінний","підготовлений","принцеса","укладений","ймовірно","продукти","нерухомість","отримав","повторюватися","цибуля-","шалот","сутичка","каракулі","вирок","окремий","плече","солдати","рішення","на","півдні","чудовий","осколок","посипати","білка","морські","зірки","панчіх","прямий","фільтр","незнайомець","сила","сильніше","боротьба","студенти","раптом","здивування","разом","трикутник","себе",
"прикметник","красивий","починаючи","ретельно","приголосний","продовжував","визначити","розроблені","різні","складні","напрямок","фабрики","після","бакалія","важливі","молекули","гори","необхідно","пункт","президент","головний","професор","вимовити","пропелер","питання","представляють","щось","іноді","пожежогасіння","заяву","потягнувся","носилки","запропонував","склади","тисячі","підкреслення",
"дошка","умови","словник","різниця","виявив","особливо","все","досвід","експеримент","ліхтарик","уряд","зокрема","вчені","стаціонарні","полуниця","речовини","самі","зрозуміти"]


a = 0
for each in mixed_list_of_words:
    if len(each)>a:
        a = len(each)
        
word_sets = [[] for i in range(a)]
alpha = 'АБВГҐДЕЄЖЗИІЇЙКЛМНОПРСТУФХЦЧШЩЬЮЯабвгґдеєжзиіїйклмнопрстуфхцчшщьюя'
for each in mixed_list_of_words:
    b = len(each)
    if each.lower()[0] in alpha:
        word_sets[b-1].append(each.lower())

for each in word_sets:
    each.sort()
    a = len(each)
    row = []
    row.append(a)
    row.extend(each)
    print(row)

"""
returned = [[16, 'а', 'в', 'в', 'в', 'в', 'в', 'ж', 'з', 'з', 'з', 'з', 'з', 'є', 'є', 'є', 'і']
,[41, 'ви', 'де', 'до', 'до', 'же', 'за', 'за', 'на', 'на', 'на', 'на', 'на', 'на', 'на', 'не', 'не', 'не', 'не', 'ну', 'ну', 'ні', 'ні', 'те', 'це', 'чи', 'чи', 'шт', 'ще', 'що', 'що', 'що', 'що', 'що', 'що', 'як', 'як', 'як', 'як', 'їх', 'їх', 'її']
,[74, 'або', 'акт', 'але', 'без', 'був', 'біп', 'вже', 'вже', 'вид', 'все', 'все', 'все', 'все', 'все', 'вік', 'газ', 'дав', 'два', 'дим', 'для', 'для', 'дощ', 'дух', 'дія', 'зір', 'ком', 'кут', 'лом', 'лід', 'ліс', 'між', 'міс', 'наш', 'ніж', 'ніс', 'ніч', 'ось', 'очі', 'пух', 'під', 'під', 'пір', 'піт', 'раз', 'рис', 'рок', 'рот', 'рух', 'рій', 'річ', 'сад', 'сам', 'сам', 'сер', 'сон', 'сон', 'сім', 'так', 'так', 'так', 'там', 'тип', 'тих', 'тих', 'той', 'тон', 'три', 'хто', 'цар', 'час', 'час', 'час', 'чиї', 'шип']
,[206, 'база', 'банк', 'бити', 'блеф', 'блок', 'брат', 'брат', 'бруд', 'буде', 'буде', 'будь', 'будь', 'були', 'було', 'було', 'вага', 'весь', 'взяв', 'взяв', 'вище', 'вниз', 'вода', 'вона', 'вони', 'вони', 'впав', 'вуха', 'вірш', 'геть', 'геть', 'глюк', 'гори', 'грам', 'граф', 'грип', 'двір', 'день', 'драп', 'друг', 'друк', 'дріт', 'дуже', 'діра', 'діти', 'жаба', 'жало', 'жити', 'звук', 'звіт', 'зима', 'зміг', 'знав', 'знаю', 'зонд', 'його', 'його', 'його', 'йшли', 'клан', 'клас', 'клас', 'клей', 'клуб', 'ключ', 'ключ', 'кліп', 'коли', 'коло', 'кора', 'краб', 'край', 'кран', 'кров', 'крок', 'крок', 'куля', 'кулі', 'кінь', 'леді', 'лезо', 'лижі', 'люди', 'літо', 'мало', 'мало', 'марш', 'мати', 'матч', 'менш', 'миль', 'мити', 'мова', 'мови', 'може', 'може', 'може', 'може', 'можу', 'море', 'міра', 'міст', 'небо', 'ноги', 'ноги', 'ноги', 'один', 'один', 'один', 'одяг', 'офіс', 'пара', 'пара', 'парк', 'перш', 'пили', 'писк', 'пити', 'план', 'плащ', 'плед', 'плуг', 'поле', 'прес', 'приз', 'прод', 'проп', 'рама', 'рано', 'раси', 'риба', 'рись', 'ритм', 'рука', 'самі', 'сани', 'своп', 'свій', 'світ', 'себе', 'себе', 'сейф', 'село', 'сенс', 'сила', 'сила', 'скат', 'скит', 'скло', 'слем', 'слиз', 'слот', 'слід', 'слід', 'смак', 'снип', 'сноб', 'сніг', 'сніг', 'соус', 'спав', 'спад', 'спис', 'став', 'стек', 'стор', 'стіл', 'сума', 'схил', 'схід', 'такі', 'тест', 'того', 'того', 'тому', 'тому', 'тому', 'трюк', 'тупі', 'тіло', 'удар', 'урод', 'уряд', 'факт', 'флеш', 'флоп', 'флот', 'фліп', 'хліб', 'хоча', 'хоча', 'цілі', 'ціна', 'чолі', 'чому', 'шанс', 'шарф', 'шафа', 'шест', 'шини', 'шрам', 'штам', 'щось', 'яйця', 'ігри', 'ідея', 'інші']
,[305, 'акцій', 'армія', 'блиск', 'блиск', 'боюся', 'брейк', 'бренд', 'брижі', 'бійка', 'білий', 'білка', 'більш', 'більш', 'важка', 'важко', 'весна', 'вечір', 'взяти', 'вибух', 'вирок', 'виріс', 'влада', 'волан', 'втеча', 'вчені', 'війна', 'вікна', 'вісім', 'вітер', 'вітер', 'гвинт', 'глина', 'годин', 'голос', 'грант', 'грати', 'гриль', 'гроші', 'грунт', 'група', 'губка', 'давай', 'двері', 'деякі', 'дзвін', 'дзвін', 'дивно', 'дикий', 'добре', 'добре', 'довго', 'доказ', 'досяг', 'дошка', 'дошка', 'дрейф', 'дриль', 'друзі', 'дужки', 'думаю', 'думаю', 'думка', 'екран', 'ескіз', 'ефект', 'жвава', 'життя', 'жінка', 'жінки', 'завод', 'зажим', 'занос', 'запах', 'запис', 'зараз', 'захід', 'заяву', 'зброя', 'земля', 'земля', 'зерно', 'знизу', 'знову', 'зірка', 'зірки', 'зірки', 'карта', 'квіти', 'кисть', 'клерк', 'клоун', 'книга', 'князь', 'кожен', 'кожен', 'колір', 'комах', 'краще', 'криза', 'крила', 'круто', 'купив', 'кухар', 'кішка', 'ласка', 'лаяти', 'легко', 'лежав', 'листи', 'ложка', 'любов', 'ляпас', 'ліжко', 'лінія', 'літак', 'мазок', 'майже', 'майор', 'малий', 'марка', 'межах', 'менше', 'метал', 'метод', 'мозок', 'морда', 'мороз', 'морок', 'місто', 'місто', 'місце', 'місце', 'мітла', 'набір', 'надія', 'назад', 'народ', 'науку', 'нести', 'нижче', 'новий', 'носик', 'одягу', 'озеро', 'океан', 'опіки', 'осінь', 'палях', 'папір', 'парші', 'пасмо', 'писав', 'плече', 'плеєр', 'плита', 'плити', 'плоть', 'пляма', 'пляма', 'пляма', 'пляму', 'побіг', 'повна', 'повне', 'поділ', 'політ', 'поруч', 'поруч', 'потік', 'похід', 'почав', 'почав', 'почув', 'поїзд', 'право', 'проте', 'проте', 'проти', 'прямі', 'птиці', 'пункт', 'після', 'після', 'пісня', 'пісок', 'пішли', 'радий', 'радіо', 'разом', 'разом', 'років', 'рости', 'рукав', 'рядок', 'рядок', 'рівні', 'різні', 'різні', 'річка', 'светр', 'свині', 'свист', 'серце', 'синку', 'синяк', 'синій', 'сквош', 'скелі', 'скраб', 'скунс', 'слайд', 'сливи', 'слова', 'слінг', 'смуга', 'смуга', 'совок', 'сонце', 'спина', 'спліт', 'спорт', 'спрей', 'стадо', 'сталь', 'стані', 'стати', 'стейк', 'стиль', 'стояв', 'страх', 'страх', 'струм', 'стіна', 'сухий', 'сфера', 'сходи', 'схоже', 'сцена', 'сюжет', 'сірий', 'сітка', 'такий', 'таким', 'також', 'танці', 'темно', 'тепло', 'тихий', 'тонкі', 'точка', 'точно', 'трава', 'троль', 'тромп', 'трохи', 'труба', 'тріск', 'убиті', 'увагу', 'угода', 'умови', 'фарба', 'ферма', 'флекс', 'форма', 'фраза', 'фільм', 'філія', 'філії', 'халат', 'хвилі', 'хвіст', 'хмара', 'хрест', 'хтось', 'цегла', 'центр', 'цифра', 'цукор', 'цього', 'часом', 'часто', 'через', 'через', 'череп', 'чином', 'число', 'числі', 'човен', 'шалот', 'шахта', 'шифер', 'школа', 'шкіри', 'шпиль', 'шпори', 'шприц', 'штамп', 'шторм', 'шукач', 'шість', 'ялина', 'ясний', 'іноді', 'іскру']
,[277, 'аварія', 'багато', 'багато', 'багато', 'багато', 'батько', 'бачили', 'бачите', 'блеать', 'блузка', 'болото', 'брехня', 'бронза', 'будучи', 'бігати', 'бізнес', 'вдарив', 'вдарив', 'велика', 'вереск', 'вереск', 'верхня', 'весело', 'взуття', 'висоти', 'виявив', 'вкриті', 'вміння', 'вогонь', 'водити', 'ворона', 'вперед', 'вперед', 'вправи', 'вранці', 'вулиця', 'вулиці', 'відчув', 'військ', 'вітати', 'гладка', 'глобус', 'голова', 'голови', 'гордий', 'гравій', 'графік', 'грубий', 'грудку', 'далеко', 'далекі', 'двигун', 'дерева', 'дерево', 'дерево', 'десять', 'деталі', 'дизайн', 'дитина', 'дитина', 'добрий', 'довіра', 'догляд', 'додати', 'додому', 'доктор', 'долари', 'долини', 'дорога', 'досвід', 'дракон', 'другий', 'дюймах', 'дядько', 'дійсно', 'жовтий', 'завжди', 'залізо', 'землею', 'змійка', 'знайти', 'золото', 'зразок', 'зробив', 'зробив', 'кабіна', 'кажучи', 'кажучи', 'камінь', 'капати', 'квітка', 'кидати', 'кисень', 'клімат', 'ковдру', 'колеса', 'корита', 'корови', 'корона', 'корінь', 'котися', 'крапля', 'красти', 'кращий', 'країна', 'крикет', 'крихта', 'кричав', 'круглі', 'крутий', 'купити', 'кутова', 'кіготь', 'кілька', 'кілька', 'кільце', 'кінець', 'кістки', 'латунь', 'лебідь', 'липкий', 'людина', 'людина', 'літати', 'машина', 'машину', 'минуле', 'могила', 'мокрий', 'молоді', 'молоко', 'молоти', 'молюск', 'момент', 'музика', 'муліне', 'місяць', 'навіть', 'натовп', 'низько', 'носити', 'нюхати', 'ніколи', 'ніколи', 'нічого', 'опухлі', 'острів', 'оцінка', 'пагорб', 'палити', 'палиці', 'пальці', 'панчіх', 'партія', 'пастка', 'певний', 'період', 'пишіть', 'планка', 'плаття', 'плоскі', 'плюнув', 'повний', 'повінь', 'погане', 'погляд', 'погляд', 'погода', 'пожежа', 'позаду', 'посаду', 'послав', 'похила', 'почати', 'почути', 'правда', 'правда', 'прапор', 'приніс', 'провів', 'проект', 'проект', 'прокат', 'просто', 'просто', 'процес', 'прямий', 'півдні', 'північ', 'підйом', 'піднос', 'підняв', 'равлик', 'раптом', 'робота', 'робота', 'рогата', 'розділ', 'розмір', 'розуму', 'розуму', 'рівень', 'рідини', 'свіжий', 'світло', 'сестра', 'сиділи', 'сидіти', 'сказав', 'сказав', 'склади', 'скупий', 'скутер', 'сльота', 'сліпий', 'сморід', 'сміття', 'собака', 'солома', 'сотень', 'спалах', 'спалах', 'список', 'сплеск', 'спосіб', 'спринт', 'старий', 'статуя', 'стебло', 'стежка', 'стерео', 'стогін', 'стояти', 'страйк', 'стрейч', 'стібка', 'суфікс', 'сіркою', 'тасьма', 'теплий', 'тисячі', 'товсті', 'третій', 'тримав', 'трубка', 'тільки', 'флейта', 'форель', 'фрукти', 'фунтів', 'фігура', 'фільтр', 'хвилин', 'хочете', 'хребет', 'худоба', 'цвісти', 'центів', 'церква', 'цілком', 'чистий', 'читати', 'членів', 'чорний', 'чотири', 'чханні', 'шахрай', 'швидко', 'швидко', 'швидкі', 'широка', 'шлунка', 'шпигун', 'щілину', 'яблуко', 'інакше', 'їздити']
,[245, 'бавовна', 'бавовна', 'багатий', 'бажання', 'бакалія', 'барабан', 'барабан', 'бахрома', 'благати', 'близько', 'близько', 'борошно', 'бродяга', 'брязкіт', 'будинок', 'бульйон', 'бітрейт', 'важливі', 'вдарити', 'ведмідь', 'великий', 'великий', 'великий', 'великий', 'взагалі', 'вибрати', 'виводок', 'випадок', 'вирвати', 'вирвати', 'виросли', 'вирішив', 'високий', 'високий', 'висівки', 'волосся', 'втратив', 'вчитель', 'відомий', 'відомий', 'вільний', 'вільний', 'вітрило', 'гармонь', 'гарячий', 'гладкий', 'говорив', 'голосно', 'горбиль', 'гострий', 'готовий', 'гілочка', 'давайте', 'держава', 'дихання', 'доверху', 'довести', 'довжина', 'дружина', 'дряпати', 'енергія', 'жорсткі', 'закуски', 'замість', 'занадто', 'запитав', 'заставу', 'затишно', 'звисати', 'зелений', 'зламані', 'зловили', 'зловити', 'змінити', 'змішати', 'знайшов', 'зокрема', 'зробити', 'кабінет', 'капелюх', 'капітал', 'капітан', 'картини', 'квадрат', 'клапоть', 'клітини', 'ковзнув', 'ковтати', 'колиска', 'колонка', 'команда', 'коробку', 'короткі', 'красива', 'кремінь', 'кричати', 'кімната', 'личинка', 'ліворуч', 'ліжечка', 'магазин', 'магазин', 'малював', 'масштаб', 'матерія', 'мелодія', 'мовчить', 'можливо', 'можливо', 'можливо', 'молитва', 'морські', 'мотузка', 'мільйон', 'містять', 'місяців', 'навколо', 'навпаки', 'наземні', 'нарешті', 'нарешті', 'настрій', 'насіння', 'недолік', 'носилки', 'область', 'область', 'обличчя', 'обробка', 'означає', 'окремий', 'олівець', 'описати', 'осколок', 'отримав', 'отримав', 'падіння', 'переляк', 'печіння', 'питання', 'плавали', 'плавати', 'плакала', 'плакати', 'планета', 'планети', 'платять', 'побачив', 'повзати', 'повидло', 'повинні', 'повинні', 'повинні', 'поворот', 'повірте', 'повітря', 'поганий', 'поганий', 'полетів', 'похвала', 'почуття', 'поїздка', 'поїхали', 'правило', 'прийшов', 'причина', 'приємно', 'провину', 'продати', 'продукт', 'продукт', 'пройшло', 'простір', 'пустеля', 'південь', 'підлогу', 'підняли', 'пізніше', 'ремесла', 'решітка', 'розбити', 'розливу', 'рослини', 'рівнини', 'різниця', 'рішення', 'свинець', 'сильний', 'символи', 'системи', 'скажімо', 'сказати', 'складки', 'складні', 'скребок', 'словник', 'служити', 'слухати', 'смажити', 'сміявся', 'солдати', 'співати', 'стадіон', 'станція', 'степлер', 'стовбур', 'сторона', 'строгий', 'струмок', 'струмок', 'струмок', 'струнка', 'стійкий', 'стілець', 'сутичка', 'тапочки', 'тварини', 'терміни', 'тиждень', 'тканина', 'тримати', 'тримати', 'троянди', 'тріщини', 'тупають', 'увійшов', 'фабрики', 'фактори', 'фермери', 'фракція', 'фізичні', 'хлопчик', 'холодно', 'хропіти', 'цибуля-', 'частина', 'частини', 'чоловік', 'чудовий', 'широкий', 'щасливі', 'іменник', 'інсульт', 'історія', 'історія']
,[173, 'блимають', 'блошиний', 'боротьба', 'боротьба', 'бродячих', 'вантажні', 'вартість', 'веснянки', 'вимовити', 'виноград', 'виноград', 'винятком', 'вирізати', 'вирішити', 'витягнув', 'вказують', 'відверто', 'відсотки', 'відчуваю', 'гарчання', 'гвоздику', 'глибокий', 'говорити', 'говорити', 'годинник', 'годинник', 'гойдалки', 'головний', 'головний', 'головний', 'голосний', 'гордість', 'діаграма', 'дівчинка', 'дієслово', 'елементи', 'заварити', 'зазвичай', 'зайнятий', 'заковика', 'залишити', 'заметіль', 'застібка', 'зауважте', 'західний', 'зверніть', 'звичайна', 'звичайно', 'згорнути', 'зламався', 'зроблено', 'зупинити', 'зупинити', 'ймовірно', 'кальмари', 'каракуль', 'каракулі', 'каркання', 'кататися', 'ковзанах', 'ковзання', 'ковзання', 'компанію', 'контроль', 'корабель', 'красивий', 'крастися', 'крендель', 'крихітні', 'крохмаль', 'культури', 'ліхтарик', 'малювати', 'молекули', 'молитися', 'мустанга', 'належать', 'налякати', 'написано', 'напрямок', 'наречена', 'невелике', 'негідник', 'обробкою', 'обрізати', 'обіцянку', 'оснастки', 'основний', 'особливо', 'отримати', 'паросток', 'пасуться', 'передати', 'передній', 'перемога', 'персонал', 'плямочка', 'по-друге', 'по-перше', 'поверхню', 'повільно', 'повільно', 'подорожі', 'показано', 'показати', 'полуниця', 'поодинці', 'поплавок', 'порожній', 'посипати', 'посмішка', 'посмішка', 'поспішна', 'поставку', 'потрібно', 'похмурим', 'пояснити', 'практика', 'практика', 'прибутку', 'принести', 'принцеса', 'пристрій', 'причиною', 'проблема', 'проблеми', 'провисає', 'програма', 'продукти', 'продукти', 'пропелер', 'професор', 'північна', 'підводне', 'піднявся', 'ремінець', 'ретельно', 'речовини', 'розумний', 'рівняння', 'священик', 'світіння', 'селезень', 'середній', 'сильніше', 'скибочку', 'солодкий', 'спритний', 'спідниця', 'століття', 'стремено', 'стрибали', 'стрибати', 'стрижень', 'стриптиз', 'студенти', 'сучасний', 'схопився', 'сценарій', 'сьогодні', 'тащаться', 'тендітна', 'торгівля', 'хоробрий', 'цвітіння', 'цінність', 'червоний', 'черствий', 'чоловіки', 'штовхнув', 'штурмове', 'яскравий', 'інвентар']
,[98, 'благодать', 'блондинка', 'бринькати', 'більшість', 'визначити', 'виробляти', 'висловити', 'витрачати', 'включають', 'всередині', 'відблиски', 'відкритий', 'відповідь', 'гарчанням', 'гребінець', 'допомогти', 'достатньо', 'дізнатися', 'забивають', 'завивають', 'загальний', 'займенник', 'заповнені', 'захистити', 'зберігати', 'збільшити', 'звиватися', 'здавалося', 'здавалося', 'зрозуміти', 'зчеплення', 'зчеплення', 'зіпсувати', 'зіткнення', 'клікнувши', 'комутатор', 'копіювати', 'крадучись', 'кукурудза', 'кількість', 'лікування', 'майнового', 'маленький', 'малювання', 'мастильні', 'матеріали', 'мистецтво', 'наприклад', 'наприклад', 'наречений', 'народився', 'насправді', 'насправді', 'натисніть', 'необхідно', 'нишпорити', 'одягнений', 'оселилися', 'особливий', 'очікувати', 'перевірте', 'пластівці', 'погодився', 'подряпини', 'полювання', 'порівняти', 'потрібним', 'почекайте', 'починаючи', 'поширення', 'правильно', 'правильно', 'президент', 'претензії', 'природний', 'прокрутки', 'процідити', 'підписати', 'підірвали', 'результат', 'розвідник', 'розгортки', 'розділені', 'рукавички', 'сенсорний', 'сковороді', 'сутулість', 'трапилося', 'трикутник', 'тушкувати', 'тушкувати', 'узбережжя', 'укладений', 'упевнений', 'управляти', 'чорнослив', 'чіплятися', 'швидкість']
,[53, 'автомобіль', 'благослови', 'вантажівка', 'величезний', 'волосистої', 'встановити', 'відбілювач', 'гальмівний', 'голодувати', 'гравітація', 'дозволяють', 'доповнення', 'друкованої', 'електричні', 'жадібність', 'забруднень', 'заклинання', 'залишитися', 'заморожені', 'захоплення', 'здивування', 'здивування', 'зустрітися', 'коричневий', 'косоокість', 'найближчим', 'неглибокої', 'перемішати', 'переміщати', 'побудувати', 'повернення', 'повзучості', 'потертості', 'потужність', 'потягнувся', 'прикметник', 'припустимо', 'прогулянка', 'пропустити', 'протектора', 'розглянути', 'розроблені', 'самостійно', 'сканування', 'сонливість', 'спробувати', 'стабільний', 'створювати', 'сьогодення', 'тривалість', 'тримайтеся', 'фотографія', 'харчування']
,[31, 'будівництво', 'відбудеться', 'відпочивати', 'десяткового', 'експеримент', 'забезпечити', 'залишаються', 'захоплюючим', 'кровоточити', 'називається', 'незнайомець', 'нерухомість', 'нетерпінням', 'переглядати', 'перетягнути', 'побудований', 'посміхнувся', 'працівників', 'приголосний', 'приєдналися', 'продовжував', 'прокотилася', 'пульсування', 'підготувати', 'підсолодити', 'розростання', 'розтягнення', 'справедлива', 'стаціонарні', 'урахуванням', 'інструменти']
,[15, 'використання', 'випадковість', 'відвідування', 'дорогоцінний', 'законопроект', 'запропонував', 'зловтішатися', 'приземкуваті', 'притиснутися', 'підкреслення', 'розбовтувати', 'розташований', 'спостерігати', 'трансплантат', 'тріумфування']
,[6, 'заморожування', 'повторюватися', 'пожежогасіння', 'представляють', 'промисловість', 'підготовлений']
,[1, 'насолоджуйтеся']]
"""