;-------------------------------------------------------------------------------
; The GIMP -- an image manipulation program
; Copyright (C) 1995 Spencer Kimball and Peter Mattis
;-------------------------------------------------------------------------------
; pysycache-number.scm : a script for make a cache for the number theme of 
;                        the move activity
; Copyright (C) 2006 Vincent DEROO (vincent.pysycache@free.fr)
;-------------------------------------------------------------------------------
;
;
; This program is free software; you can redistribute it and/or 
; modify it under the terms of the GNU General Public License 
; as published by the Free Software Foundation; either version 2 
; of the License, or (at your option) any later version. 
; 
; This program is distributed in the hope that it will be useful, 
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
; GNU General Public License for more details. 
; 
; You should have received a copy of the GNU General Public License 
; along with this program; if not, write to the Free Software 
; Foundation, Inc. : 
; 51 Franklin Street, Fifth Floor, Boston, MA02110-1301, USA
;-------------------------------------------------------------------------------



       
;-------------------------------------------------------------------------------
; 
;-------------------------------------------------------------------------------
(define (PutTheText
	ShadowColor
	TopText
	TopTextFont
	Left
	Top
	Size
	TypeOfPosition
	)
	(gimp-palette-set-foreground ShadowColor)
			(let* 
					(	
						(LayText
							(car
							   (gimp-text-fontname
								MyImg -1
								Left Top
								TopText
								-1
								TRUE
								Size PIXELS
								TopTextFont)
						   )
						)						
						(larg (car (gimp-drawable-width LayText)))
                        (haut (car (gimp-drawable-height LayText)))					
					)
			
			
			(if (= TypeOfPosition 0)
				;top text
				(begin
				)
			)
			(if (= TypeOfPosition 1)
				;middle text
				(begin
					(gimp-layer-translate LayText (- (/ larg 2) ) (- (/ haut 2) ) )
				)
			)
			(if (= TypeOfPosition 2)
				;bottom text
				(begin
					(gimp-layer-translate LayText (- larg) (- haut) )
				)
			)
			
			)

)
       
;-------------------------------------------------------------------------------
; 
;-------------------------------------------------------------------------------
(define (script-fu-pysycache-number
	img
	draw
	BackgroundFile
	ShadowColor
	
	TopText
	TopTextFont
	TopTextSize
	TopTextColor
	
	MiddleText
	MiddleTextFont
	MiddleTextSize
	MiddleTextColor

	BottomText
	BottomTextFont
	BottomTextSize
	BottomTextColor
	)
	

	(let*	(	
				;(draw-type (car (gimp-drawable-type draw)))
				
				;recuperation de la taille de l'image originale
;				(ImgWidth (car (gimp-image-width img)))
;				(ImgHeight (car (gimp-image-height img)))
				
;				(MyImg (car (gimp-image-new ImgWidth ImgHeight RGB)))				
;				(layBG (car (gimp-layer-new-from-drawable draw MyImg)))
				
				
			)

			(set! MyImg (car (gimp-file-load RUN-NONINTERACTIVE BackgroundFile BackgroundFile)))
;			(set! MyLay (car (gimp-layer-new-from-drawable draw MyImg)))

;			(gimp-image-add-layer MyImg MyLay -1)
;			(MyDraw (car (gimp-image-get-active-drawable MyImg)))
;			(set! MyDraw (car (gimp-image-get-active-drawable MyImg)))	

			;-------------------------- top text -------------------------------
			;the shadow
			(PutTheText ShadowColor TopText TopTextFont 10 10 TopTextSize 0)
			(PutTheText TopTextColor TopText TopTextFont 7 7 TopTextSize 0)

			;-------------------------- Middle text ----------------------------
			;the shadow
			(PutTheText ShadowColor MiddleText MiddleTextFont 363 273 MiddleTextSize 1)
			(PutTheText MiddleTextColor MiddleText MiddleTextFont 360 270 MiddleTextSize 1)

			;------------------------- Bottom text -----------------------------
			;the shadow
			(PutTheText ShadowColor BottomText BottomTextFont 682 525 BottomTextSize 2)
			(PutTheText BottomTextColor BottomText BottomTextFont 685 528 BottomTextSize 2)

			(gimp-image-merge-visible-layers MyImg 1)	
			
			(gimp-display-new MyImg)
	)
)


;-------------------------------------------------------------------------------
; Register in the Gimp menus
;-------------------------------------------------------------------------------
(script-fu-register "script-fu-pysycache-number"
		    _"<Image>/Script-Fu/Pysycache/Theme number..."
		    "Make the cache for the number theme of the move activity \n
		By writing a number and it's letters"


		    "Vincent DEROO (contact.pysycache@free.fr)"
		    "Vincent DEROO"
		    "16/09/2006 - v 1.0"
		    "RGB GRAY RGBA GRAYA"
			
		    SF-IMAGE "Image" 0
			SF-DRAWABLE "Drawable" 0
			SF-FILENAME "Background" (string-append "" gimp-data-dir "/scripts/images/masque-image-clair.png")
			SF-COLOR "Color of the shadow" '(46 113 169)
			
			SF-STRING "Top text" "one"
			SF-FONT "Font for the top text" "URW Chancery L, Italic"
			SF-ADJUSTMENT "Font size for the top text" '(110 10 300 1 10 0 1)
			SF-COLOR "Color of the top text" '(255 0 0)

			SF-STRING "Middle text" "1"
			SF-FONT "Font for the middle text" "Bitstream Vera Serif Bold"
			SF-ADJUSTMENT "Font size for the middle text" '(200 10 300 1 10 0 1)
			SF-COLOR "Color of the middle text" '(255 255 0)

			SF-STRING "Bottom text" "ONE"
			SF-FONT "Font for the bottom text" "Courier 10 Pitch Bold"
			SF-ADJUSTMENT "Font size for the bottom text" '(120 10 300 1 10 0 1)
			SF-COLOR "Color of the bottom text" '(0 255 0)
			
)
